/*
** Arr_ship.t defines the aliens, their ship, and some random daemons.
**
** Copyright (c) 1998, Stephen Granade. All rights reserved.
*/

#pragma C+

// Some #define's to help me create the filename for the free_console picture.
// Since there are eight pictures depending on the state of the console, I've
// named the console pictures 'console0.jpg' through 'console7.jpg'. See
// free_console for more information.
#define BUTTON_DEPRESSED        1
#define LEVER_SET_TO_INTAKE     2
#define GAUGE_FULL              4

// More #define's. These are for the password_panel
#define TRIANGLE_ON             1
#define SQUARE_ON               2
#define CIRCLE_ON               4

alien_daemon: thing
    arrival = {
        "\b";
        "<IMG SRC=\"Resources/Ship Crash.jpg\" WIDTH=\"400\" HEIGHT=\"278\"
            ALIGN=\"Right\" BORDER=\"0\" HSPACE=\"6\"> ";
        "A gleam out the window, a faux star, grows brighter and brighter.
            You pull yourself up on the edge of the sink, soaking your elbows.
            The gleam is a glow, is a streak, is a flame which is rocketing
            into your backyard and <b>WHAM</b> onto the ground. You reflexively
            blink, the flash brighter than the one on that camera dad lugs
            around everywhere. When you can see again, there is a silvery
            ship in the backyard.
        \bA ship! Oh man oh man, it must be a spaceship! From outer space!
            Maybe from Gamma Proxima Epsilon Centauri Five B! Forget the
            dishes&mdash;this is way too cool to ignore. ";
        "<SOUND SRC=\"mp3/Crash Landing.mp3\" LAYER=\"FOREGROUND\">";
        startroom.landed = true;
        startroom.hasShip = true;

        // Set up the hint structure
        hint_menu.myContents += [house_menu ship_menu];

        version.ldesc;              // *Now* print the name of the game
    }
    lowerTheRamp = {
        if (Me.location != backyard) {
            notify(self, &lowerTheRamp, 1);
            return;
        }
        "\bWith the sound of a thousand cats yowling a thousand different
            songs, a piece of the saucer lowers, forming a ramp. For a few
            seconds, the only things coming out of the ship are gouts of
            white gas which quickly dissipate.\b
        <IMG SRC=\"Resources/Aliens Emerge.jpg\" WIDTH=\"420\" HEIGHT=\"292\"
            ALIGN=\"Left\" BORDER=\"0\" HSPACE=\"6\">
        Then the aliens step forth.
        \bFull of might and majesty, two shapes drift down the ramp and onto
            the zoysia grass";
        if (backyard_faucet.ison)
            ", carefully avoiding the running faucet";
        ". One is purple and cylindrical, with several
            tentacles dangling. The other is green and much more blobby, though
            he too is be-tentacled.
        \bThe purple alien squints for a moment at the bright lights,
            then produces a small box with a rotating antenna on it.
            He punches some buttons on the box. It responds with bleeps and
            blips. The purple one nods and puts the box away.
            <<flo('Scan for life signs in immediate vicinity complete. Two
            adults, one child, no tabloid reporters found.')>>
        \b<<zig('Good,')>> the green one says.
            <<zig('We now must&mdash;')>> He stops, staring right
            at you. You blink.
        \b<<flo('Zigurt,')>> the purple alien says to the green one. His voice
            is thick with worry.
        \b<<zig('Shh,')>> the green alien replies. <<zig('I am cogitating.')>>
        \b<<flo('Ziiiiiguuurt,')>> the purple alien whines.
        \b<<zig('Shh!')>>
        \b<<flo('But ZIIiiIIiiIIiiguuuurt, the child can see us! Why is
            that?')>> The purple alien turns to the green one, filling the air
            with his flailing tentacles. <<flo('You
            said the neurotron would prevent our detection. You said that
            this would be a slight wind, that this would be without
            difficulty!')>>
        \b<<zig('Silence, Floban.')>> The purple alien falls
            quiet. <<zig('We will unravel this conundrum in due time. For now,
            I have closed the child&rsquo;s avenue of
            retreat.')>> You spin around&mdash;sure enough, a curtain
            of energy has sprung up between you and your house. ";
        energy_curtain.moveInto(backyard);
        house_menu.contents += energy_field;
        zigurt.moveInto(backyard);
        floban.moveInto(backyard);
        outside_ship_ramp.moveInto(backyard);
        zigurt.makingComments = true;
        backyard.cutOff = true;
        notify(self, &rantAndRave, 1);
        real_ship.rampDown = true;
    }
    rantAndRave = {
        "\bThe two aliens begin whispering back and forth.
            <<zig('Obviously the child is the Ambassador
            Plenipotentiary for this planet.')>>
        \b<<flo('A child?')>>
        \b<<zig('Certainly. The Zufans&rsquo; intelligence, while fearful in
            their young, diminishes with age. All of their civil servants
            are children. Why not with Terrans? Have you not seen the
            their <q>sit-coms,</q> in which the children are all-knowing and
            their elders impotent fools?')>>
        \b<<flo('Fine, fine, fine. But can the child understand
            us?')>> Zigurt responds by displaying a plain metal rod.
            <<flo('Ah, yes. I had forgotten of the translator.')>> ";
        notify(self, &rantAndRave2, 1);
        universal_translator.moveInto(zigurt);
    }
    rantAndRave2 = {
        "\bZigurt makes a sound like that of gravel being crushed
            underfoot. <<zig('Floban, would this not be an opportune
            time to present our demands to the Ambassador?')>>
        \bFloban looks hurt. <<flo('I was preparing the list
            mentally,')>> he says truculently. <<flo('There
            is no need for you to clear your esophageal passages at
            me.
        \b&ldquo;Human child!')>> The latter is directed at you, making
            you jump. Floban moves forward,
            looming ominously. <<flo('We are here on behalf of all
            spacefaring races
            who must cope with the mess your species is making. Must you
            shout your news across all radio frequencies?')>>
        \b<<zig('Mmm, Floban,')>> says Zigurt.
        \b<<flo('Must I hear of your puny world wars? Must I deal with
            the endless chatter of a semi-sentient race? Must you flood
            the universe with your <q>top-ten lists</q> and <q>buzz clips</q>?')>>
        \b<<zig('What about our demands, Floban?')>>
        \b<<flo('Must I sully the tips of my tentacles by dipping them
            in the muck of this world? Must I stop your stupid, stupid
            development of Solarnite?
            Must I spend more time on a
            backwards planet, educating the&mdash;')>>
        \b<<zig('FLOBAN! FOOD!')>>
        \bFloban winces. <<flo('Not so loud,')>> he
            hisses to Zigurt. <<flo('One moment, please, Ambassador,')>> he
            says to you as he rolls back to Zigurt. ";
        notify(self, &makeDemands, 1);
    }
    makeDemands = {
        "\bZigurt and Floban have a hurried, whispered discussion.
            Finally, Zigurt
            moves closer to you. <<zig('Our trip has been a long one,
            and we are in need of sustenance. You will bring us rock
            salt, so that we might de-hydrate.')>>
        \b<<flo('And some Ho-Hos,')>> Floban interjects hopefully.
        \bZigurt glares at Floban. Finally, grudgingly, he adds, <<zig('And
            some Ho-Hos. You will&mdash;')>>
        \b<<flo('And a memento!')>> says Floban.
        \bThis silence lasts longer than the previous one. Slowly
            Zigurt
            swivels around to stare at Floban. <<zig('A...memento?')>> he
            asks.
        \b<<flo('Oh, my, yes! The preliminary scan&mdash;')>> he waves around
            the small box you saw before, <<flo('&mdash;showed a high
            concentration of mementos somewhere within the domicile. We should
            obtain...one to...add...')>> Floban&rsquo;s words trail off under
            Zigurt&rsquo;s glare.
        \bZigurt sighs before turning back to you. <<zig('Bring us
            rock salt, some Ho-Hos,')>> he pauses and glares again at Floban,
            who ducks his head, <<zig('and a memento. You will bring them to
            our skrrbtz...')>> Zigurt
            frowns, shakes the translator. <<zig('Enter our
            fzzgt...')>> His frown is deeper this time. <<zig('Our gblzzt...')
            >> He waves his tentacles, distressed. <<zig('<q>Universal
            translator</q> my anterior appendage!')>>\ he shouts.
        \b<<flo('Please, not so loud!')>> Floban brings out an
            open white bottle and pops a pill from it. <<flo('I am
            experiencing a horrendous headache. If you would but wait a
            moment.')>> From somewhere he finds a large book, which he consults.
            <<floNQ('&ldquo;The word you want is &lsquo;')>>sheep<<
            floNQ('&rsquo;.&rdquo;')>>
        \bZigurt pauses, rolling the strange word around in his
            mouth, tasting its sounds. <<zigNQ('&ldquo;Bring the rock salt,
            Ho-Hos, and memento to our')>> sheep<<zigNQ('. We will
            wait.&rdquo;')>> ";
        translation_book.moveInto(floban);
        sheep_ship.canCallItSheep = true;
        notify(self, &partingShot, 1);
    }
    partingShot = {
        "\bZigurt and Floban drift back up the ramp. When they are near
            the top, they stop. <<zig('Oh, and tell your world
            governments&rsquo; spacefarers to clean up after themselves in
            orbit,')>> Zigurt says.
        \b<<flo('Yeah, especially that Mir.')>>
        \bZigurt negligently waves a tentacle, making the curtain of
            energy vanish, and the two aliens disappear into their
            ship. ";
        energy_curtain.moveInto(nil);
        house_menu.contents -= energy_field;
        backyard.cutOff = nil;
        zigurt.makingComments = nil;
        zigurt.moveInto(rec_room);
        floban.moveInto(rec_room);
        tylenol_bottle.moveInto(counter);
        universal_translator.moveInto(counter);
        translation_book.moveInto(counter);
        cabinets.canOpen = true;      // Let the player open the cabinets
    }
;

// The 'sheep' is here because IF players are a sarky lot
sheep_ship: decoration
    canCallItSheep = nil
    noun = 'sheep'
    adjective = 'silvery' 'crinkly'
    location = backyard
    sdesc = "silvery sheep"
    dobjGen(a, v, i, p) = {
        if (!self.canCallItSheep)   // Aliens haven't called it a sheep yet
            "I never learned the word <q>sheep</q> in school. ";
        else "C&rsquo;mon, just because the aliens think this thing should be
            called a sheep is no reason for you to go calling it one. What
            would your grammar think? ";
        exit;
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

real_ship: fixeditem
    givenPointsForFilling = nil     // Player's awarded points for filling
                                    // the fuel tank with water
    rampDown = nil
    hatchOpen = nil
    filledWithWater = nil
    noun = 'ship' 'saucer' 'ufo'
    adjective = 'silvery' 'crinkly' 'flying'
    location = backyard
    sdesc = "silvery ship"
    ldesc = {
        if (self.rampDown)
            gprint('Resources/Ship Closeup Ramp.jpg');
        else gprint('Resources/Ship Closeup.jpg');
        if (global.graphicsOn)
            "\n";
        "It&rsquo;s much, much cooler close up. The surface is all crinkly and
            silvery. The top and bottom are flat; the sides angle out, then
            back in, and are ruffled. On its back are two bumper stickers. ";
        if (self.rampDown)
            "Its ramp lies open like a big silver tongue; you can enter to
                the <<link('north', 'n')>>. ";
        if (self.hatchOpen)
            "Near the bottom of the saucer, a hatch dangles open. ";
    }
    whatdesc = {
        if (startroom.landed)
            "It&rsquo;s obviously a flying saucer. Well, right now
                it&rsquo;s a sitting saucer. ";
        else "It&rsquo;s something that hasn&rsquo;t arrived yet. Say, have you
            played this game before? ";
    }
    verDoTake(actor) = {
        "What do you think this thing is made of, tinfoil? It&rsquo;s not
            going anywhere. ";
    }
    doSynonym('Take') = 'Move' 'Push' 'Pull'
    verDoEnter(actor) = {
        if (!self.rampDown)
            "You see no way to enter the ship. ";
        else if (zigurt.location == backyard)
            "The aliens move to block you. ";
    }
    doEnter(actor) = {
        local dest;
        
        dest = actor.location.north;
        if (dest)
            actor.travelTo(dest);
    }
    verDoClimb(actor) = {
        "The ship is way too slick for that. ";
    }
    verDoOpen(actor) = {
        if (self.rampDown)
            "The ship is already open. ";
        else "Be patient. ";
    }
    verDoAttachTo(actor, io) = {
        if (!self.hatchOpen)
            pass verDoAttachTo;
        else ship_opening.verDoAttachTo(actor, io);
    }
    verIoAttachTo(actor) = {
        if (!self.hatchOpen)
            pass verIoAttachTo;
        else ship_opening.verIoAttachTo(actor);
    }
    ioAttachTo(actor, dobj) = {
        ship_opening.ioAttachTo(actor, dobj);
    }
    doSynonym('AttachTo') = 'FastenTo' 'PlugIn' 'ScrewInto'
    ioSynonym('AttachTo') = 'FastenTo' 'PlugIn' 'ScrewInto'
    verIoPutIn(actor) = {
        if (!self.hatchOpen)
            pass verIoPutIn;
        else ship_opening.verIoPutIn(actor);
    }
    ioPutIn(actor, dobj) = {
        ship_opening.ioPutIn(actor, dobj);
    }
    verDoDetach(actor) = {
        if (!self.hatchOpen)
            pass verDoDetach;
        else ship_opening.verDoDetach(actor);
    }
    doDetach(actor) = {
        ship_opening.doDetach(actor);
    }
    verDoDetachFrom(actor, iobj) = {
        if (!self.hatchOpen)
            pass verDoDetachFrom;
        else ship_opening.verDoDetachFrom(actor, iobj);
    }
    verIoDetachFrom(actor) = {
        if (!self.hatchOpen)
            pass verIoDetachFrom;
        else ship_opening.verIoDetachFrom(actor);
    }
    ioDetachFrom(actor, dobj) = {
        ship_opening.ioDetachFrom(actor, dobj);
    }
    doSynonym('Detach') = 'Unfasten' 'Unscrew'
    doSynonym('DetachFrom') = 'UnplugFrom' 'UnscrewFrom'
    ioSynonym('DetachFrom') = 'UnplugFrom' 'UnscrewFrom'
    fillShip = {            // The tanks are filled with water!
        if (fuel_gauge.full) return nil;
        self.filledWithWater = true;
        fuel_gauge.full = true;
        if (!self.givenPointsForFilling) {
            self.givenPointsForFilling = true;
            incscore(4);
        }
        return true;
    }
    emptyShip = {
        self.filledWithWater = nil;
        fuel_gauge.full = nil;
    }
    blastOff = {            // The aliens depart
        "<SOUND SRC=\"mp3/Saucer Launches.mp3\" LAYER=\"FOREGROUND\">";
        if (Me.location != backyard) {
            "\bThe house rumbles as the ship outside departs into the night
                sky. You sigh, amazed that you got to meet some real live
                aliens!\b";
            if (!fuel_gauge.full) {
                "Then the ship returns, shuddering its way back into your
                    backyard. You run outside in time to meet Floban coming
                    down the ramp. ";
                if (VALLEYSPEAK)
                    flo('Like, sorry, but our ship is sooo out of fuel.
                        I&rsquo;m so sure! So we&rsquo;ve gotta,
                        y&rsquo;know, turn a tree into fuel.');
                else flo('Apologies, Ambassador, but our
                    ship has no propellant. We must convert some local organic
                    material into fuel.');
                "\bYou start to ask him what he means, but are distracted
                    by the sight of a giant claw extending from the saucer.
                    It flails about, finally grabbing the tree next to the
                    saucer.
                    It uproots the tree, then retracts into the ship. The
                    dripping sound of a giant coffee-machine floats from
                    the saucer, followed by a cheerful <i>ding!</i> ";
                if (VALLEYSPEAK)
                    flo('So, like, thanks for that tree,');
                else flo('We thank you for the use of your tree,');
                " Floban says before re-entering the saucer, which then zips
                    up into the sky, vanishing. ";
            }
            else if (self.filledWithWater) {
                "<img src=\"Resources/Esplode Away Ship.jpg\" align=\"left\">";
                "You are startled out of your nightdreaming by a dry
                    coughing sound, followed shortly by a horrendous
                    <b>KA-BOOM!</b>
                    You rush outside into the backyard and look up.";
                "<SOUND SRC=\"mp3/Saucer Coughs.mp3\" LAYER=\"FOREGROUND\">";
                "<SOUND SRC=\"Snds/1 Sec Silence.wav\" LAYER=\"FOREGROUND\">";
                "<SOUND SRC=\"mp3/Saucer Explodes.mp3\" LAYER=\"FOREGROUND\">";
            }
        }
        else {
            "\bThe saucer rises a few feet, flame billowing out beneath it. ";
            if (fuel_puddle.location == backyard)
                "The puddle under the ship burns merrily for a bit, finishing
                    off what was left of your mom&rsquo;s azaleas. ";
            if (garden_hose.attachedToShip) {
                if (garden_hose.attachedToFaucet)
                    "\bMeanwhile, the garden hose stretches tighter and
                        tighter until,
                        with a loud snap!\ the head of the faucet breaks off,
                        leaving an exposed section of pipe and a small
                        fountain of water. ";
                "As the ship continues to rise, the garden hose slithers after
                    it, then
                    swings free in the air. You have to dodge it a time or
                    two before it is finally too high to reach you.\b";
            }
            "You step back, shielding your eyes, as the ship rockets up, higher
                and higher and higher, until you can&rsquo;t see it
                anymore.\b";
            if (!fuel_gauge.full) {
                "Then the ship returns, shuddering its way back into your
                    backyard. You run outside in time to meet Floban coming
                    down the ramp. ";
                if (VALLEYSPEAK)
                    flo('Like, sorry, but our ship is sooo out of fuel.
                        I&rsquo;m so sure! So we&rsquo;ve gotta,
                        y&rsquo;know, turn a tree into fuel.');
                else flo('Apologies, Ambassador, but our
                    ship has no propellant. We must convert some local organic
                    material into fuel.');
                "\bYou start to ask him what he means, but are distracted by
                    the sight of a giant claw extending from the saucer. It
                    flails about, then grabs the tree next to the saucer.
                    It uproots the tree, then retracts into the ship. The
                    dripping sound of a giant coffee-machine floats from
                    the saucer, followed by a cheerful <i>ding!</i> ";
                if (VALLEYSPEAK)
                    flo('So, like, thanks for that tree,');
                else flo('We thank you for the use of your tree,');
                " Floban says before re-entering the saucer, which then zips
                    up into the sky, vanishing. ";
            }
            else if (self.filledWithWater) {
                "<img src=\"Resources/Esplode Away Ship.jpg\" align=\"left\">";
                "Then, faint at first, you hear a coughing sound. Straining
                    your eyes to the limit, you are almost blinded when
                    there is an explosion directly above you. You
                    look down, blinking away the afterimages, then look back
                    up.";
                "<SOUND SRC=\"mp3/Saucer Coughs.mp3\" LAYER=\"FOREGROUND\">";
                "<SOUND SRC=\"Snds/1 Sec Silence.wav\" LAYER=\"FOREGROUND\">";
                "<SOUND SRC=\"mp3/Saucer Explodes.mp3\" LAYER=\"FOREGROUND\">";
            }
        }
        if (!self.filledWithWater) {
            if (global.graphicsOn)
                "<img src=\"Resources/Fly Away Ship.jpg\">";
            "\b";
            pageBreak();
            "Your parents are quite surprised to be woken up the next
                morning by pounding on the front door. Having been too
                excited to sleep last night, you are already awake and
                follow them to the front door. They open it to find
                an alien who looks a lot like a thinner version of Floban.
            \b<<flo('Greetings, progenitors-of-Ambassador,')>> he
                says before clapping them and you in leg-irons. <<
                flo('Because of the Ambassador&rsquo;s help with our plot,
                High Commander Floban has agreed that you be 
                sold into slavery instead of being rendered into
                commemorative candles celebrating the subjugation
                of your species.')>>
            \b<q>You little scamp,</q> your dad says bemusedly. Your mom
                ruffles your hair and smiles. Then all three of you
                are hauled away to join the flood of humans being driven
                into work camps. ";
            die();
        }
        "\b";
        "Among the cloud of debris even now falling around you, two specks
            appear, drifting down like thistles. Though distracted by the
            sound of metal slamming into neighbor&rsquo;s houses and starting
            minor
            fires, you eventually realize that the two specks are Zigurt
            and Floban. In minutes they reach the earth, landing lightly
            in front of you.\b";
        if (VALLEYSPEAK)
            flo('Bummer. Like, hey Ambassador! Totally cool of you to still,
                y&rsquo;know, be here and stuff.');
        else flo('Ah, Ambassador, so good of you to still be here,');
        " Floban says, wringing his tentacles. ";
        if (VALLEYSPEAK)
            flo('Major bummer. Our ship, like...uh, y&rsquo;know how...um...');
        else flo('Our ship has...hm...that is, we have experienced...');
        "\b";
        if (VALLEYSPEAK)
            zig('Like, gag me with a spoon! You are sooo lame sometimes,');
        else zig('Never mind your duplicitous and circuitous speech,');
        " Zigurt snaps. ";
        if (VALLEYSPEAK)
            zig('You know the Ambassador, like, saw the boom!');
        else zig('No doubt the Ambassador witnessed our ship&rsquo;s
            explosion.');
        " He turns towards you, head slightly bowed, tentacles drooping. ";
        if (VALLEYSPEAK)
            zig('Uh...like, could we have a sleep-over with you? Like, for
                a while? A dork survey ship won&rsquo;t be here for,
                like, three hundred years. Sha, as if!');
        else zig('Could we perhaps seek shelter with you
            for some whiles? The next survey ship will be along in a mere
            three hundred years.');
        "\b";
        if (VALLEYSPEAK)
            flo('Yeah! We&rsquo;re totally good houseguests, because, like,
                we know how to kiss up to lower cultures!');
        else flo('We are quite good houseguests, being adept at ingratiating
            ourselves with less-advanced cultures!');
        " They both grin hopefully at you, revealing three rows of teeth.
        \bIt doesn&rsquo;t take you long to decide. I mean, heck, who else can
            say that they know two aliens? Maybe they&rsquo;ll even turn out
            to be real good at familial responsibilities. ";
        incscore(4);
        win();
    }
;

// This item is purely for the player's amusement
ship_shadow: decoration
    snappyComebackNumber = 1
    noun = 'shadow'
    location = backyard
    sdesc = "shadow"
    ldesc = "The ship casts a shadow across the lawn. "
    verDoEnter(actor) = {}
    doEnter(actor) = {
        switch (self.snappyComebackNumber) {
            case 1:
            "If you think I&rsquo;m gonna make a <i>So Far</i> joke, you&rsquo;ve
                got another thing coming. ";
            break;

            case 2:
            "I mean it. There&rsquo;s no <i>So Far</i> joke I could do that
                would really be funny. ";
            break;

            case 3:
            "You really know how to be pushy, don&rsquo;t you? ";
            break;

            case 4:
            "Okay, okay, one joke. But don&rsquo;t say I didn&rsquo;t warn you.
            \b<i>The shadow doesn&rsquo;t work that way.</i> ";
            break;

            case 5:
            "I knew I shoulda gone with, <i>I double-dog dare you to enter
                that shadow.</i> What was I thinking? ";
            break;

            case 6:
            "You can stop trying to enter the shadow now. You&rsquo;ve hurt my
                feelings enough as it is. ";
            break;

            case 7:
            "Quit it! ";
            return;
        }
        self.snappyComebackNumber++;
    }
;

// So are the bumper stickers
left_bumper_sticker: fixeditem, readable
    noun = 'sticker'
    plural = 'stickers'
    adjective = 'left' 'bumper'
    location = backyard
    sdesc = "left bumper sticker"
    ldesc = "The left sticker reads, <q>Speed Kills! .55c Saves Lives.</q> "
    whatdesc = "People put &rsquo;em on the back of vehicles to tell
        everybody what they think of stuff. "
;

right_bumper_sticker: fixeditem, readable
    noun = 'sticker'
    plural = 'stickers'
    adjective = 'right' 'bumper'
    location = backyard
    sdesc = "right bumper sticker"
    ldesc = "The right bumper sticker reads, <q>My Other Saucer Is A
        Porsche.</q> "
    whatdesc = "People put &rsquo;em on the back of vehicles to tell
        everybody what they think of stuff. "
;

outside_ship_ramp: fixeditem, floatingItem
    noun = 'ramp'
    location = backyard
    sdesc = "ramp"
    ldesc = "It leads into the ship. "
    verDoEnter(actor) = {
        if (zigurt.location == backyard)
            "The aliens move, blocking your path. ";
    }
    doEnter(actor) = { actor.travelTo(ship_hallway); }
    doSynonym('Enter') = 'Climb'
    verDoGoto(actor) = {
        if (!startroom.landed)        // Can't go here if the ship isn't around
            "Okay, okay, you&rsquo;ve made your point&mdash;you&rsquo;ve played
                <i>Arrival</i>
                before. We&rsquo;re all quite impressed with you now.
                But think about it:\ how are you going to get there
                until the ship&rsquo;s arrived?
            \bSmart-alec. ";
        else if (!real_ship.rampDown) // Ditto if the ship's ramp is up
            "Not until the ship&rsquo;s ramp lowers. Be patient. ";
    }
    // If the player is outside the ship, they are taken to the hallway.
    // Otherwise, they're taken to the backyard
    doGoto(actor) = {
        if (!isclass(actor.location, shipRoom)) {
            local loc = actor.location;
            
            while (loc != ship_hallway) {
                "(moving <<loc.gotoString>>)\n";
                actor.travelTo(loc.(loc.gotoDir));
                "\b";
                loc = actor.location;
            }
        }
        else {
            if (actor.location != ship_hallway) {
                "(moving <<actor.location.gotoString>>)\n";
                actor.travelTo(ship_hallway);
                "\b";
            }
            "(moving south)\n";
            actor.travelTo(self.location);
        }
    }
;

ship_hatch: fixeditem
    noun = 'hatch'
    sdesc = "hatch"
    ldesc = {
        "It hangs limply from the bottom of the saucer, revealing an
            opening. ";
        if (translation_book.location == Me)
            "The flowing script on the hatch reads, &lsquo;Unleaded
                only.&rsquo; ";
        else "Something is written on the hatch in an alien script. ";
    }
    whatdesc = "It must normally cover some of the innards of the ship. "
    verDoClose(actor) = {}
    doClose(actor) = {
        "You ";
        if (garden_hose.attachedToShip) {
            "pull the hose out of the ship&rsquo;s opening and ";
            garden_hose.detachFromShip;
        }
        "push the hatch shut. It blends seamlessly into the surface of
            the saucer. Pretty soon, you can&rsquo;t remember quite where it was. ";
        fuel_button.handleClosing;
    }
    verDoRead(actor) = {
        if (translation_book.location != Me)
            "You can&rsquo;t tell what it says. ";
    }
    doRead(actor) = {
        "The script reads, <q>Unleaded Only.</q> ";
    }
    ioPutIn -> ship_opening
    doAttachTo -> ship_opening
    ioAttachTo -> ship_opening
    doSynonym('AttachTo') = 'FastenTo' 'PlugIn' 'ScrewInto'
    ioSynonym('AttachTo') = 'FastenTo' 'PlugIn' 'ScrewInto'
    doDetach -> ship_opening
    doDetachFrom -> ship_opening
    ioDetachFrom -> ship_opening
    doSynonym('Detach') = 'Unfasten' 'Unscrew'
    doSynonym('DetachFrom') = 'UnplugFrom' 'UnscrewFrom'
    ioSynonym('DetachFrom') = 'UnplugFrom' 'UnscrewFrom'
;

ship_opening: fixeditem
    noun = 'opening' 'hole'
    adjective = 'black' 'small'
    sdesc = "opening"
    ldesc = {
        "It must lead somewhere in the ship. Too bad it&rsquo;s about as big
            as your palm, or you&rsquo;d climb right in. ";
        if (garden_hose.attachedToShip)
            "Well, you&rsquo;d climb on in if it were bigger and if a garden
                hose wasn&rsquo;t dangling from it. ";
        else "Wonder if the aliens made it that small on purpose. ";
    }
    whatdesc = "It is a small hole into the ship. "
    verDoEnter(actor) = {
        "It&rsquo;s too small for you. Duh. ";
    }
    doSynonym('Enter') = 'Climb'
    verIoPutIn(actor) = {
        if (fuel_lever.setToIntake == nil)
            "Something is blocking the opening, and it&rsquo;s not something you
                can see. ";
    }
    ioPutIn(actor, dobj) = {
        if (dobj != garden_hose) {
            "\^<<dobj.thedesc>> won&rsquo;t fit in the opening. It must be some
                funky shape that&rsquo;ll only let one kind of thing in. ";
            return;
        }
        if (garden_hose.attachedToShip)
            "You&rsquo;ve already put the hose in the opening. Geez. ";
        else {
            "When you bring the end of the hose up to the opening, some
                force snatches it out of your hands and sucks it into the
                opening, making a pretty good seal. ";
            if (backyard_faucet.ison) {
                if (real_ship.fillShip)
                    "You hear a moment of quiet gurgling from the ship. ";
            }
            garden_hose.attachToShip;
        }
    }
    verDoAttachTo(actor, io) = {
        if (io != garden_hose)
            "There&rsquo;s no need to attach <<io.thedesc>> to the opening. ";
    }
    verIoAttachTo(actor) = {}
    ioAttachTo(actor, dobj) = {
        if (dobj != garden_hose)
            "There is no need to attach <<dobj.thedesc>> to the opening. ";
        else dobj.ioAttachTo(actor, self);
    }
    doSynonym('AttachTo') = 'FastenTo' 'PlugIn' 'ScrewInto'
    ioSynonym('AttachTo') = 'FastenTo' 'PlugIn' 'ScrewInto'
    verIoPutOn(actor) = {}
    ioPutOn(actor, dobj) = {
        if (dobj != garden_hose)
            "You can&rsquo;t really put anything <i>on</i> the opening, now can
                you? ";
        else dobj.ioAttachTo(actor, self);
    }
    verDoDetach(actor) = {
        if (!garden_hose.attachedToShip)
            "Nothing&rsquo;s attached to the opening. ";
    }
    doDetach(actor) = { garden_hose.ioDetachFrom(actor, self); }
    verDoDetachFrom(actor, iobj) = {
        if (iobj != garden_hose || !garden_hose.attachedToShip)
            "\^<<iobj.thedesc>> isn&rsquo;t attached to the opening. ";
    }
    verIoDetachFrom(actor) = {}
    ioDetachFrom(actor, dobj) = {
        if (dobj != garden_hose)
            "\^<<dobj.thedesc>> isn&rsquo;t attached to the opening. ";
        else dobj.ioDetachFrom(actor, self);
    }
    doSynonym('Detach') = 'Unfasten' 'Unscrew'
    doSynonym('DetachFrom') = 'UnplugFrom' 'UnscrewFrom'
    ioSynonym('DetachFrom') = 'UnplugFrom' 'UnscrewFrom'
    verDoTakeOut(actor, iobj) = {
        if (iobj != garden_hose)
            pass verDoTakeOut;
        if (!garden_hose.attachedToShip)
            "The hose isn&rsquo;t attached to the opening. ";
    }
    ioTakeOut(actor, dobj) = {
        if (dobj != garden_hose)
            pass ioTakeOut;
        dobj.ioDetachFrom(actor, self);
    }
;

universal_translator: item
    alienItem = true
    isOn = true
    noun = 'rod' 'translator'
    adjective = 'straight' 'metal' 'metallic' 'silver' 'universal'
    sdesc = "universal translator"
    ldesc = {
        "The universal translator is a metallic silver rod about the
            length of your forearm and almost as thick around. It is
            currently turned <<self.isOn ? "on" : "off">>. There is a
            button on its side labelled ";
        if (translation_book.location != Me)
            "in an alien script";
        else "<q>Local Dialect Filter (archaic)</q>";
        if (translator_button.isPushed)
            ", which is currently pushed in";
        ". ";
    }
    whatdesc = "It translates spoken languages for the weilder. "
    momdesc = 'Another backyard treasure, huh?'
    daddesc = 'Hm. Probably some car part someone threw away.'
    doTake(actor) = {
        "It&rsquo;s surprisingly heavy--you can&rsquo;t pick it up. ";
    }
    doPush -> translator_button
    verDoTurnon(actor) = {
        if (self.isOn)
            "The translator is already on. ";
        else if (self.location == zigurt)
            "Zigurt won&rsquo;t let you close enough to it. ";
        else if (self.location == counter && floban.location ==
            counter.location && actor.location != counter)
            "Floban slaps your hand away with a tentacle. ";
    }
    doTurnon(actor) = {
        "You turn the translator back on. ";
        self.isOn = true;
    }
    verDoTurnoff(actor) = {
        if (!self.isOn)
            "The translator is already off. ";
        else if (self.location == zigurt)
            "Zigurt won&rsquo;t let you close enough to it. ";
        else if (self.location == counter && floban.location ==
            counter.location && actor.location != counter)
            "Floban slaps your hand away with a tentacle. ";
    }
    doTurnoff(actor) = {
        "You turn off the translator. ";
        self.isOn = nil;
    }
;

translator_button: fixeditem
    isPushed = nil
    noun = 'button'
    adjective = 'translator'
    location = universal_translator
    sdesc = "translator button"
    ldesc = {
        "A button on the side of the universal translator. ";
        if (self.isPushed)
            "It has been pushed in. ";
    }
    verDoPush(actor) = {
        if (universal_translator.location == zigurt)
            "Zigurt won&rsquo;t let you close enough to it. ";
        else if (universal_translator.location == counter &&
            floban.location == counter.location && actor.location != counter)
            "Floban slaps your hand away with a tentacle. ";
    }
    doPush(actor) = {
        "You push the button, which ";
        if (self.isPushed) "pops out. ";
        else "stays depressed when you release it. ";
        self.isPushed = !self.isPushed;
    }
;

translation_book: item
    alienItem = true
    noun = 'book'
    adjective = 'large' 'leather'
    sdesc = "large book"
    ldesc = "Large and, strangely enough, bound in leather. Stamped on its
        cover are the words, <q>To Serve Man.</q> Someone has made a feeble
        attempt to obliterate <q>Serve</q> and replace it with
        <q>Understand</q>. "
    momdesc = "Your mom frowns. <q>That reminds me, your library books are
        due tomorrow. Don&rsquo;t forget to take them with you to
        school.</q> "
    daddesc = 'I think that&rsquo;s the biggest book I&rsquo;ve seen you
        check out of the library yet.'
    whatdesc = "It&rsquo;s a translation book. "
    verDoRead(actor) = {}
    doRead(actor) = {
        "The book is filled with columns of flowing alien script matched up
            with their English equivalents and the occasional recipe. ";
    }
;

tylenol_bottle: openable, qcontainer
    alienItem = true
    contentsVisible = true
    contentsReachable = true
    isopen = true
    noun = 'bottle'
    adjective = 'small' 'white'
    location = floban
    sdesc = "white bottle"
    ldesc = {
        "The white bottle is about three inches tall";
        if (self.isopen)
            ". Its lid has been removed. The inside of the bottle is crammed
                full of white pills. ";
        else " and is closed. ";
    }
    momdesc = {
        "Mom grabs the bottle from you. <q>Don&rsquo;t be playing with
            mommy&rsquo;s medicine, kid.</q> ";
        self.moveInto(nil);
    }
    daddesc = {
        "<q>You know better than to go rooting around in the medicine
            cabinet.</q> Dad takes the bottle from you. ";
        self.moveInto(nil);
    }
    whatdesc = "It is a pill bottle. "
    doOpen(actor) = {
        "It takes you a moment, but you&rsquo;re finally able to twist off the
            child-proof lid. ";
        self.isopen = true;
        bottle_lid.moveInto(actor);
    }
    verDoClose(actor) = {
        if (!self.isopen)
            "The bottle isn&rsquo;t open. ";
        if (bottle_lid.location != actor)
            "Not without the lid to the bottle. ";
    }
    doClose(actor) = {
        if (self.location == counter && zigurt.location == counter.location &&
            actor.location != counter) {
            "A tentacle darts out, thumping your hand vigorously. ";
            if (VALLEYSPEAK)
                flo('Mitts off, creep,');
            else flo('Most definitely do not do that,');
            " Floban says while you rub your smarting hand. ";
            return;
        }
        "You pop the lid back on the bottle. ";
        self.isopen = nil;
        bottle_lid.moveInto(self);
    }
    verIoPutOn(actor) = {}
    ioPutOn(actor, dobj) = {
        if (dobj != bottle_lid)
            "There&rsquo;s no good surface on <<self.thedesc>>. ";
        else self.doClose(actor);
    }
    verIoPutIn(actor) = {
        if (!self.isopen)
            "Not while the lid is on. ";
        else "There is no need. ";
    }
;

tylenols: fixeditem
    noun = 'pill' 'pills' 'asprin' 'tylenol'
    adjective = 'white'
    location = tylenol_bottle
    sdesc = "white pills"
    ldesc = "Little. White. Similar. "
    whatdesc = "Acetaminophen. "
    verDoTake(actor) = {
        if (global.isHTMLRuntime) {
            "<CENTER>
            <FONT SIZE=\"+1\" COLOR=blue><q>Winners don&rsquo;t use
                drugs.</q></FONT>
            </CENTER>\n
            <DIV ALIGN=\"RIGHT\"><FONT SIZE=\"-1\">
            &mdash;This message brought to you by the director of the FBI.
            </FONT></DIV> ";
        }
        else {
            "\"Winners don't use drugs.\"\n\t\t
            --This message brought to you by the director of the FBI. ";
        }
    }
    doSynonym('Take') = 'Eat'
;

bottle_lid: item
    notakeall = true        // Because it's hidden in the junk
    noun = 'lid' 'cap' 'top'
    adjective = 'red' 'child-proof'
    location = hold_junk
    sdesc = "red lid"
    ldesc = "A red child-proof lid. "
    verDoTake(actor) = {
        if (self.location == tylenol_bottle)
            tylenol_bottle.verDoOpen(actor);
        else pass verDoTake;
    }
    doTake(actor) = {
        if (self.location == tylenol_bottle)
            tylenol_bottle.doOpen(actor);
        else pass doTake;
    }
;

ship_hallway: shipRoom
    sdesc = "Silvery Hallway"
    ldesc = "The silvery hallway splits into five branches, like the inside
        of some mutant cauliflower. The branches lead <<link('north', 'n')
        >>, <<link('northeast', 'ne')>>, <<link('northwest', 'nw')>>, <<
        link('southeast', 'se')>>, and <<link('southwest', 'sw')>>. Behind
        you, the <<link('ramp', 's')>> flops out onto the
        backyard. A <<link('strange metal plate', 'x plate')>> is attached
        to the wall by the ramp. "
    canGoNorth = true
    canGoSouth = true
    canGoNE = true
    canGoNW = true
    canGoSE = true
    canGoSW = true
    north = bridge
    south = backyard
    ne = slumber_chamber
    nw = rec_room
    se = hold
    sw = exam_room
    out = backyard
;

ship_ramp: fixeditem
    noun = 'ramp'
    location = ship_hallway
    sdesc = "ramp"
    ldesc = "It leads out onto the backyard. "
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(backyard); }
    doSynonym('Enter') = 'Climb'
    doGoto -> outside_ship_ramp
;

metal_plate: fixeditem
    mapGiven = nil
    noun = 'plate'
    adjective = 'strange' 'metal' 'shiny'
    location = ship_hallway
    sdesc = "strange metal plate"
    ldesc = "The plate is shinier than the rest of the surrounding wall, as
        if rubbed by countless tentacles (tentacli?). "
    whatdesc = "Your guess is as good as mine. "
    verDoRub(actor) = {
        if (self.mapGiven) {
            "Again the thousand filaments run across your mind. ";
             if (!global.isHTMLRuntime) "<q>";
            "<tt>Our cookie shows that you have already connected once in the
                last seven arbitrary time units. You may reconnect after this
                time period has elapsed.</tt>";
            if (!global.isHTMLRuntime) "</q>";
            " With a <i>snik!</i>\ the connection is gone. ";
        }
    }
    doRub(actor) = {
        self.mapGiven = true;
        "You feel the odd sensation of a thousand whispery filaments drawn
            lightly across your mind. The smell of oranges fills your nose,
            and a voice in your head says, <b>Non-V'lvxnlxian intelligence
            detected. Attempting to render information in comprehensible
            manner.</b> The voice goes away for a moment, then returns.
            It has changed, and is now oddly familiar. ";
         if (!global.isHTMLRuntime) "<q>";
         "<tt>Contacting host
            www.aliencomputer.com...done.</tt>";
         if (!global.isHTMLRuntime) "</q>";
         " Symbols and colors fill
            your vision, all incomprehensible. Then everything goes
            dark for a moment.\b";
        morePrompt();
        clearscreen();

        if (global.isHTMLRuntime) {
"<body background=\"Resources/shiptile.jpg\" bgcolor=#000000 text=#FFFFFF>

<table border=0 cellpadding=0 cellspacing=0 bgcolor=black width=100%>
  <tr><td align=\"center\" width=100%><p align=\"center\"><img src=\"Resources/Corps logo.jpg\"
        width=288 height=198></p>
  </td></tr>
</table>

<table border=0 cellpadding=0 cellspacing=8 width=100%>
  <tr>
    <td valign=\"top\" width=20% BGCOLOR=blue>Best viewed with a
        <IMG SRC=\"Resources/VButton.png\" WIDTH=\"88\" HEIGHT=\"31\">
    <p>Due to host wetware incompatibilities, all hyperlinks have been
        disabled.</p>
    <br><br><font size=+1>Did you know?</font>";
    "<br><font color=#FF4040>V'lvxnlxians</font> possess a form of sonar,
        in part to compensate for their lack of visual acuity and their
        sensitivity to light.</td>";
    "<td valign=\"top\">
	<font size=+1>";
	    }
	    
    "<p>Welcome to Scout 3LZ, a representative of the glorious
        <font color=red>V'lvxnlxian</font> empire!</p>
    <p>Scout 3LZ is one of the newer, faster Cuppa model scout ships. It
        incorporates new technology from the <u>Waveparticle Duality
        Consortium</u>. As a result, Cuppa model scouts boast an extremely
        short transit time between solar systems and high atmospheric
        maneuverability.
    <p>Scout 3LZ carries a crew of two:\ <font color=\"#00C000\">Zigurt</font>
        and <font color=\"#C000C0\">Floban</font>. Both are native
        <font color=red>V'lvxnlxians</font>, and both have had long and
        illustrious careers with the Corps. They are currently enjoying
        their tour through one of the lesser-explored arms of the galaxy,
        though they hope to find potential colony sites soon.</p>
    <p>What kind of colony sites does the Corps look for? Corps personnel
        are experienced planetologists who have an eye for comfort. They
        report on only the best planets, ones which are within 98% of
        <font color=red>V'lvxnlxia</font> norms. Though many different
        biospheres are acceptable, planets with dry climates and dim
        suns are a must.</p>
    <p>Corps personnel are also skilled negotiators and diplomats, in
        case a potential colony planet possesses a native race. A certain
        amount of intelligence is welcome in natives, as smarter natives
        are more capable of following orders. However, should a native
        population be found to possess intelligence above a 5.9 on the
        L'xlvnxl scale, the planet may require a quick bio-scrubbing.</p>
    <p>For your convenience while on-board, a temporary overlay map of
        the ship will be downloaded and installed. For visitors who are
        unable to handle a fully interactive overlay map, a hardcopy will
        be created for them.</p>";
        if (global.isHTMLRuntime) {
    "</font>";
    "<hr size=\"5\">
    <p align=\"center\">
        <font color=\"#00C0C0\" size=\"3\"><strong>what's new</strong></font>
        <font color=white size=\"3\"><strong> | </strong></font>
        <font color=\"#C0C000\" size=\"3\"><strong>current scouting route</strong></font><br>

        <font color=\"#00C000\" size=\"3\"><strong>zigurt personal</strong></font>
        <font color=white size=\"3\"><strong> | </strong></font>
        <font color=\"#C000C0\" size=\"3\"><strong>floban personal</strong></font>
        <font color=white size=\"3\"><strong> | </strong></font>
        <font color=\"#C00000\" size=\"3\"><strong>fun links</strong></font></p>
    </td>
  </tr>
</table>";
"<p align=\"right\">On-the-fly language processing provided by
    <strong>X'lnxvlv Enterprises</strong>.<br>
This ship has been accessed <IMG SRC=\"Resources/counter.png\"
    WIDTH=\"75\" HEIGHT=\"20\" BORDER=\"0\" ALT=\"2018\" VSPACE=\"0\"
    ALIGN=\"MIDDLE\"> times.</p>";
        }
        
        morePrompt();
        clearscreen();

        "<body bgcolor=white text=black>When you can see normally again, you
            find that you now possess a map of the ship. ";
        ship_map.moveInto(actor);
    }
    doSynonym('Rub') = 'Push'
    verDoTouch(actor) = {
        "A whispering of voices runs lightly through your mind, then fades
            away when you stop touching the plate. ";
    }
;

ship_map: item
    displayedBefore = nil
    noun = 'map'
    adjective = 'ship'
    sdesc = "ship map"
    ldesc = {
        if (!global.graphicsOn) {
            "The map shows the innards of the spaceship. According to it, the
                <<link('bridge', 'goto bridge')>> lies to the north of
                the silver hallway, the <<link('rec room', 'goto rec room')
                >> is northwest of the hallway, the <<
                link('slumber chamber', 'goto slumber chamber')>> is
                northeast,
                the <<link('exam room', 'goto exam room')>> is southwest,
                and the <<link('hold', 'goto hold')>> is southeast from
                the hallway. ";
            return;
        }
        
        // Define the image map for the map of the ship
        "<MAP NAME=\"mapmap\">
<AREA SHAPE=\"RECT\" COORDS=\"86, 147, 116, 227\" HREF=\"goto ramp\">
<AREA SHAPE=\"RECT\" COORDS=\"118, 146, 175, 192\" HREF=\"goto hold\">
<AREA SHAPE=\"RECT\" COORDS=\"51, 137, 82, 151\" HREF=\"goto exam room\">
<AREA SHAPE=\"RECT\" COORDS=\"24, 149, 84, 193\" HREF=\"goto exam room\">
<AREA SHAPE=\"RECT\" COORDS=\"138, 74, 159, 116\" HREF=\"goto slumber chamber\">
<AREA SHAPE=\"RECT\" COORDS=\"157, 56, 188, 141\" HREF=\"goto slumber chamber\">
<AREA SHAPE=\"RECT\" COORDS=\"41, 69, 65, 121\" HREF=\"goto rec room\">
<AREA SHAPE=\"RECT\" COORDS=\"10, 54, 43, 145\" HREF=\"goto rec room\">
<AREA SHAPE=\"RECT\" COORDS=\"65, 51, 139, 72\" HREF=\"goto bridge\">
<AREA SHAPE=\"RECT\" COORDS=\"43, 10, 169, 53\" HREF=\"goto bridge\">
</MAP>";
        // Print the banner, if we need to
        if (self.location == Me && !self.displayedBefore) {
            map_banner.turnOnBanner;   // map_banner defined in arr_ban.t
        }
        // Print the map. I don't use gprintf() here b/c I want the map
        //  shown each time, whether the player wants it or not
        "<IMG SRC=\"resources/map.jpg\" Width=\"200\" Height=\"236\"
            USEMAP=\"#mapmap\"><BR>";
        if (self.location == Me && !self.displayedBefore) {
            "[You may toggle the map display using the command <<link('display
                map', 'display map')>>] ";
            self.displayedBefore = true;
        }
    }
    momdesc = 'Yes, I see the map you&rsquo;ve drawn. It&rsquo;s very
        nice.'
    daddesc = "Dad glances at the map. <q>Nice coloring job. Does it lead to
        buried pirate treasure?</q> He smiles and begins reading again. "
    whatdesc = "Looking at the map should be enough to tell you what it is. "
    // If the player drops the map, the banner should go away
    moveInto(dest) = {
        if (map_banner.bannerOn && dest != Me) {
            map_banner.turnOffBanner;
        }
        pass moveInto;
    }
    verDoDisplay(actor) = {
        if (self.location != Me)
            "You must be holding the map to do that. ";
        else if (!global.isHTMLRuntime)
            "That command will only work in HTML versions of the runtime. ";
    }
    doDisplay(actor) = {
        map_banner.toggleBanner;
        if (!map_banner.bannerOn)
            "The map is no longer being displayed. ";
        else "Done. ";
    }
;

bridge: shipRoom, floatingItem
    gotoString = 'south'
    gotoFinalString = 'north'
    noun = 'bridge'
    sdesc = "Bridge"
    ldesc = "Curving control consoles, all just taller than you, line the
        underneath of the viewport. There are no chairs, no creature
        comforts&mdash;just austere controls and an exit to the <<
        link('south', 's')>>. "
    canGoSouth = true
    south = ship_hallway
    out = ship_hallway
;

bridge_viewport: fixeditem
    noun = 'viewport' 'port'
    location = bridge
    sdesc = "viewport"
    ldesc = "The viewport is shuttered, preventing you from seeing outside. "
;

bridge_controls: fixeditem
    noun = 'control' 'controls' 'consoles'
    adjective = 'control' 'curving' 'silver'
    location = bridge
    sdesc = "control consoles"
    ldesc = "No doubt the consoles are all lit up when the ship is flying, but
        right now they're turned off, their controls deactivated. A large
        red bar is locked across the consoles&rsquo; surface, leaving only one
        console free. "
    whatdesc = "The consoles control everything in the ship. "
    verDoTurnon(actor) = {
        "That red bar blocks you from most of the controls. ";
    }
    verDoTurnoff(actor) = {
        "Oh, no! You&rsquo;re too late&mdash;someone&rsquo;s beaten you to it! ";
    }
;

// I don't want the player to be able to work the console unless they have the
// translation book. I handle all of this in the ldesc. The first time the
// player looks at the console while holding the translation book, I teleport in
// the console's controls.
free_console: fixeditem
    firstTranslation = true     // Our labels have never been translated before
    locked = true               // The console is locked until the player
                                //  defeats the password panel
    // pictureFilename prints the filename of the picture which matches the
    // current state of the console's controls. Use this when drawing the console:
    // <IMG SRC=\"<<free_console.pictureFilename>>\">
    pictureFilename = {
        local i = 0;

        if (fuel_button.pushed)
            i += BUTTON_DEPRESSED;
        if (fuel_lever.setToIntake)
            i += LEVER_SET_TO_INTAKE;
        if (fuel_gauge.full)
            i += GAUGE_FULL;
        return('Resources/console'+cvtstr(i)+'.jpg');
    }
    noun = 'control' 'console'
    adjective = 'control' 'single' 'free'
    location = bridge
    sdesc = "free control console"
    ldesc = {
        if (global.graphicsOn && password_panel.location != self.location) {
            // Create the image map & display the console picture
            "<MAP NAME=\"consoleMap\"><AREA SHAPE=\"RECT\"
                COORDS=\"138, 24, 184, 61\" HREF=\"x gauge\">
                <AREA SHAPE=\"RECT\" COORDS=\"164, 75, 199, 110\"
                HREF=\"throw lever\"><AREA SHAPE=\"RECT\"
                COORDS=\"73, 73, 117, 102\" HREF=\"push button\">
                </MAP>";
            "<IMG SRC=\"<<self.pictureFilename>>\" WIDTH=300 HEIGHT=278
                Usemap=\"#consoleMap\"><BR>";
        }
        if (self.firstTranslation && translation_book.location == Me) {
            "By glancing between the console and the translation book, you are
                eventually able to figure out what the labels mean and what
                the controls are. The console appears to control the
                fuel systems. On it are a square pushbutton, a lever, and a
                gauge. ";
            self.firstTranslation = nil;
        }
        else "The console contains a square pushbutton, a lever, and a gauge. ";
        if (password_panel.location == bridge)
            "A metal panel is sticking out from the console&rsquo;s side. ";
    }
    verDoRead(actor) = {
        if (translation_book.location != Me) {
            "You can&rsquo;t&emdash;you don&rsquo;t know how to read the
                alien script. ";
        }
    }
    doRead(actor) = (self.ldesc)
;

password_panel: fixeditem
    // This is, for the most part, exactly like free_console's pictureFilename
    pictureFilename = {
        local i = 0;

        if (red_triangle.isGlowing)
            i += TRIANGLE_ON;
        if (green_square.isGlowing)
            i += SQUARE_ON;
        if (blue_circle.isGlowing)
            i += CIRCLE_ON;
        return('Resources/panel'+cvtstr(i)+'.jpg');
    }

    noun = 'panel'
    adjective = 'metal'
    sdesc = "metal panel"
    ldesc = {
        local   glows = [], len, i;
        
        if (global.graphicsOn) {
            // Create the image map & display the console picture
            "<MAP NAME=\"panelMap\"><AREA SHAPE=\"RECT\"
                COORDS=\"135, 135, 170, 167\" HREF=\"press blue circle\">
                <AREA SHAPE=\"RECT\" COORDS=\"40, 138, 70, 172\"
                HREF=\"press green square\"><AREA SHAPE=\"RECT\"
                COORDS=\"89, 81, 121, 115\" HREF=\"press red triangle\">
                </MAP>";
            "<IMG SRC=\"<<self.pictureFilename>>\" width=\"300\"
                height=\"286\" usemap=\"#panelMap\"><BR>";
        }
        "From the side of the console juts a metal panel. On it are a red
            triangle, green square, and blue circle. ";
        if (red_triangle.isGlowing)
            glows += red_triangle;
        if (green_square.isGlowing)
            glows += green_square;
        if (blue_circle.isGlowing)
            glows += blue_circle;
        len = length(glows);
        if (len != 0) {
            "\^";
            for (i = 1; i <= len; i++) {
                glows[i].thedesc;
                if (i == len) continue;
                if (i+1 < len)
                    ", ";
                else if (i == 1)
                    " and ";
                else ", and ";
            }
            " <<len == 1 ? "is" : "are">> glowing. ";
        }
        "Someone has scrawled a hasty note across the panel in a flowing alien
            script. ";
    }
    heredesc = "Sticking out of the side of one of the consoles is a metal
        panel. "
    deploy = {
        "Something whirrs within the console. A hole opens in its side,
            allowing a metal panel to slide out. The hole closes, leaving the
            edge of the panel stuck to the side of the console. ";
        self.moveInto(bridge);
    }
    verDoAttack(actor) = {}
    doAttack(actor) = {
        "You cock your arm back and give the panel what-for! It vibrates
            wildly, making a high-pitched ringing sound. The colored shapes
            on its surface all flash together, and the panel is swallowed
            back up by the console. Violence <b>was</b> the answer to this
            one! ";
        self.moveInto(nil);
        free_console.locked = nil;
    }
    doSynonym('Attack') = 'Break'
    doRead -> password_panel_note
;

password_panel_note: fixeditem, readable
    noun = 'note'
    adjective = 'hasty' 'scrawled'
    location = password_panel
    sdesc = "hasty note"
    ldesc = {
        if (translation_book.location == Me) {
            floNQ('Zigurt,\bThe identification verification mechanism has
                ceased working properly. Fortunately, you need merely hit it
                for it to unlock the fuel control subsystem.');
        }
        else "You can&rsquo;t tell what the note on the panel says. ";
    }
    readdesc = (self.ldesc)
;

class passwordButton: fixeditem, buttonitem
    isGlowing = nil
    location = password_panel
    soundDesc = ''                  // Describes the sound made when pressed
    soundFile = ''                  // What sound file should we use?
    ldesc = {
        "\^<<self.thedesc>> is on the metal panel. ";
        if (self.isGlowing)
            "It is glowing gently. ";
    }
    doPush(actor) = {
        "You push <<self.thedesc>> down. A <<self.soundDesc>> sounds and <<
            self.thedesc>> ";
        if (self.isGlowing)
            "stops glowing. ";
        else "begins glowing. ";
        "<sound layer=\"BACKGROUND\" src=\"<<self.soundFile>>\" interrupt>";
        self.isGlowing = !self.isGlowing;
    }
;

red_triangle: passwordButton
    noun = 'triangle'
    adjective = 'red'
    sdesc = "red triangle"
    soundDesc = 'low-pitched note'
    soundFile = 'Snds/LowNote.mid'
;

green_square: passwordButton
    noun = 'square'
    adjective = 'green'
    sdesc = "green square"
    soundDesc = 'note of moderate pitch'
    soundFile = 'Snds/MidNote.mid'
;

blue_circle: passwordButton
    noun = 'circle'
    adjective = 'blue'
    sdesc = "blue circle"
    soundDesc = 'high-pitched note'
    soundFile = 'Snds/HighNote.mid'
;

// The button changes from blue to red when the hatch is open. The 'hatchOpen'
// property in the real_ship item keeps track of whether or not the hatch
// is open, and thus whether the button is blue or red.
fuel_button: buttonitem
    pushed = (real_ship.hatchOpen)
    handleOpening = {
        addword(self, &adjective, 'red');
        delword(self, &adjective, 'blue');
        real_ship.hatchOpen = true;
        ship_hatch.moveInto(backyard);
        ship_opening.moveInto(backyard);
        if (!fuel_lever.setToIntake)
            fuel_gauge.emptyIfNecessary;
    }
    handleClosing = {
        addword(self, &adjective, 'blue');
        delword(self, &adjective, 'red');
        real_ship.hatchOpen = nil;
        ship_hatch.moveInto(nil);
        ship_opening.moveInto(nil);
    }
    noun = 'pushbutton' 'button'
    adjective = 'square' 'royal' 'blue' 'flaming'
    location = bridge
    sdesc = "square button"
    ldesc = {
        if (translation_book.location == Me)
            "The <<real_ship.hatchOpen ? "flaming red" :
                "royal blue">> button&rsquo;s
                label translates roughly as &lsquo;fuel intake cover
                latch&rsquo;. ";
        else "The <<real_ship.hatchOpen ? "flaming red" :
            "royal blue">> button&rsquo;s label is unreadable. ";
    }
    doPush(actor) = {
        if (free_console.locked) {
            if (password_panel.location == nil)
                password_panel.deploy;
            else "The button refuses to go down at all. ";
            return;
        }
        "<sound src=\"Snds/Button Click.wav\" layer=\"foreground\">";
        if (real_ship.hatchOpen) {
            "The button depresses, but without the resistance you
                felt earlier. ";
        }
        else {
            "You have to lean a little on the button to get it to go all
                the way down, but when you do, it turns from blue to red. ";
            self.handleOpening;
        }
    }
;

fuel_lever: fixeditem
    setToIntake = nil
    noun = 'lever'
    adjective = 'small'
    location = bridge
    sdesc = "small lever"
    ldesc = {
        "A small lever, roughly the size of your index finger. ";
        if (translation_book.location == Me)
            "The forward position&rsquo;s script translates as
                &lsquo;intake&rsquo;, the back position&rsquo;s as
                &lsquo;outflow&rsquo;. ";
        else "Its two positions are labelled in alien script, but you
            can&rsquo;t tell what they mean. ";
        "The lever is currently <<self.setToIntake ? "pushed forward" :
            "pulled back">>. ";
    }
    verDoThrow(actor) = {}
    doThrow(actor) = {
        if (self.setToIntake)
            self.doPull(actor);
        else self.doPush(actor);
    }
    verDoPull(actor) = {
        if (!self.setToIntake)
            "The lever won&rsquo;t pull back any farther. ";
    }
    doPull(actor) = {
        if (free_console.locked) {
            if (password_panel.location == nil)
                password_panel.deploy;
            else "The lever is completely stuck. ";
            return;
        }
        "<sound src=\"Snds/Lever Pull.wav\" layer=\"foreground\">";
        "The lever ratchets towards you, as if in need of oil. ";
        self.setToIntake = nil;
        garden_hose.detachFromShip;
        if (fuel_button.pushed)
            fuel_gauge.emptyIfNecessary;
    }
    verDoPush(actor) = {
        if (self.setToIntake)
            "The lever won&rsquo;t go forward any more. ";
    }
    doPush(actor) = {
        if (free_console.locked) {
            if (password_panel.location == nil)
                password_panel.deploy;
            else "The lever is completely stuck. ";
            return;
        }
        "<sound src=\"Snds/Lever Push.wav\" layer=\"foreground\">";
        "You push the lever gently away from you. It ratchets forward in
            fits and starts. ";
        self.setToIntake = true;
    }
;

fuel_gauge: fixeditem
    full = true
    fillLevel = {
        if (self.full) "full";
        else "empty";
    }
    emptyIfNecessary = {
        if (self.full) {
            self.full = nil;
            "The gauge&rsquo;s needle slowly moves to empty. ";
            if (fuel_puddle.location == nil && water_puddle.location == nil)
                fuel_puddle.moveInto(backyard);
            else if (water_puddle.location == nil) {
                fuel_puddle.moveInto(nil);
                water_puddle.moveInto(backyard);
            }
        }
        real_ship.emptyShip;
    }
    noun = 'gauge'
    adjective = 'fuel'
    location = bridge
    sdesc = "gauge"
    ldesc = {
        if (translation_book.location == Me)
            "The gauge&rsquo;s label translates as &lsquo;level of the
                fuel&rsquo;. It currently reads <<self.fillLevel>>. ";
        else "The gauge reads <<self.fillLevel>>. ";
        if (real_ship.filledWithWater)
            "Some water has condensed inside it. ";
    }
;

ship_club: fixeditem
    noun = 'club' 'bar'
    adjective = 'large' 'red' 'metal' 'ship'
    location = bridge
    sdesc = "large red bar"
    ldesc = "A large red bar is locked across the control consoles, preventing
        you from accessing them. Something is printed across it. "
    takedesc = "It&rsquo;s far too solidly locked. "
    whatdesc = "It is a device to prevent spaceship theft. "
    verDoUnlock(actor) = {
        "You&rsquo;d need a key, and I don&rsquo;t see the aliens just handing
            one over to you. Besides, you don&rsquo;t have your drivers&rsquo;
            permit yet. ";
    }
    verDoPush(actor) = {
        "No matter how you tug at the bar, it stays in place. ";
    }
    doSynonym('Push') = 'Pull' 'Move'
    verDoRead(actor) = {}
    doRead(actor) = { "<q>The Club.</q> "; }
;

rec_room: shipRoom, floatingItem
    gotoString = 'southeast'
    gotoFinalString = 'northwest'
    noun = 'room'
    adjective = 'rec'
    sdesc = "Rec Room"
    ldesc = "The rec room is surprisingly empty, its only features a slanted
        ledge on one wall and a counter jutting from another. Across from
        the ledge is the <<link('southeast exit', 'se')>>. "
    canGoSE = true
    se = ship_hallway
    out = ship_hallway
    // The first time the player enters, start Floban a-poppin them pills,
    // and prepare the aliens' conversation
    firstseen = {
        notify(floban, &popPill, 5 + _rand(2));
        zigurt.phraseNumbers = shuffle(zigurt.phraseNumbers);
        notify(zigurt, &makeConversation, 3 + _rand(2));
        "\bFloban nods in your direction. <<flo('Ambassador,')>> he says. ";
    }
    leaveRoom(actor) = {
        local   i, len, list = [];
        if (floban.location != self || actor.canThieve)
            pass leaveRoom;
        len = length(actor.contents);
        for (i = 1; i <= len; i++)
            if ((actor.contents[i]).alienItem)
                list += actor.contents[i];
        if (length(list) > 0) {
            "As you are walking away, a purple tentacle encircles you and
                drags you back. <<flo('Zigurt!')>> Floban calls. ";
            if (VALLEYSPEAK)
                flo('Like, the Ambassador is such a dork, trying to steal
                    our stuff! See?');
            else flo('The Ambassador has filched some of our things!
                Observe.');
            " Tentacles dart in and out of your pockets, producing ";
            // This next part is a nasty hack to keep me from having to
            // re-write the listcont() function.
            moveList(list, contentObj);
            listcont(contentObj);
            moveList(list, counter);        // Move the stolen stuff back
            " as if by magic.\b";
            if (VALLEYSPEAK)
                zig('So put them, like, back on the counter, okay? You can
                    be such the wuss,');
            else zig('Replace them on the counter and let us continue,
                    Floban,');
            " Zigurt says.\b";
            if (VALLEYSPEAK)
                flo('What-EVERRR!');
            else flo('Hmph,');
            " says Floban. ";
            if (VALLEYSPEAK)
                flo('You so need to not steal our stuff.');
            else flo('Really, Ambassador. Stooping to petty theivery.');
            " He turns around, ignoring you. ";
            if (VALLEYSPEAK)
                flo('So, like, scram, dweeb.');
            else flo('You may go now.');
            " Chastened, you walk out of the rec room.\b";
        }
        pass leaveRoom;
    }
;

// adv.t has a function to print out the contents of something in a nice, neat
// list, but doesn't make that function available for just any old list. So
// I've made this kludge object as a workaround. If you have a list of objects
// which you'd like printed, move the objects to this object, then call
// listcont(contentObj). This only works when you want all the objects lumped
// together, so this isn't an ideal hack.
contentObj: thing
;

slanted_ledge: fixeditem
    noun = 'ledge'
    adjective = 'slanted'
    location = rec_room
    sdesc = "slanted ledge"
    ldesc = {
        "The ledge is slightly above your eye level. ";
        if (road_atlas.location == self)
            "An open road atlas lies on it. ";
    }
    verIoPutOn(actor) = {
        if (floban.location == rec_room)
            "The aliens gently push you away. ";
        else "There&rsquo;s no need to cover the atlas with anything. ";
    }
;

road_atlas: fixeditem
    isListed = true
    noun = 'atlas' 'map' 'maps'
    adjective = 'road'
    location = slanted_ledge
    sdesc = "road atlas"
    ldesc = "The atlas lies open to a map of the USA. "
    takedesc = {
        if (floban.location == rec_room)
            "The aliens gently push you away. ";
        else "Some invisible energy field protects it&mdash;your fingers slide
            right over it. ";
    }
    verDoRead(actor) = {}
    doRead(actor) = {
        if (floban.location == rec_room)
            "You step in front of Floban, jumping a little to see over
                Zigurt&rsquo;s shoulder. Floban pushes you back with an
                exasperated hissing sound. ";
        else "You stand on tip-toes and trace several roads and rivers with
            a finger. ";
    }
;

// The counter is a hybrid object; it is both fixed counter and it's where
// the player goes when (s)he hides behind it. Thus its code is unusual.
counter: fixeditem, surface, nestedroom
    statusPrep = "behind"
    reachable = [ counter, small_space ]
    noun = 'counter'
    adjective = 'low' 'low-slung' 'formica'
    location = rec_room
    sdesc = "low-slung counter"
    ldesc = {
        "The counter sticks out from one curved wall of the rec-room, leaving
            a small space behind it. Its surface is a shiny white, so shiny
            that you&rsquo;d swear it was Formica. ";
        if (length(self.contents) > 0)
            "On the counter you see <<listcont(self)>>. ";
        if (length(small_space.contents) > 0)
            "Behind it, in the small space, you see <<listcont(small_space)>>. ";
    }
    roomdesc = {
        "Your hiding place doesn&rsquo;t give you much of a view of the rec
            room. You can just see the top of the counter, and a small slice
            of the room next to the southeast exit is visible. ";
        if (zigurt.location == rec_room)
            "From time to time you hear Zigurt or Floban moving about. ";
    }
    whatdesc = "Formica. Definitely formica. "
    // Don't let the player grab stuff from the counter with the aliens present
    verGrab(obj) = {
        if (zigurt.location == rec_room && Me.location != counter) {
            "A tentacle darts out, thumping your hand and making it sting. ";
            if (VALLEYSPEAK)
                flo('Like, manners? Paws off, creep,');
            else flo('That is not polite,');
            " Floban says. ";
        }
    }
    leaveRoom(actor) = {
        self.location.leaveRoom(actor);
        pass leaveRoom;
    }
    // Don't let the player put stuff on the counter, neither, unless it's
    //  supposed to be there.
    ioPutOn(actor, dobj) = {
        if (zigurt.location == rec_room && Me.location != counter) {
            if (dobj.alienItem) {
                "Floban stares at you for a moment, trying to figure out if
                    you were taking the book or leaving it. He then says, ";
                if (VALLEYSPEAK)
                    flo('Hands off our stuff, creep.');
                else flo('Kindly do not handle our things.');
                dobj.moveInto(self);
            }
            else {
                "Floban gently shoves you away from the counter. ";
                if (VALLEYSPEAK)
                    flo('Don&rsquo;t, y&rsquo;know, put stuff there, kay?');
                else flo('You should not put anything on our counter.');
            }
        }
        else pass ioPutOn;
    }
    verDoHidebehind(actor) = {
        if (actor.location == self)
            "You&rsquo;re already hiding in the small space behind the counter. ";
    }
    doHidebehind(actor) = {
        "You slither in the small space behind the counter, crouching down. ";
        if (zigurt.location == rec_room)
            "Neither Zigurt nor Floban see you; they only have ocular
                appendages for the atlas. ";
        actor.moveInto(self);
    }
    verDoUnhidebehind(actor) = {
        if (actor.location != self)
            "But you&rsquo;re not behind the counter. ";
    }
    doUnhidebehind(actor) = { self.doUnboard(actor); }
    doSynonym('Hidebehind') = 'Enter'
    // The next bit lets the player exit the room from behind the counter
    canGoSE = true
    north -> rec_room
    south -> rec_room
    east  -> rec_room
    west  -> rec_room
    up    -> rec_room
    down  -> rec_room
    ne    -> rec_room
    nw    -> rec_room
    se    -> rec_room
    sw    -> rec_room
    in    -> rec_room
    out = rec_room
    noexit = { "%You% can&rsquo;t go that way. "; return nil; }
    // If the player drops something, it should go into the small_space,
    // *not* into counter
    roomDrop(obj) = {
        "Dropped. ";
        obj.moveInto(small_space);
    }
    // I'm also going to tweak lookAround/nrmLkAround to change the room
    //  description when the player's hiding behind the counter
    lookAround( verbosity ) = {
        self.statusRoot; "\n\t";
        self.nrmLkAround( verbosity );
    }
    nrmLkAround(verbosity) = {
        local l, cur, i, tot;

        if ( verbosity )
        {
            "\n\t"; self.roomdesc;  // roomdesc is of my own making

            l = self.contents;
            tot = length( l );
            i = 1;
            while ( i <= tot )
            {
                cur = l[i];
                if ( cur.isfixed ) cur.heredesc;
                i++;
            }
        }
        "\n\t";
        // Re-route the list of contents to small_space
        if (itemcnt( small_space.contents ))
        {
            "You see "; listcont( small_space ); " here. ";
        }
        listcontcont( small_space ); "\n";
        // Print anything that's on top of the counter
        if (itemcnt(self.contents))
        {
            self.dispParagraph;
            "On top of <<self.thedesc>> you see <<listcont(self)>>. ";
        }
        // If you look in the definition of nrmLkAround in room, you'll
        //  discover that here is where it handles actors. I know for a fact
        //  that no actor (other than the player) will ever be back here, so
        //  I've deleted that part of the processing.
    }
;

small_space: fixeditem
    isqcontainer = true     // Don't spill your guts in the ldesc
    noun = 'space' 'cubby'
    adjective = 'small'
    location = rec_room
    sdesc = "small space"
    ldesc = {
        "The space is just big enough for you to crouch down behind the
            counter. ";
        if (length(self.contents) > 0)
            "In it you see <<listcont(self)>>. ";
    }
    verDoEnter(actor) = {}
    doEnter(actor) = {
        counter.doHidebehind(actor);
    }
    doSynonym('Enter') = 'Board'
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
        dobj.doPutIn(actor, self);
    }
;

slumber_chamber: shipRoom, floatingItem
    gotoString = 'southwest'
    gotoFinalString = 'northeast'
    noun = 'chamber'
    adjective = 'slumber'
    sdesc = "Slumber Chamber"
    ldesc = "The room is several degrees colder than the hallway to the
        <<link('southwest', 'sw')>>, a chill which leaves your breath
        diaphanous in front of you. Ovoids the size of small couches lie
        scattered about. "
    canGoSW = true
    sw = ship_hallway
    out = ship_hallway
;

sleep_pods: fixeditem, openable
    isopen = nil
    isThem = true
    noun = 'pod' 'pods' 'ovoid' 'ovoids'
    adjective = 'small' 'sleep'
    location = slumber_chamber
    sdesc = "sleep pods"
    ldesc = {
        "The ovoids must be sleep pods, given their frosted windows and
            sleep-podish appearance. ";
        if (length(self.contents) > 0) {
             if (self.isopen)
                "Resting in the pods you see <<listcont(self)>>. ";
             else
                "There&rsquo;s something in the pods, though you can&rsquo;t
                    tell what it is through the frosting. ";
        }
    }
    takedesc = "The pods are bolted to the deck. "
    whatdesc = "They place beings in suspended animation for long flights. "
    doOpen(actor) = {
        "The pods open reluctantly and with a hiss. ";
        self.isopen = true;
    }
    verIoPutIn(actor) = {
        if (!self.isopen)
            "The pods are closed. ";
    }
    verDoEnter(actor) = {
        if (!self.isopen)
            "Good luck getting in the sleep pods while they&rsquo;re closed. ";
    }
    doEnter(actor) = {
        "Gingerly you lower yourself into a pod. You have to wiggle around
            a bit before you&rsquo;re comfortable, but soon enough
            you&rsquo;re settled.\b
        All that shifting and squirming must have started the pod&rsquo;s
            lid to closing, though. You look up just as the lid snicks into
            place.\b
        You thump your fists against the lid, hard at first, then weaker and
            weaker as the gas filling the pod puts you to sleep.\b";
        pageBreak();
        "You blink away the crusty sleep which fills your eyes. Above you,
            Zigurt and Floban peer at you in surprise.\b";
        if (VALLEYSPEAK)
            zig('Like, Ambassador!');
        else zig('Ambassador!');
        " Zigurt says as he helps you out of the pod. ";
        if (VALLEYSPEAK)
            zig('Oh my gawd! We had nooo idea you were, like, snoozing in
                the pods!');
        else zig('We had no idea you were on board with us!');
        "\b";
        if (VALLEYSPEAK)
            flo('Yeah, but, like, this can be good!');
        else flo('But what a wonderful happenstance!');
        " Floban says. ";
        if (VALLEYSPEAK)
            flo('I mean, we can&rsquo;t take you back to, y&rsquo;know,
                your home, &rsquo;cause your planet has, like, been
                V&rsquo;lvxnlxiaformed.');
        else flo('We cannot return you to your world, since the
            V&rsquo;lvxnlxiaforming of Terra is nearly complete.');
        " He looks sad for a moment, pausing in sympathy. <<flo('But!')
            >> he says, brightening, ";
        if (VALLEYSPEAK)
            flo('Our leaders&rsquo;ll, like, y&rsquo;know, probably think
                you&rsquo;re funny, and they probably won&rsquo;t, like,
                kill you or anything.');
        else flo('The nobles of V&rsquo;lvxnlxia will no
            doubt find you amusing, and suffer you to live.');
        "\b";
        if (VALLEYSPEAK)
            zig('Like, Floban.');
        else zig('Say, Floban.');
        " Floban turns to look at Zigurt, who is now holding a small
            barrel organ. ";
        if (VALLEYSPEAK)
            zig('Can you, y&rsquo;know, play this thing? It&rsquo;ll make
                the Ambassador way funnier.');
        else zig('If you can learn to play
            this instrument, no doubt the Ambassador&rsquo;s performances
            will be more entertaining.');
        "\b";
        if (VALLEYSPEAK)
            flo('Like, oh my gawd! What a way rad idea!');
        else flo('Splendid!');
        "\b";
        if (VALLEYSPEAK)
            theEnd('You have, like, slept the sleep of the sleepy');
        else theEnd('You have slept the sleep of the sleepy');
    }
    doSynonym('Enter') = 'Board' 'Lieon'
;

exam_room: shipRoom, floatingItem
    gotoString = 'northeast'
    gotoFinalString = 'southwest'
    noun = 'room'
    adjective = 'exam' 'examination'
    sdesc = "Examination Room"
    ldesc = "Stark. Metal. An examination table fills the center of the room.
        Above it crouch various tools on metal appendages, extended like the
        legs of some insect. Along one wall is a control panel. The exit is
        to the <<link('northeast', 'ne')>>. "
    thedesc = "the examination room"
    canGoNE = true
    ne = ship_hallway
    out = ship_hallway
;

exam_table: fixeditem, surface
    noun = 'table'
    adjective = 'exam' 'examination'
    location = exam_room
    sdesc = "examination table"
    ldesc = {
        "Whatever metal was used in its making has been buffed to a high
            sheen. You can see your face reflected in its surface when you
            stand on tippy-toes. ";
        if (itemcnt(self.contents))
            "On it you see <<listcont(self)>>. ";
    }
    verDoLieon(actor) = {
        "You spend a moment fantasizing what it would be like to be examined
            by Zigurt and Floban. The pain you would experience would likely
            far outweigh any money a tabloid (or the Fox network) might
            pay. ";
    }
    doSynonym('Lieon') = 'Siton'
    verDoClimb(actor) = {
        "Its metal proves to be too slippery for you to gain enough purchase
            to scale it. ";
    }
    doSynonym('Climb') = 'Standon' 'Board'
;

various_tools: fixeditem
    noun = 'tool' 'tools'
    adjective = 'various'
    location = exam_room
    sdesc = "various tools"
    ldesc = "You can begin to guess at some of the tools&rsquo;
        functions&mdash;the
        brightly-shining light is familiar, reminding you of visits to the
        dentist. Other tools, however, are too strange for your puny Earth
        brain. "
    whatdesc = "No telling. "
    dobjGen(a, v, i, p) = {
        if (v != inspectVerb) {
            "The tools are much too far away for a short kid like you. Even
                if you stood on the table you couldn&rsquo;t reach them. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

metal_appendages: distantItem
    noun = 'appendage' 'appendages'
    adjective = 'metal'
    location = exam_room
    sdesc = "metal appendages"
    ldesc = "They all sprout from a central point in the ceiling, then dangle
        obscenely above the table. "
    whatdesc = "They are pieces of metal from which tools are suspended. "
    dobjGen(a, v, i, p) = {
        if (v != inspectVerb) {
            "The appendages are much too far away for a short kid like you.
                Even if you stood on the table you couldn&rsquo;t reach them. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

exam_control_panel: fixeditem
    noun = 'panel'
    adjective = 'control'
    location = exam_room
    sdesc = "control panel"
    ldesc = "The panel is low enough that you can see a dizzying array of
        levers, knobs, and switches, but you can&rsquo;t see any labels, if
        there are any. "
    // This will prevent some awkward disambiguation problems
    verDoWhatis(actor) = {
        "The panels control everything in the ship. ";
    }
;

exam_controls: fixeditem
    noun = 'lever' 'levers' 'switch' 'switches' 'knob' 'knobs' 'control' 'controls'
    location = exam_room
    sdesc = "controls"
    ldesc = "So many controls. So many, many controls, and all unlabeled. "
// I want to know whether the player is referring to a lever, knob, switch, or
// "control". This function returns 1 if the player's talking about a lever,
// 2 for knob, 3 for switch, and 4 for control.
    whatdesc = "The only way you&rsquo;ll find out for sure is if you play
        with them. "
    idVocab = {
        local list;

        list = objwords(1);                 // Get the direct object words
        if (find(list, 'lever') != nil || find(list, 'levers') != nil)
            return 1;
        if (find(list, 'knob') != nil || find(list, 'knobs') != nil)
            return 2;
        if (find(list, 'switch') != nil || find(list, 'switches') != nil)
            return 3;
        return 4;                           // Assume player typed 'control'
    }
// compareID sees if the player typed the proper word or not. This is so you
// can't, say, pull a knob or turn a switch. It returns true if the player
// typed either the word you wanted (see above for which numbers correspond to
// which words) or "control(s)".
    compareID(num) = {
        local i;

        i = self.idVocab;
        return (i == num || i == 4);
    }
    verDoPull(actor) = {
        if (!self.compareID(1))              // You pull a lever (1)
            "Why don&rsquo;t you try that on a lever? ";
    }
    doPull(actor) = {
        "You yank on a lever. ";
        self.performRandomActOfTesting;
    }
    doSynonym('Pull') = 'Push'
    verDoTurn(actor) = {
        if (!self.compareID(2))              // You turn a knob (2)
            "Why don&rsquo;t you try that on a knob? ";
    }
    doTurn(actor) = {
        "You reach up and give a knob a quick turn. ";
        self.performRandomActOfTesting;
    }
    verDoFlip(actor) = {
        if (!self.compareID(3))              // You flip a switch (3)
            "Why don&rsquo;t you try that on a switch? ";
    }
    doFlip(actor) = {
        "You flip a switch at random. ";
        self.performRandomActOfTesting;
    }
    doSynonym('Flip') = 'Turnon' 'Turnoff'
// randomActionList is a list of actions which occur when the player yanks on
// one of the controls.
    randomActionList = [
        'A light flickers above the table, then quits. '
        'There is a loud keening sound as a laser beam shoots from one of
            the tools and strikes the table. The beam traces up the middle
            of the table before shutting off again. '
        'A whirling circular saw descends, slices the air above the table,
            then retracts. '
        'Tiny motes of light float down onto the table, then vanish. '
        'An energy field flicks into brief existence around the table. '
        'The table undergoes a series of uncomfortable-looking contortions
            before straightening back out. '
        'A pair of gloved hands descends on the table, makes kneading and
            probing motions, then retracts. '
        'From the ceiling, a giant probe drops onto the table. A few jabbing
            motions later, it ascends back into the cluster of tools. '
        'Pulsing, throbbing bands of energy play across the table&rsquo;s
            surface for a moment. '
        'A disco ball descends, shooting rays of color throughout the room
            for a brief moment. '
        'The table is wrapped in what looks suspiciously like
            Saran-Wrap. The plastic sheeting dissolves and
            vanishes a short time later. '
        'A black box drops from the ceiling, hovering a foot above the
            table. From it a constant pinging sound emerges. It slides above
            the table, tracing out a grid, then falls quiet and vanishes back
            into the ceiling. '
    ]
// randomActionNumber keeps track of where we are in the list
    randomActionNumber=100

// Finally, the function which makes it happen. Things to note: once
// randomActionNumber is greater than the length of randomActionList, I
// change the order in which all the actions occur by using the function
// shuffle(), defined in arrival.h.
    performRandomActOfTesting = {
        local i = itemcnt(exam_table.contents);
        
        if (i != 0) {
            "The table shudders, as if trying to do something, then quits.
                A red light on the control panel winks on, then off. A tool
                descends, points angrily at the object<<i > 1 ? "s" : "">> on
                the table&rsquo;s surface, and retracts once more. ";
            return;
        }

        if (self.randomActionNumber > length(self.randomActionList)) {
            self.randomActionNumber = 1;
            self.randomActionList = shuffle(self.randomActionList);
        }
        say(self.randomActionList[self.randomActionNumber]);
        self.randomActionNumber++;
    }
;

hold: shipRoom, floatingItem
    gotoString = 'northwest'
    gotoFinalString = 'southeast'
    noun = 'hold'
    adjective = 'ship' 'ship\'s'
    sdesc = "Ship&rsquo;s Hold"
    ldesc = "In sharp contrast to what you&rsquo;ve seen of the rest of the
        ship, this room is filthy. Junk piles up in corners, spilling out
        over the floor, claiming most of the room. It&rsquo;s as if Zigurt
        and Floban had thrown every bauble which had ever caught their eye
        into this room without regard for order or the boundaries of good
        taste. Indeed, most things you see lie squarely on the far
        side of tasteful. Somewhere in the midst of the junk is the <<
        link('northwest exit', 'nw')>>. "
    canGoNW = true
    nw = ship_hallway
    out = ship_hallway
;

// The player is going to be able to search the junk for stuff. What I'll do
// is put all possible items the player can find inside hold_junk and then
// pick one at random each time the player searches until there's nothing
// left.
// You may ask: why not use a searchHider? Well, I want to randomize the order
// in which the object are found from game to game. What can I say? I'm
// stubborn.
hold_junk: fixeditem
    contentsVisible = nil               // Can't see what's in me
    contentsReachable = nil             // Can't reach what's in me
    zigdesc = {
        "Zigurt says, ";
        if (VALLEYSPEAK)
            zig('Our, like, collection? It&rsquo;s way rad. We take,
                y&rsquo;know, stuff from every planet we go to.');
        else zig('Our small collection of memorabilia? We take mementos from
            every planet we visit.');
    }
    flodesc = {
        "Floban says, ";
        if (VALLEYSPEAK)
            flo('Isn&rsquo;t that stuff cool?');
        else flo('Isn&rsquo;t our collection lovely?');
    }
    noun = 'junk' 'pile' 'piles' 'bauble' 'bauble'
    adjective = 'junk'
    location = hold
    sdesc = "junk"
    ldesc = "The amount of junk thrown down here is astounding. There&rsquo;s
        no telling what you could find with a bit of work. "
    verDoSearch(actor) = {
        if (itemcnt(self.contents) == 0)
            "You find nothing else. ";
    }
    doSearch(actor) = {
        local i, obj;

        i = _rand(length(self.contents));
        obj = self.contents[i];
        "Some rooting around turns up <<obj.adesc>>, which you pick up. ";
        obj.notakeall = nil;        // Fix this before you go-go
        obj.moveInto(actor);
    }
    doSynonym('Search') = 'Lookin' 'Lookthru' 'Lookunder' 'Lookbehind'
    verDoClean(actor) = {
        "What, you get so few things to clean at home that you want to go
            clean an alien ship? Get out. ";
    }
;

// You know, this hose is a lot more complex than I'd expect a hose to be
garden_hose: item
    notakeall = true            // So you can't take all the hold junk at once
    attachedToFaucet = nil          // True when we're attached to faucet
    attachedToShip = nil            // True when we're attached to spaceship
    noun = 'hose'
    adjective = 'garden' 'green'
    location = hold_junk
    sdesc = "garden hose"
    ldesc = {
        "A green garden hose. ";
        if (self.attachedToFaucet) {
            "One end of it is attached to the faucet";
            if (self.attachedToShip)
                "; the other end is stuck inside the opening on the
                    ship&rsquo;s belly";
            else if (backyard_faucet.ison)
                "; water pours from the other end";
            ". ";
        }
        else if (self.attachedToShip)
            "One end of it is stuck inside the opening on the ship&rsquo;s
                belly. ";
    }
    zigdesc = {
        "Zigurt says, ";
        if (VALLEYSPEAK)
            zig('Like, hoses are always great!');
        else zig('Whenever is a hose not useful?');
    }
    flodesc = {
        "Floban shrugs his tentacles. ";
        if (VALLEYSPEAK)
            flo('It&rsquo;s a hose, dweeb.');
        else flo('As I understand it, it is a hose.');
        " He leans closer, almost whispering. ";
        if (VALLEYSPEAK)
            flo('Like, I think. I mean, Zigurt made us, y&rsquo;know, bring
                it.');
        else flo('Don&rsquo;t ask me; Zigurt demaded we bring it.');
    }
    whatdesc = "A device for getting water from a faucet to elsewhere,
        usually used in backyards. "
    attachToFaucet = {
        self.attachedToFaucet = true;
        backyard_faucet.hoseIsAttached = true;
    }
    attachToShip = {
        self.attachedToShip = true;
    }
    detachFromFaucet = {
        self.attachedToFaucet = nil;
        backyard_faucet.hoseIsAttached = nil;
    }
    detachFromShip = {
        self.attachedToShip = nil;
    }
    verDoAttachTo(actor, iobj) = {
        if (iobj != backyard_faucet && iobj != ship_opening &&
            iobj != real_ship && iobj != ship_hatch)
            "There is no need to attach the hose to <<iobj.thedesc>>. ";
    }
    verIoAttachTo(actor) = {}
    ioAttachTo(actor, dobj) = {
        if (dobj == backyard_faucet) {
            if (self.attachedToFaucet) {
                "Haven&rsquo;t you already done that? ";
                return;
            }
            "You screw one end of the hose onto the faucet";
            if (dobj.ison) {
                ", only slightly hampered by the water gushing from it. ";
                if (!self.attachedToShip) {
                    "As soon as you get the hose attached, water flows from
                        its other end";
                }
            }
            ". ";
            self.attachToFaucet;
        }
        else if (dobj == ship_opening || dobj == real_ship ||
            dobj == ship_hatch) {
            ship_opening.ioPutIn(actor, self);
        }
        else "There is no need to attach the hose to <<dobj.thedesc>>. ";
    }
    doSynonym('AttachTo') = 'FastenTo' 'PlugIn' 'ScrewInto'
    ioSynonym('AttachTo') = 'FastenTo' 'PlugIn' 'ScrewInto'
    verDoDetach(actor) = {
        if (!self.attachedToFaucet && !self.attachedToShip)
            "The hose isn&rsquo;t attached to anything. ";
    }
    doDetach(actor) = {
        if (self.attachedToFaucet && self.attachedToShip)
            "Since the hose is attached to two things, you&rsquo;ll have to
                specify which you want to detach it from. ";
        else if (self.attachedToFaucet)
            self.ioDetachFrom(actor, backyard_faucet);
        else self.ioDetachFrom(actor, ship_opening);
    }
    verDoDetachFrom(actor, iobj) = {
        if (!(iobj == backyard_faucet && self.attachedToFaucet) &&
            !((iobj == ship_opening || iobj == ship_hatch ||
            iobj == real_ship) && self.attachedToShip))
            "The hose isn&rsquo;t attached to <<iobj.thedesc>>. ";
    }
    verIoDetachFrom(actor) = {}
    ioDetachFrom(actor, dobj) = {
        if (!(dobj == backyard_faucet && self.attachedToFaucet) &&
            !((dobj == ship_opening || dobj == ship_hatch ||
            dobj == real_ship) && self.attachedToShip)) {
            "The hose isn&rsquo;t attached to <<dobj.thedesc>>. ";
            return;
        }
        if (dobj == backyard_faucet) {
            "Hoses are always harder to take off than to put on, but you
                manage it";
            if (dobj.ison) {
                ", even though you forgot to turn off the water";
            }
            ". ";
            self.detachFromFaucet;
        }
        else {
            "You yank on the hose, which finally comes free with a gross
                slurping sound. ";
            if (backyard_faucet.ison)
                "Of course, water sprays everywhere when it does come free. ";
            self.detachFromShip;
        }
    }
    doSynonym('Detach') = 'Unfasten' 'Unscrew'
    doSynonym('DetachFrom') = 'UnplugFrom' 'UnscrewFrom'
    ioSynonym('DetachFrom') = 'UnplugFrom' 'UnscrewFrom'
    verDoTakeOut(actor, iobj) = {
        if (iobj != backyard_faucet && iobj != ship_opening &&
            iobj != real_ship && iobj != ship_hatch)
            pass verDoTakeOut;
        if (!(iobj == backyard_faucet && self.attachedToFaucet) &&
            !((iobj == ship_opening || iobj == ship_hatch ||
            iobj == real_ship) && self.attachedToShip))
            "The hose isn&rsquo;t attached to <<iobj.thedesc>>. ";
    }
    ioTakeOut(actor, dobj) = {
        if (dobj != backyard_faucet && dobj != ship_opening &&
            dobj != real_ship && dobj != ship_hatch)
            pass ioTakeOut;
        self.ioDetachFrom(actor, dobj);
    }
    verDoPointAt(actor, io) = {
        "If you want to spray something with the hose, just say so. ";
    }
    verDoSprayAt(actor, io) = {
        if (!self.attachedToFaucet || !backyard_faucet.ison)
            "Oddly enough, spraying air through the hose doesn&rsquo;t
                have much of an effect. ";
    }
    doSprayAt(actor, io) = (self.ioSprayWith(actor, io))
    verIoSprayWith(actor) = {
        if (!self.attachedToFaucet || !backyard_faucet.ison)
            "Oddly enough, spraying air through the hose doesn&rsquo;t
                have much of an effect. ";
    }
    ioSprayWith(actor, dobj) = {
        if (dobj == dad) {
            "You direct a spray of water at your dad. The water cascades over
                him, wetting him thoroughly.
            \bAs funny as this is right now, you know you&rsquo;ll pay for it.
                In fact, dad seems ready to make you pay right now. He grabs
                the hose from you, turning off the faucet, and drags you
                inside. <q>What have I told you about playing with
                that?</q>\ he snaps as he marches you to your room and grounds
                you.
            \bZigurt and Floban must eventually decide that you&rsquo;re not
                coming, because some time that night everything vanishes in a
                burst of flame. ";
            die();
        }
        if (dobj == fake_zigurt_and_floban || (dobj == real_ship &&
            fake_zigurt_and_floban.location == backyard)) {
            "You send a jet of water at the ship. Zigurt and Floban recoil
                in horror, and their window becomes opaque again. Your dad
                somehow misses all of this byplay. ";
            fake_zigurt_and_floban.moveInto(nil);
        }
        else if (dobj == real_ship) {
            "You send a jet of water towards the ship. The water beads on the
                skin of the ship, then rolls down onto the ground. ";
            if (dad.location == backyard)
                "Your dad somehow misses all of this byplay. ";
        }
        else if (dobj == azaleas)
            "The azaleas are beyond the help of even the finest water in the
                world. ";
        else "There really is no need to spray <<dobj.thedesc>>. ";
    }
;

velvet_elvis: item
    notakeall = true
    noun = 'elvis' 'painting' 'art'
    adjective = 'velvet'
    location = hold_junk
    sdesc = "velvet Elvis"
    ldesc = "The King, captured in all his glory by a simple piece of mounted
        velvet. Stunning. "
    momdesc = "<q>That&rsquo;s real pretty. I wonder who would have gotten
        rid of it?</q> Mom muses. "
    daddesc = "Dad frowns at you. <q>You better not have gotten that from
        Aunt Mabel&rsquo;s trailer, you hear?</q> "
    zigdesc = {
        "Zigurt stares at you. ";
        if (VALLEYSPEAK)
            zig('Like, isn&rsquo;t he majorly your king?');
        else zig('Is he not your king?');
        " ";
    }
    flodesc = {
        "Floban says, ";
        if (VALLEYSPEAK)
            flo('That painting is soooo rad. I mean, y&rsquo;know,
                it&rsquo;s, like, the best art you dweebs have got.');
        else flo('I rather like that painting myself. Surely one of the
            finest works of art your culture has to boast about.');
        " ";
    }
    verDoTouch(actor) = { "Fuzzy. "; }
    verDoClean(actor) = {
        "As if perfection such as this would need cleaning. ";
    }
;

salad_shooter: item
    notakeall = true
    noun = 'shooter'
    adjective = 'salad' 'broken'
    location = hold_junk
    sdesc = "salad shooter"
    ldesc = "The salad shooter might once have chopped up vegetables and more
        for a mighty fine salad, but someone has removed all of its blades,
        rendering it useless. "
    momdesc = {
        "Mom grabs the salad shooter from you. <q>Look what kid found in the
            backyard!</q> mom tells dad.\b
        <q>Stupid Haskills, always throwing their trash over here,</q> he
            grumbles. ";
        self.moveInto(nil);
    }
    daddesc = {
        "<q>What have I told you about rooting around in the dumpster?</q>
            Dad takes the salad shooter away from you. ";
        self.moveInto(nil);
    }
    zigdesc = {
        "Zigurt says, ";
        if (VALLEYSPEAK)
            zig('Talk to, like, Floban. He&rsquo;s the cook.');
        else zig('Ask Floban. He fancies himself a culinary artiste.');
        " ";
    }
    flodesc = {
        "Floban says, ";
        if (VALLEYSPEAK)
            flo('That was such the bad buy, because, like, it broke when
                I tried to use it!');
        else flo('Truthfully, I didn&rsquo;t want it, but Mr.\ Popeil ordered
            me to buy it. And then it failed catastrophically the first time
            I attempted to use it!');
        " ";
    }
    whatdesc = "It&rsquo;s a piece of junk sold on late-night infomercials. "
    verDoTurnon(actor) = {
        "It is far too gone for that. ";
    }
    verDoTurnoff(actor) = {
        "Done. (You do know it was already off, right?) ";
    }
;

stress_ball: item
    notakeall = true
    noun = 'ball'
    adjective = 'stress'
    location = hold_junk
    sdesc = "stress ball"
    ldesc = "The stress ball is quite deformed from people squeezing it. "
    momdesc = "<q>Another major find for the great archaeologist?</q> your
        mom asks, smiling gently. "
    daddesc = "<q>Huh. Did that quack chiropractor give that to you?</q> "
    zigdesc = {
        "Zigurt says, ";
        if (VALLEYSPEAK)
            zig('Ahhh, it&rsquo;s, like, the stress ball.');
        else zig('Ahhh, the stress ball.');
        " He smiles frighteningly. ";
    }
    flodesc = {
        "Floban says, ";
        if (VALLEYSPEAK)
            flo('Ahhh, it&rsquo;s, like, the stress ball.');
        else flo('Ahhh, the stress ball.');
        " He smiles frighteningly. ";
    }
    verDoBreak(actor) = {
        "Not a chance. It&rsquo;s made of tougher stuff than you can break. ";
    }
    verDoSqueeze(actor) = {}
    doSqueeze(actor) = {
        "Mmm, that takes some of the stress out of your day. ";
    }
    doSynonym('Squeeze') = 'Push' 'Pull'
;

rain_stick: item
    notakeall = true
    noun = 'stick'
    adjective = 'rain'
    location = hold_junk
    sdesc = "rain stick"
    ldesc = "A hollow stick filled with beads and capped at both ends.
        When turned, the beads slide down the stick and make a sound that is
        kinda like the sound of falling rain. "
    momdesc = 'Wonderful! You found your rain stick!'
    daddesc = 'Just don&rsquo;t you go running around the house banging
        on stuff with that.'
    zigdesc = {
        if (VALLEYSPEAK) {
            zigNQ('&ldquo;Rain is, like, sooo rare on our planet. This');
            " &lsquo;rain stick&rsquo; ";
            zigNQ('thingy is super for letting our, like, friends hear
            what it sounds like, right?&rdquo;');
        }
        else {
            "<<zigNQ('&ldquo;Precipitation is all but unknown on our planet.
                Technology such as your')>> &lsquo;rain stick&rsquo; <<
                zigNQ('is ideal for bringing the sound of rain to our fellow
                beings.&rdquo;')>> ";
        }
    }
    flodesc = {
        "Floban sighs. ";
        if (VALLEYSPEAK)
            flo('Like, Zigurt made me bring it,');
        else flo('It was Zigurt&rsquo;s big idea.');
        " Zigurt sticks a large purple tongue out at Floban in response. ";
    }
    verDoOpen(actor) = {
        "When the rain stick was made, it was glued together so tight that
            there&rsquo;s no way you&rsquo;ll get it open. ";
    }
    verDoTurn(actor) = {}
    doTurn(actor) = {
        "You give the rain stick a turn, listening to the beads fall. ";
        if (zigurt.location == actor.location) {
            "Zigurt glances upwards. ";
            if (VALLEYSPEAK)
                zig('Is it, like, raining?');
            else zig('Do you hear precipitation?');
            " he asks Floban, who shrugs. ";
        }
        else if (actor.location == counter &&
            zigurt.location == counter.location) {
            "You hear Zigurt say, ";
            if (VALLEYSPEAK)
                zig('Is it, like, raining?');
            else zig('Do you hear precipitation?');
            "\b";
            if (VALLEYSPEAK)
                flo('I so can&rsquo;t tell,');
            else flo('I am not sure,');
            " responds Floban.\b";
            if (VALLEYSPEAK)
                zig('What-EVER. It&rsquo;s so not doing it any more.');
            zig('It matters not, as it has stopped.');
            " ";
        }
    }
;

