#charset "us-ascii"

 /*
  *  Words File
  * 
  *  This is where we add and/or redefine verbs, pronouns, etc.
  *  
  *  Main game file:
  *  C:\sw\game_design\tads3\cromGame3.cromfun3.t
  * 
  */
// #include cromfun3.t

// allow this file to be included only once in any project
#pragma once

#ifndef ADV3_H
#include <adv3.h>
#endif


// checks for if a variable was NOT defined from file en_us.h
// .. and if so then include the file to define that variable, method, etc.
#ifndef singleDir
#include <en_us.h>
// #error "You can put an error here too if the variable <> something. Boooo!!"
#endif

// VERBS: See: http://www.tads.org/howto/t3verb.htm

#ifdef __DEBUG 
// ** command only avail in debug mode


DefineIAction(Library)
 execAction { 
       werewolf.moveIntoForTravel(pixyland);
       gPlayerChar.moveIntoForTravel(mansionLibrary);
       gPlayerChar.lookAround(true);
 } 
; 
VerbRule(Library)
  'library' 
  : LibraryAction
  verbPhrase = 'library'
; 

// an older pirate text adventure used the word "booty" instead of inventory - we'll add this feature in case the player trys it
VerbRule(Booty)
    'booty'
    : BootyAction
    verbPhrase = 'take/taking booty'
;
// just copied from DefineIAction(Inventory) - Cleo Kraft 6/22/2019
DefineIAction(Booty)
    execAction()
    {
        "Yar! (This be the pirate\'s version of inventory, matey).<.p>";
        /* show the actor's inventory in the current mode */
        gActor.showInventory(inventoryMode == InventoryTall);
    }

    /* current inventory mode - start in 'wide' mode by default */
    inventoryMode = InventoryWide;
;

// The magic word to change sex is:  Blargosexchange
DefineIAction(Powerup)
   execAction() {
   
  // myObject.setSuperclassList(new class list); // interesting - TADS classes can *change* after runtime using this command to change them to ONLY TADS type classes in a class list


  tempPlayerClothes.moveInto(pixyland);
girlingBooth.warningSeen = true;
girlingBooth.girlingSet = true;
girlingBooth.playerGirlified = true;
girlingBooth.girlType = 'normal';

formSaver.hasUsed = true;
formCube.moveIntoForTravel(formSaverReceptical);
formSaverBooth.makeOpen(true);
formSaverBooth.makeLocked(nil);

dressingRoomMakeup.hasUsed = true;
dressingRoomHairbrush.hasUsed = true;


                         tempPlayerClothes.makeWornBy(nil);

                         gameMain.girlType = girlingBooth.girlType;
  
                         mePenis.moveIntoForTravel(pixyland);
                         noPenis.moveInto(gPlayerChar);
                         me.is_A_Girl = true;
                         gPlayerChar.is_A_Girl = true; // CromexxHuman class needs this set for clothes handling
                         gameMain.is_a_girl = true; // this is the KEY variable to set for sex changing player
                         girlingBooth.playerGirlified = true;
                         me.pcAge = 18;
                         me.pcHeight = '5\' 3\"';
                         me.pcHair = 'blond';
                         me.pcEyes = 'blue';
   
                       // create female body parts and give them to the gActor
                       local oStrangeFemLegs = new AdultFemaleLegs();
                       local oStrangeFemArms = new AdultFemaleArms();
                       local oStrangeFemChest = new AdultFemaleBreasts();
                       local oStrangeFemSkin = new AdultFemaleSkin();
                       local oStrangeFemNipples = new AdultFemaleNipples();
                       local oStrangeFemShoulders = new AdultFemaleShoulders();
                       local oStrangeFemTorso = new AdultFemaleTorso();
                       local oStrangeFemBellyButton = new AdultFemaleBellybutton();
                       local oStrangeFemHips = new AdultFemaleHips();
                       local oStrangeFemWaist = new AdultFemaleWaist();
                       local oStrangeFemToes = new AdultFemaleToes();
                       local oStrangeFemMouth = new AdultFemaleMouth();
                       local oStrangeFemNose = new AdultFemaleNose();
                       local oStrangeFemHair = new AdultFemaleBlondeHair();
                       local oStrangeFemEyeLashes = new AdultFemaleEyeLashes();
                       local oStrangeFemEyeBrows = new AdultFemaleEyeBrows();
                       local oStrangeFemBlueEyes = new AdultFemaleBlueEyes();
                       local oStrangeFemEars = new AdultFemaleEars();
                       local oStrangeFemHead = new AdultFemaleHead();
                       local oStrangeFemHands = new AdultFemaleHands();
                       local oStrangeFemFingers = new AdultFemaleFingers();
                       local oStrangeFemFingerNails = new AdultFemaleFingerNails();
                       local oStrangeFemFeet = new AdultFemaleFeet();
                       local oStrangeFemToeNails = new AdultFemaleToeNails();
                       local oStrangeFemVagina = new AdultFemaleVagina();
                       // move them to gActor..
                       oStrangeFemLegs.moveInto(gPlayerChar);
                       oStrangeFemArms.moveInto(gPlayerChar);
                       oStrangeFemChest.moveInto(gPlayerChar);
                       oStrangeFemSkin.moveInto(gPlayerChar);
                       oStrangeFemNipples.moveInto(gPlayerChar);
                       oStrangeFemShoulders.moveInto(gPlayerChar);
                       oStrangeFemTorso.moveInto(gPlayerChar);
                       oStrangeFemBellyButton.moveInto(gPlayerChar);
                       oStrangeFemHips.moveInto(gPlayerChar);
                       oStrangeFemWaist.moveInto(gPlayerChar);
                       oStrangeFemToes.moveInto(gPlayerChar);
                       oStrangeFemMouth.moveInto(gPlayerChar);
                       oStrangeFemNose.moveInto(gPlayerChar);
                       oStrangeFemHair.moveInto(gPlayerChar);
                       oStrangeFemEyeLashes.moveInto(gPlayerChar);
                       oStrangeFemEyeBrows.moveInto(gPlayerChar);
                       oStrangeFemBlueEyes.moveInto(gPlayerChar);
                       oStrangeFemEars.moveInto(gPlayerChar);
                       oStrangeFemHead.moveInto(gPlayerChar);
                       oStrangeFemHands.moveInto(gPlayerChar);
                       oStrangeFemFingers.moveInto(gPlayerChar);
                       oStrangeFemFingerNails.moveInto(gPlayerChar);
                       oStrangeFemFeet.moveInto(gPlayerChar);
                       oStrangeFemToeNails.moveInto(gPlayerChar);
                       oStrangeFemVagina.moveInto(gPlayerChar);   
                
strangeFemPanties.discover();
strangeFemBra.discover();
strangeFemDress.discover();
strangeFemShoes.discover();
strangeFemPanties.moveInto(gPlayerChar);
strangeFemBra.moveInto(gPlayerChar);
strangeFemDress.moveInto(gPlayerChar);
strangeFemShoes.moveInto(gPlayerChar);
strangeFemPanties.makeWornBy(gPlayerChar);
strangeFemBra.makeWornBy(gPlayerChar);
strangeFemDress.makeWornBy(gPlayerChar);
strangeFemShoes.makeWornBy(gPlayerChar);
blackLeatherPurse.moveInto(gPlayerChar);
blackLeatherPurse.makeWornBy(gPlayerChar);
blackLeatherPurse.makeOpen(true);
travelersCheck.moveInto(blackLeatherPurse);

brassLantern.moveInto(gPlayerChar);

                         girlingBooth.makeOpen(true);
                         girlingBooth.makeLocked(nil);
                         

me.girlDream.advanceState();// advance dream counter
gameMain.generalTime = 'morning';// set the time to morning
bathHouseBath.bathingTable.advanceState(); // set that player took a bath .. getScriptState() == 1;
dollyCostume.moveInto(pixyland);


idolOfZakra.moveInto(gPlayerChar);
zombieMaster.moveIntoForTravel(mansionLibrary); // gPlayerChar.location);
zombieMaster.setCurState(zombieFollowing);

gameMain.is_a_zombie = true;
mansionParlor.chokedMaster = true;
werewolf.moveIntoForTravel(pixyland);

gPlayerChar.pcHeight = '2\' 8\"';

                gPlayerChar.moveIntoForTravel(mansionLibrary); // mansionBasementBack); // poolSideTwo); // yourVillaOuter);// poolSideTwo); // yourVillaOuter);
                gPlayerChar.lookAround(true);
   }
;
VerbRule(Powerup)
   'powerup'
   : PowerupAction
     verbPhrase = 'powerup'
;


DefineIAction(FiatLux) 
 execAction 
{ 
  if(gPlayerChar.brightness == 0) 
  { 
    "You start to glow!\n"; 
    gPlayerChar.brightness = 3; 
  } 
  else 
  { 
    "Repeating the spell reverses its effect, and your glowing aura disappears. "; 
    gPlayerChar.brightness = 0; 
  } 
} 
; 

VerbRule(FiatLux) 
  'fiat' 'lux' 
  : FiatLuxAction 
  verbPhrase = 'make/making light' 
; 
// ** end command only avail in debug mode
#endif 


DefineIAction(Nothing)
 execAction { 
       " ";
 } 
; 
VerbRule(Nothing)
  'null' | 'nothing'
  : NothingAction
  verbPhrase = 'null'
; 


/*
DefineIAction(Debugon)
   execAction(){
      if (debugTrace(1, true))
        "Debug diagnostic mode engaged. ";
      exit;
   }
;
VerbRule(Debugon)
  'debugon'
  : DebugonAction
verbPhrase = 'debugon'
;
*/

/*
DefineIAction(Debugoff)
   execAction(){
      if (debugTrace(1, nil))
        "Debug diagnostic mode disengaged. ";
      exit;
   }
;
VerbRule(Debugoff)
  'debugoff'
  : DebugoffAction
verbPhrase = 'debugoff'
;
*/


/* NOTE: for below /slashcheck to work you need:
 *    PreinitObject
 *       execute()
 *       {
 *           cmdTokenizer.insertRule(
 *               ['chat-word', new RexPattern('/<alpha>+'),
 *                tokString, nil, nil],
 *               'word', nil);
 *       }
 *       .... which should be already added to crom_mod.t
 *
 */
// player types the word "/slashcheck" (without quotes)
DefineIAction(SlashCheck)
   execAction(){       
     "Yes, slash commands work! \n";
   }
;
VerbRule(SlashCheck)
  '/slashcheck'
  : SlashCheckAction
verbPhrase = '/slashcheck'
;

// EverQuest style commands - not necessary but here as a /nod to the game

// player types the word "/friends" (without quotes)
DefineIAction(FriendsList)
   execAction(){       
       "You have no friends. Awwww... how sad. Maybe you should get some. ";
   }
;
VerbRule(FriendsList)
  '/friends'
  : FriendsListAction
verbPhrase = '/friends'
;


DefineIAction(OrderFood)
   execAction(){    
         if((gPlayerChar.location != tiffys) && (gPlayerChar.location != tiffysBoothChair)){
               "You can\'t do that here. ";
               exit;
         }
         if((gPlayerChar.location == tiffys) && (gPlayerChar.location != tiffysBoothChair)){
               "You should be seated first before ordering food. ";
               exit;
         }
         libGlobal.totalTurns--;                  
         local tokList = Tokenizer.tokenize('hi');
         executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)         
   }
;
VerbRule(OrderFood)
  'order' |
  'order' 'food' |
  'order' 'breakfast' |
  'call' 'waitress' |
  'order' 'eggs' |
  'order' 'bacon' 'and' 'eggs' |
  'order' 'some' 'food' |
  'order' 'some' 'breakfast'
  : OrderFoodAction
  verbPhrase = 'order food'
;

/* 
 * Normalization spell
 */
DefineIAction(Normalize)
   execAction(){       
         "The correct way to cast this spell is:
          frazoltto malitti zafry timtow <b>[target]</b> with magic wand. ";
   }
;
VerbRule(Normalize)
  'say' 'Frazoltto' 'Malitti' 'Zafry' 'Timtow' |
  'Frazoltto' 'Malitti' 'Zafry' 'Timtow'
  : NormalizeAction
verbPhrase = 'frazoltto malitti zafry timtow (who)'
;

DefineTIAction(NormalizeWith)
   getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
   }
;
VerbRule(NormalizeWith)
   'frazoltto' 'malitti' 'zafry' 'timtow' singleDobj 'with' singleIobj
   : NormalizeWithAction
      verbPhrase = 'normalize (what) (with what)'
;
modify Thing
   dobjFor(NormalizeWith){
      verify(){ illogical('That would have no effect. '); }
   }
   iobjFor(UseWith){
      verify(){ if(!self.ofKind(MagicWand)) illogical('{That iobj/he} isn\'t a magic wand. ');
      }
   }
;


DefineTAction(NormalizeWhat)
  execAction(){
         "The correct way to cast this spell is:
          frazoltto malitti zafry timtow <b>[target]</b> with magic wand. ";
  }
;
VerbRule(NormalizeWhat)
   'frazoltto' 'malitti' 'zafry' 'timtow' singleDobj
   : NormalizeWhatAction
      verbPhrase = 'normalize (what)'
;
modify Thing
   dobjFor(NormalizeWhat){
      verify(){ illogical('Nothing happens. Perhaps you are using the spell incorrectly. '); }
   }
;

// ******************** femify spell
/* 
 * Normalization spell
 */
DefineIAction(Femify)
   execAction(){       
         "The correct way to cast this spell is:
          femify <b>[target]</b> with magic wand. ";
   }
;
VerbRule(Femify)
  'say' 'femify' |
  'femify'
  : FemifyAction
verbPhrase = 'femify (who)'
;

DefineTIAction(FemifyWith)
   getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
   }
;
VerbRule(FemifyWith)
   'femify' singleDobj 'with' singleIobj
   : FemifyWithAction
      verbPhrase = 'femify (what) (with what)'
;
modify Thing
   dobjFor(FemifyWith){
      verify(){ illogical('That would have no effect. '); }
   }
   iobjFor(FemifyWith){
      verify(){ if(!self.ofKind(MagicWand)) illogical('{That iobj/he} isn\'t a magic wand. ');
      }
   }
;


DefineTAction(FemifyWhat)
  execAction(){
         "The correct way to cast this spell is:
          femify <b>[target]</b> with magic wand. ";
  }
;
VerbRule(FemifyWhat)
   'femify' singleDobj
   : FemifyWhatAction
      verbPhrase = 'femify (what)'
;
modify Thing
   dobjFor(FemifyWhat){
      verify(){ illogical('Nothing happens. Perhaps you are using the spell incorrectly. '); }
   }
;

// ******************** boyify spell
DefineIAction(Boyify)
   execAction(){       
         "The correct way to cast this spell is:
          boyify <b>[target]</b> with magic wand. ";
   }
;
VerbRule(Boyify)
  'say' 'boyify' |
  'boyify'
  : BoyifyAction
verbPhrase = 'boyify (who)'
;

DefineTIAction(BoyifyWith)
   getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
   }
;
VerbRule(BoyifyWith)
   'boyify' singleDobj 'with' singleIobj
   : BoyifyWithAction
      verbPhrase = 'boyify (what) (with what)'
;
modify Thing
   dobjFor(BoyifyWith){
      verify(){ illogical('That would have no effect. '); }
   }
   iobjFor(BoyifyWith){
      verify(){ if(!self.ofKind(MagicWand)) illogical('{That iobj/he} isn\'t a magic wand. ');
      }
   }
;


DefineTAction(BoyifyWhat)
  execAction(){
         "The correct way to cast this spell is:
          boyify <b>[target]</b> with magic wand. ";
  }
;
VerbRule(BoyifyWhat)
   'boyify' singleDobj
   : BoyifyWhatAction
      verbPhrase = 'boyify (what)'
;
modify Thing
   dobjFor(BoyifyWhat){
      verify(){ illogical('Nothing happens. Perhaps you are using the spell incorrectly. '); }
   }
;

// ** little girl spell
// ******************** boyify spell
DefineIAction(Frimp)
   execAction(){       
         "The correct way to cast this spell is:
          frimp <b>[target]</b> with magic wand. ";
   }
;
VerbRule(Frimp)
  'say' 'frimp' |
  'frimp'
  : FrimpAction
verbPhrase = 'frimp (who)'
;

DefineTIAction(FrimpWith)
   getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
   }
;
VerbRule(FrimpWith)
   'frimp' singleDobj 'with' singleIobj
   : FrimpWithAction
      verbPhrase = 'frimp (what) (with what)'
;
modify Thing
   dobjFor(FrimpWith){
      verify(){ illogical('That would have no effect. '); }
   }
   iobjFor(FrimpWith){
      verify(){ if(!self.ofKind(MagicWand)) illogical('{That iobj/he} isn\'t a magic wand. ');
      }
   }
;


DefineTAction(FrimpWhat)
  execAction(){
         "The correct way to cast this spell is:
          frimp <b>[target]</b> with magic wand. ";
  }
;
VerbRule(FrimpWhat)
   'frimp' singleDobj
   : FrimpWhatAction
      verbPhrase = 'frimp (what)'
;
modify Thing
   dobjFor(FrimpWhat){
      verify(){ illogical('Nothing happens. Perhaps you are using the spell incorrectly. '); }
   }
;

/*
 *  The class "MagicWand" is used for spellcasting
 */
class MagicWand: Thing
   // frazoltto malitti zafry timtow <who> with wand
   iobjFor(NormalizeWith){
      preCond=[touchObj,objHeld]
      verify(){ logicalRank(110,'likely'); }
   }
   iobjFor(FemifyWith){
      preCond=[touchObj,objHeld]
      verify(){ logicalRank(110,'likely'); }
   }
   iobjFor(BoyifyWith){
      preCond=[touchObj,objHeld]
      verify(){ logicalRank(110,'likely'); }
   }
;





DefineIAction(Blargojunk)
   execAction(){       
     gActor.moveIntoForTravel(startRoom); // lgBadGuyHideoutCloset); // erifCafe14); 
     mainReport('You find yourself somewhere else<.p>');
     // strangeMetalChair.iSatOnTally = 24;
     "blargo junk...\n";
     say(me.listActorPosture(me));
   }
;
VerbRule(Blargojunk)
  'blargojunk'
  : BlargojunkAction
verbPhrase = 'blargojunk'
;

// from tads 3 technical manual
class SpecialNounPhraseProd: NounPhraseWithVocab
    /* get the list of objects matching our special phrase */
    getMatchList = []

    /* resolve the objects */
    getVocabMatchList(resolver, results, flags)
    {
        /* return all of the in-scope matches */
        return getMatchList().subset({x: resolver.objInScope(x)})
            .mapAll({x: new ResolveInfo(x, flags)});
    }
;

//grammar adjWord(mySex) :
//    'my' 'sex' | 'sex'
//    : SpecialNounPhraseProd
//    getMatchList = [me] // magazine]
//    getAdjustedTokens =
//      ['my', &adjective, 'sex', &adjective]
//;


DefineTIAction(UseWith)
   getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
   }
;
VerbRule(UseWith)
   ('use') singleDobj 'with' singleIobj
   : UseWithAction
      verbPhrase = 'use (what) (with what)'
;
modify Thing
   dobjFor(UseWith){
      verify(){ illogical('{You/he} can\'t use {that dobj/him}. '); }       
   }
   iobjFor(UseWith){
      verify(){ illogical('{That iobj/he} do{es}n\'t look
             very useful for that. '); 
      }
   }
;

// *** WORKS! TI-action NOT TA-Action... 
DefineTIAction(UseOn)
  // execAction(){
  //       mainReport('Something happuns... '); 
  // }
;
VerbRule(UseOn)
   'use' dobjList 'on' singleIobj
   : UseOnAction
      verbPhrase = 'use (what) on (what)'
;
modify Thing
   dobjFor(UseOn){
      verify(){ illogical('{You/he} can\'t use {that dobj/him} on {subj iobj}{a/her}. '); }       
   }
   iobjFor(UseOn){
      verify(){ illogical('{You/he} can\'t use {that dobj/him} on {subj iobj}{a/her}. '); }
   }
;

DefineTAction(Drag);
VerbRule(Drag)
   ('drag') singleDobj
   : DragAction
   verbPhrase = 'drag/dragging (what)'
;
modify Thing
   dobjFor(Drag){
      verify(){ illogical('{You/he} can\'t drag {that dobj/him}. '); }
   }
;

DefineTAction(Buy);
VerbRule(Buy)
   ('buy') singleDobj
   : BuyAction
   verbPhrase = 'buy/buying (what)'   
;
modify Thing
   dobjFor(Buy){
      verify(){
            illogical('{You/he} can\'t buy {that dobj/him}. ');
      }
   }
;

DefineIAction(SwimDir)
  //construct(dir){ dir_ = dir; }
  execAction(){
     local dirn = (dirMatch != nil) ? dirMatch.dir : nil;
     if(gActor.posture != swimming){
        libGlobal.totalTurns--;
        local tokList = Tokenizer.tokenize('crawl in water');
        executeCommand(gActor,gActor,tokList,nil);
     }
     if(dirn != nil){ 
         // execute another command but don't count agains player turn counter
         libGlobal.totalTurns--;                  
         local tokList = Tokenizer.tokenize(dirn.name); 
         executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
     }
     //nestedActorAction(gActor,TravelAction,dirMatch);// North);
     //tryImplicitAction(gActor,Stand);
     // **** LEFT OFF ABOVE 19MAR2007 ****
     //nestedActorAction(gActor,dirMatch.dir.dirProp);// 'north');// dirMatch.dir);
     //}
  }
;

VerbRule(SwimDir)
   ('swim') ('to' ('the' |) |) singleDir
  : SwimDirAction
  verbPhrase = 'swim/swimming {where} '
;


DefineTAction(SwimIn);
VerbRule(SwimIn)
   'swim' 'in' singleDobj
   : SwimInAction
   verbPhrase = 'swim/swimming in (what)'
;
modify Thing
   dobjFor(SwimIn){
      verify(){
            illogical('{You/he} can\'t swim in {that dobj/him}. ');
      }
   }
;

// see actions.t (ex: DefineIAction(sit))
DefineIAction(Swim)
   execAction(){
        if(gActor.posture == swimming){
           reportFailure('{You/he} are already swimming. ');
       }else{
           askForDobj(SwimIn);
        }
   }
;
VerbRule(Swim)
  'swim'
  : SwimAction
  verbPhrase = 'swim/swimming'
;

// for "brush hair"
DefineTAction(Brush);
VerbRule(Brush)
   ('brush') dobjList
   : BrushAction
   verbPhrase = 'brush/brushing (what)'
;
DefineTIAction(BrushWith)
    getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
    }
;
VerbRule(BrushWith)
   ('brush') singleDobj 'with' singleIobj
   : BrushWithAction
     verbPhrase = 'brush/brushing (what) (with what)'
;
modify Thing
   dobjFor(Brush){
      verify(){
            illogical('{You/he} can\'t brush {that dobj/him}. ');
      }
   }
   iobjFor(Brush){
      verify(){ illogical('{That iobj/him} isn\'t something {you/he} 
                          can brush anything with. ');
      }
   }
   dobjFor(BrushWith){
      verify() {
        illogical('{You/he} can\'t brush {that dobj/him}. ');
     }
   }
   iobjFor(BrushWith){
      verify(){
          illogical('{That iobj/him} can not be brushed. ');
      }
   }
;



DefineTAction(Load);
VerbRule(Load)
   ('load') singleDobj
   : LoadAction
   verbPhrase = 'load/loading (what)'   
;
modify Thing
   dobjFor(Load){
      verify(){
            illogical('{You/he} can\'t load {that dobj/him}. ');
      }
   }
;
DefineTAction(LoadWith);
VerbRule(LoadWith)
   ('load') 
       singleDobj 
    'with' singleIobj
   : LoadWithAction
      verbPhrase = 'load (what)'
;
modify Thing
   dobjFor(LoadWith){
      verify(){ illogical('{You/he} can\'t load {that dobj/him}. '); }       
   }
;



// see actions.t (ex: DefineIAction(sit))
DefineIAction(Crawl)
   execAction(){
      //  if(gActor.location==roissySolitaryConfinement){
      //    if((attackHitPunchKickClawRene.ranIt==true) &&
      //      (getOnAllFours.ranIt!=true)){
      //       getOnAllFours.runIt();
      //       exit;// don't run the rest of this execAction() routine...             
      //    }
      //  }
        if(gActor.posture == crawling){
           reportFailure(&alreadyCrawlingMsg);
        }else{
           // execute another command but don't count agains player turn counter
           if(gActor==gPlayerChar) libGlobal.totalTurns--;                  
           local tokList = Tokenizer.tokenize('crawl on floor');
           executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
           // askForDobj(CrawlOn);        
        }
   }
;
VerbRule(Crawl)
  'crawl' | 
  'heel' |
  'get' 'on' 'all' 'fours' |
  'get' 'on' 'hands' 'and' 'knees' |
  'get' 'on' 'knees' : CrawlAction
  verbPhrase = 'crawl/crawling'
;

DefineTAction(CrawlOn)
;
// Copied from SitOn verbrule in: en_us.t
VerbRule(CrawlOn)
  'crawl' ('on' | 'in' | 'down' 'on' | 'down' 'in') singleDobj
  : CrawlOnAction
  execAction(){
      if(gActor.posture == crawling){
         reportFailure(&alreadyCrawlingMsg);
      }
      if(gActor.location.canCrawlOn== nil){
         reportFailure(&cannotCrawlOnMsg); 
      }else{
         // crawling.tryMakingPosture(crawling); "neebo! "; 
         //verifyEntry(crawling,&alreadyCrawlingMsg);
         //performEntry(crawling);
         gActor.makePosture(crawling); // setActorToPosture(gActor,crawling);
         local oFloor =  gActor.location.getNominalDropDestination();
         local sRpt = playerActionMessages.roomOkayPostureChangeMsg(crawling,oFloor);
         mainReport(sRpt);
         //mainReport(&nothingThroughPassageMsg);// &roomOkayPostureChangeMsg(crawling,gActor));// posture, obj) {
         //mainReport(&roomOkayPostureChangeMsg(crawling,oFloor));// { 
        }
      // defaultReport(&
      //setActorToPosture(actor,loc)// tryMakingPosture(r.setActorToPosture(
  }
  verbPhrase = 'crawl/crawling (on what)'
  askDobjResponseProd = singleNoun
;


DefineIAction(CrawlDir)
  //construct(dir){ dir_ = dir; }
  execAction(){
     local dirn = (dirMatch != nil) ? dirMatch.dir : nil;
     //local cirn = getDirection();
     if(gActor.posture != crawling){
        libGlobal.totalTurns--;
        local tokList = Tokenizer.tokenize('crawl on the floor');
        executeCommand(gActor,gActor,tokList,nil);
        //CrawlAction.execAction(); // Works!    //gActor.tryMakingPosture(crawling);
     }
     if(dirn != nil){ 
         // execute another command but don't count agains player turn counter
         libGlobal.totalTurns--;                  
         local tokList = Tokenizer.tokenize(dirn.name); //'north');//dirn.name);// 'look');
         executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
     }
     //nestedActorAction(gActor,TravelAction,dirMatch);// North);
     //tryImplicitAction(gActor,Stand);
     // **** LEFT OFF ABOVE 19MAR2007 ****
     //nestedActorAction(gActor,dirMatch.dir.dirProp);// 'north');// dirMatch.dir);
     //}
  }
;

VerbRule(CrawlDir)
   ('crawl') ('to' ('the' |) |) singleDir
  : CrawlDirAction
  verbPhrase = 'crawl/crawling {where} '
;

/*
 * This is for the "Crawl to Hsaio Ling" task, among other things.
 */ 
DefineTAction(CrawlTo)
  // exec
;
VerbRule(CrawlTo)
   'crawl' 'to' singleDobj
   : CrawlToAction
   verbPhrase = 'crawl (to) (what)'
;
modify Thing
   dobjFor(CrawlTo){
      verify(){ 
        if((gDobj !=nil) && (gDobj==gActor))
            illogical('{You/he} can\'t crawl to {subj dobj}{itself/herself}. '); 
        if(gActor==gPlayerChar){
            illogical('Why would {you/he} want to crawl to {subj dobj}{the/her}? 
                    {You/he} don\'t need to do that. '); 
        }else{
            illogical('Why would {you/he} want to crawl to {subj dobj}{the/her}? 
                    {You/he} doesn\'t need to do that. '); 
        }
      }
   }
;

// see actions.t (ex: DefineIAction(sit))
DefineIAction(Kneel)
   execAction(){
        if(gActor.posture == kneeling)
           reportFailure(&alreadyKneelingMsg);
        else
           askForDobj(KneelOn);        
   }
;
DefineTAction(KneelOn)
;
// Copied from SitOn verbrule in: en_us.t
VerbRule(KneelOn)
  'kneel' ('on' | 'in' | 'down' 'on' | 'down' 'in')
     singleDobj
  : KneelOnAction
 /* *** remmed this out - objects should handle this via dobjFor(KneelOn) now...
  execAction(){
      if(gActor.posture == kneeling){
         reportFailure(&alreadyKneelingMsg);
      }
      if(gActor.location.canKneelOn== nil){
         reportFailure(&cannotKneelOnMsg); 
      }else{
         // crawling.tryMakingPosture(crawling); "neebo! "; 
         //verifyEntry(crawling,&alreadyCrawlingMsg);
         //performEntry(crawling);
         local oFloor =  gActor.location.getNominalDropDestination();
         local sRpt= playerActionMessages.roomOkayPostureChangeMsg(kneeling,oFloor);
         if((gDobj!=nil) && (gDobj!= oFloor)){
             sRpt = playerActionMessages.roomOkayPostureChangeMsg(kneeling,gDobj);
             gDobj.performEntry(kneeling);
         }else{
             gActor.makePosture(kneeling);
             mainReport(sRpt);
         }         
         //mainReport(&nothingThroughPassageMsg);// &roomOkayPostureChangeMsg(crawling,gActor));// posture, obj) {
         //mainReport(&roomOkayPostureChangeMsg(crawling,oFloor));// { 
        }
      // defaultReport(&
      //setActorToPosture(actor,loc)// tryMakingPosture(r.setActorToPosture(
  }
  */
  verbPhrase = 'kneel/kneeling (on what)'
  askDobjResponseProd = singleNoun
;
modify Thing
  dobjFor(KneelOn){
       verify(){ 
            illogical('{You/he} can\'t kneel on {subj dobj}{the/her}. '); 
       }
  }
;

VerbRule(Kneel)
  'kneel' |
  'drop' 'to' 'knees' |
  'drop' 'to' 'my' 'knees'
  : KneelAction
  verbPhrase = 'kneel/kneeling'
;


DefineIAction(Fly)
   execAction(){       
     // menuTsk.conditions(); // execute task menuTsk if conditions pass
     // flyTsk.conditions();
     reportFailure(&cannotFlyMsg);
   }
;
VerbRule(Fly)
   'fly'
   : FlyAction
   VerbPhrase = 'fly/flying'
;

DefineIAction(FlyDir)
  //construct(dir){ dir_ = dir; }
  execAction(){
     local dirn = (dirMatch != nil) ? dirMatch.dir : nil;
     //local cirn = getDirection();
     if(gActor.posture != flying){
        libGlobal.totalTurns--;
        local tokList = Tokenizer.tokenize('fly'); // ('crawl on the floor');
        executeCommand(gActor,gActor,tokList,nil);
        exit;
        //CrawlAction.execAction(); // Works!    //gActor.tryMakingPosture(crawling);
     }else if(gActor.location.canFly != true){
         reportFailure(&cannotFlyMsg);
     }else if(dirn != nil){ 
         // execute another command but don't count agains player turn counter
         libGlobal.totalTurns--;                  
         local tokList = Tokenizer.tokenize(dirn.name); //'north');//dirn.name);// 'look');
         executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)
     }else{
         reportFailure(&cannotFlyMsg);
     }
     //nestedActorAction(gActor,TravelAction,dirMatch);// North);
     //tryImplicitAction(gActor,Stand);
     // **** LEFT OFF ABOVE 19MAR2007 ****
     //nestedActorAction(gActor,dirMatch.dir.dirProp);// 'north');// dirMatch.dir);
     //}
  }
;
VerbRule(FlyDir)
   'fly' singleDir |
   'fly' 'to' 'the' singleDir
   // ('fly') ('to' ('the' |) |) singleDir
  : FlyDirAction
  verbPhrase = 'fly/flying {where} '
;

DefineIAction(StraddleAlone)
  execAction(){ "The proper command is <b>straddle &lsaquo;someone&rsaquo;</b>. "; }
;
VerbRule(StraddleAlone)
  'straddle'
  : StraddleAloneAction
  verbPhrase = 'straddle'
;

DefineTAction(Straddle)
  // exec
;
VerbRule(Straddle)
  'straddle' dobjList // singleDobj
  : StraddleAction
  verbPhrase = 'straddle (what)'
;
modify Thing
  dobjFor(Straddle){
      verify(){
        if((gDobj !=nil) && (gDobj==gActor))
            illogical('{You/he} can\'t straddle {subj dobj}{itself/herself}. '); 
        illogical('Why would {you/he} want to straddle {subj dobj}{the/her}? 
                   {You/he} don\'t need to do that. '); 
      }
  }
;

// - tfgamingworkshop.com - Mashadara's solution to "Look On" below...
DefineTAction(LookOn);

VerbRule(LookOn)
   'look' 'on' singleDobj
   : LookOnAction
   verbPhrase = 'look/looking (on what)'
;

modify Surface
   dobjFor(LookOn) asDobjFor(LookIn)
;


/*
 * Our Sign & SignWith actions.
 * These are for use with signing the contract or perhaps you
 * can sign some grafitti on the garage door or something.
 */
DefineTAction(Sign);
VerbRule(Sign)
    'sign' dobjList
    : SignAction
    verbPhrase = 'sign/signing (what)'
;
DefineTIAction(SignWith)
    getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
    }
;
VerbRule(SignWith)
   ('sign') singleDobj 'with' singleIobj
   : SignWithAction
     verbPhrase = 'sign/signing (what) (with what)'
;
modify Thing
   dobjFor(Sign){
      verify(){ illogical('{That dobj/him} can\'t be signed. '); 
      }
   }
   iobjFor(Sign){
      verify(){ illogical('{That iobj/him} isn\'t something {you/he} 
                          can sign anything with. ');
      }
   }
   dobjFor(SignWith){
      verify() {
        illogical('{You/he} can\'t sign {that dobj/him}. ');
     }
   }
   iobjFor(SignWith){
      verify(){
          illogical('{That iobj/him} can not be signed. ');
      }
   }
;


DefineTIAction(BreakWith)
    getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
    }
;
VerbRule(BreakWith)
   ('break') singleDobj 'with' singleIobj
   : BreakWithAction
     verbPhrase = 'break/breaking (what) (with what)'
;
modify Thing
   dobjFor(BreakWith){
      verify(){ illogical('{That dobj/him} can\'t be broken. '); 
      }
   }
   iobjFor(BreakWith){
      verify(){ illogical('{That iobj/him} isn\'t something {you/he} 
                          can break anything with. ');
      }
   }   
;


// This adds the verb 'smash' to the list of attack types
modify VerbRule(Attack) 
    ('attack' | 'kill' | 'hit' | 'kick' | 'punch' | 'smash') singleDobj
    : 
; 
// ... note that we did not need to modify the Action area of the above
// ... so all after the : is left intact (see: en_us.t)

// this adds the verb 'smash' to the list of attack types
modify VerbRule(AttackWith)
    ('attack' | 'kill' | 'hit' | 'kick' | 'punch' | 'strike' | 'smash')
        singleDobj
        'with' singleIobj
    : 
;



// ... note that we did not need to modify the Action area of the above
// ... so all after the : is left intact (see: en_us.t)

DefineTAction(Drain);
VerbRule(Drain)
   ('drain') singleDobj
   : DrainAction
     verbPhrase = 'drain/draining (what)'
;
modify Thing
   dobjFor(Unzip){
      verify() {
        illogical('{You/he} can\'t drain {that dobj/him}. ');
     }
   }
;


// TAction = transitive verb, IAction = inactive
DefineTAction(Unzip);
VerbRule(Unzip)
   ('unzip') singleDobj
   : UnzipAction
     verbPhrase = 'unzip/unzipping (what)'
;
modify Thing
   dobjFor(Unzip){
      verify() {
        illogical('{You/he} can\'t unzip {that dobj/him}. ');
     }
   }
;

DefineTAction(Zip);
VerbRule(Zip)
   ('zip') singleDobj
   : ZipAction
     verbPhrase = 'zip/zipping (what)'
;
modify Thing
   dobjFor(Zip){
      verify() {
        illogical('{You/he} can\'t zip {that dobj/him}. ');
     }
   }
;

// for washing things

DefineIAction(Washo)
   execAction(){
        "Weeee! it dids it! ";
//        gPlayerChar.moveIntoForTravel(bookShop); // orphanageAttic);
    }
;
VerbRule(Washo)
    'wash' 'hands' |
    'clean' 'hands' |
    'scrub' 'hands'
    : WashoAction
    verbPhrase = 'wash/washing (what)'
;

DefineTAction(Wash);
VerbRule(Wash)
    'wash' dobjList |
    'clean' dobjList |
    'scrub' dobjList
    : WashAction
    verbPhrase = 'wash/washing (what)'
;

DefineTIAction(WashWith)
    getAllIobj(actor, scopeList) {
        return scopeList.subset({x: x.isIn(actor)});
    }
;
VerbRule(WashWith)
   ('wash') singleDobj 'with' singleIobj
   : WashWithAction
     verbPhrase = 'wash/washing (what) (with what)'
;

DefineTIAction(WashIn)
;
VerbRule(WashIn)
   ('wash') singleDobj singleIobj
   : WashWithAction
     verbPhrase = 'wash/washing (what) (in what)'
;

modify Thing
   dobjFor(Wash){
      verify(){ illogical('{That dobj/him} can\'t be washed. '); 
      }
   }
   iobjFor(Wash){
      verify(){ illogical('{That iobj/him} isn\'t something {you/he} 
                          can wash anything with. ');
      }
   }
   dobjFor(WashWith){
      verify() {
        illogical('{You/he} can\'t wash {that dobj/him}. ');
     }
   }
   iobjFor(WashWith){
      verify(){
          illogical('{That iobj/him} can not be used for washing anything........... ');
      }
   }
   dobjFor(WashIn){
      verify() {
        illogical('{You/he} can\'t wash {that dobj/him}. ');
     }
   }
   iobjFor(WashIn){
      verify(){
          illogical('{That iobj/him} can not be used for washing anything in. ');
      }
   } 
;
modify Actor
   dobjFor(Wash){
          verify(){
            if(gActor == gPlayerChar){
                    illogical('You can\'t do that here. '); 
            }
 	       illogical('{The dobj/he} probably wouldn&rsquo;t {|have} like{|d} that. ');
          }
   }
;





// We'll add an "aboutDesc" option to each Thing object.
// If the aboutDesc has a value we'll describe it in
// an "about" command. Example: "about gate" could return
// a historical type analysis. Ex: "The gate was built in 1843
// by Larbintire Inc. and was imported from a European castle 
// and installed here at the mansion at great cost. If you'd like
// to you can open the gate or close the gate or even enter the gate. "
DefineTAction(AboutWhat);
VerbRule(AboutWhat)
   ('about') singleDobj
   : AboutWhatAction
     verbPhrase = 'about (what)'
;
modify Thing
   dobjFor(AboutWhat){
     // preCond=[objVisible,touchObj]
      verify() { 
                  logicalRank(50,'not a likely command');
                  if(!isIn(gActor))
                     logicalRank(80,'not held');                 
                  if(gDobj == nil)
                     illogical('You\'ll have to be more specific. ');
               }
      action(){ 
          self.aboutDesc; 
      }
   }
   aboutDesc { 
               local obj = (gDobj == nil) ? self : gDobj;
               gMessageParams(obj);// set params for use with {} tags
               local s0 = 'There is nothing special or unsual to describe about {that obj/him} that {you/he} would not already know from simply examining {it obj/her}. ';               
               if(gActor==gPlayerChar) say(s0);
             }
;


DefineTAction(Lick);
VerbRule(Lick)
   ('lick') singleDobj
   : LickAction
     verbPhrase = 'lick/licking (what)'
;
modify Thing
   dobjFor(Lick){
      verify() {
        illogical('{You/he} can\'t or shouldn\'t lick {that dobj/him}. Even
                 if it were possible you\'d probably get a licking you\'d never forget. ');
     }
   }
;

DefineTAction(Fondle);
VerbRule(Fondle)
   ('fondle') singleDobj
   : FondleAction
     verbPhrase = 'fondle/fondling (what)'
;
modify Thing
   dobjFor(Fondle){
      verify() {
        illogical('{You/he} can\'t fondle {that dobj/him}. ');
     }
   }
;






// TAction = transitive verb, IAction = inactive
// example: Play With Toys, Play With Guitar, Play With Friend
// see also: en_us.t for some other verb examples
// NOTE: below accounts for just a plain "have sex" command (i.e. you would be prompted "have sex (with what)?"
//   ...but the correct syntax is "have sex with" not just plain "have sex"
DefineTAction(HaveSexWith);
VerbRule(HaveSexWith)
    (('fuck') | ('have' 'sex') | ('have' 'sex' 'with')) dobjList
    : HaveSexWithAction
    verbPhrase = 'have sex/sex (with what)' 
;
modify Thing
   dobjFor(HaveSexWith){
      preCond = [touchObj]
      verify() { 
          if(gActor.is_A_Little_Girl==true){            
            illogical('Even if it were possible, which it\'s not, you are just a little girl
             and shouldn\'t even be thinking about such things. ');
          }
         // by default this action is illogical
         illogical('{That dobj/he} {is}n\'t something {you/he} can have sex with. ');         
      }      
   }  
;

// command: parse-debug
// 'attach' dobjList 'to' dobjList 'with' singleIobj   --> attach line to book with pin (book script recognizes)
// 'attach' dobjList 'to' singleIobj 'with' singleIobj --> attach book to line with pin (book script recognizes)
DefineTIAction(AttachToWith);
VerbRule(AttachToWith)
   'attach' dobjList 'to' singleIobj 'with' singleIobj  //'attach' dobjList 'to' dobjList 'with' singleIobj
   :AttachToWithAction
   verbPhrase = 'attach (what) to (what) (with what)'
;
modify Thing
   dobjFor(AttachToWith){
       preCond = [touchObj]
       verify() {
              illogical('{That dobj/he} {is}n\'t something {you/he} can attach like that. ');
       }
   }
;





// TAction = transitive verb, IAction = inactive
// example: Play With Toys, Play With Guitar, Play With Friend
// see also: en_us.t for some other verb examples
DefineTAction(PlayWith);
VerbRule(PlayWith)
   ('play' | 'zingoalternativetoplay') 'with' dobjList
    : PlayWithAction
    verbPhrase = 'play/playing (with what)' 
;
modify Thing
   dobjFor(PlayWith){
      preCond = [touchObj]
      verify() {
        illogical('{That dobj/he} {is}n\'t something {you/he} can play with. ');
     }
   }  
;

DefineTAction(Rub);
VerbRule(Rub)
   'rub' dobjList
    : RubAction
    verbPhrase = 'rub/rubbing (what)' 
;
modify Thing
  rubDesc = 'You feel nothing out of the ordinary. '
;
modify Thing 
  dobjFor(Rub){   
  preCond = [touchObj]
       verify(){ illogical('{That dobj/he} {is}n\'t something {you/he} can rub. '); }
   //    action(){
   //       /* show our "feel" description */
   //       fromPOV(gActor, &basicExamineFeel);
   //    }
   }
;

// NOTE: Global action... all scripting done here (i.e. you can not override with dobjFor...)
//DefineIAction(Swim)
//  execAction(){ 
//       // check to see if we are in a location with sharks in the water...
//       local myarray = [wonderlandBay1,wonderlandBay2,wonderlandBeach,islandPier,bigBoat];
//       if(myarray.indexOf(me.location) != nil){
//          "You can't swim here. There are sharks in that water. <.p>";
//          return;
//       }     
//       mainReport('You can not swim here. ');      
//  }
//;
//VerbRule(Swim)
//  'swim' | 'wade' | 'dive' | 'snorkel'
//  : SwimAction
//  verbPhrase = 'swim/wade'
//;

// Typing "sex" will show if you are male or female...
DefineIAction(Sex)
   execAction() {
       #ifdef __DEBUG
         // mainReport(' ... ran the DefineIAction(Sex) for verb \"SEX\".... \n'); 
       #endif       
     // old ref tag was: me.is_A_Girl
       if(libGlobal.playerChar.is_A_Girl){
          mainReport('You are female. ');
       }else{
          mainReport('You are male. ');// will show for is_A_Girl being nil or 0 
       }     
   }
;
VerbRule(Sex)
  // 'sex' | ('examine') 'sex' | 'look' 'sex'
 'sex' | 'look' 'sex' | 'x' 'sex' | 'x' 'my' 'sex' | 'examine' 'sex' | 'examine' 'my' 'sex' |
 'gender' | 'look' 'gender' | 'look' 'my' 'gender' | 'examine' 'gender' | 'examine' 'my' 'gender'
   : SexAction
   verbPhrase = 'sex/gender'
;

/* Note: for the doorbell object i.e. push or ring the bell */
DefineTAction(Ring);
VerbRule(Ring)
   ('ring') singleDobj
   : RingAction
     verbPhrase = 'ring/ringing (what)'
;
modify Thing
   dobjFor(Ring){
      verify() {
        illogical('{You/he} can\'t ring {that dobj/him}. ');
     }
   }
;

DefineTAction(KnockOn);
VerbRule(KnockOn)
   ('knock') singleDobj |
   ('knock') ('on') singleDobj
   : KnockOnAction
     verbPhrase = 'knock/knocking on (what)'
;
modify Thing
   dobjFor(KnockOn){
      preCond=[objVisible,touchObj]
      verify(){ 
        illogical('Knocking on {the dobj/him} serves no purpose here. ');
      }
   }
;
modify Door
   dobjFor(KnockOn){
       preCond=[objVisible,touchObj]
       verify(){ logicalRank(110,'likely'); }
       check(){}
       action(){ 
         if(gActor==gPlayerChar)
            "You knock on the door. ";
         else
            "\^<<gActor.name>> knocks on the door. ";
        }
   }
;



// The magic word if you bug the parser too much about a dirty thing
//  is:  Binkle
// You get awarded 10 points for being dity minded... hmm.... maybe it should be you LOSE 10 points?
//DefineIAction(Binkle)   
//   execAction() {
//       if(body_Vagina_LG.counter >= (body_Vagina_LG.myList2.eventList.length()-1)  && playerSaidBinkle.saidBinkleOnce == 0){
//        "Fooled you that time, didn\'t I? Hahahahaha! 
//          You thought you found a secret in the game. Well you did, 
//          and for that I suppose you deserve some extra points. ";
//        playerSaidBinkle.saidBinkleOnce = 1; // a made up flag (NOT to be confused with .awardPointsOnce()... this flag is so this IAVerb has something to look for and set
//        playerSaidBinkle.awardPointsOnce(); // playerSaidBinkle is an Achievement class object found in cromfun4.t - see also score.t        
//       }else{
//          if(body_Vagina_LG.counter < (body_Vagina_LG.myList2.eventList.length()-1)){
//             "No such command. At least not... yet. You probably got this command from
//              a walkthrough or someone told you but now look at you. You\'re entering 
//              silly words like \"Binkle\" and expecting 10 points automatically. No way. ";
//          }
//          if(playerSaidBinkle.saidBinkleOnce){
//              mainReport('You already got your 10 points buddy. So stop with the Binkle command. ');
//          }
//       }
//   }  
//   flagOneTimeOnly = 0   
//;
//VerbRule(Binkle)
//   'binkle'
//   : BinkleAction
//     verbPhrase = 'binkle_1'      
//;

// The magic word to change sex is:  Blargosexchange
DefineIAction(Blargosexchange)
   execAction() {
      // me.changeSex();
      // GameMainDef.initialPlayerChar.changeSex();
      // GameMainDef.initialPlayerChar = memDroid;  
   //   gameMain.is_a_girl=true;
   //   chancey.girlfriend=gPlayerChar; 
   //  chancey.knowsYouAreNotReallyAGirl = true;
      mainReport('This shortcut command word has been disabled.<.p>');
      
   }
;
VerbRule(Blargosexchange)
   'blargosexchange'
   : BlargosexchangeAction
     verbPhrase = 'blargosexchange_1'
;






//DefineIAction(ExamineClothes);
//   execBAction(){
//      mainReport('this is the examine clothes IAction in crom_wrd.t....<.p>');
//   }
//;
//VerbRule(ExamineClothes)
//   'examine' 'clothes'
//   : ExamineClothesAction
//      verbPhrase = 'examine clothes'
//;


// Teleport to girl land south gate
//DefineIAction(Blargoxyzzyy)
//   execAction(){     
//     me.moveInto(girlLandOuterSouthGate);  
//     if(!me.is_A_Girl)
//        aRingForMeNowMyDarling.moveInto(me); // give the ring to the player IF player is male
//     aRingForMeNowMyDarling.readyForUse = true; // default is nil
//     mainReport('You find yourself somewhere else<.p>');
//   }
//;
//VerbRule(Blargoxyzzyy)
//  'blargoxyzzyy'
//  : BlargoxyzzyyAction
//verbPhrase = 'blargoxyzzyy'
//;

DefineIAction(Xyzzyy)
    execAction(){
        "...skipping to \'restarted 3+ times\' and moving to mansion basement with lantern and shovel. ";
        statisticsObj.restartCount = 3;
        largeCorkPlug.moveIntoForTravel(mansionBasement);
        corkPlugDrain.moveIntoForTravel(mansionBasement);
        largePlugChain.moveIntoForTravel(mansionBasement);
        shovel.moveInto(gPlayerChar);
        brassLantern.moveInto(gPlayerChar);
        brassLantern.makeOn(true);
        gPlayerChar.moveIntoForTravel(mansionBasement);
        gPlayerChar.lookAround(true);
    }
;
VerbRule(Xyzzyy)
    'xyzzyy'
    : XyzzyyAction
    verbPhrase = 'xyzzyy'
;

DefineIAction(Poplabnow)
    execAction(){
        gPlayerChar.moveIntoForTravel(outsideDifferentTGARLab);
        // gPlayerChar.moveIntoForTravel(mansionFormSaverLabRoom);
        gPlayerChar.lookAround(true);
    }
;
VerbRule(Poplabnow)
    'poplabnow'
    : PoplabnowAction
    verbPhrase = 'poplabnow'
;

DefineIAction(Betatester)
    execAction(){
        gameMain.betaTester = true;
        "<table bgcolor=black>
        <tr><td bgcolor=black><font color=yellow>Hi there beta tester! Here are some commands you
        can use to skip to other sections of the game to get there faster. To jump to the basement
        simulating game re-start three times (to see the cork in the floor) try \"xyzzyy\", to jump
        to the bonus game\'s form saver lab try \"poplabnow\", to jump to the bonus game\'s starting
        location try \"plovered\", to jump to the main game\'s end room scene as a woman (with form cube)
        try \"bangend\" (use \"powerup\" to get there in zombie form without the form cube). Hopefully 
        these cheat commands can be useful to you. Have fun!<.p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp- Cleo Kraft
        </font></td></tr></table>";
    }
;
VerbRule(Betatester)
    'betatester' | 'beta' 'tester'
    : BetatesterAction
    verbPhrase = 'betatester'
;

DefineIAction(Plovered)
    execAction(){
        gPlayerChar.moveIntoForTravel(restartRoom);
        gPlayerChar.lookAround(true);
    }
;
VerbRule(Plovered)
    'plovered'
    : PloveredAction
    verbPhrase = 'plovered'
;

DefineIAction(Bangend)
    execAction(){    
        // port werewolf out of game
        werewolf.moveIntoForTravel(pixyland);
        // flag master out of game
        mansionParlor.chokedMaster = true;
        // give player the form cube (w. orig. male pattern) 
        formCubeTwo.moveInto(gPlayerChar);
        
        // shrink
        gPlayerChar.pcHeight = '2\' 8\"';
        // give lamp & shovel to player
        shovel.moveInto(gPlayerChar);
        brassLantern.moveInto(gPlayerChar);
        brassLantern.makeOn(true);
        // turn player into a woman (abysmal version)
        tempPlayerClothes.moveInto(pixyland);
        tempPlayerClothes.makeWornBy(nil);
        girlingBooth.girlType = 'abysmal';
        gameMain.girlType = girlingBooth.girlType;
        gPlayerChar.girlType = girlingBooth.girlType; // added this line in an attempt to fix the bug, appears to work. - Lashek
        mePenis.moveIntoForTravel(pixyland);
        noPenis.moveInto(gPlayerChar);
        me.is_A_Girl = true;
        gPlayerChar.is_A_Girl = true; // CromexxHuman class needs this set for clothes handling
        gameMain.is_a_girl = true; // this is the KEY variable to set for sex changing player
        girlingBooth.playerGirlified = true;
        me.pcAge = 18;
        me.pcHeight = '5\' 3\"';
        me.pcHair = 'blond';
        me.pcEyes = 'blue';

        // create female body parts and give them to the gActor
        local oStrangeFemLegs = new AdultFemaleLegs();
        local oStrangeFemArms = new AdultFemaleArms();
        local oStrangeFemChest = new AdultFemaleBreasts();
        local oStrangeFemSkin = new AdultFemaleSkin();
                       local oStrangeFemNipples = new AdultFemaleNipples();
                       local oStrangeFemShoulders = new AdultFemaleShoulders();
                       local oStrangeFemTorso = new AdultFemaleTorso();
                       local oStrangeFemBellyButton = new AdultFemaleBellybutton();
                       local oStrangeFemHips = new AdultFemaleHips();
                       local oStrangeFemWaist = new AdultFemaleWaist();
                       local oStrangeFemToes = new AdultFemaleToes();
                       local oStrangeFemMouth = new AdultFemaleMouth();
                       local oStrangeFemNose = new AdultFemaleNose();
                       local oStrangeFemHair = new AdultFemaleBlondeHair();
                       local oStrangeFemEyeLashes = new AdultFemaleEyeLashes();
                       local oStrangeFemEyeBrows = new AdultFemaleEyeBrows();
                       local oStrangeFemBlueEyes = new AdultFemaleBlueEyes();
                       local oStrangeFemEars = new AdultFemaleEars();
                       local oStrangeFemHead = new AdultFemaleHead();
                       local oStrangeFemHands = new AdultFemaleHands();
                       local oStrangeFemFingers = new AdultFemaleFingers();
                       local oStrangeFemFingerNails = new AdultFemaleFingerNails();
                       local oStrangeFemFeet = new AdultFemaleFeet();
                       local oStrangeFemToeNails = new AdultFemaleToeNails();
                       local oStrangeFemVagina = new AdultFemaleVagina();
                       // move them to gActor..
                       oStrangeFemLegs.moveInto(gPlayerChar);
                       oStrangeFemArms.moveInto(gPlayerChar);
                       oStrangeFemChest.moveInto(gPlayerChar);
                       oStrangeFemSkin.moveInto(gPlayerChar);
                       oStrangeFemNipples.moveInto(gPlayerChar);
                       oStrangeFemShoulders.moveInto(gPlayerChar);
                       oStrangeFemTorso.moveInto(gPlayerChar);
                       oStrangeFemBellyButton.moveInto(gPlayerChar);
                       oStrangeFemHips.moveInto(gPlayerChar);
                       oStrangeFemWaist.moveInto(gPlayerChar);
                       oStrangeFemToes.moveInto(gPlayerChar);
                       oStrangeFemMouth.moveInto(gPlayerChar);
                       oStrangeFemNose.moveInto(gPlayerChar);
                       oStrangeFemHair.moveInto(gPlayerChar);
                       oStrangeFemEyeLashes.moveInto(gPlayerChar);
                       oStrangeFemEyeBrows.moveInto(gPlayerChar);
                       oStrangeFemBlueEyes.moveInto(gPlayerChar);
                       oStrangeFemEars.moveInto(gPlayerChar);
                       oStrangeFemHead.moveInto(gPlayerChar);
                       oStrangeFemHands.moveInto(gPlayerChar);
                       oStrangeFemFingers.moveInto(gPlayerChar);
                       oStrangeFemFingerNails.moveInto(gPlayerChar);
                       oStrangeFemFeet.moveInto(gPlayerChar);
                       oStrangeFemToeNails.moveInto(gPlayerChar);
                       oStrangeFemVagina.moveInto(gPlayerChar);   
                       // open and unlock booth
                       girlingBooth.makeOpen(true);
                       girlingBooth.makeLocked(nil);
            // jump player to the library...
            gPlayerChar.moveIntoForTravel(mansionLibrary);
            gPlayerChar.lookAround(true);
    }
;
VerbRule(Bangend)
    'bangend'
    : BangendAction
    verbPhrase = 'bangend'
;




DefineIAction(Stop)
   execAction(){   
         "You stop what you\'re doing for a moment so you can better concentrate on your
         surroundings. "; 
   }
;
VerbRule(Stop)
  'stop' 
  : StopAction
verbPhrase = 'stop'
;

DefineTAction(StopWho);
VerbRule(StopWho)
   ('stop') singleDobj
   : StopWhoAction
     verbPhrase = 'stop/stopping (who)'
;
modify Thing
   dobjFor(StopWho){
      verify() {
        illogical('{You/he} can\'t stop {that dobj/him}. ');
     }
   }
;
modify Actor
   dobjFor(StopWho) maybeRemapTo(gDobj==gPlayerChar, Stop)
;


// ** A PATHFINDING EXAMPLE! **
// see file: pathfind.t
// DefineIAction(Blargofindranger)
//   execAction(){       
//    local myPathFinder = new roomPathFinder();
//    local myVector = new List();
    // myVector = myPathFinder.findPath(gActor,gActor.location,standardForestRanger01.location); // Works!
//    myVector = myPathFinder.findPath(gActor,gActor.location,me.location); 
//    foreach(local obj in myVector){     
//      if(gActor.location != obj){
//           // gActor.moveIntoForTravel(obj);
//           gActor.scriptedTravelTo(obj);          
//      }      
//    }
//}
//;
//VerbRule(Blargoafindranger)
//  'blargofindranger'
//  : BlargofindrangerAction
//verbPhrase = 'blargofindranger'
//;



/* "Time" command
 * 
 * note: This will only work if all clocks & watches have 
 * the vocabWord of 'timepiece' in their vocabWord list.
 * see file: cromclok.t
 */
DefineIAction(Time)
   execAction(){    
         libGlobal.totalTurns--;                  
         local tokList = Tokenizer.tokenize('read timepiece');
         executeCommand(gActor,gActor,tokList,nil);// nil = start of sentence (true/nil)         
   }
;
VerbRule(Time)
  ('read') ('the') 'time' | 
  ('read') 'time' | 
  ('get') ('the') 'time' | 
  ('get') 'time' | 
  ('x') 'time' | 
  ('examine') 'time' | 
  ('x') ('the') 'time' | 
  ('examine') ('the') 'time' | 
  ('get') 'time' |
  'time' 
  : TimeAction
verbPhrase = 'time'
;


DefineIAction(Emexifomy)
   //myDelayer(milliseconds){
   //  local origElapsedTime = realTimeManager.getElapsedTime();// set orig time
   //  local concludeTime    = realTimeManager.getElapsedTime() + milliseconds; //  milliseconds ex: 2200
   //  local x =0;
   //  local y =0;
   //  do{
   //     if(realTimeManager.getElapsedTime==concludeTime) x++; 
   //     y++;
   //     if(y>3200) x=1;
   //  }while(x==0); 
   //}
   execAction(){       
         "A hollow voice says \"fool.\" ";
   }
;
VerbRule(Emexifomy)
  'emexifomy'
  : EmexifomyAction
verbPhrase = 'emexifomy'
;

// cloned from Tads library: AttachTo - this is for clothes hangars and hatracks, etc. - 13SEP2013 C.K.
DefineTIAction(HangOn)
;
VerbRule(HangOn)
   ('hang') dobjList 'on' singleIobj
   : HangOnAction
    askIobjResponseProd = toSingleNoun
    verbPhrase = 'hang/hanging (what) (on what)'
;
VerbRule(HangOnWhat)
    [badness 500] ('hang') dobjList
    : HangOnAction
    verbPhrase = 'hang/hanging (what) (on what)'
    construct()
    {
        /* set up the empty indirect object phrase */
        iobjMatch = new EmptyNounPhraseProd();
        iobjMatch.responseProd = toSingleNoun;
    }
;
modify Thing
   dobjFor(HangOn){
      verify() {
        illogical('{You/he} can\'t hang {that dobj/him} on anything. ');
     }
   }
   iobjFor(HangOn){
      verify(){
          illogical('{That iobj/him} can not be used to hang things on. ');
      }
   }
    
;


// The magic word to see the Message Parameter Table is:  mpt
DefineIAction(Mpt)
  execAction() {
   "Message Parameter Substitutions Table (mpt):";
   "\nDo not forget to first set gMessageParams(obj,obj,...) for each object you are referring to
      in the message param tags. ";     
     local horace = me; // tiffanyMeadows;// too lazy to change all the tags...
     //local horace = new Thing();
     //horace.name = 'horace';    
     //horace.isHer = nil;
     //horace.isShe = nil;
     //horace.isHim = true;
     //horace.isIt = nil;
     //horace.isPlural = nil;
     //horace.moveInto(nil);
     // horace.properName = 'horace'; 
     //  horace.isProperName = true;
     //horace.desc = 'a test actor';          
     gMessageParams(horace,me);// set message params for use with message tags 
     "<TABLE border=1 bgcolor=#000000>";
      "<TR><TD><font color=white>\{the subj command\}</font></TD><TD><font color=white>\{</font><font color=red>subj me</font><font color=white>\} ..or player</font></TD><TD><font color=white>\{</font><font color=blue>subj tiffanyMeadows</font><font color=white>\} ..or npc</font></TD></TR>";
      "<TR><TD><font color=white>a/he</font></TD><TD><font color=red>{subj me}{a/he}</font></TD><TD><font color=blue>{subj horace}{a/he}<br></font></TD></TR>
      <TR><TD><font color=white>a/her</font></TD><TD><font color=red>{subj me}{a/her}</font></TD><TD><font color=blue>{subj horace}{a/her}<br></font></TD></TR>
      <TR><TD><font color=white>a/him</font></TD><TD><font color=red>{subj me}{a/him}</font></TD><TD><font color=blue>{subj horace}{a/him}<br></font></TD></TR>
      <TR><TD><font color=white>a/she</font></TD><TD><font color=red>{subj me}{a/she}</font></TD><TD><font color=blue>{subj horace}{a/she}<br></font></TD></TR>
      <TR><TD><font color=white>an/he</font></TD><TD><font color=red>{subj me}{an/he}</font></TD><TD><font color=blue>{subj horace}{an/he}<br></font></TD></TR>
      <TR><TD><font color=white>an/her</font></TD><TD><font color=red>{subj me}{an/her}</font></TD><TD><font color=blue>{subj horace}{an/her}<br></font></TD></TR>
      <TR><TD><font color=white>an/him</font></TD><TD><font color=red>{subj me}{an/him}</font></TD><TD><font color=blue>{subj horace}{an/him}<br></font></TD></TR>
      <TR><TD><font color=white>an/she</font></TD><TD><font color=red>{subj me}{an/she}</font></TD><TD><font color=blue>{subj horace}{an/she}<br></font></TD></TR>
      <TR><TD><font color=white>are</font></TD><TD><font color=red>{subj me}{are}</font></TD><TD><font color=blue>{subj horace}{are}<br></font></TD></TR>
      <TR><TD><font color=white>es</font></TD><TD><font color=red>{subj me}{es}</font></TD><TD><font color=blue>{subj horace}{es}<br></font></TD></TR>
      <TR><TD><font color=white>has</font></TD><TD><font color=red>{subj me}{has}</font></TD><TD><font color=blue>{subj horace}{has}<br></font></TD></TR>
      <TR><TD><font color=white>have</font></TD><TD><font color=red>{subj me}{have}</font></TD><TD><font color=blue>{subj horace}{have}<br></font></TD></TR>
      <TR><TD><font color=white>ies</font></TD><TD><font color=red>{subj me}{ies}</font></TD><TD><font color=blue>{subj horace}{ies}<br></font></TD></TR>
      <TR><TD><font color=white>in</font></TD><TD><font color=red>{subj me}{in}</font></TD><TD><font color=blue>{subj horace}{in}<br></font></TD></TR>
      <TR><TD><font color=white>into</font></TD><TD><font color=red>{subj me}{into}</font></TD><TD><font color=blue>{subj horace}{into}<br></font></TD></TR>
      <TR><TD><font color=white>is</font></TD><TD><font color=red>{subj me}{is}</font></TD><TD><font color=blue>{subj horace}{is}<br></font></TD></TR>
      <TR><TD><font color=white>it\'s/he\'s</font></TD><TD><font color=red>{subj me}{it\'s/he\'s}</font></TD><TD><font color=blue>{subj horace}{it\'s/he\'s}<br></font></TD></TR>
      <TR><TD><font color=white>it/he</font></TD><TD><font color=red>{subj me}{it/he}</font></TD><TD><font color=blue>{subj horace}{it/he}<br></font></TD></TR>
      <TR><TD><font color=white>it/her</font></TD><TD><font color=red>{subj me}{it/her}</font></TD><TD><font color=blue>{subj horace}{it/her}<br></font></TD></TR>
      <TR><TD><font color=white>it/him</font></TD><TD><font color=red>{subj me}{it/him}</font></TD><TD><font color=blue>{subj horace}{it/him}<br></font></TD></TR>
      <TR><TD><font color=white>it/she</font></TD><TD><font color=red>{subj me}{it/she}</font></TD><TD><font color=blue>{subj horace}{it/she}<br></font></TD></TR>
      <TR><TD><font color=white>its/her</font></TD><TD><font color=red>{subj me}{its/her}</font></TD><TD><font color=blue>{subj horace}{its/her}<br></font></TD></TR>
      <TR><TD><font color=white>its/hers</font></TD><TD><font color=red>{subj me}{its/hers}</font></TD><TD><font color=blue>{subj horace}{its/hers}<br></font></TD></TR>
      <TR><TD><font color=white>itself/herself</font></TD><TD><font color=red>{subj me}{itself/herself}</font></TD><TD><font color=blue>{subj horace}{itself/herself}<br></font></TD></TR>
      <TR><TD><font color=white>itself</font></TD><TD><font color=red>{subj me}{itself}</font></TD><TD><font color=blue>{subj horace}{itself}<br></font></TD></TR>
      <TR><TD><font color=white>on</font></TD><TD><font color=red>{subj me}{on}</font></TD><TD><font color=blue>{subj horace}{on}<br></font></TD></TR>
      <TR><TD><font color=white>onto</font></TD><TD><font color=red>{subj me}{onto}</font></TD><TD><font color=blue>{subj horace}{onto}<br></font></TD></TR>
      <TR><TD><font color=white>s</font></TD><TD><font color=red>{subj me}{s}</font></TD><TD><font color=blue>{subj horace}{s}<br></font></TD></TR>
      <TR><TD><font color=white>subj</font></TD><TD><font color=red>{subj me}{subj}</font></TD><TD><font color=blue>{subj horace}{subj}<br></font></TD></TR>
      <TR><TD><font color=white>that/he</font></TD><TD><font color=red>{subj me}{that/he}</font></TD><TD><font color=blue>{subj horace}{that/he}<br></font></TD></TR>
      <TR><TD><font color=white>that/her</font></TD><TD><font color=red>{subj me}{that/her}</font></TD><TD><font color=blue>{subj horace}{that/her}<br></font></TD></TR>
      <TR><TD><font color=white>that/him</font></TD><TD><font color=red>{subj me}{that/him}</font></TD><TD><font color=blue>{subj horace}{that/him}<br></font></TD></TR>
      <TR><TD><font color=white>that/she</font></TD><TD><font color=red>{subj me}{that/she}</font></TD><TD><font color=blue>{subj horace}{that/she}<br></font></TD></TR>
      <TR><TD><font color=white>the\'s/her</font></TD><TD><font color=red>{subj me}{the\'s/her}</font></TD><TD><font color=blue>{subj horace}{the\'s/her}<br></font></TD></TR>
      <TR><TD><font color=white>the\'s/hers</font></TD><TD><font color=red>{subj me}{the\'s/hers}</font></TD><TD><font color=blue>{subj horace}{the\'s/hers}<br></font></TD></TR>
      <TR><TD><font color=white>the/he</font></TD><TD><font color=red>{subj me}{the/he}</font></TD><TD><font color=blue>{subj horace}{the/he}<br></font></TD></TR>
      <TR><TD><font color=white>the/her</font></TD><TD><font color=red>{subj me}{the/her}</font></TD><TD><font color=blue>{subj horace}{the/her}<br></font></TD></TR>
      <TR><TD><font color=white>the/him</font></TD><TD><font color=red>{subj me}{the/him}</font></TD><TD><font color=blue>{subj horace}{the/him}<br></font></TD></TR>
      <TR><TD><font color=white>the/she</font></TD><TD><font color=red>{subj me}{the/she}</font></TD><TD><font color=blue>{subj horace}{the/she}<br></font></TD></TR>
      <TR><TD><font color=white>was</font></TD><TD><font color=red>{subj me}{was}</font></TD><TD><font color=blue>{subj horace}{was}<br></font></TD></TR>
      <TR><TD><font color=white>were</font></TD><TD><font color=red>{subj me}{were}</font></TD><TD><font color=blue>{subj horace}{were}<br></font></TD></TR>
      <TR><TD><font color=white>you\'re/he\'s</font></TD><TD><font color=red>{subj me}{you\'re/he\'s}</font></TD><TD><font color=blue>{subj horace}{you\'re/he\'s}<br></font></TD></TR>
      <TR><TD><font color=white>you\'re/she\'s</font></TD><TD><font color=red>{subj me}{you\'re/she\'s}</font></TD><TD><font color=blue>{you\'re/she\'s}{subj horace}<br></font></TD></TR>
      <TR><TD><font color=white>you\'re</font></TD><TD><font color=red>{subj me}{you\'re}</font></TD><TD><font color=blue>{subj horace}{you\'re}<br></font></TD></TR>
      <TR><TD><font color=white>you/he</font></TD><TD><font color=red>{subj me}{you/he}</font></TD><TD><font color=blue>{subj horace}{you/he}<br></font></TD></TR>
      <TR><TD><font color=white>you/her</font></TD><TD><font color=red>{subj me}{you/her}</font></TD><TD><font color=blue>{subj horace}{you/her}<br></font></TD></TR>
      <TR><TD><font color=white>you/him</font></TD><TD><font color=red>{subj me}{you/him}</font></TD><TD><font color=blue>{subj horace}{you/him}<br></font></TD></TR>
      <TR><TD><font color=white>you/she</font></TD><TD><font color=red>{subj me}{you/she}</font></TD><TD><font color=blue>{subj horace}{you/she}<br></font></TD></TR>
      <TR><TD><font color=white>your/her</font></TD><TD><font color=red>{subj me}{your/her}</font></TD><TD><font color=blue>{subj horace}{your/her}<br></font></TD></TR>
      <TR><TD><font color=white>your/his</font></TD><TD><font color=red>{subj me}{your/his}</font></TD><TD><font color=blue>{subj horace}{your/his}<br></font></TD></TR>
      <TR><TD><font color=white>your</font></TD><TD><font color=red>{subj me}{your}</font></TD><TD><font color=blue>{subj horace}{your}<br></font></TD></TR>
      <TR><TD><font color=white>yours/hers</font></TD><TD><font color=red>{subj me}{yours/hers}</font></TD><TD><font color=blue>{subj horace}{yours/hers}<br></font></TD></TR>
      <TR><TD><font color=white>yours/his</font></TD><TD><font color=red>{subj me}{yours/his}</font></TD><TD><font color=blue>{subj horace}{yours/his}<br></font></TD></TR>
      <TR><TD><font color=white>yours</font></TD><TD><font color=red>{subj me}{yours}</font></TD><TD><font color=blue>{subj horace}{yours}<br></font></TD></TR>
      <TR><TD><font color=white>yourself/herself</font></TD><TD><font color=red>{subj me}{yourself/herself}</font></TD><TD><font color=blue>{subj horace}{yourself/herself}<br></font></TD></TR>
      <TR><TD><font color=white>yourself/himself</font></TD><TD><font color=red>{subj me}{yourself/himself}</font></TD><TD><font color=blue>{subj horace}{yourself/himself}<br></font></TD></TR>
      <TR><TD><font color=white>yourself</font></TD><TD><font color=red>{subj me}{yourself}</font></TD><TD><font color=blue>{subj horace}{yourself}<br></font></TD></TR>
    </TABLE>
      See: http://www.tads.org/howto/t3msg.htm<br>
      Or: D:\\sw\\games\\tads\\t3msg.htm<br>";
      // Now setup our default body tag again in case the above with "pause" messes up the prompt font
      "<BODY BGCOLOR=#CCCCCC TEXT=#000000 LINK=#DA39E5 VLINK=#99038F></BODY>";
   }
;
VerbRule(Mpt)   
   'mpt'
   : MptAction
     verbPhrase = 'mpt'
;




// end of crom_wrd.t


