#charset "us-ascii"
#include "adv3.h"
#include "en_us.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// TODO: Later, put together table of contents

// -------------------------------------------------------------------
// SCOPE OF FILE
// -------------------------------------------------------------------

// This menu defines a rather extensive debugging menu I wrote for two reasons:
// (1) general debugging, and (2) multimedia testing. 
// It does NOT include the ABOUT/HINT/INSTRUCTIONS menu, whose 
// content/modifications I currently have in 1actions.t.

// -------------------------------------------------------------------
// DEBUG START MENU
// -------------------------------------------------------------------

// *If __DEBUG is defined*, then when the game begins, we will not 
// start out normally. Instead we will go to a menu of options about
// what part of the game to debug, by calling startMenu.select().
// 
// *If __DEBUG is not defined*, we still need some of the code below. 
// When beginning the game, we will use the goToIntro menu option, 
// calling its execute() method. When going to virtual reality from 
// the cell, we will call goToVR.execute(). And so on.
// 
// This is done using my qtalk.t extension. Qtalk.t was designed for 
// conversation, but it works perfectly well for this too. 
// 
// Sorry if this makes my code hard to fathom for non-qtalk.t users.
// But before I did this setup, debugging was entirely too difficult.
// 
// See also gameMain.showIntro() above.

startMenu: QMain
  reply {
    "Select an option:";
  }
  options = [
     goToIntro
    ,goToConfRoom
    ,goToCell
    ,goToVR
    ,goToSupermaze
    ,goToHac
    ,goToArgument
    ,goToEndgame
    ,goToDreamRoom
    // These are at the end, which might not be too logical, but 
    // I have a deeply ingrained habit of typing, e.g., "5"
    // for the supermaze, and I don't want to have to change that.
    ,goToBeach
    ,goToEmptyRoom
    ,goToHacWithoutAdam
    ,goToTesting
    //,goToBanner
  ]
  killQ = true
  killZ = true
  choice = nil
;

// The options referenced above -- goToIntro, goToConfRoom, etc. --
// are all ways of starting the game, in addition to being menu options.
// Therefore, let them all belong to a class StartMethod, which
// belongs to class Quip, qtalk.t's class for menu options.
class StartMethod: Quip
  reply {
    nbmCls();
    execute;
  }
  // The execute method can be called to call any given StartMethod
  // into action.
  execute {
    //if (self == goToEndgame)
    //  pleaseSay('<.p><font color=red><b>PC before going into endgame: ' + (gPlayerChar ? gPlayerChar.theName : 'nil') + '.</b></font><.p>');
    if (initPC && initPC != gPlayerChar)
      setPlayer(initPC);
    gActor = gPlayerChar;
    //libGlobal.curActor = gPlayerChar;
    
    // Deal with clothes
    if (gPlayerChar.intendedClothes 
        && dataType(gPlayerChar.intendedClothes) == TypeList
        && gPlayerChar.intendedClothes.length >= 1) {
      if (attirePC) {
        for (local a = 1; a <= gPlayerChar.intendedClothes.length; a++) {
          if (!gPlayerChar.intendedClothes[a].isIn(gPlayerChar))
            gPlayerChar.intendedClothes[a].moveInto(gPlayerChar);
          if (!gPlayerChar.intendedClothes[a].isWornBy(gPlayerChar))
            gPlayerChar.intendedClothes[a].makeWornBy(gPlayerChar);
        }
      }
      else { // make sure PC is not attired
        for (local a = 1; a <= gPlayerChar.intendedClothes.length; a++) {
          gPlayerChar.intendedClothes[a].makeWornBy(nil);
          if (gPlayerChar.intendedClothes[a].location != nil)
            gPlayerChar.intendedClothes[a].moveInto(nil);
        }
      }
    }
    // end clothes stuff
    
    if (gPlayerChar.location != initLoc) {
      //local origin = gPlayerChar.location;
      //if (origin) origin.travelerLeaving(gPlayerChar, initLoc, nil);
      gPlayerChar.moveIntoForTravel(initLoc);
      //The following couple of lines cause run-time errors, as
      //gActor, gTranscript, etc., have not yet been set.
      //if (gPlayerChar.location)
      //  gPlayerChar.location.travelerArriving(gPlayerChar, origin, nil, nil);
      gPlayerChar.location.enteringRoom(gPlayerChar);
    }
    if (initParser && initParser != glob.parser)
      glob.parser = initParser;
    if (initStatus && initStatus != glob.status)
      glob.status = initStatus;
    if (initFont && initFont != glob.font)
      glob.font = initFont;
    // if there's no gExitLister and we need to add it:
    if (hasExitList && !gExitLister) {
      //"<p>ExitLister retrieval attempted.<p>";
      libGlobal.exitListerObj = exitLister;
      retrieveExitSettings();
    }
    // if there's a gExitLister and we need to remove it:
    if (!hasExitList && gExitLister) {
      libGlobal.exitListerObj = nil;
      storeExitSettings();
    }
    if (glob.changeFont) "<.nbmfont>";
    init;
    // nbmBanner.updateMe is intentionally last, in case it needs 
    // to reflect any changes made here.
    nbmBanner.updateMe();
  }
  init { }
  attirePC = true
;

goToIntro: StartMethod
  desc = "Intro: Start normally"
  initPC     = me
  initLoc    = nil
  initParser = human
  initStatus = blank
  initFont   = verdana
  hasExitList= true
  init {
    // 2019-05-15: Not sure if the distinction between Scenario 1 and Scenario 2
    // is needed anymore, since we no longer want to include the excessively retro
    // splash image mazessplash.png.
    // SCENARIO 1: New play session
    // If this is a new play session, then...
    if (!transientGlob.sessionBegun) {
      //// Now that we are no longer trying to cover the RESTART scenario 
      //// here, we will try not clearing the screen and see if this 
      //// causes any problems.
      ////nbmCls();
      //"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
      //  <tr>
      //    <td>";
      //      "<div align=\"center\"><img src=\"misc/mazessplash.png\" border=\"0\"></div>";
      //    "</td>
      //  </tr>";
      //"</table>";
      //nbmPause();
      nbmCls();
      transientGlob.sessionBegun = true;
      "<.p>";
    }
    // SCENARIO 2: Restarting
    // If the player has just typed RESTART, then...
    else {
      maybeNbmCls(RestartAction);
      if (actionRequiresCls(RestartAction))
        "<.p>";
    }
    "When consciousness returns, it returns slowly. ";
    glob.blockNonMetaVerbs = true;
  }
  attirePC = nil
;

//modify RestartAction
//  doRestartGame() {
//    commandSequencer.setCommandMode();
//    "<.commandsep>";
//    //"<.p>";
//    PreRestartObject.classExec();
//    throw new RestartSignal();
//  }
//;

goToCoffin: StartMethod
  desc = "Intro: Coffin only"
  initPC     = me
  initLoc    = coffin
  initParser = human
  //msgtype  = me
  initStatus = trinity
  initFont   = verdana
  hasExitList= true
  init {
  }
  attirePC = nil
;

goToConfRoom: StartMethod
  desc = "Intro: Conference room"
  initPC     = me
  initLoc    = firstConfChair
  initParser = human
  //msgtype  = me
  initStatus = trinity
  initFont   = verdana
  hasExitList= true
  init {
    me.makePosture(sitting);
    createIntroConditions();
  }
;

goToCell: StartMethod
  desc = "Intro: Cell"
  initPC     = me
  initLoc    = cell
  initParser = human
  //msgtype  = me
  initStatus = trinity
  initFont   = verdana
  hasExitList= true
  init {
    createIntroConditions();
    if (!me.hasSeen(confRoom)) {
      vicki.hasBeenIdentified = true;
      diane.hasBeenIdentified = true;
    }
  }
;

goToVR: StartMethod
  desc = "Intro: VR"
  initPC     = virtualMe
  initLoc    = vrRoom
  initParser = alien
  //msgtype  = virtualMe
  initStatus = trinity
  initFont   = courier
  hasExitList= nil//true // otherwise, "EXIT" could trip people up. I don't want that.
  init {
    // June 2010: This init() method previously lacked 
    // createIntroConditions(). I don't know why, so I am adding it now.
    createIntroConditions();
    vicki.hasBeenIdentified = true;
    diane.hasBeenIdentified = true;
    // Move "me" to the cell, while the virtualMe goes to the VR room
    me.moveIntoForTravel(cell);
  }
;

goToBeach: StartMethod
  desc = "Middle: Beach"
  initPC     = virtualMe
  initLoc    = beachChair
  initParser = alien
  //msgtype  = virtualMe
  initStatus = trinity
  initFont   = courier
  hasExitList= nil
  init {
    virtualMe.makePosture(sitting);
    endgameDaemon.endDaemon();
  }
;

goToEmptyRoom: StartMethod
  desc = "Middle: Empty Room"
  initPC     = virtualMe
  initLoc    = emptyRoom
  initParser = alien
  //msgtype  = virtualMe
  initStatus = trinity
  initFont   = courier
  hasExitList= nil
  init {
    endgameDaemon.endDaemon();
  }
;

goToSupermaze: StartMethod
  desc = "Middle: Supermaze"
  initPC     = bot
  initLoc    = supermazeJ1
  initParser = alien
  //msgtype  = bot
  initStatus = zork
  initFont   = courier
  hasExitList= nil
  init {
    endgameDaemon.endDaemon();
    startSupermaze();
  }
;

goToHac: StartMethod // with Adam
  desc = "Middle: Net-Hac-Man"
  initPC     = bot
  initLoc    = hacRoomH12
  initParser = hacman
  //msgtype  = bot
  initStatus = zork
  initFont   = courier
  hasExitList= nil
  init {
    adamThorntonM.isInExe = true;
    // Only do hacTitle() if we're doing debugging. Otherwise 
    // hacTitle() will be called separately elsewhere.
    if (!glob.doingHacManForReal)
      hacTitle();
    saveInitialHacInfo();
    saveMazePortableLocations();
    glob.hacInvoked = nil;
    invokeHac();
    endgameDaemon.endDaemon();
#ifdef __DEBUG
    butterflyIdM.isInExe = true;
#endif // __DEBUG
  }
;

goToHacWithoutAdam: StartMethod
  desc = "Middle: Net-Hac-Man (without Adam) "
  initPC     = bot
  initLoc    = hacRoomH12
  initParser = hacman
  //msgtype  = bot
  initStatus = zork
  initFont   = courier
  hasExitList= nil
  init {
    adamThorntonM.isInExe = nil;
    // Only do hacTitle() if we're doing debugging. Otherwise 
    // hacTitle() will be called separately elsewhere.
    if (!glob.doingHacManForReal)
      hacTitle();
    saveInitialHacInfo();
    saveMazePortableLocations();
    glob.hacInvoked = nil;
    invokeHac();
    endgameDaemon.endDaemon();
#ifdef __DEBUG
    butterflyIdM.isInExe = true;
#endif // __DEBUG
  }
;

goToArgument: StartMethod
  desc = "Endgame: Argument"
  initPC     = bot
  initLoc    = dreamRoom
  initParser = human
  //msgtype  = me
  initStatus = trinity
  initFont   = courier
  hasExitList= nil
  init {
    nbmBanner.removeBanner;
    // This one little line runs the entire argument sequence.
    argMain.select();
    // 
    transitionToEndgame();
    goToEndgame.execute();
  }
;

goToEndgame: StartMethod
  desc = "Endgame: Start normally, with daemons"
  initPC     = me
  initLoc    = dreamRoom
  initParser = human
  //msgtype  = me
  initStatus = trinity
  initFont   = verdana
  hasExitList= true
  init {
    //ovan.moveIntoForTravel(office);
    //neton.moveIntoForTravel(office);
    //oldGuard.moveIntoForTravel(breakRoom);
    //youngGuard.moveIntoForTravel(bathroom);
    //assistant.moveIntoForTravel(confRoom);
    ovan.scMoveInto(office);
    neton.scMoveInto(office);
    ovan.makePosture(standing);
    neton.makePosture(standing);
    oldGuard.scMoveInto(breakRoom);
    youngGuard.scMoveInto(bathroom);
    assistant.scMoveInto(confRoom);
    if (!vicki.isIn(cell))
      vicki.scMoveInto(cell);
    if (!diane.isIn(cell))
      diane.scMoveInto(cell);
    me.moveInto(dreamCouch);
    me.makePosture(lying);
    nbmBanner.updateMe;
    //"You open your eyes. After a moment of disorientation, 
    //  the room comes into focus. You are lying on your back 
    //  on the couch, with the metal bulb just above your head. ";
    //glob.endgameJeopardy = true;
    doStuffForEndgame();
    if (endgameProfSequence.epsValue < 1) {
      //pleaseSay('<.p><font color=red><b>Because epsValue is less than 1:</b></font><.p>');
      endgameProfSequence.execute;
    }
    //challengeManager.setChallenge(
    //  'You have just woken up from the aliens<./s> maze game. ');
    
    initializeAchievementsForEndgame();
    
    challengeManager.setChallenge(
      new function {
        //nbmPause();
        
        //maybeNbmCls(RetryAction);
        "<.p>";
        endgameProfSequence.firstPartOfSequence;
        "<.p><b><<dreamRoom.roomName>> (lying on <<dreamCouch.theName>>)</b> ";
        "<br>";
        dreamRoom.desc;
        "<.p><<endgameProfSequence.seeProfs>>";
        "<p>";
        endgameProfSequence.secondPartOfSequence;
      }
    );
    //pleaseSay('<.p><font color=red><b>Challenge manager should be invoked now. </b></font><.p>');
    //pleaseSay('<.p><font color=red><b>Running goToEndgame: after doStuffForEndgame().</b></font><.p>');
    //if (gKey()) { local k = 0; k=k/k; }
    //// Make daRn sure to print the first part of the endgameProfSequence.
    //// But don't allow an infinite loop, either, just in case.
    //for (local a = 1; a <= 5; a++) {
    //  if (endgameProfSequence.epsValue >= 1)
    //    break;
    //  endgameProfSequence.execute;
    //}
    //pleaseSay('<.p><font color=red><b>Running goToEndgame: after endgameProfSequence.execute().</b></font><.p>');
    //if (gKey()) { local k = 0; k=k/k; }
    
    //endgameDaemon.startDaemon;
    
    //// Again, make damn sure to do the endgame prof crap.
    //for (local a = 1; a <= 5; a++) {
    //  if (endgameProfSequence.epsValue >= 2)
    //    break;
    //  //endgameProfSequence.execute;
    //  endgameDaemon.daemon;
    //}
    //pleaseSay('<.p><font color=red><b>Running goToEndgame: after endgameDaemon.startDaemon().</b></font><.p>');
    //pleaseSay('<.p><font color=red><b>This is the very end of goToEndgame.init.</b></font><.p>');
  }
;

goToDreamRoom: StartMethod
  desc = "Endgame: Dreamroom; no daemons"
  initPC     = me
  initLoc    = dreamRoom
  initParser = human
  //msgtype  = me
  initStatus = trinity
  initFont   = verdana
  hasExitList= true
  init {
    // Don't accomplish "It's not impoossible, just really hard"
    // simply by virtue of just choosing this...
    slowingField.hasEverBeenOn = true;
    me.moveInto(dreamCouch);
    me.makePosture(lying);
    nbmBanner.updateMe;
    doStuffForEndgame();
    endgameDaemon.startDaemon;
    glob.endgameJeopardy = nil;
    if (!vicki.isIn(cell))
      vicki.scMoveInto(cell);
    if (!diane.isIn(cell))
      diane.scMoveInto(cell);
    initializeAchievementsForEndgame();
  }
;

function createIntroConditions() {
  //youngGuard.moveIntoForTravel(confRoom);
  //oldGuard.moveIntoForTravel(confRoom);
  youngGuard.scMoveInto(confRoom);
  oldGuard.scMoveInto(confRoom);
  vicki.scMoveInto(cell);
  diane.scMoveInto(cell);
  youngGuard.setCurState(youngGuardByConfDoorState);
  oldGuard.setCurState(oldGuardByConfDoorState);
}

// -------------------------------------------------------------------
// DEBUG START MENU: BANNER EXPERIMENT TESTING
// -------------------------------------------------------------------

//goToBanner: TestingQSub
//  desc = "Testing: Banner experimentation"
//  reply {
//    nbmCls();
//    cutSceneExperiment.execute();
//    "I think that, by the time you see this, you will need to go back to the main menu. ";
//  }
//  options = [
//    backToStartMenu
//  ]
//  
//;

// -------------------------------------------------------------------
// DEBUG START MENU: MULTIMEDIA TESTING
// -------------------------------------------------------------------

// -------------------------------
// TESTING main menu

class TestingQuip: Quip
  killQ = true
  killZ = true
;

class TestingQSub: TestingQuip, QSub
;

goToTesting: TestingQSub
  desc = "Testing: Multimedia testing"
  reply {
    nbmCls();
    "Choose what you want to do for multimedia testing. ";
  }
  options = [
     showCS
    ,showMusic
    ,showTwisty
    ,showAch
    ,showGame
    ,showMaps
    ,backToStartMenu
  ]
;

backToTestingMenu: TestingQuip
  desc = "Back to the testing menu"
  reply {
    goToTesting.reply();
  }
  transfer = goToTesting
;

backToStartMenu: TestingQuip
  desc = "Back to the main menu"
  reply {
    nbmCls();
    startMenu.reply();
  }
  transfer = startMenu
;

// -------------------------------
// TESTING: cut scene quips

showCS: TestingQSub
  desc = "Show cut scenes"
  reply {
    nbmCls();
    "Which cut scene? ";
  }
  options = [ 
     showCutScene1
    ,showCutScene2
    ,showCutScene3
    ,showCutSceneHac
    ,showNbmTitle
    ,showNbmWinGameSequence
    ,backToTestingMenu 
  ]
;

class CSQuip: TestingQuip
  reply {
    showCS.reply();
  }
  transfer = showCS
;

showCutScene1: CSQuip
  desc = "Show cut scene 1"
  reply {
    "Cut scene details: ";
    "<ul>";
    "<li>Frame 1-2: text without video or sound</li>";
    "<li>Frame 3: alien, with music!!!</li>";
    "<li>Frame 4: alien</li>";
    "<li>Frame 5-6: alien hospital</li>";
    "<li>Frame 7-8: aircar</li>";
    "<li>Frame 9-10: dream couch</li>";
    "<li>Frame 11-13: hallway walking east</li>";
    "<li>Frame 14: conference room</li>";
    "</ul>";
    "Beginning cut scene. You will normally be asked to press a key to begin...";
    "Beginning cut scene. You will normally be asked to press a key to begin...<.p>";
    "<hr>";
    //nbmCls();
    cutScene1.skipEndScene = true;
    cutScene1.execute();
    cutScene1.skipEndScene = nil;
    glob.status = blank;
    statusLine.showStatusLineDaemon();
    inherited();
  }
;

showCutScene2: CSQuip
  desc = "Show cut scene 2"
  reply {
    "Cut scene details: ";
    "<ul>";
    "<li>Frame 1-3: hallway walking west (no sound)</li>";
    "</ul>";
    "Beginning cut scene. You will normally be asked to press a key to begin...";
    "<.p>";
    "<hr>";
    //nbmCls();
    cutScene2.skipEndScene = true;
    cutScene2.execute();
    cutScene2.skipEndScene = nil;
    glob.status = blank;
    statusLine.showStatusLineDaemon();
    inherited();
  }
;

showCutScene3: CSQuip
  desc = "Show cut scene 3"
  reply {
    "Cut scene details: ";
    "<ul>";
    "<li>Frame 1: Moonlit night (no sound)</li>";
    "<li>Frame 2: Hallway walking east (no sound)</li>";
    "<li>Frame 3-4: Dream room (no sound)</li>";
    "</ul>";
    "Beginning cut scene. You will normally be asked to press a key to begin...";
    "<.p>";
    "<hr>";
    //nbmCls();
    cutScene3.skipEndScene = true;
    cutScene3.execute();
    cutScene3.skipEndScene = nil;
    glob.status = blank;
    statusLine.showStatusLineDaemon();
    inherited();
  }
;

showCutSceneHac: CSQuip
  desc = "Show Hac-Man cut scene"
  reply {
    "Cut scene details: ";
    "<ul>";
    "<li>Frame 1-5: text without video or sound</li>";
    "</ul>";
    "Beginning cut scene. You will normally be asked to press a key to begin...";
    "<.p>";
    "<hr>";
    //nbmCls();
    hacCutScene.skipEndScene = true;
    hacCutScene.execute();
    hacCutScene.skipEndScene = nil;
    glob.status = blank;
    statusLine.showStatusLineDaemon();
    inherited();
  }
;

showNbmTitle: CSQuip
  desc = "Show title sequence"
  reply {
    "This isn't really a cut scene.";
    "<p>Details: ";
    "<ul>";
    "<li>The part before the title</li>";
    "<li>The title, with music!!!</li>";
    "<li>The part after the title</li>";
    "</ul>";
    "Beginning cut scene. You will normally be asked to press a key to begin...";
    "<.p>";
    "<hr>";
        "<p><.q>And so,<./q> says Ovan, <.q><i>Totoona Eeret</i> 
            means <i>The Mazes of Earth,</i> 
            but it also means <i>Only Mazes.</i><./q>
          <p><.q>Or, to translate it more idiomatically,
            you might call it\ .\ .\ .<./q> ";
        nbmPause();
        confRoom.killBanner = true;
        nbmBanner.updateMe;
        glob.status = blank;
        statusLine.showStatusLineDaemon();
        //nbmCls();
        //csShout('');
        //cutSceneBanner.clearWindow();
        if (glob.imageSize == 1) {
          csDispImg('illustrations/mazestitle0420.jpg');
        }
        else {
          csDispImg('illustrations/mazestitle0605.jpg');
        }
        playSound('<sound src=\"sound/prelude.mp3\" layer=foreground>');
        nbmPause();
        cutSceneBanner.removeBanner();
        confRoom.killBanner = nil;
        nbmBanner.updateMe;
        glob.status = trinity;
        statusLine.showStatusLineDaemon();
        "<p>
            <b>NOTHING BUT MAZES</b>
            \nA Game
            \nby Greg Boettcher
            \nVersion <<versionInfo.version>>
            \nCopyright 2006 Greg Boettcher";
        "\n<a href=\"<<versionInfo.gameUrl>>\">Game<./s>s web site</a>";
        "\n(Whatever you do, don<./s>t type <a href=\"about\">ABOUT</a>.)";
        "<p><.q>.\ .\ .\ <i>Nothing but Mazes,<./q></i> 
            says Neton.
          <p>You are aghast. A game called <i>Nothing but Mazes?</i>
            And they want you to play it? This is just too
            much! ";
    glob.status = blank;
    statusLine.showStatusLineDaemon();
    nbmPause();
    //nbmCls();
    inherited();
  }
;

showNbmWinGameSequence: CSQuip
  desc = "Show victory sequence"
  reply {
    "This isn't really a cut scene.";
    "<p>Details: ";
    "<ul>";
    "<li>\"The end\" image, with music!!!</li>";
    "<li>\"Or is it?\" image, with music!!!</li>";
    "</ul>";
    "Beginning cut scene. You will normally be asked to press a key to begin...";
    "<.p>";
    "<hr>";
    
          // Pause for input before showing the final graphics
          // and music.
          nbmPause();
          
          //// Clear the main window; banner is coming
          //nbmCls();
          
          // I think I should ensure the status line is blank
          glob.status = blank;
          statusLine.showStatusLineDaemon();
          
          // Remove the regular banner
          nbmBanner.removeBanner();
          // "The end," plus accompanying fanfare
          if (glob.imageSize == 1) {
            csDispImg('illustrations/theend1_0300.jpg');
          }
          else {
            csDispImg('illustrations/theend1_0469.jpg');
          }
          playSound('<sound src=\"sound/fanfare1.mp3\" layer=foreground>');
          // Pause for input
          nbmPause();
          // Clear the cut scene banner
          cutSceneBanner.clearWindow();
          
          // "Or is it?" plus accompanying fanfare
          if (glob.imageSize == 1) {
            csDispImg('illustrations/theend3_0300.jpg');
          }
          else {
            csDispImg('illustrations/theend3_0469.jpg');
          }
          playSound('<sound src=\"sound/fanfare2.mp3\" layer=foreground>');
          // Pause for input
          nbmPause();
          // Remove the cut scene banner
          cutSceneBanner.removeBanner();
          // Reinstate the regular banner
          nbmBanner.updateMe();
    inherited();
  }
;

// -------------------------------
// TESTING: music quips

showMusic: TestingQSub
  desc = "Play music"
  reply {
    nbmCls();
    "Note: The music in this game should be subject to the MUSIC OFF
      command; however, this menu is not because it happens right 
      at the beginning of the game. ";
    "<.p>";
    "What music to play? ";
  }
  options = [ 
     showMusicAlien
    ,showMusicPrelude
    ,showMusicHacMan
    ,showMusicFanfare1
    ,showMusicFanfare2
    ,backToTestingMenu 
  ]
;

class MusicQuip: TestingQuip
  reply {
    showMusic.reply();
  }
  transfer = showMusic
;

showMusicAlien: MusicQuip
  desc = "alien.mp3"
  reply {
    "<.p>";
    "Press a key to play: ";
    "<.p>";
    "alien.mp3";
    "<.p>";
    "The first music you hear in the game.";
    playSound('<sound src=\"sound/alien.mp3\" layer=foreground>');
    nbmPause();
    inherited();
  }
;

showMusicPrelude: MusicQuip
  desc = "prelude.mp3"
  reply {
    "<.p>";
    "Press a key to play: ";
    "<.p>";
    "prelude.mp3";
    "<.p>";
    "The title music.";
    playSound('<sound src=\"sound/prelude.mp3\" layer=foreground>');
    nbmPause();
    inherited();
  }
;

showMusicHacMan: MusicQuip
  desc = "hacman.mp3"
  reply {
    "<.p>";
    "Press a key to play: ";
    "<.p>";
    "hacman.mp3";
    "<.p>";
    "The Net-Hac-Man music.";
    playSound('<sound src=\"sound/hacman.mp3\" layer=foreground>');
    nbmPause();
    inherited();
  }
;

showMusicFanfare1: MusicQuip
  desc = "fanfare1.mp3"
  reply {
    "<.p>";
    "Press a key to play: ";
    "<.p>";
    "fanfare1.mp3";
    "<.p>";
    "The first of two fanfares when you win the game.";
    playSound('<sound src=\"sound/fanfare1.mp3\" layer=foreground>');
    nbmPause();
    inherited();
  }
;

showMusicFanfare2: MusicQuip
  desc = "fanfare2.mp3"
  reply {
    "<.p>";
    "Press a key to play: ";
    "<.p>";
    "fanfare2.mp3";
    "<.p>";
    "The second of two fanfares when you win the game.";
    playSound('<sound src=\"sound/fanfare2.mp3\" layer=foreground>');
    nbmPause();
    inherited();
  }
;

// -------------------------------
// TESTING: twisty quips

showTwisty: TestingQSub
  desc = "Test retrieval from resource file"
  reply {
    nbmCls();
    "If this succeeds, you should be able to retrieve the first few words
      from a text file that begin and end with the specified letters. ";
    "<.p>";
    "What letters to begin and end with? ";
  }
  options = [ 
     showTwistyTW
    ,showTwistyWI
    ,showTwistyIS
    ,showTwistyST
    ,showTwistyTY
    ,backToTestingMenu 
  ]
;

class TwistyQuip: TestingQuip
  reply {
    showTwisty.reply();
  }
  transfer = showTwisty
  maxCount = 5
;

showTwistyTW: TwistyQuip
  desc = "T---W"
  reply {
    teData.forgetCurList;
    teData.rememberNewList(twistyRoomT.teFilename);
    "If this succeeds, you will get a list of <<maxCount>> words 
      that match the pattern <<desc>>. This will prove our ability 
      to retrieve from the external file that holds that information. ";
    "<.p>";
    for (local i = 1; i <= maxCount; i++) {
      say(teData.curList[i]);
      say('\n');
    }
    teData.forgetCurList;
    nbmPause();
    inherited();
  }
;

showTwistyWI: TwistyQuip
  desc = "W---I"
  reply {
    teData.forgetCurList;
    teData.rememberNewList(twistyRoomTw.teFilename);
    "If this succeeds, you will get a list of <<maxCount>> words 
      that match the pattern <<desc>>. This will prove our ability 
      to retrieve from the external file that holds that information. ";
    "<.p>";
    for (local i = 1; i <= maxCount; i++) {
      say(teData.curList[i]);
      say('\n');
    }
    teData.forgetCurList;
    nbmPause();
    inherited();
  }
;

showTwistyIS: TwistyQuip
  desc = "I---S"
  reply {
    teData.forgetCurList;
    teData.rememberNewList(twistyRoomTwi.teFilename);
    "If this succeeds, you will get a list of <<maxCount>> words 
      that match the pattern <<desc>>. This will prove our ability 
      to retrieve from the external file that holds that information. ";
    "<.p>";
    for (local i = 1; i <= maxCount; i++) {
      say(teData.curList[i]);
      say('\n');
    }
    teData.forgetCurList;
    nbmPause();
    inherited();
  }
;

showTwistyST: TwistyQuip
  desc = "S---T"
  reply {
    teData.forgetCurList;
    teData.rememberNewList(twistyRoomTwis.teFilename);
    "If this succeeds, you will get a list of <<maxCount>> words 
      that match the pattern <<desc>>. This will prove our ability 
      to retrieve from the external file that holds that information. ";
    "<.p>";
    for (local i = 1; i <= maxCount; i++) {
      say(teData.curList[i]);
      say('\n');
    }
    teData.forgetCurList;
    nbmPause();
    inherited();
  }
;

showTwistyTY: TwistyQuip
  desc = "T---Y"
  reply {
    teData.forgetCurList;
    teData.rememberNewList(twistyRoomTwist.teFilename);
    "If this succeeds, you will get a list of <<maxCount>> words 
      that match the pattern <<desc>>. This will prove our ability 
      to retrieve from the external file that holds that information. ";
    "<.p>";
    for (local i = 1; i <= maxCount; i++) {
      say(teData.curList[i]);
      say('\n');
    }
    teData.forgetCurList;
    nbmPause();
    inherited();
  }
;

// -------------------------------
// TESTING: Achievement-scope stuff

showAch: TestingQSub
  desc = "Test reading/writing data to external file"
  reply {
    nbmCls();
    "This section will let you read from, and write to, 
      a variable whose value 
      will be stored to the following file
      and preserved for future sessions 
      and future playthroughs. ";
    "<.p>";
    "The filename will be saved as: \n";
    "<<achievementScopeFileManager.achievementFilename>> ";
    "<.p>";
    "The current value of the variable is: \n";
    say(asIntTest.value);
    "<.p>";
    "What would you like to do? ";
  }
  options = [ 
     showAchAdd1
    ,showAchAdd10
    ,showAchSubtract1
    ,showAchSubtract10
    ,showAchMultiplyBy2
    ,showAchDivideBy2
    ,showAchResetTo0
    ,backToTestingMenu 
  ]
;

class AchQuip: TestingQuip
  reply {
    showAch.reply();
  }
  transfer = showAch
;

showAchAdd1: AchQuip
  desc = "Add 1 to current value"
  reply {
    asIntTest.setValue(asIntTest.value + 1);
    achievementScopeManager.saveData();
    "<.p>";
    "The new value of the variable is: \n";
    say(asIntTest.value);
    nbmPause();
    inherited();
  }
;
showAchAdd10: AchQuip
  desc = "Add 10 to current value"
  reply {
    asIntTest.setValue(asIntTest.value + 10);
    achievementScopeManager.saveData();
    "<.p>";
    "The new value of the variable is: \n";
    say(asIntTest.value);
    nbmPause();
    inherited();
  }
;
showAchSubtract1: AchQuip
  desc = "Subtract 1 from current value"
  reply {
    asIntTest.setValue(asIntTest.value - 1);
    achievementScopeManager.saveData();
    "<.p>";
    "The new value of the variable is: \n";
    say(asIntTest.value);
    nbmPause();
    inherited();
  }
;
showAchSubtract10: AchQuip
  desc = "Subtract 10 from current value"
  reply {
    asIntTest.setValue(asIntTest.value - 10);
    achievementScopeManager.saveData();
    "<.p>";
    "The new value of the variable is: \n";
    say(asIntTest.value);
    nbmPause();
    inherited();
  }
;
showAchMultiplyBy2: AchQuip
  desc = "Multiply current value by 2"
  reply {
    asIntTest.setValue(asIntTest.value * 2);
    achievementScopeManager.saveData();
    "<.p>";
    "The new value of the variable is: \n";
    say(asIntTest.value);
    nbmPause();
    inherited();
  }
;
showAchDivideBy2: AchQuip
  desc = "Divide current value by 2 (using integer math...)"
  reply {
    asIntTest.setValue(asIntTest.value / 2);
    achievementScopeManager.saveData();
    "<.p>";
    "The new value of the variable is: \n";
    say(asIntTest.value);
    nbmPause();
    inherited();
  }
;
showAchResetTo0: AchQuip
  desc = "Reset current value to 0"
  reply {
    asIntTest.setValue(0);
    achievementScopeManager.saveData();
    "<.p>";
    "The new value of the variable is: \n";
    say(asIntTest.value);
    nbmPause();
    inherited();
  }
;

// -------------------------------
// TESTING: Map sections

showMaps: TestingQSub
  desc = "Try displaying maps"
  reply {
    nbmCls();
    "Which map do you want to see? ";
  }
  options = [ 
     showMapSupermaze
    ,showMapAfrica
    ,showMapMexico
    ,showMapAnimals
    ,showMapTwisty
    ,showMapEscape
    ,showMapQuat1
    ,showMapQuat2
    ,showMapNetHacMan
    ,showMapEndgame
    ,showMapPyramid1
    ,showMapPyramid2
    ,showMapMarquez
    ,showMapUntouch
    ,showMapValance
    ,showMapFloor
    ,showMapCompass
    ,backToTestingMenu 
  ]
;


class MapQuip: TestingQuip
  reply {
    showMaps.reply();
  }
  transfer = showMaps
;

// Canonical/accepted ones begin here:

showMapAnimals: MapQuip
  desc = "Animals"
  reply {
    pleaseSay(animalMapPrint());
    writeMapToTextFile(animalMapPrint(), 'map-animalMapPrint.txt');
    nbmPause();
    inherited();
  }
;

showMapPyramid1: MapQuip
  desc = "Pyramid 1"
  reply {
    glob.hackPyramidMap = true;
    pleaseSay(pyramid1MapPrint());
    writeMapToTextFile(pyramid1MapPrint(), 'map-pyramid1MapPrint.txt');
    glob.hackPyramidMap = nil;
    nbmPause();
    inherited();
  }
;
showMapPyramid2: MapQuip
  desc = "Pyramid 2"
  reply {
    glob.hackPyramidMap = true;
    pleaseSay(pyramid2MapPrint());
    writeMapToTextFile(pyramid2MapPrint(), 'map-pyramid2MapPrint.txt');
    glob.hackPyramidMap = nil;
    nbmPause();
    inherited();
  }
;


showMapAfrica: MapQuip
  desc = "Africa"
  reply {
    glob.hackNationMaps = true;
    pleaseSay(africaMapPrint());
    writeMapToTextFile(africaMapPrint(), 'map-africaMapPrint.txt');
    glob.hackNationMaps = nil;
    nbmPause();
    inherited();
  }
;


// Autogenerated-ones follow:


showMapSupermaze: MapQuip
  desc = "Supermaze"
  reply {
    glob.hackSupermazeMap = true;
    pleaseSay(supermazeMapPrint());
    writeMapToTextFile(supermazeMapPrint(), 'map-supermazeMapPrint.txt');
    glob.hackSupermazeMap = nil;
    nbmPause();
    inherited();
  }
;
//showMapAfrica: MapQuip
//  desc = "Africa"
//  reply {
//    pleaseSay(africaMapPrint());
//    nbmPause();
//    inherited();
//  }
//;
showMapMexico: MapQuip
  desc = "Mexico"
  reply {
    glob.hackNationMaps = true;
    pleaseSay(mexicoMapPrint());
    writeMapToTextFile(mexicoMapPrint(), 'map-mexicoMapPrint.txt');
    glob.hackNationMaps = nil;
    nbmPause();
    inherited();
  }
;
//showMapAnimals: MapQuip
//  desc = "Animals"
//  reply {
//    pleaseSay(animalMapPrint());
//    writeMapToTextFile(animalMapPrint(), 'map-animalMapPrint.txt');
//    nbmPause();
//    inherited();
//  }
//;
showMapTwisty: MapQuip
  desc = "Twisty"
  reply {
    pleaseSay(twistyMapPrint());
    writeMapToTextFile(twistyMapPrint(), 'map-twistyMapPrint.txt');
    nbmPause();
    inherited();
  }
;
showMapEscape: MapQuip
  desc = "Escape"
  reply {
    pleaseSay(escapeMapPrint());
    writeMapToTextFile(escapeMapPrint(), 'map-escapeMapPrint.txt');
    nbmPause();
    inherited();
  }
;
showMapQuat1: MapQuip
  desc = "Quat 1"
  reply {
    glob.hackQuat1Map = true;
    pleaseSay(quat1MapPrint());
    writeMapToTextFile(quat1MapPrint(), 'map-quat1MapPrint.txt');
    glob.hackQuat1Map = nil;
    nbmPause();
    inherited();
  }
;
showMapQuat2: MapQuip
  desc = "Quat 2"
  reply {
    glob.hackQuat2Map = true;
    pleaseSay(quat2MapPrint());
    writeMapToTextFile(quat2MapPrint(), 'map-quat2MapPrint.txt');
    glob.hackQuat2Map = nil;
    nbmPause();
    inherited();
  }
;
showMapNetHacMan: MapQuip
  desc = "Net-Hac-Man"
  reply {
    glob.hackHacManMap = true;
    pleaseSay(hacMapPrint());
    writeMapToTextFile(hacMapPrint(), 'map-hacMapPrint.txt');
    glob.hackHacManMap = nil;
    nbmPause();
    inherited();
  }
;
showMapEndgame: MapQuip
  desc = "Endgame"
  reply {
    glob.hackEndgameMap = true;
    pleaseSay(endgameMapPrint());
    writeMapToTextFile(endgameMapPrint(), 'map-endgameMapPrint.txt');
    glob.hackEndgameMap = nil;
    nbmPause();
    inherited();
  }
;
//showMapPyramid1: MapQuip
//  desc = "Pyramid 1"
//  reply {
//    pleaseSay(pyramid1MapPrint());
//    writeMapToTextFile(pyramid1MapPrint(), 'map-pyramid1MapPrint.txt');
//    nbmPause();
//    inherited();
//  }
//;
//showMapPyramid2: MapQuip
//  desc = "Pyramid 2"
//  reply {
//    pleaseSay(pyramid2MapPrint());
//    writeMapToTextFile(pyramid2MapPrint(), 'map-pyramid2MapPrint.txt');
//    nbmPause();
//    inherited();
//  }
//;
showMapMarquez: MapQuip
  desc = "Book maze"
  reply {
    pleaseSay(marquezMapPrint());
    writeMapToTextFile(marquezMapPrint(), 'map-marquezMapPrint.txt');
    nbmPause();
    inherited();
  }
;
showMapUntouch: MapQuip
  desc = "Movie maze (U)"
  reply {
    pleaseSay(untouchMapPrint());
    writeMapToTextFile(untouchMapPrint(), 'map-untouchMapPrint.txt');
    nbmPause();
    inherited();
  }
;
showMapValance: MapQuip
  desc = "Movie maze (V)"
  reply {
    pleaseSay(valanceMapPrint());
    writeMapToTextFile(valanceMapPrint(), 'map-valanceMapPrint.txt');
    nbmPause();
    inherited();
  }
;
showMapFloor: MapQuip
  desc = "Floor"
  reply {
    pleaseSay(floorMapPrint());
    writeMapToTextFile(floorMapPrint(), 'map-floorMapPrint.txt');
    nbmPause();
    inherited();
  }
;
showMapCompass: MapQuip
  desc = "Compass"
  reply {
    pleaseSay(doCompass2(wait));
    writeMapToTextFile(doCompass2(wait), 'map-compassMapPrint.txt');
    nbmPause();
    inherited();
  }
;


function writeMapToTextFile(str, filename) {
  local f = File.openTextFile(filename, FileAccessWrite);
  f.writeFile(str);
  f.closeFile();
}

// -------------------------------
// TESTING: Gameplay sections

showGame: TestingQSub
  desc = "Try playing the multimedia-heavy parts of the gmae"
  reply {
    nbmCls();
    "The most multimedia-heavy parts of the game are probably 
      the ones with the most intensive interactive maps. 
      <.p>
      These include the middle part of the game 
      (after you fall asleep). The middle part consists of what I call 
      the \"supermaze.\" Try wandering around the verious mazes 
      within the supermaze to look at the various interactive maps.
      <.p>
      The most multimedia-intensive section of all is the last 
      maze (the north-central maze within the supermaze). 
      Try that and let me know of any multimedia problems there,
      or anywhere else. ";
    "<.p>";
    "What would you like to do? ";
  }
  options = [
    backToTestingMenu 
  ]
;

//// -------------------------------------------------------------------
//// EXPERIMENTAL CUTSCENE
//// -------------------------------------------------------------------
//
//cutSceneExperiment: ExperimentalCutScene
//  beginScene {
//    say(glob.coffinMsg4);
//  }
//  endScene {
//  }
//  sceneList = [
//    [ 'firstalien.jpg',
//      'Before you stands a creature that is not human. His 
//          skin is green, like that of a lizard or a fish. But 
//          he is dressed in clothing, and his eyes peer at you 
//          with intensity. ' 
//      , nil
//    ]
//  ]
//;
//
//// -------------------------------------------------------------------
//// New CutScene class for experimental cutscene
//// -------------------------------------------------------------------
//
//class ExperimentalCutScene: object
//  // Is transcript file output to be attempted?
//  // Presently only attempt this under Windows, because of reported 
//  // incongruities between HyperTADS and the Windows 'terp.
//  doTfo = (systemInfo(SysInfoOsName).substr(1,3).toUpper == 'WIN')
//  // If transcript file output (TFO) is to be attempted, should 
//  // this be done by means of simply outputting text to the main window?
//  // Presently, yes, do it this way. There seems to be no other way.
//  tfoViaMainWindow = true
//  // A hook for anything that happens before the cut scene
//  beginScene() { }
//  // A hook for anything that happens after the cut scene (and there
//  // is always something).
//  endScene() { }
//  // A hook for an ad-hoc mid-scene method.
//  midScene() { }
//  // Do we prefer to make the banner window disappear by reducing
//  // its width to zero, as opposed to simply removing it?
//  banishBannerViaZeroWidth = nil
//  // Do we prefer to update the status line when we're done with 
//  // our cut-scene? Nearly always, the answer will be yes.
//  updateStatusLineAfterwards = true
//  // To override the default behavior of executing endScene():
//  skipEndScene = nil
//  // The main method.
//  execute {
//    // ----------------
//    // Do initial stuff
//    
//    // First do initial output, etc. before the cut scene begins.
//    beginScene();
//    // Then pause for input.
//    nbmPause();
//    // For the sake of any transcript file, ensure a proper paragraph 
//    // break between the last outputted text and whatever comes next.
//    "<.p>";
//    // Make sure the status line is blank during the cut scene.
//    glob.status = blank;
//    statusLine.showStatusLineDaemon();
//    // If the banner is present, then either remove it or reduce its
//    // width to zero, depending on preference.
//    if (!banishBannerViaZeroWidth)
//      nbmBanner.removeBanner();
//    else
//      nbmBanner.setSize(
//        0, // zero size
//        BannerSizeAbsolute, // or BannerSizePercent
//        nil); // isAdvisory == nil
//    // It so happens that with all three cut scenes, I want a cleared
//    // screen afterwards. Might as well do that now.
//    nbmCls();
//    
//    // ----------------
//    // Attempt transcript file output, if desired
//    
//    // Do the "transcript file output via main window" scenario
//    if (doTfo && tfoViaMainWindow) {
//      // Cover the whole screen with a blank, 100%-size banner.
//      csShout('');
//      // Loop through the list. Output the text to the main window,
//      // thereby ensuring the text goes to the transcript.
//      for (local a=1; a<=sceneList.length(); ++a) {
//        "<<sceneList[a][2]>><.p>";
//      }
//      // Then clear the main window again, since the text just 
//      // outputted is never supposed to be visible in that window.
//      nbmCls();
//    }
//    
//    // ----------------
//    // Do standard on-screen output
//    
//    // Loop through the scene list.
//    for (local a=1; a<=sceneList.length(); ++a) {
//      // If this isn't the first iteration, clear the cut scene banner.
//      if (a != 1)
//        cutSceneBanner.clearWindow();
//      
//      // If the first element isn't nil, display it as an image 
//      // in the banner window.
//      if (sceneList[a][1]) {
//        csDispImg(sceneList[a][1], ''); // 'height=\"100\" width=\"900\"'
//      }
//      // If there is text to output to the banner, output it.
//      if (sceneList[a][2]) {
//        csShout(sceneList[a][2]);
//      }
//      // If the third value is non-nil, it might be either
//      // (1) a single-quoted string (in which case it represents
//      // music to be sent to the main window), or
//      // (2) a function pointer (in which case the function should 
//      // be executed) (this functionality isn't working, though),
//      // (3) the value "true," in which case the midScene()
//      // method should be called.
//      if (sceneList[a][3]) {
//        if (dataType(sceneList[a][3]) == TypeSString) {
//          playSound(sceneList[a][3]);
//        }
//        if (dataType(sceneList[a][3]) == TypeTrue) {
//          midScene();
//        }
//        if (dataType(sceneList[a][3]) == TypeFuncPtr) {
//          (sceneList[a][3])();
//        }
//      }
//      nbmPause();
//    }
//    
//    // ----------------
//    // Do concluding stuff
//    
//    // Remove the cut scene banner
//    cutSceneBanner.removeBanner;
//    // Unless we are in "don't show right-hand banner" mode,
//    // return the status line to its usual state.
//    if (!glob.dontUpdateBanner && updateStatusLineAfterwards) {
//      if (gPlayerChar == bot)
//        glob.status = zork;
//      else
//        glob.status = trinity;
//      statusLine.showStatusLineDaemon();
//    }
//    // Unless we are in "don't show right-hand banner" mode,
//    // try to show the right-hand banner.
//    if (!glob.dontUpdateBanner)
//      nbmBanner.updateMe;
//    // Do concluding output after the cut scene is done.
//    if (!skipEndScene) {
//      endScene();
//    }
//  }
//;
//
//experimentalCutSceneBanner: BannerWindow
//  updateMe(whatToSay) {
//    if (showBanner(nil,      // parent = nil; i.e. the main window.
//          BannerLast,        // where = BannerLast: the main window's last priority.
//          nil,               // other = irrelevant
//          BannerTypeText,    // windowType = BannerTypeText: a regular window
//          BannerAlignBottom, // align = BannerAlignRight
//          100,               // size = 35 times wider than a "0"
//          BannerSizePercent, // sizeUnits = BannerSizeAbsolute: units as wide as a "0"
//          (hasVerticalScroll 
//            ? BannerStyleVScroll | BannerStyleTabAlign 
//            : BannerStyleTabAlign)
//          ))
//    {
//      //clearWindow();
//      if (glob.changeFont)   writeToBanner('<.nbmfont>');
//      if (glob.changeColors) writeToBanner('<.nbmcolors>');
//      writeToBanner(whatToSay);
//    }
//  }
//  hasVerticalScroll = nil
//;



