/* Copyright (c) 1998 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  plantmt.t - Mr. Teeterwaller
Function
  
Notes
  
Modified
  07/25/98 MJRoberts  - Creation
*/

teeterwaller_slacks: item
    isListed = nil
    location = teeterwaller
    sdesc = "slacks"
    isThem = true
    noun = 'slacks' 
    adjective = 'mr' 'mr.' 'teeterwaller\'s'
    noun = 'pants' 'slacks' 'trousers' 'brown' 'pockets'
    ldesc = "The slacks are dull brown. "
    isworn = true
    verDoSearch(actor) =
    {
        "<q>Hey!</q> Teeterwaller protests, moving away from you. ";
    }
    doSynonym('Search') = 'Lookin'
;

teeterwaller_shirt: item
    isListed = nil
    location = teeterwaller
    sdesc = "beige shirt"
    adjective = 'mr' 'mr.' 'teeterwaller\'s' 'beige' 'plain' 'dress'
    noun = 'shirt'
    ldesc = "It's a plain beige dress shirt. "
    isworn = true
;

teeterwaller_tie: item
    isListed = nil
    location = teeterwaller
    adjective = 'mr' 'mr.' 'teeterwaller\'s' 'striped' 'brown'
    noun = 'tie'
    sdesc = "tie"
    ldesc = "It's a medium-width tie with brown stripes. "
    isworn = true
;

teeterwaller_mustache: fixeditem
    location = teeterwaller
    adjective = 'mr' 'mr.' 'teeterwaller\'s'
    noun = 'mustache' 'mustache'
    sdesc = "mustache"
    ldesc = "Teeterwaller's mustache is a little darker than his hair.
             He keeps it neatly trimmed. "
;

teeterwaller: Actor
    location = inCar
    sdesc = "Mr.\ Teeterwaller"
    adesc = { self.sdesc; }
    thedesc = { self.sdesc; }
    noun = 'teeterwaller' 'boss' 'himself'
    adjective = 'mr.' 'mr'
    myfollower = teeterwaller_follower
    isHim = true
    hintedAboutPipe = nil
    actorDesc =
    {
        "Your boss Mr.\ Teeterwaller is here. ";
    }
    ldesc =
    {
        "He's about five-foot-six, with graying black hair
        that he keeps cut in a short business-like style, and
        a neatly trimmed mustache. ";
        "He's wearing a dull brown slacks that are part of
        a suit (although he's not currently wearing the jacket),
        a beige shirt and a brown striped tie. ";

        if (itemcnt(teeterwaller.contents) != 0)
        {
            "He's carrying <<listcont(teeterwaller)>>. ";
            listcontcont(teeterwaller);
        }
    }
    verDoSearch(actor) =
    {
        "<q>Hey!</q> he protests, moving away from you. ";
    }
    doSynonym('Search') = 'Lookin'
    actorAction(v, d, p, i) =
    {
        /* special responses when in the vent outside the holding cell */
        if (self.isInCellVent)
        {
            "<q>We don't have time for that now.</q> ";
            exit;
        }
        
        if (v.isTravelVerb)
        {
            "<q>I'd rather we keep together for now.</q> ";
            exit;
        }
        
        switch(v)
        {
        case noVerb:
        case yesVerb:
        case helloVerb:
            break;

        case wearVerb:
            if (d = teeterwallerJacket)
                "<q>I'm more comfortable without it right now, and I
                don't want to get it wrinkled before our meeting
                tomorrow.</q> ";
            else
                "<q>I'm comfortable with what I'm already wearing.</q> ";
            exit;

        default:
            switch(rand(4))
            {
            case 1:
                "<q>I <i>could</i> do that for you, but I wouldn't be a very
                good manager if I did.  As your manager, I'm here
                to empower you to pro-actively take the initiative and
                demonstrate personal leadership,</q> he recites from some
                faddish management book he's read recently.";
                break;

            case 2:
                "<q>Hey, who's the boss here?</q> ";
                break;

            case 3:
                "He seems too lost in thought. ";
                break;

            case 4:
                "<q>I'm not sure that's the right course of action
                for me right now.</q> ";
                break;
            }
            exit;
        }
    }
    ioSynonym('GiveTo') = 'ShowTo'
    ioGiveTo(actor, dobj) =
    {
        switch(dobj)
        {
        case teeterwallerJacket:
            "<q>No, thanks, I'm more comfortable without it right now,
            and I don't want to get it wrinkled before our meeting
            tomorrow.</q> ";
            break;

        case map:
            map.doInspect(actor);
            break;

        case tycheSpec:
            self.askWord('tyche', [tycheSpec]);
            break;

        case lab7_disk:
            "<q>Why don't you hang on to that for now,</q> he says. ";
            break;

        case newerGasMask:
        case olderGasMask:
        case yellowHardhat:
        case whiteHardhat:
            if (dobj.otherOne.isIn(self))
                "<q>I already have this one,</q> he says, pointing
                to <<dobj.otherOne.thedesc>>. ";
            else
            {
                "<q>Thanks,</q> he says, accepting it. ";
                dobj.moveInto(self);
            }
            break;

        default:
            "<q>I don't need that right now.</q> ";
            break;
        }
    }
    disavow =
    {
        local msg :=
            [
                '<q>I don\'t know much about that.</q> '
                '<q>I don\'t really know.</q> '
                '<q>You probably know as much as I do.</q> '
                'Teeterwaller just shrugs. '
            ];

        /* 
         *   pick a random message, to make things less repetitive when
         *   asked about multiple unknown topics 
         */
        say(msg[rand(length(msg))]);
    }
    askWord(word, lst) =
    {
        switch(substr(word, 1, 6))
        {
        case 'me':
        case 'myself':
            "<q>This probably isn't the best time for a performance
            review,</q> he says. ";
            return true;
                
        case 'himsel':
        case 'teeter':
        case 'boss':
            "<q>I don't think this is the best time for us to get to
            know each other better,</q> he says, a little impatiently. ";
            return true;

        case 'map':
            if (map.isIn(self.location) || map.isIn(parserGetMe()))
                map.doInspect(parserGetMe());
            else
                "<q>A map could definitely be helpful right now.</q> ";
            return true;
            
        case 'car':
        case 'piglet':
        case 'toyunc':
            "<q>It's always been very reliable,</q> he says defensively.
            <q>I know people make all sorts of jokes about what a terrible
            car it is, but I've had very good luck with it.</q> ";
            return true;

        case 'punch':
        case '335':
        case 'keyboa':
        case 'typewr':
            "You know from past experience not to ask Mr.\ Teeterwaller
            about his part in the history of computing. ";
            return true;

        case 'briefc':
        case 'file':
        case 'files':
        case 'drawer':
            if (self.isIn(recordsRoom) || briefcase.isIn(self))
            {
                "<q>I've been trying to find this sort of information
                for years, but all I've been able to find before are
                bits and pieces.</q> ";
                return true;
            }
            else
                return nil;

        case 'cargo':
        case 'radiat':
        case 'radioa':
        case 'truck':
        case 'trucks':
        case 'crate':
            if (narrowPassage_space.isseen)
            {
                "<q>Believe me, I wish I knew.</q> ";
                return true;
            }
            else
                return nil;

        case 'omegat':
        case 'compan':
            "<q>I've worked at Omegatron too long, I think, because
            I can't think of anything interesting to tell you.</q> ";
            return true;

        case 'journa':
        case 'magazi':
        case 'dufon':
            "<q>Oh, that,</q> he says, looking a bit embarrassed.
            <q>It's just a hobby of mine.</q> ";
            return true;

        case 'ufo':
        case 'ufos':
            "<q>I've never seen one,</q> he says. ";
            return true;

        case 'deck':
            "<q>Those were the days,</q> he says, going into a reverie.
            <q>Now <i>that</i> was <i>real</i> programming.</q> ";
            return true;

        case 'tyche':
        case 'spec':
        case 'specif':
        case 'projec':
        case 'manual':
            if (tycheSpec.isExtraInfoKnown)
            {
                "<q>Well, now I know what happened to this missing
                section of the specification document, and I know
                that those magical logic chips were just as out-of-place
                as they seemed.</q> ";
            }
            else
            {
                "<q>I worked on that project, oh, twenty-five years ago or
                so. We were building an embedded controller system
                for some industrial
                equipment; it would be quite routine today, but it had some
                amazing technology for those days.  There were a couple
                of parts in particular, some logic chips, that seemed to come
                out of nowhere... without them the project would have been
                nearly impossible.  I got a copy of the old specification
                document from the corporate archives people a couple of
                months ago,
                because I wanted to figure out the history of those logic
                chips, but for some reason that section of the spec is
                missing.</q> ";
            }

            tycheSpec.isAskedAbout := true;
            return true;

        case 'millto':
        case 'conner':
        case 'knight':
            "<q>I've driven through a few times, but I don't know
            much about it.</q> ";
            return true;

        case 'logic':
        case 'chip':
        case 'chips':
            if (tycheSpec.isAskedAbout)
            {
                "<q>The Tyche logic chips were much faster and smaller
                than anything we had at the time.  It was at least ten
                years before I saw equivalent chips anywhere else.</q> ";
                return true;
            }
            else
                return nil;

        case 'disk':
            if (lab7_disk.location != nil)
            {
                "<q>Good question.</q> ";
                return true;
            }
            else
                return nil;

        case 'plant':
        case 'comple':
        case 'factor':
            if (plantHill.sceneSeen)
                "<q>I'd like to find out more about it.</q> ";
            else if (roadAtPlant.isseen)
                "<q>All I can tell is that it looks like a chemical
                plant.</q> ";
            else
                "<q>I don't know much about it.</q> ";
            return true;

        case 'pipe':
        case 'rusty':
            if (self.hintedAboutPipe
                && canalInPlant_rustyPipeSomething.isIn(
                   canalInPlant_rustyPipe))
            {
                "<q>Maybe we could flush the object out, if we could
                get some water up into the pipe somehow.</q> ";
                return true;
            }
            return nil;

        case 'blottn':
            "<q>I went there on a business trip once,</q> he says. <q>That
            was years ago, back when they had a government.  It was
            a little scary&mdash;they had undercover
            police following us around everywhere, and you could
            hear them listening in on the phone.  I wouldn't want
            to go back.</q> ";
            return true;

        case 'pocket':
            "You ask Teeterwaller why he keeps searching his pockets.
            He looks confused for a moment. <q>Sorry. That's just a nervous
            habit, I guess.</q> ";
            return true;

        case 'shadow':
            "<q>I love <q>Shadow Man</q>!  The last episode was
            great.  NSA agents were chasing Renault, because he
            uncovered a mind control experiment using military
            satellites three episodes ago and was going to
            upload the plans to the internet.  The NSA agents
            had him cornered in this big creepy lab in the basement
            of the Pentagon, and they were closing in on him, but
            then he got a call on his cell phone from Heinrich&mdash;he's
            the ex-Air Force guy that Renault broke out of jail early
            last season, only he turned out to have shady
            CIA connections in the season opener this year, and somehow
            knew all about Operation Yellow Hue, so we don't really know
            whose side he's on any more.  Anyway, he called and just said
            one word, <q>Ambidextrous.</q>  That was really chilling, of
            course, because <q>ambidextrous</q> was the code name for
            these brainwashing drug experiments that the Army did in the
            50's, which is one of the long-running conspiracy threads
            in the show.  Renault suddenly realized where he was,
            which was right in the middle of the Ambidextrous morgue.
            The camera pulled back and you saw all of these stacks of
            mummified bodies on shelves stacked up shelf after shelf,
            fifty feet high, and then the picture faded out and the
            words <q>to be continued</q> appeared.
            I don't know how he's going to get out
            of this one.  Great show.</q> ";
            return true;

        case 'gossip':
            "<q>There's too much gossip around the office,</q> he
            says. <q>For example, Simmons over in HR was telling me
            that Dunman is trying to annex the Bizmark marketing group.
            Can you believe it? What an empire builder. Anyway, there's
            too much gossip, if you ask me.</q> ";
            return true;

        default:
            return nil;
        }
    }
    doAskAbout(actor, iobj) =
    {
        /* special handling in the cell vent */
        if (self.isInCellVent)
        {
            "<q>We don't have time to talk about that right now.</q> ";
            return;
        }
        
        /* check for any special objects we know about */
        switch(iobj)
        {
        case teeterwallerJacket:
            "<q>I've had that jacket many years.</q> ";
            return;

        case warehouse_machines:
            self.askWord('335', [iobj]);
            return;

        case garageOpener:
            "<q>That isn't mine. The previous owner left it in the car.
            As it was an estate sale, I wasn't able to return it.  I
            suppose it's just cluttering up the glovebox, but I never
            seem to be able to throw anything away.</q> ";
            return;

        case doggy:
            if (!doggy.isGuarding)
                "<q>He seems friendly enough.</q> ";
            else if (doggy.hasSaidAus)
                "<q>Well, my German theory didn't help.</q> ";
            else if (doggy.teeterNoted || doggy.isIn(self.location))
            {
                "<q>I saw a television program that said they usually
                train guard dogs using German words.  They usually
                call off an attack by saying <q>aus.</q></q> ";

                doggy.teeterNoted := true;
            }
            else
                "<q>I don't know much about dogs.</q> ";
            return;
        }
        
        /* we didn't find anything special; use the default behavior */
        inherited.doAskAbout(actor, iobj);
    }
    doHello =
    {
        "<q>Good to see you,</q> he says. ";
    }
    actorDaemon =
    {
        /* follow the player if necessary */
        if (self.didPreFollow && self.location != parserGetMe().location)
        {
            self.travelTo(parserGetMe().location);
            self.didPreFollow := nil;
        }
        else
        {
            /* call the room and do my idle action */
            if (self.location != nil && parserGetMe().isIn(self.location))
                self.location.teeterIdleAction;
        }
    }
    isFollowingMe = true
    sayArriving =
    {
        /* 
         *   don't say anything if I'm following the player, because the
         *   player's travelTo routine will provide this information 
         */
        if (!self.isFollowingMe)
            inherited.sayLeaving;
    }
    preFollowMe(meObj, rm) =
    {
        /* 
         *   if I'm following along with the player, tell the room to
         *   announce this fact 
         */
        if (self.checkFollowMe(meObj, rm))
        {
            meObj.location.teeterwallerPreFollow(rm);
            self.didPreFollow := true;
        }
        else
            self.didPreFollow := nil;
    }
    postFollowMe(meObj, rm) =
    {
        /*
         *   if I'm following along with the player, tell the new room
         *   that we just followed the player here 
         */
        if (self.didPreFollow)
            rm.teeterwallerPostFollow;
    }
    checkFollowMe(meObj, rm) =
    {
        /* 
         *   I'll follow from here if I'm set to follow and I'm in the
         *   same location as the player character 
         */
        return (self.isFollowingMe && meObj.location = self.location
                && self.location.teeterCanFollow(rm));
    }
    verDoTurnon(actor) =
    {
        "Better not; you wouldn't want to risk a sexual harassment
        lawsuit. ";
    }
    verDoAttack(actor) = { }
    doAttack(actor) =
    {
        "That would not look good on your performance review. ";
    }
    verDoAttackWith(actor, iobj) = { }
    doAttackWith(actor, iobj) = { self.doAttack(actor); }

    isInCellVent = nil
    validActor =
    {
        /*
         *   If I'm in the air vent near the holding cell, and the player
         *   is in the holding cell, make me accessible for talking. 
         */
        if (self.isInCellVent)
            return true;
        else
            return inherited.validActor;
    }
    askingGivingUp = nil
    answerYes =
    {
        parserGetMe().conversingWith := nil;

        if (self.askingGivingUp)
        {
            "<q>Are you sure?</q> Teeterwaller asks.  You tell him that
            you don't think it's a good idea to go any further, that it's
            just too dangerous.  He pleads with you for a while, then
            finally gives up.
            \bThe two of you sit in the car in silence.  Lightning
            flashes in the sky every so often.  You close your eyes.
            \bYou wake up to sunlight on the eastern horizon, not
            realizing you fell asleep.  Cars start zooming past in the
            damp morning air.  You see Teeterwaller out on the highway,
            flagging down a tow truck.
            \bYou make it home later that day, a little tired and sore
            from sleeping in the car but otherwise fine.
            \bIn the weeks
            and months that follow, you sometimes think back to the
            bizarre events that night, but for some reason you and
            Teeterwaller never discuss it again.
            \b*** Your life has returned to normal.\ ***\b";

            incscore(5, 'making it back home');
            exitOptions(true);

            self.askingGivingUp := nil;
            abort;
        }
        else
            inherited.answerYes;
    }
    answerNo =
    {
        parserGetMe().conversingWith := nil;

        if (self.askingGivingUp)
        {
            "<q>That's a relief,</q> Teeterwaller says. <q>I really
            appreciate your help.</q> ";
            self.askingGivingUp := nil;
        }
        else
            inherited.answerNo;
    }
    converseAction(verb, dobj, prep, iobj) =
    {
        if (!verb.issysverb && verb != yesVerb && verb != noVerb)
        {
            "Mr.\ Teeterwaller is waiting for an answer. ";
            exit;
        }
    }
;

/*
 *   An object for some words that exist only as concepts to ask
 *   teeterwaller about.  We'll distinguish the actual text of the word in
 *   doAskAbout, so we'll lump all of these words into a single object.  
 */
teeterwaller_concepts: item
    noun = 'radiation' 'omegatron' 'company' 'cargo' 'chip' 'chips'
           'milltown' 'knighting' 'city' 'project' 'tyche'
           'blottnya' 'man' 'gossip' 'ufo' 'ufos'
    adjective = 'radioactive' 'logic' 'milltown' 'conners' 'tyche' 'project'
                'shadow' 'office'
;


teeterwaller_follower: follower
    sdesc = "Mr.\ Teeterwaller"
    adesc = { self.sdesc; }
    thedesc = { self.sdesc; }
    noun = 'teeterwaller' 'boss'
    adjective = 'mr.' 'mr'
    myactor = teeterwaller
;

/*
 *   Modify the basic room object so that it can display a message when
 *   Teeterwaller is staying with the player during travel.  Individual
 *   rooms can override teeterwallerPre/PostFollow to display custom
 *   messages.  
 */
modify room
    teeterwallerSeen = nil
    teeterCanFollow(destRoom) =
    {
        /* 
         *   by default, we'll allow teeterwaller to follow us to the
         *   given destination; certain rooms may want to override this to
         *   prevent him from following to certain destinations or under
         *   certain circumstances 
         */
        return true;
    }
    teeterwallerPreFollow(rm) =
    {
        "Mr.\ Teeterwaller comes with you.\b";
    }
    teeterwallerPostFollow =
    {
        /* note that I've seen this room now */
        self.teeterwallerSeen := true;
    }

    /*
     *   If a room wants to customize the random messages that
     *   teeterwaller issues when present, just override this list with an
     *   alternative set of messages.  These should be suitably random for
     *   most locations; some locations will want something more specific,
     *   however. 
     */
    teeterRandomMsg =
    [
        'Mr.\ Teeterwaller mumbles something to himself. '
        'Teeterwaller looks around purposefully. '
        'Mr.\ Teeterwaller seems to be lost in thought. '
        'Teeterwaller looks through his pockets for something. '
        'Mr.\ Teeterwaller watches you expectantly. '
        'Mr.\ Teeterwaller looks around. '
    ]

    /*
     *   These are some more messages, but these are handed out
     *   sequentially rather than randomly, so that they only appear once. 
     */
    teeterSeqMsgNum = 1
    teeterSeqMsg =
    [
        'Mr.\ Teeterwaller starts telling you some office gossip,
        but stops, a little disappointed, when he realizes you don\'t
        know the people involved in the embarrassing parts. '

        'Teeterwaller tells you about the latest episode of his
        favorite TV show, <q>Shadow Man.</q>  You never liked the
        show very much&mdash;too much silly conspiracy theory
        stuff&mdash;but you listen politely. '
    ]

    /* 
     *   This is called each turn that teeterwaller and the player are in
     *   the same room, except right after the player moved to a new room
     *   (we skip it in this case to avoid too many teeterwaller
     *   messages).  
     */
    teeterIdleAction =
    {
        /* if the player is here, generate a random message */
        if (parserGetMe().isIn(self))
        {
            /* only say something every so often */
            if (rand(100) > 40)
            {
                "\b";
                say(self.teeterRandomMsg[rand(length(self.teeterRandomMsg))]);
            }
            else if (rand(100) > 80
                     && self.teeterSeqMsgNum <= length(self.teeterSeqMsg))
            {
                "\b";
                say(self.teeterSeqMsg[self.teeterSeqMsgNum++]);
            }
        }
    }
;

