/* Copyright (c) 1998 by Michael J. Roberts.  All Rights Reserved. */
/*
Name
  plantse.t - The Plant - Special Edition features
Function
  
Notes
  
Modified
  11/20/98 MJRoberts  - Creation
*/


/*
 *   deleted scene - Major Bennett 
 */
deletedScene1: function
{
    "\b<hr>
    \b<i>(One of the biggest changes that I made after starting work on
    the game was adding Mr.\ Teeterwaller.  Originally, the player was
    going to be alone.  I decided very early on that I wanted the player
    to have a companion who had an inkling (or at least a suspicion) of
    what might be going on inside the plant, but the original design
    lacked this element.
    \b(Without Mr.\ Teeterwaller, the player needed some sort of motivation
    to break into the plant.  The hijacking scene certainly made it clear
    that something mysterious was going on, but it didn't by itself give
    the player any reason to become involved.  To provide this motivation,
    the original design had a minor character named Major Bennett, who
    shows up just after the hijacking.
    \b
    (The hijacking started off pretty much the same as it does in the
    final game.  After the bulldozers started clearing wreckage, though,
    Major Bennett shows up...)
    \b</i>";
    
    "\bThe trucks that are still intact start moving into the
    plant, one by one, as the bulldozers clear a path through
    the wreckage.

    \bYou hear a rustling sound behind you.  You turn to look,
    and hear a woman's voice yell <q>Freeze!</q>  You're so
    rattled by what you've just seen that you practically jump
    over the fence with fright.  You quickly raise your hands.
    Someone approaches behind you and pats you down for weapons,
    then withdraws.

    \b<q>Turn around, slowly,</q> the voice says.
    
    \bYou turn around&mdash;like she said, slowly&mdash;and see
    a woman in an army uniform pointing a pistol at you.
    Her uniform looks like an officer's, which is quickly
    confirmed when you see that her nameplate reads
    MAJ.\ BENNETT&mdash;a major.  Her eyes do not blink as she
    watches you, and her expression is fierce.
            
    \b<q>Who the hell are you?</q> she asks.  <q>Are you part
    of this operation?</q> ";

    "\b&gt;yes";

    "\nShe almost laughs. <q>I doubt it,</q> she says dismissively. ";
    "She seems to relax a little, having decided you're not a threat.
    <q>Okay, so who are you?</q>

    \bYou explain about your car trouble, that you're here purely
    by accident and bad timing.
    
    \bThe major nods. <q>It may be bad timing for you, but you may
    be the first bit of good luck I've had today.</q>  She lowers her
    gun, then suddenly loses her balance, just managing to grab the
    fence for support.  You notice for the first time that her left
    leg is wet&mdash;with blood, you realize.  The major slowly
    lowers herself to the ground, her left leg out straight in front
    of her.

    \b<q>As you can probably see, I've been shot,</q> she says.
    <q>I'm not going anywhere in this condition. From the way I
    feel I doubt I'll even be conscious much longer.  I don't
    suppose you're a doctor?</q> she asks; you can't tell if
    she's being sarcastic. ";

    "\b&gt;no\n";

    "<q>There's not much you could have done anyway,</q> she
    says. ";
    "\b<q>I'd better at least try to stop this bleeding.</q>
    She laboriously takes off her belt, leans forward, wraps it
    around her leg above the wound and pulls the belt tight.

    \bShe leans back against the fence.  She looks exhausted.
    <q>I need your help,</q> she says, visibly fighting to stay
    awake.  <q>Those trucks out there were transporting...</q>
    She stops and coughs painfully.  <q>I can't tell you what's
    in those trucks, but you have to understand.  If it falls
    into the wrong hands, the consequences would be unthinkable.
    I don't know who the hell these people are, but someone has
    to stop them.</q>  Her voice drops almost to a whisper.
    <q>Look, I know you're just an innocent bystander, but
    you're the only one who can stop them now.</q>
    
    \bWith that, the major slips into unconsciousness, her head
    falling to her chest and her body going limp. ";

    "\b<i>(The scene concludes pretty much as in the final game.)</i>
    \b";
}

/*
 *   deleted scene - the crate and the force-field 
 */
deletedScene2: function
{
    "\b<hr>
    \b<i>(In the first scene involving opening the crate from the truck,
    when you're viewing events through the vent opening in the air duct,
    there was originally going to be a force field erected around the
    crate.  This was meant to make it more obvious that this was no
    ordinary crate.)</i>";

    "\b
    This aluminum air duct is just large enough to crawl through here,
    but splits into several smaller ducts to the west, none of which
    are large enough to permit further passage.  The duct widens
    to the east. 
    A vent cover, two feet on a side, is over an opening
    in the floor. ";

    "\b&gt;look in opening";
    "\n
    A cavernous space the size of an airplane hangar is
    visible through the opening.  The floor is a hundred feet
    below.  Equipment of all kinds is scattered throughout the
    room: forklifts, generators, machines connected by thick
    electrical cables running across the floor, welding torches
    with their gas tanks, rolling racks of power tools, portable
    arc lights.
    \bIn the center of the room is a rectangular
    area marked with a yellow border painted on the floor,
    clear of any equipment.
    \bSeveral workers, dressed in isolation suits and gas masks,
    are standing just outside the yellow border. ";

    "\bA forklift comes into view and moves toward the center
    of the floor below, beeping as it slowly carries a silver
    crate the size of a small car across the room.  The forklift
    drives into the yellow rectangle and gently sets the crate
    down in the center.  The forklift backs out and heads out
    of view.
    \bThe workers, still standing just outside the yellow border,
    turn around and face away from the crate.  Suddenly, a flash
    of white light, like a reflection of the
    sun in a mirror, bursts from the yellow border, and a
    moment later you hear a small thunderclap.  The afterimage
    takes several seconds to fade from your eyes; once you can
    see clearly again, you notice that the air around and above
    the yellow rectangular area is shimmering slightly and has
    a slight blue glow. ";

    "\b&gt;wait";
    "\nTime passes...";
    "\bThrough the opening in the floor, you see the workers
    move to different pieces of equipment, setting dials and
    switches.  After each worker has checked several pieces
    of equipment, they gather together; they look like they're
    talking among themselves but you can't hear what they're
    saying.
    \bThe workers seem to conclude their conversation.  They
    take off their gas masks, then head to a corner of the
    room and disappear from sight. ";

    "\b<i>(The force field was to have played a part later in the
    game as well.  The observation room was actually going to be
    a control room, which would have let you turn off the force field,
    which would in turn would have sent the workers running for cover.
    Once the force field had been lowered, of course, you'd have
    needed an isolation suit of your own to enter the lab.  I removed
    all of this partially because the game was getting to be long enough
    without additional puzzles involving the force field and isolation
    suit, but mostly because it would have robbed the end of the game of
    its momentum.)</i>\b";
}

/*
 *   deleted scene - captured 
 */
deletedScene3: function
{
    "\b<hr>
    \b<i>(The end of the game was originally going to be rather different
    from the way it finally turned out.  After you'd seen enough&mdash;the
    records room and the lab in particular&mdash;the end-game was to
    begin with your capture.)</i> ";
    
    "\bA large group of armed guards appears out of nowhere.  Before you
    realize what's happening, several of the guards wrestle you to
    the ground and handcuff your hands behind your back.
    \b<q>X-Ray five, we've apprehended the subject,</q> you hear someone
    say.  An unintelligible voice from a walkie-talkie replies.
    \bThe guards pull you to your feet.  You look around and realize that
    Teeterwaller has disappeared; you're not sure if the guards have
    already taken him away separately or if he somehow evaded them.
    \bThe guards escort you through a series of passages that you haven't
    seen before, leading you deeper and deeper underground.  Finally,
    you arrive at a small cell; a guard removes your handcuffs, then
    locks the door, leaving you alone.\b";

    "Cell
    \n\tThis is a small room, about eight feet by eight feet; the
    single exit is a heavy steel door to the south, locked from
    the outside.  Against one wall is an air vent; the only
    other feature is an air vent in the ceiling. ";

    "\b<i>(A few turns would elapse, allowing you to explore your
    surroundings, although there wasn't much you could do at this
    point.)</i> ";

    "\bYou hear a scraping sound coming from the air vent. ";
    "\b&gt;wait
    \nTime passes...";
    
    "\bA whisper comes from the air vent. <q>Hello, is
    that you?</q> You realize it's Mr.\ Teeterwaller! ";

    "\b&gt;teeterwaller, hello";
    "\n<q>We don't have time for that now.</q> ";

    "\b<q>I'm going to find a way to get you out of here,</q>
    Teeterwaller whispers from the air vent. ";

    "\b&gt;open air vent
    \nNot surprisingly, the builder didn't use the kind of
    air vent cover you can open.

    \bThe cell door opens.  A guard enters and motions for
    you to follow.  You glance up at the vent, then follow
    the guard.
    \bFive guards escort you down the hall and into an
    elevator, which climbs several floors.  You emerge into
    a plushly furnished room that looks like a country club
    lounge: big leather chairs, portraits on the wall, a
    brick fireplace with smoldering logs.  The guards lead
    you across the room and through some doors, down a wide
    hallway, and into a darkened room; all of the guards but
    one remain outside.
    \bThe guard leads you to a chair sitting in a pool of
    light at the end of a mahogany table.  You sit, and
    the guard stands behind you. ";

    "\b<i>(You'd receive essentially the same lecture from the
    gray-haired man at this point as in the final end-game
    sequence.  Eventually, Teeterwaller would have shown up to
    rescue you, and you'd make your daring escape.
    \b(I saw quickly that this approach wasn't going to work.
    The obvious problem was that the gray-haired man simply had
    no good reason to lecture or cajole you, since you had essentially
    nothing that he might want.  If you'd already stolen the disk,
    the guards simply would have taken it when they captured you.
    Teeterwaller might have slipped away with it, but that wouldn't
    leave you with any bargaining power.  This was basically going to
    be a James Bond end-game, with the evil genius revealing his master
    plan as the laser beam slowly closes in on Bond, who's strapped to
    a table.  The device is tired in movies but worse in IF, because of
    the momentum-destroying effects of a puzzle.
    \b(So, I rearranged the end-game to eliminate the capture, replacing
    it with an extended chase, leaving the player with a degree of freedom
    in the final showdown.)</i>\b";
}

/*
 *   Deleted Scenes menu 
 */
deletedScenesMenu: function
{
    local done;
    
    "\b<hr><b>Deleted Scenes</b>
    \bAs probably happens in the course of any software project,
    a number of details of the game's original design changed in the
    course of implementation, when I found that some elements weren't
    working.  I've made transcripts of some of the biggest changes, along
    with some notes on why I didn't keep the original versions. ";

    for (done := nil ; !done ; )
    {
        "\b<i>Deleted Scenes Menu</i>
        \b\t1. <a href='1'>Major Bennett</a>
        \n\t2. <a href='2'>The crate and the force-field</a>
        \n\t3. <a href='3'>Captured</a>
        \n\t4. <a href='4'>Return to the Special Features menu</a>
        \bPlease enter the number of your choice:\ ";

        switch(cvtnum(input()))
        {
        case 1:
            deletedScene1();
            break;

        case 2:
            deletedScene2();
            break;

        case 3:
            deletedScene3();
            break;

        case 4:
            done := true;
            break;

        default:
            "\bSorry, that's not on the menu. Please enter the
            number of your selection from the list. ";
            break;
        }
    }
}

/*
 *   Authors Notes 
 */
authorsNotes: function
{
    "\b<hr>

    <h3>Author's Notes</h3>

    \b<b>Are we in Blottnya yet?</b>
    \bSome people who played the Competition Edition wondered whether
    the game was meant to take place in Blottnya.  There's so much
    Blottnian stuff lying around (Teeterwaller's car, the dog, the article
    in the Dufon journal, the language textbook), especially in the areas
    outside the plant complex, that it may seem that the
    setting is Blottnya.  If you made this assumption, you probably found
    it jarring near the end of the game when the gray-haired man says a
    few things that strongly imply that the setting is really the
    United States (he mentions Arizona and Illinois, for example).
    \bAll of the Blottnian references were really just a motif, and
    weren't meant to imply that the story was set in Blottnya.  In fact, to
    me the language textbook suggests that we're <i>not</i> in Blottnya,
    since it teaches Blottnian as a foreign language to speakers of
    English.
    \bIn this revised edition, I've tried to make it more obvious from
    the start that we're not in Blottnya.  For example, if you ask
    Teeterwaller about Blottnya, he'll tell you that he traveled there
    years ago and doesn't want to go back; Teeterwaller also points out
    while you're reading the textbook that he's never heard of anyone
    <q>in this country</q> studying Blottnian. ";

    "\b<b>What happened to the hostages?</b>
    \bThe fate of the guards from the hijacked trucks is a detail that
    never made it into the final game, mostly for lack of time before
    the competition.  My plan was to include a seminar room where the
    guards from the trucks were watching a presentation on the many
    reasons to switch employers and join the company that owns the
    plant&mdash;great health insurance benefits, a generous relocation
    allowance, career advancement potential, and a very competitive
    compensation package.
    \bI always wonder, when I'm watching something like a Bond movie,
    how these vast criminal enterprises always manage to attract and
    retain such a large army of generic henchmen, especially when the
    evil genius running the show is always giving negative performance
    feedback to underperforming lieutenants by opening the trap door
    or feeding them to the sharks.  I mean, where's the incentive to
    come into work in the morning?
    \bSo, the seminar room was supposed to show that the plant's owners
    were a new kind of criminal enterprise, an enlightened, 90's kind of
    conspiracy that recognizes that its employees are its most important
    asset and emphasizes teamwork and coaching over sharks and trap doors.
    But, it wasn't integral to the story, so in the end it fell off
    the list. ";

    "\b<b>Would the decoy trucks really work?</b>
    \bOriginally, the decoy trucks were never meant to reach their
    destination.  In my early plans for the game, soon after entering
    the plant, you'd come across a television (in a guard house)
    showing coverage of the aftermath of a horrible train wreck that,
    of course, involved the decoy truck convoy.  The idea was that
    the trucks would be destroyed in a huge flaming wreck, which would
    damage everything so badly that the government would never know
    that the materials had been stolen.
    \bAs with the recruiting seminar, this detail didn't seem important
    enough to build a whole scene around it, so the matter of the decoys
    was handled in the gray-haired man's speech,
    when he says that the government scientists wouldn't be smart enough
    to detect the deception.
    \bThis doesn't address the question of whether the original guards
    would be missed (which wasn't as issue with the train wreck, since
    everyone would have been presumed killed).  However, one can imagine
    that the people on the receiving end of the shipment didn't know the
    guards or the drivers personally, so henchmen posing as the guards
    should have fooled the recipients.  Given the apparent resources
    of the conspirators, a little bureaucratic tampering should be
    sufficient to paper over any remaining questions about where all
    of the guards went after delivering the goods. ";
    
    "\b<b>What did Teeterwaller know and when did he know it?</b>
    \bA few people have asked whether Teeterwaller knew what he was
    getting you into; it has even been suggested that Teeterwaller
    planned the automobile breakdown so that he'd be at the right
    place at the right time.
    \bIt's clear toward the end of the story that Teeterwaller knows more
    than he's letting on.  The first real sign of this, I think, is his lack
    of surprise when you realize that the truck cargo is radioactive, but
    he's especially blatant in the records room (<q>I've been looking for
    this type of information for <i>years</i></q>).
    \bPersonally, my theory is that Teeterwaller was just incredibly
    lucky, and that chance favored his prepared mind, which was obviously
    full of conspiracy theories and UFO trivia to start with.  However,
    he <i>is</i> suspiciously eager to find out what's going on, and his
    talk of a <q>big reward</q> is pretty unconvincing motivation.
    (So unconvincing, in fact, that I've changed that detail in this
    revised edition.  He's now straightforward about being driven by
    curiosity, and doesn't try the <q>reward</q> ploy, but instead
    simply asks for your help.) ";

    "\b<b>A Witness to History</b>
    \bOne of the techniques that I used throughout this game was
    multi-turn cut scenes.  In some games, major plot events
    are related in single, large blocks of text, often called
    <q>cut scenes</q> (a term borrowed from graphical games, which
    use it to refer to non-interactive sequences of animation, essentially
    little movies, that fill in plot and provide transitions between
    game sections).  <i>The Plant</i> uses a similar technique, but
    I broke up most of these into series of scenes spread out over
    several turns.  In most cases, you're viewing the events from a
    distance, and can't do much except watch and wait.
    \bAs the author it's always hard to perceive the exact effect that
    players will, but I have mixed feelings about the technique.  On
    the one hand, I like the small, easily-digested chunks of text;
    long monolithic cut scenes are often overwhelming simply in the amount
    of text that appears all at once.  I also like the way that the
    multi-turn sequences integrate the cut scenes with <q>game time,</q>
    keeping the action on a somewhat consistent time scale rather than
    abruptly having many turns' worth of time elapse between two
    consecutive command prompts.";
    "\bOn the other hand, the effect is distancing, in that it removes
    interactivity from a scene almost as much as a single large cut
    scene would.
    \bI think that, in future games, I'd like to try to find more
    interactive ways of unfolding major plot advances.  It's a difficult
    balancing act, because you want the plot to unfold without puzzling
    the player, indeed almost in spite of the player&mdash;in other words,
    you essentially want to coerce the player into doing
    the right thing; but at the same time, you want the player to feel
    a degree of freedom of action greater than I offered in these
    cut scenes.
    \bSome games achieve this type of coercion by killing
    the player on a misstep, but I think this destroys the illusion
    of interactivity by forcing you to save and restore repeatedly,
    since you're essentially trying to navigate through a minefield.
    I think a better approach would be to make it so obvious what to
    do next, and so rewarding to do the obvious thing, that the player
    will naturally feel inclined play along and follow your
    script&mdash;ideally without even realizing that there's a script.
    The multi-turn cut scenes in this game are a very primitive
    attempt at this, I think, but since the only thing you
    can do is <q>wait,</q> it gets repetitive after a while.
    Something to keep in mind on the next game. ";

    "\b<hr>";
}

/*
 *   Amusing Things 
 */
amusingThings: function
{
    "\b<hr>
    <h3>Amusing things to try</h3>

    \bAsk Mr.\ Teeterwaller about...
    \n\tme;
    \n\thimself;
    \n\tShadow Man;
    \n\t335 card punch;
    \n\tOmegatron;
    \n\tBlottnya;
    \n\toffice gossip.

    \bLook in Mr.\ Teeterwaller's pockets.

    \bGive Teeterwaller orders.  (He has several different responses.
    Ordering him to go somewhere [Teeterwaller, North] elicits one
    type of response, and most other commands [Teeterwaller, look]
    receive random, uncooperative responses.)

    \bAfter seeing the initial truck hijacking scene outside the plant
    entrance, return to the car (and get in), and answer <q>yes</q> when
    Teeterwaller asks if you want to give up. ";

    "\bBefore befriending the dog, say <q>aus</q> in the dog's presence.

    \bAfter turning on the water, point the hose at...
    \n\tme;
    \n\tMr.\ Teeterwaller.

    \bAfter opening the access hatch in the glass over the atrium,
    and turning on the water, put the hose in the gap in the
    pipes (to the southeast of the safety station) and pull the
    lever. ";

    "\bHolding the hose, go down into the canal; Mr.\ Teeterwaller will
    stay behind to help guide the hose over the edge of the canal.
    Once you're down in the canal, drop the hose.

    \bOpen drawers in the Records Room several times.  (There are about
    eight separate files to look at; each time you open a drawer you'll
    get a different one until you've read them all.)

    \bAlternative endings: at the end of the game, when you're on the
    roof of the tower and
    the gray-haired man is telling you his life story...
    \n\tthrow the disk;
    \n\tgive the disk to the man (before he makes you the offer);
    \n\tgive the disk to the man (after he makes you the offer).
    \b<hr>";
}

/*
 *   About the author 
 */
aboutAuthor: function
{
    "\b<i>About the author</i>
    \bMichael Roberts is the author of several works of interactive
    fiction, including
    <i>Ditch Day Drifter</i>, <i>Deep Space Drifter</i> (with Steve
    McAdams), and <i>Perdition's Flames</i>, and is the developer of TADS,
    the design tool used to create this game.
    His email signature sometimes claims that he is a public policy
    analyst at a conservative think-tank, but this is not in fact the case.
    Michael lives in Palo Alto, California, in the heart of
    Silicon Valley, where he and countless others labor tirelessly
    to turn today's engineering dreams into tomorrow's technical
    support nightmares.
    \b";
}

/*
 *   Special features menu 
 */
specialFeatures: function
{
    local done;
    
    /* clear the screen before we begin */
    clearscreen();

    for (done := nil ; !done ; )
    {
        /* show the menu options */
        "\b\b<i><b>The Plant</b>
        \nSpecial Features Menu</i>
        \b\t1. <a href='1'>Amusing things to try</a>
        \n\t2. <a href='2'>Author's notes</a>
        \n\t3. <a href='3'>View deleted scenes</a>
        \n\t4. <a href='4'>About the author</a>
        \n\t5. <a href='5'>Return to the game</a>
        \bPlease enter the number of your choice:\ ";

        switch(cvtnum(input()))
        {
        case 1:
            amusingThings();
            break;

        case 2:
            authorsNotes();
            break;

        case 3:
            deletedScenesMenu();
            break;

        case 4:
            aboutAuthor();
            break;

        case 5:
            done := true;
            break;

        default:
            "\bSorry, that's not on the menu.  Please enter the number
            of your selection from the list.";
            break;
        }
    }
}

/*
 *   "Special" verb - activate special features menu 
 */
specialVerb: sysverb
    verb = 'special'
    isWarned = nil

    /*
     *   Show the warning about possible spoilers, if applicable.  Returns
     *   true if they wish to proceed in spite of the warning. 
     */
    showWarning =
    {
        /* 
         *   check to see if we should warn - only warn if we they haven't
         *   already bypassed the warning AND they haven't achieved the
         *   maximum possible score (there's nothing to spoil if they've
         *   won already) 
         */
        if (!self.isWarned && global.score != global.maxscore)
        {
            "<b>Warning:</b> you are about to enter the Special Features
            menu, which contains information that may give away some
            surprises if you haven't finished playing through the game
            yet.  The author recommends that you finish the game (with
            the maximum score) before viewing any of the special features.
            \bAre you sure you want to enter the special features menu?
            (Y is affirmative) >";

            /* ask - if they don't say YES, tell the caller not to proceed */
            if (yorn() != 1)
                return nil;

            /* note that they've seen the warning and decided to proceed */
            self.isWarned := true;
        }

        /* okay to proceed */
        return true;
    }
    action(actor) =
    {
        /* 
         *   if we haven't warned before, and they haven't just achieved
         *   the maximum possible score, do so now 
         */
        if (!self.showWarning)
            abort;

        /* activate the special features */
        specialFeatures();

        /* clear the screen and show the player where they were */
        clearscreen();
        parserGetMe().location.lookAround(true);

        /* don't count this as a turn */
        abort;
    }
;

