/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      djp     In real life:   David J. Picton
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 * Modification History
 *
 *
 * AD551
 * =====
 *
 * 14-Apr-99    djp     Initial release of Adventure 551 (1.01)
 *
 * 15-Jul-99    djp     New release (2.00)
 *                      Changes in this version:
 *                      * Added 'hints' as synonym to 'hint'
 *                      * Added a hint for getting the cask down to the
 *                        Limestone Spires.
 *
 * 17-Feb-00    djp     New release - Version 2.20
 *                        Changes in this version
 *                      * Further generalization of version handling
 *                      * Hints are now implemented as class 'thing' so
 *                        that the standard version handling code will
 *                        flag non-relevant ones as deleted.
 *                      * The hint system now replies "OK" if you decline
 *                        the hint.
 *
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Pre-release version 0.00
 *              bjs     550-point extensions.
 *
 *          djp+bjs     Incorporated ad551 mods up to 2.20
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Changed chute hint in 701-point mode (you can't
 *                        make it up there at all.)
 *              
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *              
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *
 * 16-Jul-06    djp     Version 3.20: Bugfixes and extensions
 *                      * Modification to elevator hint code to reflect 
 *                        new possibility of finding the key.
 *                      
 */

// This implements a hint system, similar to the one in the original game;
// most hints give help relevant to a particular location or group of
// locations.  However they are now offered only in response to the 'hints'
// command, and there will sometimes be more than one hint available at the
// same time.
//
// Hints with the 'universal' property set to true will work anywhere
// provided that the 'cond' property is also true.
// Other hints will be valid only if 'cond' is true and the hint is listed
// in the optional 'myhints' property of the player's top location.

// If defined, the myhints property of the player's top-level location may
// contain the list of potentially-available hints.
hintVerb: sysverb
// For now just list available hints at the player's location.
    verb = 'hint' 'hints'
    action(actor) = {
        local i,o,hintlist,reply,num;
        o := firstobj(CCRhint);
        hintlist := [];
        while (o <> nil) {
            if(o.valid and not o.isseen) {
                 hintlist += o;
            }
            o := nextobj(o, CCRhint);
        }
        if (length(hintlist) = 0) {
            "There are currently no hints available.";
        }
        else if (length(hintlist) > 1) {
            "There are "; say(length(hintlist)); " hints available.";
            P();
            for (i := 1; i <= length(hintlist); i++) {
                o := hintlist[i];
                say(i);": ";o.ques;"\n";
            }
            P();
            "Type the number of the required hint (1 to ";
            say(length(hintlist));") or 0 to exit:";
            reply := input();
            num := cvtnum(reply);
            if(datatype(num) != 1) num := 0;
            if(num > 0) {
                self.askhint(hintlist[num]);
            }
        }
        else {
            self.askhint(hintlist[1]);
        }
    abort;
    }
    askhint(hint) = {
        hint.ques; P();
        if(hint.points != 0) {
            "I am prepared to offer you this hint, but it will cost ";
            say(hint.points); " points.  Do you want the hint?\b>";
        }
        else {
            "I am prepared to offer you this hint for free.
            Do you want the hint?\b>";
        }
        if (yorn()) {
            incscore(-hint.points);
            hint.ans;
            hint.isseen := true;
        }
        else "OK";
    }
;

/* We put the hints into the 'thing' class to enable normal version
   handling */
class CCRhint: thing
        valid = {
            local toploc := toplocation(Me);
            if (self.deleted) return nil;
            if (self.universal and self.cond) return true;
            if (datatype(toploc.myhints) = 7) {
                if (find(toploc.myhints,self) and self.cond)return true;
            }
            return nil;
        }
;
Cavehint1: CCRhint
        cond = {
            local toploc := toplocation(Me);
            return (not (At_Y2.isseen or In_Debris_Room.isseen or
            Below_The_Grate.isseen or set_of_keys.isInside(toploc)));
        }
        ques = "Are you trying to get into the cave?"
        points = 2
        ans = "The grate is very solid and has a hardened steel lock.
        You cannot enter without a key, and there are no keys nearby.
        I would recommend looking elsewhere for the keys."
;
Cavehint2: CCRhint
        universal = true
        cond = {
            local toploc := toplocation(Me);
            if(not toploc.isoutside) return nil; // exclude rooms inside cave
            if(toploc.isindoor) return nil; // also exclude 'indoor' rooms.
            return (not (At_Y2.isseen or In_Debris_Room.isseen or
            Below_The_Grate.isseen or Me.isIn(Outside_Grate)));
        }
        ques = "Are you trying to get into the cave?"
        points = 2
        ans = "I don't know where the cave is, but hereabouts no stream can
            run on the surface for long.  I would try the stream."
;
Birdhint: CCRhint
        universal = true // (bird may get moved if we sit on the throne)
        cond = {
             local toploc := toplocation(Me), rodcond;
                if(global.oldgame)rodcond := black_rod.isIn(Me);
                else rodcond := black_rod.isIn(toploc);
                if(rodcond and (not little_bird.moved) and
                little_bird.isIn(toploc))
                    return true;
                else
                    return nil;
        }
        points = 2
        ques = "Are you trying to catch the bird?"
        ans = "The bird is frightened right now and you cannot catch it no
              matter what you try.  Perhaps you might try later."

        //The rod scares the bird.
;
Snakehint: CCRhint
        cond = {
            local toploc := toplocation(Me);
            if(little_bird.isIn(toploc) or Snakehint2.isseen) return nil;
            if(Snake.isIn(toploc))return true;
            else return nil;
        }
        points = 2
        ques = "Are you trying to somehow deal with the snake?"
        ans = "You can't kill the snake, or drive it away, and there's not
        much chance to slip past it or anything like that.   There is a way
        to get by, but you don't have the necessary resources right now."
        // changed to 'not much chance' because it is possible to slip past
        // to the SW.
;
       

Snakehint2: CCRhint
        cond = {
            local toploc := toplocation(Me);
            if(little_bird.isIn(toploc)) {
                if(Snake.isIn(toploc))return true;
                else return nil;
            }
            else return nil;
        }
        points = 2
        ques = "Are you trying to somehow deal with the snake?"
        ans = "You can't drive away the snake, but maybe someone else can ..."
;

Mazehint: CCRhint
        cond = true
        points = 4
        ques = "Do you need help getting out of the maze?"
        ans = "You can make the passages look less alike by dropping things."
;
Ploverhint: CCRhint
        cond = (not In_Dark_Room.isseen)
        points = 5
        ques = "Are you trying to explore beyond the Plover Room?"
        ans = "There is a way to explore that region without having to worry
        about falling into a pit.  None of the objects available is
        immediately useful in discovering the secret."
        // objects aren't useful but one word is.
;
Witthint: CCRhint
        cond = true
        points = 3
        ques = "Do you need help getting out of the maze?"
        ans = "You can make the passages look less alike by dropping things."
;
Swordhint: CCRhint
        game551 = true
        cond = true
        points = 10
        ques = "Do you want to extract the sword from the anvil?"
        ans = "If you could convince me of your royal blood, you might get
        somewhere."
;
Slidehint: CCRhint
        game551 = true
        cond = (not Sword_Point.isseen)
        points = 5
        ques = "Are you trying to go up the slide?"
        ans = {
            if(not global.game701) {
                "Unless you're prepared to spend all day trying to get up
                there, ";
            }
            else {
                "The chute is particularly slippery in this version of the
                game, and I don't think you'll get up there however hard
                you try. ";
            }
            "I'd advise you to find another way in to that area.";
        }
        // Original hint said 'another way into the cave' but this is
        // misleading.
;
Elfindoorhint: CCRhint
        game551 = true
        cond = (not Ledge_By_Door.isseen)
        points = 2
        ques = "Are you trying to get into the cave?"
        ans = "This is obviously an elfin entrance.  Unless you can squeeze
        yourself through a six-inch door, you'll have to find another
        way into the cave."
        //we require an elfin magic word
;
Bridgehint: CCRhint
        game551 = true
        cond = (not slippers.moved)
        points = 5
        ques = "Are you trying to reach the natural bridge?"
        ans = "You can't get to it by climbing the walls or jumping or anything
        like that. You could always put in a telephone call to the local
        spelunking club for advice, if you could find a phone."
        //if this clue is followed up, the phone call now gives more clues
        //than in the original
;
Caskhint: CCRhint
        game551 = true
        cond = (not Grotto_West.isseen)
        points = 5
        ques = "Are you trying to go down here with bulky items? "
        ans = "Maybe you'd better look for another way into the cave. "
        //boat transport is required
;
Doghint: CCRhint
        game551 = true
        points = 5
        cond = (not Dog.isasleep)
        ques="Are you trying to get past the dog?"
        ans="The only person I can remember who managed to get past the dog
        was that singer, ummm, what's his name... Euridice's friend...."
;
Castlehint: CCRhint
        game551 = true
        points = 2
        cond = (not Castle_Pinnacle.isseen)
        ques="Are you trying to get to the castle?"
        ans="It's easy to get there if you know how. The elves cross over
        from here so perhaps you might watch an elf to see how.
        Of course they are a bit shy, so keep a good way off while you
        watch."
        //use crystal ball/sapphire
;
Cloakhint: CCRhint
        game551 = true
        points = 5
        cond = (not Wumpushint.isseen and not Wumpus.isdead and not
            cloak.moved)
        ques = "Are you trying to take the cloak without waking the Wumpus?"
        ans = "You can't take the cloak without making an unholy din, and
        no-one has ever managed to outrun the Wumpus, even with the aid of
        magic!  You'll have to work out a better way to outwit him."
;
Wumpushint: CCRhint
        universal = true
        game551 = true
        points = 5
        cond = (not Cloakhint.isseen and not Cloakhint.valid and
            Wumpus.ischasing)
        ques = "Are you trying to escape from the Wumpus?"
        ans = "No-one has ever managed to outrun the Wumpus, even with the
        aid of magic!  You'll have to work out a better way to outwit him."
;
Foghint: CCRhint
        game550 = true
        points = 5
        cond = (brass_lantern.islit)
        ques = "Having problems?"
        ans = "OK - what you need to do is apply a little philosophy.
                To wit: there is a question that you need to ask whenever
                you explore a new room in this cave.  In most places, the
                answer to the question is \"yes\". In some other places,
                it's \"no\" for an obvious reason.  Right here, the
                answer is \"no\" but the reason isn't so obvious.  If
                you can figure out what the question is, you can get
                out of here easily.  I can tell you this - it's always
                a vital question if you wish to survive."
;
Icehint: CCRhint
        game550 = true
        points = 10
        cond = true
        ques = "Are you having problems getting out of the ice tunnels?"
        ans = "To get out of here, you'll first have to get your bearings
        so that you know where you are.  I suggest that you draw a
        careful, accurate map of the tunnel system; for clarity's sake,
        keep your lines as straight as is feasible and draw in all of
        the dead ends and such.  Once you've got a complete and accurate
        map, examine it carefully; if your thoughts refuse to clarify,
        you might try using the old Yoga trick of standing on your head,
        and see if that helps."
;

Vaulthint: CCRhint
        game550 = true
        points = 5
        // DJP - turn this hint off if the sceptre has been taken
        cond = (not sceptre.moved)
        ques = "Are you having trouble getting into the vault?"
        ans = "It will be some time before you are able to open it, I
        fear.  For now, you should turn your attention to other things,
        and try again when you have learned more. "
;

Octagonhint: CCRhint
        game701p = true
        points = 5
        // Turn off the hints once the rockfalls have been searched or moved.
        cond = ((not Rockfalls.movable) and (not Rockfalls.ismoved) 
        and global.game701p)
        ques = "Trying to work out what you should be doing here? "
        ans = {
            "An old (and probably apocryphal) Elvish tale states that the 
            Wumpus entered the cave from the east passage, many years ago.  
            There's no way to check out the story because the said passage is
            blocked by rocks which look as if they weigh a ton.   There's
            no way through.  Hmmm...  I can't pinpoint the reason, but 
            there's something odd about the rocks blocking the east passage.
            Hope this helps somehow ... ";
            Rockfalls.movable := true;
        }
;

SteelKeyhint: CCRhint
        game701p = true
        points = 5
        ques = "Are you trying to figure out where to find the key?"
        cond = ((not transindection_key.moved) and Rockfalls.ismoved 
        and (not Octagonhint.isseen)) 
        ans = "An old (and maybe apocryphal) Elvish tale states that the 
            Wumpus entered the cave through that door, many years ago. "
;

Pendanthint: CCRhint
        universal = true
        points = 5
        ques = "Are you trying to figure out how to recharge the pendant?"
        cond = ((tarnished_pendant.location != nil) and 
               (not Translevel_Rockfalls.searched) and 
               (not phrosalVerb.invoked))
        ans = "Have you noticed that things come in threes round here?
              For example, three Transindection levels are available to you,
              and there are three pendant keywords.  Something needs to be
              done three times, but you've only done it twice. "
              //must examine the rockfalls at Green level
;
Elevatorhint: CCRhint
        points = 5
        ques = "Are you trying to get into the elevator?"
        // Turned off once the Adventurer has managed to enter the elevator,
        // or has obtained the key

        cond = (not (In_Elevator.isseen or elevator_key.moved))
        ans = "Maybe there's a key somewhere, but I don't think that 
              Eldrand would have needed it. ";
              // i.e. use Transindection.   The key is also available if
              // the pendant is rubbed.
;

Beach_Shelfhint: CCRhint
        points = 5
        ques = "Are you trying to climb the path up the cliff?"
        cond = (not Blue_Bird_Chamber.isseen)
        ans = "You won't get up the path by conventional means. "
              // see Elevatorhint
;

Spinhint: CCRhint
        points = 5
        ques = "Are you trying to span a rod over the fissure? "
        cond = (manual.isread and manual.misunderstood and not 
        (black_rod.isspun or gray_rod.isspun or DisplayBoards.spanseen))
        ans = "There are three possibilities to work on.  Firstly, you may
              need to find a very long rod.  Secondly, you may need to find a 
              narrow fissure.  Or thirdly, you may need to take another 
              look at the scrawled note in the manual.  Words can sometimes
              have more than one meaning ... ";
              // also see the display boards at the west end of the Hall of
              // Mists at Blue level.  
;

Machinehint: CCRhint
        points = 5
        ques = "Are you trying to get this machine to work?"
        cond = (not SmallroomMachine.charged and not 
               oblong_box_1.isIn(Blue_Doorsite_SmallRoom) and not
               oblong_box_2.isIn(Blue_Doorsite_SmallRoom))
        ans = "This machine has received the maintenance which it requires,
              but I suspect that a part is missing.  Maybe the oblong hole
              has something to do with it ... "
              // We require one of the oblong boxes.
;
