/* MenuTalk.t
   By Guilherme De Sousa 
   April 2001
   Version 1.0

   Based on Adam Cadre`s Phototalk.inf code from Photopia

*/

modify global
  menulinks = 'on'
  menustyle = '1'
  menuwrap = 'on'
  HTML_Interpreter = true
  menu_exit = 0
;

SetMenuDefaults: function ()
{

	/* Check that the interpreter can display HTML */

	if (systemInfo(__SYSINFO_SYSINFO) = true) 
		{
        	global.HTML_Interpreter := (systemInfo(__SYSINFO_HTML) = 1);
        }
    else 
		{
          	global.HTML_Interpreter := nil;
		}

	if (global.HTML_Interpreter)
		{
			/* Set menu defaults for a html interpreter - a split screen */

			global.menu_style := '1';
			global.menulinks := 'on';
			global.menuwrap := 'on' ;
		}
	else
		{
			/* Set menu defaults for a non-html interpreter - single pane display */

			global.menu_style := '2';
			global.menulinks := 'off';
			global.menuwrap := 'off';
		}

}


TalkSub: function (actor)
{
	local choice_no;
	local valid_input := 0;
	local choices = [0,0,0,0,0,0,0,0,0];
	local input_no;
	local len, ind;
	global.menu_exit := 0;

	/* Setup loop for updating the choices on screen (html only) */

	while (global.menu_exit = 0) 
		{
			choice_no := 1;
			valid_input := 0;
			choices := [0,0,0,0,0,0,0,0,0];
			global.menu_exit := 0;

			/* Test that there is at least one quip available */

			if (TestQuips(actor))  
		  		{
					/* Display a list of available quips */

					len := length(actor.Quips);
  					choice_no := 1;
  					if (global.menustyle = '1')  // Setup the split screen banner (html only)
  						{
  							"<BANNER ID=convmenu ALIGN=bottom border=2>";
  							"<BODY BGCOLOR=#BAD6F2>";
  						}   
  					"\bPlease select one:\b";
  					for (ind := 1 ; ind <= len ; ind++)  // Loop through the actors quips printing out any available ones
    					{
      						if (actor.Quips[ind] = 1)
      							{		
									if ( global.menulinks = 'on' )  // print each available quip
	   									{
	      									"[<<choice_no>>] <a href='<<choice_no>>'><<actor.SayQ(ind)>></a>";
	   									}
									else
	   									{
	      									"[<<choice_no>>] <<actor.SayQ(ind)>>";
	   									}
									choices[choice_no] := ind;
									choice_no++;
									"\n";
      							}
    					}
					"\b\bSelect an option or '0' to say nothing ";
					if (global.menustyle = '1') "</BANNER>";
		
  					/* Get a choice and respond to it */

					while ( valid_input = 0 )
						{
  							"\b>>";
							input_no := 0;
							input_no := input();
							switch(input_no)
       	  	 					{
          	    					case '1':
	  	    						case '2':
          	  						case '3':
          	  						case '4':     
	  	    						case '5':          
	  	    						case '6':    
          	    					case '7':
          	    					case '8':
       	  	    					case '9':
               								actor.RespondQ(choices[cvtnum(input_no)]);
											valid_input := 1;
											global.menu_exit := 0;
											if (global.menuwrap = 'off') global.menu_exit := 1;
											break;
	  	    						case '0':
											if ((global.HTML_Interpreter) and (global.menustyle = '1')) "<BANNER ID=convmenu REMOVE>";
											valid_input := 1;
											global.menu_exit := 1;
           									break;
		    						default:
											break;
          	  					} 
						}
				}			
			else
				{
					if ((global.HTML_Interpreter) and (global.menustyle = '1'))
		  				{
							"<BANNER ID=convmenu ALIGN=bottom border=2 height=previous>";
  							"<BODY BGCOLOR=#BAD6F2>";
	   						"\bYou have nothing else to say to <<actor.thedesc>> just now.";
							"\b\b\b(Please press a key to exit conversation mode)";
							"</BANNER>";
							inputkey();
							"<BANNER ID=convmenu REMOVE>";
		    				global.menu_exit := 1;
		  				}
					else
		  				{
		    				"\bYou have nothing to say to <<actor.thedesc>> just now.";
							global.menu_exit := 1;		
		  				}
				}
		}
global.menu_exit := 1;
}




TestQuips: function (actor)
{
  	local quipson := 0;
  	local ind;
  	local len := length(actor.Quips);  	// Count the number of quips (set to 1 or 0 ) for the actor

  	for (ind := 1 ; ind <= len ; ind++ )
  		{
     		if (actor.Quips[ind] = 1) quipson := 1;  
   		}

  	if (quipson = 1)
      	{
			return true;			   // Return true if there`s one or more quip set to on
      	}
  	else
      	{
			return nil;				   // Return nil if there`s nothing to talk about
      	}
}




SetQuip: function (actor, quipno, quipvalue)
{
   	actor.Quips[quipno] := quipvalue;
}



talkVerb: deepverb
  	verb = 'talk' 'speak' 'talk to' 'talk with' 'speak with' 'speak to' 'chat with' 'chat to'
  	sdesc = "talk to"
  	doAction = 'Talk'
  	prepDefault = toPrep
;



modify thing
  	verDoTalk(actor) = {}
  	doTalk(actor) =
		{
			"\bAs stimulating as a conversation with <<self.sdesc>> might be, I think I`ll pass.";  // add special cases
		}
;



menulinksVerb: sysverb
  	verb = 'menulinks'
  	action( actor ) =
  		{
			if (global.HTML_Interpreter)
				{
    				if (global.menulinks = 'on')
						{
	   						global.menulinks := 'off';
	   						"\b(Menu hyperlinks are now switched off)";
						}
    				else
						{
  	   						global.menulinks := 'on';
	   						"\b(Menu hyperlinks are now switched on)";	
						}
  				}
			else
				{
					"\bThat command is only available on HTML-TADS interpreters.";
				}
		}
;



menustyleVerb: sysverb
  	verb = 'menustyle'
  	action( actor ) =
  		{
			if (global.HTML_Interpreter)
				{
  	 				if (global.menustyle = '1')
						{
	   						global.menustyle := '2';
	   						global.menuwrap := 'off';
	   						"\b(Menu options will now appear in the main window)";
						}
    				else
						{
	   						global.menustyle := '1';
	   						global.menuwrap := 'on';
	   						"\b(Menu options will now appear in a separate window)";
						}
				}
			else
				{
					"\bThat command is only available on HTML-TADS interpreters.";	
				}
  		}
;
