/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringWriter;
import java.util.Vector;

public class OutputFormatter {
    public static final int DEFAULT_TAB_SIZE = 4;
    private PlatformIO _platform_io = null;
    private int _wrap_column = 78;
    private int _wrap_line = 20;
    private StringBuffer _current_word = new StringBuffer(10);
    private char _last_printed = '\u0000';
    private int _last_column = 0;
    private int _last_line = 0;
    private Vector _outhides = new Vector(1);
    private Vector _outcaptures = new Vector(1);
    private TObject _filter = null;
    private StringBuffer _status_line = null;
    private boolean _html_mode = false;
    private StringBuffer _current_entity = null;
    private StringBuffer _current_tag = null;
    private int _quote_level = 0;

    public OutputFormatter(PlatformIO platformIO) {
        this._platform_io = platformIO;
    }

    public void print(String string) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        if (this._filter != null) {
            TValue tValue = new TValue(TValue.SSTRING, string);
            TValue tValue2 = Jetty.runner.run(this._filter.get_data(), TObject.arg_array(tValue));
            if (tValue2.get_type() == TValue.SSTRING) {
                string = tValue2.get_string();
            }
        }
        if ((string = this.expand_format_strings(string)).length() == 0) {
            return;
        }
        if (this._outhides.size() > 0) {
            int n = 0;
            while (n < this._outhides.size()) {
                this._outhides.setElementAt(Boolean.TRUE, n);
                ++n;
            }
            return;
        }
        if (this._outcaptures.size() > 0) {
            int n = 0;
            while (n < this._outcaptures.size()) {
                ((StringWriter)this._outcaptures.elementAt(n)).write(string);
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < string.length()) {
            block35: {
                char c;
                block40: {
                    block36: {
                        block39: {
                            block38: {
                                block37: {
                                    c = string.charAt(n);
                                    if (Character.isISOControl(c)) break block35;
                                    if (!this._html_mode) break block36;
                                    if (this._current_entity == null) break block37;
                                    if (Character.isLetterOrDigit(c) || c == '#') {
                                        this._current_entity.append(c);
                                    } else {
                                        this.process_entity(this._current_entity.toString());
                                        this._current_entity = null;
                                    }
                                    break block35;
                                }
                                if (this._current_tag == null) break block38;
                                if (c != '>') {
                                    this._current_tag.append(c);
                                } else {
                                    this.process_tag(this._current_tag.toString());
                                    this._current_tag = null;
                                }
                                break block35;
                            }
                            if (c != '&') break block39;
                            this._current_entity = new StringBuffer(5);
                            break block35;
                        }
                        if (c != '<') break block36;
                        this._current_tag = new StringBuffer(5);
                        break block35;
                    }
                    if (this._last_printed == '-' && c != '-') {
                        this.flush();
                        this._last_printed = '\u0000';
                    }
                    if (c != '\\') break block40;
                    c = string.charAt(++n);
                    switch (c) {
                        case 'n': {
                            this.print_newline();
                            break;
                        }
                        case 'b': {
                            this.print_blankline();
                            break;
                        }
                        case 't': {
                            this.print_tab(4);
                            break;
                        }
                        case '^': 
                        case 'v': {
                            this._last_printed = c;
                            break;
                        }
                        case '(': {
                            if (!this.printing_status()) {
                                this.flush();
                                this._platform_io.set_style(0, true);
                                break;
                            }
                            break block35;
                        }
                        case ')': {
                            if (!this.printing_status()) {
                                this.flush();
                                this._platform_io.set_style(0, false);
                                break;
                            }
                            break block35;
                        }
                        case '-': {
                            this.add_char('-', '-');
                            break;
                        }
                        case ' ': {
                            this.add_char(' ', ' ');
                            break;
                        }
                        case 'H': {
                            this._html_mode = true;
                            if (++n < string.length() && string.charAt(n) == '-') {
                                this._html_mode = false;
                                break;
                            }
                            break block35;
                        }
                        default: {
                            this.add_char(c, '\u0000');
                            break;
                        }
                    }
                    break block35;
                }
                if (c == ' ') {
                    if (!Character.isWhitespace(this._last_printed)) {
                        this.add_char(' ', ' ');
                    }
                    this.flush();
                } else if (c == '-') {
                    this.add_char('-', '-');
                } else {
                    if (this._last_printed == '^') {
                        c = Character.toUpperCase(c);
                    } else if (this._last_printed == 'v') {
                        c = Character.toLowerCase(c);
                    }
                    this.add_char(c, '\u0000');
                }
            }
            ++n;
        }
    }

    private void add_char(char c, char c2) {
        this._current_word.append(c);
        this._last_printed = c2;
        this.wrap_long_words();
    }

    private String expand_format_strings(String string) throws ParseException, ReparseException, HaltTurnException, GameOverException {
        TObject tObject = Jetty.state.get_actor();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                ++n;
            } else if (string.charAt(n) == '%') {
                int n2 = n + 1;
                while (n2 < string.length()) {
                    if (string.charAt(n2) == '%') break;
                    ++n2;
                }
                if (n2 >= string.length()) {
                    return string;
                }
                String string2 = string.substring(n + 1, n2);
                int n3 = Jetty.state.lookup_fmtstr(string2.toLowerCase());
                if (n3 == -1) {
                    n = n2;
                } else {
                    int n4 = this.capture_output();
                    tObject.eval_property(n3, TObject.arg_array());
                    String string3 = this.uncapture_output(n4);
                    if (string3.length() > 0 && Character.isUpperCase(string2.charAt(0))) {
                        string3 = Character.isUpperCase(string2.charAt(1)) ? string3.toUpperCase() : string3.substring(0, 1).toUpperCase() + string3.substring(1);
                    }
                    string = string.substring(0, n) + string3 + string.substring(n2 + 1);
                    n += string3.length();
                }
            }
            ++n;
        }
        return string;
    }

    public void print_statusline(boolean bl, boolean bl2) {
        if (bl) {
            this.flush();
            this._status_line = new StringBuffer(10);
            this._status_line.append(this._last_printed);
            return;
        }
        this.flush();
        this._platform_io.set_status_string(this._status_line.toString().substring(1), bl2);
        this._last_printed = this._status_line.charAt(0);
        this._status_line = null;
    }

    public void print_error(String string, int n) {
        if (Jetty.get_debug_level() >= n) {
            this._platform_io.print_error(string);
        }
    }

    public void flush() {
        if (!this.printing_status()) {
            int n = this._platform_io.size_text(this._current_word.toString());
            if (this._last_column + n >= this._wrap_column) {
                this.inc_line();
            }
            this._last_column += n;
            this._platform_io.print_text(this._current_word.toString());
            this._current_word.setLength(0);
        } else {
            this._status_line.append(this._current_word.toString());
            this._current_word.setLength(0);
        }
    }

    private void wrap_long_words() {
        if (this.printing_status()) {
            return;
        }
        String string = this._current_word.toString();
        if (this._platform_io.size_text(string) >= this._wrap_column) {
            String string2 = string;
            while (this._platform_io.size_text(string2) >= this._wrap_column) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this._platform_io.print_text(string2);
            this.inc_line();
            String string3 = string.substring(string2.length());
            if (this._current_word.length() == this._wrap_column) {
                this._last_printed = (char)10;
            }
            this._current_word = new StringBuffer(string3);
        }
    }

    private void inc_line() {
        if (!this.printing_status()) {
            this._last_column = 0;
            this._platform_io.scroll_window();
            if (++this._last_line >= this._wrap_line) {
                this._last_line = this._platform_io.more_prompt("[More]") ? 0 : --this._last_line;
            }
        }
    }

    private void print_newline() {
        if (this.printing_status()) {
            return;
        }
        this.flush();
        if (this._last_printed != '\n') {
            this.inc_line();
        }
        this._last_printed = (char)10;
    }

    private void print_blankline() {
        if (this.printing_status()) {
            return;
        }
        this.flush();
        this.inc_line();
        if (this._last_printed != '\n') {
            this.inc_line();
        }
        this._last_printed = (char)10;
    }

    private void print_tab(int n) {
        this.flush();
        int n2 = this._platform_io.size_text(' ');
        int n3 = 0;
        while (n3 < n && this._last_column < this._wrap_column) {
            this._current_word.append(' ');
            this._last_printed = (char)32;
            this._last_column += n2;
            ++n3;
        }
    }

    public void input_entered() {
        this._last_column = 0;
        this._last_line = 0;
        this._last_printed = (char)10;
    }

    public void set_filter(TObject tObject) {
        this._filter = tObject;
    }

    public void clear_screen() {
        if (this.no_output() || this.printing_status()) {
            return;
        }
        this._platform_io.clear_screen();
    }

    public void set_platform_io(PlatformIO platformIO) {
        this._platform_io = platformIO;
    }

    public void resize(int n, int n2) {
        this._wrap_column = n;
        this._wrap_line = n2 - 1;
        this._last_column = 0;
        this._last_line = 0;
        this._current_word.setLength(0);
    }

    public int hide_output() {
        this.flush();
        this._outhides.addElement(Boolean.FALSE);
        return this._outhides.size() - 1;
    }

    public boolean unhide_output(int n) {
        this.flush();
        if (this._outhides.size() <= n) {
            return false;
        }
        boolean bl = (Boolean)this._outhides.elementAt(n);
        while (this._outhides.size() > n) {
            this._outhides.removeElementAt(this._outhides.size() - 1);
        }
        return bl;
    }

    public int capture_output() {
        this.flush();
        this._outcaptures.addElement(new StringWriter());
        return this._outcaptures.size() - 1;
    }

    public String uncapture_output(int n) {
        this.flush();
        if (this._outcaptures.size() <= n) {
            return "";
        }
        String string = this._outcaptures.elementAt(n).toString();
        while (this._outcaptures.size() > n) {
            this._outcaptures.removeElementAt(this._outcaptures.size() - 1);
        }
        return string;
    }

    public void cancel_outhiding() {
        this._outcaptures.removeAllElements();
        this._outhides.removeAllElements();
    }

    private boolean no_output() {
        return this._outcaptures.size() > 0 || this._outhides.size() > 0;
    }

    private boolean printing_status() {
        return this._status_line != null;
    }

    public void print_more_prompt() throws ParseException, ReparseException, HaltTurnException, GameOverException {
        if (this.no_output() || this.printing_status()) {
            return;
        }
        this._last_line = this._wrap_line;
        this._last_line = this._platform_io.more_prompt("[More]") ? 0 : --this._last_line;
    }

    private void process_entity(String string) {
        if ((string = string.toLowerCase()).equals("amp")) {
            this.add_char('&', '\u0000');
        } else if (string.equals("gt")) {
            this.add_char('>', '\u0000');
        } else if (string.equals("lt")) {
            this.add_char('<', '\u0000');
        } else if (string.equals("quot") || string.equals("rdquo") || string.equals("ldquo")) {
            this.add_char('\"', '\u0000');
        } else if (string.equals("lsquo") || string.equals("rsquo")) {
            this.add_char('\'', '\u0000');
        } else if (string.equals("copy")) {
            this.add_char('(', '\u0000');
            this.add_char('c', '\u0000');
            this.add_char(')', '\u0000');
        } else if (string.equals("mdash")) {
            this.add_char('-', '-');
            this.add_char('-', '-');
        } else if (string.equals("ndash")) {
            this.add_char('-', '-');
        } else if (string.equals("nbsp")) {
            this.add_char(' ', ' ');
        } else {
            this.print_error("Unknown entity=" + string, 2);
            this.add_char('?', '\u0000');
        }
    }

    private void process_tag(String string) {
        String string2 = string.toLowerCase();
        int n = string2.indexOf(" ");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if (string2.equals("p")) {
            this.print_blankline();
        } else if (string2.equals("br")) {
            this.print_newline();
        } else if (string2.equals("b")) {
            if (!this.printing_status()) {
                this.flush();
                this._platform_io.set_style(0, true);
            }
        } else if (string2.equals("/b")) {
            if (!this.printing_status()) {
                this.flush();
                this._platform_io.set_style(0, false);
            }
        } else if (string2.equals("i")) {
            if (!this.printing_status()) {
                this.flush();
                this._platform_io.set_style(1, true);
            }
        } else if (string2.equals("/i")) {
            if (!this.printing_status()) {
                this.flush();
                this._platform_io.set_style(1, false);
            }
        } else if (string2.equals("tab")) {
            n = 4;
            int n2 = string.toLowerCase().indexOf("multiple=");
            if (n2 != -1) {
                if ((n2 = (string = string.substring(n2 + "multiple=".length())).indexOf(" ")) != -1) {
                    string = string.substring(0, n2);
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.print_error("Unknown tab multiple value=" + string, 2);
                    n = 4;
                }
            }
            this.print_tab(n);
        } else if (string2.equals("q")) {
            if (this._quote_level % 2 == 0) {
                this.add_char('\"', '\u0000');
            } else {
                this.add_char('\'', '\u0000');
            }
            ++this._quote_level;
        } else if (string2.equals("/q")) {
            --this._quote_level;
            if (this._quote_level % 2 == 0) {
                this.add_char('\"', '\u0000');
            } else {
                this.add_char('\'', '\u0000');
            }
        }
    }
}

