////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: EnterableTravelable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ENTERABLE_TRAVELABLE_H_
#define _ENTERABLE_TRAVELABLE_H_

#include <bedtravelable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  EnterableTravelable: BedTravelable
 *
 *  Rules for travel, boarding and unboarding, for an Enterable-style
 *  room.
 */
class EnterableTravelable: BedTravelable
    boardingPosture = standing
    verDoEnter(actor) = { self.verDoBoard(actor); }
    doEnter(actor) = { self.doBoard(actor); }
    verDoBoard(actor) = {
        if (actor.location == self)
            "%You're% already <<actor.posture.desc>> 
            <<self.boardingPrep>> <<self.theDesc>>! ";
        else if (actor.isCarrying(self))
            "%You%'ll have to drop <<self.theDesc>> first!";
    } 	
    verDoUnboard(actor) = {
        if (actor.location != self)
            "%You're% not <<self.boardingPrep>> <<self.theDesc>>! ";
        else if (self.location == nil)
            "%You% can't leave <<self.theDesc>>! ";
    }
    out = (self.location)
    noExit = {
        if (self.isLit(gActor()))
            pass noExit;
        else {
            darkTravel();
            return nil;
        }
    }
;

#pragma C-

#endif /* _ENTERABLE_TRAVELABLE_H_ */
