////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Material 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//  Based on ADV3 (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _MATERIAL_H_
#define _MATERIAL_H_

#pragma C+

class Material: object
    senseThru(sense) = {
        return self.(sense.thruProp);
    }
    seeThru = nil
    hearThru = nil
    smellThru = nil
    touchThru = nil
;

/*
 *   Altima is the basic stuff of the game universe.  This is the
 *   default material for any object that doesn't specify a different
 *   material.  This type of material prevents passage of all senses.  
 */
altima: Material
    seeThru = nil
    hearThru = nil
    smellThru = nil
    touchThru = nil
;

/*
 *   Glass allows passage of sight, but not sound, smell, or touch.
 */
glass: Material
    seeThru = true
    hearThru = nil
    smellThru = nil
    touchThru = nil
;

/*
 *   Paper allows passage of sound and smell, but not sight or touch. 
 */
paper: Material
    seeThru = nil
    hearThru = true
    smellThru = true
    touchThru = nil
;

/*
 *   Fine Mesh allows passage of sight, sound, and smell, but not touch. 
 */
fineMesh: Material
    seeThru = true
    hearThru = true
    smellThru = true
    touchThru = nil
;

/*
 *   Coarse Mesh allows passage of sight, sound, smell, and touch.  
 */
coarseMesh: Material
    seeThru = true
    hearThru = true
    smellThru = true
    touchThru = true
;

#pragma C-

#endif /* _MATERIAL_H_ */
