////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: NestedRoomActionable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _NESTED_ROOM_ACTIONABLE_H_
#define _NESTED_ROOM_ACTIONABLE_H_

#include <roomactionable.h>
#include <checkreach.t>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  NestedRoomActionable: DarkRoomActionable
 */
class NestedRoomActionable: DarkRoomActionable
    /*
     *   If canReachContents is nil, enforce the limitation 
     */
    roomAction(actor, v, dobj, prep, io) = {
        /* enforce !canReachContents, except for 'look at' */
        if (dobj != nil && !self.canReachContents && v != inspectVerb)
            checkReach(self, actor, v, dobj);

        /* enforce !canReachContents, except for 'ask/tell about' */
        if (io != nil && !self.canReachContents
             && v != askVerb && v != tellVerb)
            checkReach(self, actor, v, io);

        /* inherit the default behavior */
        inherited.roomAction(actor, v, dobj, prep, io);
    }
    /*
     *   canReachContents - this flag indicates whether or not the player
     *   can reach the contents of objects in the 'reachable' list from
     *   this nested room.  This is true by default, which means that the
     *   player can reach not only the items directly in the 'reachable'
     *   list, but also the objects within those objects.  If this is nil,
     *   it means that the player can only reach the objects actually
     *   listed in the 'reachable' list, and not any objects within those
     *   objects.
     *   
     *   Setting canReachContents to nil is probably undesirable in most
     *   cases.  This setting is provided mostly for compatibility with
     *   past versions of adv.t, which behaved as though canReachContents
     *   was true for nested rooms *except* for chairItem objects, which
     *   acted as though canReachContents was nil.  If you want consistent
     *   behavior in all nested rooms including chairs, simply set
     *   chairItem.canReachContents to true.  
     */
    canReachContents = true

    roomDrop(obj) = {
        if (self.location == nil || self.isDropLoc)
            pass roomDrop;
        else
            self.location.roomDrop(obj);
    }
;

#pragma C-

#endif /* _NESTED_ROOM_ACTIONABLE_H_ */
