////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: OpenableContainer 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _OPENABLE_CONTAINER_H_
#define _OPENABLE_CONTAINER_H_

#include <openable.h>
#include <container.h>

#pragma C+

/*
 *  OpenableContainer: Openable, Container
 *
 *  A Container that can be opened and closed.  The isOpenable
 *  property is set to true.  The default lDesc displays
 *  the contents of the Container if the Container is open, otherwise
 *  a message saying that the object is closed.
 */
class OpenableContainer: Openable, Container
    lDesc = {
        caps(); self.theDesc; " "; self.isDesc;
        if (self.isOpen) {
            " open. ";
            pass lDesc;
        } else {
            " closed. ";
            
            /* if it's transparent, list its contents anyway */
            if (self.isTransparent)
                pass lDesc;
        }
    }
;

#pragma C-

#endif /* _OPENABLE_CONTAINER_H_ */
