////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Readable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _READABLE_H_
#define _READABLE_H_

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Readable: Item
 *
 *  A class that can be read.  The readDesc property is displayed
 *  when the item is read.  By default, the readDesc is the same
 *  as the lDesc, but the readDesc can be overridden to give
 *  a different message.
 */
class Readable: object
    readDesc = {
        self.lDesc;
    }
    verDoRead(actor) = {}
    doRead(actor) = {
        self.readDesc;
    }
;

#pragma C-

#endif /* _READABLE_H_ */
