////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: VehicularActionable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _VEHICULAR_ACTIONABLE_H_
#define _VEHICULAR_ACTIONABLE_H_

#include <nestedroomactionable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  VehicularActionable: NestedRoomActionable
 */
class VehicularActionable: NestedRoomActionable
    reachable = ([] + self)
    verDoTake(actor) = {
        if (actor.isIn(self))
            "%You%'ll have to get <<self.unboardingPrep>> <<self.theDesc>> first.";
        else
            pass verDoTake;
    }
    dobjGen(a, v, i, p) = {
        if (a.isIn(self) && v != inspectVerb && v != getOutVerb
        && v != outVerb) {
            "%You%'ll have to get <<self.unboardingPrep>> <<
                self.theDesc>> first. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if (a.isIn(self) && v != putVerb) {
            "%You%'ll have to get <<self.unboardingPrep>> <<
                self.theDesc>> first. ";
            exit;
        }
    }
;

#pragma C-

#endif /* _VEHICULAR_ACTIONABLE_H_ */
