////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: commonAncestor() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _COMMON_ANCESTOR_T_
#define _COMMON_ANCESTOR_T_

#include <parent.t>

#pragma C+

/*
 *  commonAncestor: function(o1, o2)
 *
 *  Find the nearest object indirectly containing o1 and o2,
 *  or return nil if there is no common ancestor.
 */
commonAncestor: function(o1, o2) {
    local i, j;
    i = o1;
    while (i != nil) {
        j = o2;
        while (j != nil) {   
            if (j == i) 
                return i;
            j = parent(j);
        }
        i = parent(i);
    }
    return nil;
}

#pragma C-

#endif /* _COMMON_ANCESTOR_T_ */
