////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: story 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _STORY_T_
#define _STORY_T_

#include <clock.h>
#include <inputline.t>
#include <scorestatus.t>
#include <turncount.t>
#include <queue.t>

#pragma C+

story: object
    altVersion = "2.1.3"
    dispBeginDesc = "<B>"
    dispEndDesc = "</B>"
    main(fname) = {
        if (fname) {
            /* perform common initializations */
            self.initCommon;
            
            self.restoreIntroduction;

            /* go restore the game in the normal way */
            self.mainRestore(fname);
        } else {
            self.initCommon;
            "<<self.introduction>>\b";
            self.dispBeginDesc;
            "<<self.title>>\n";
            self.dispEndDesc;
            "<<self.headline>>\n";
            "<<self.versionDesc>>\n";
            
            // start daemons, fuses, and gameClock
            self.initDaemon;
            
            self.initialize;
        }
    }
    title = ""
    headline = ""
    startingLocation = nil
    introduction = ""
    initialize = {
        // move player to initial location    
        parserGetMe().moveInto(self.startingLocation);

        // show player where he is  
        execCommand(parserGetMe(), lookVerb);
        parserGetMe().location.isSeen = true;
        queue.processQueue;
        scoreStatus(0,0);
    }
    initCommon = { "\H+"; }
    initDaemon = {
        notify(queue, &processQueue, 0);    
        setdaemon(turnCount, nil);                 // start the turn counter daemon
        setdaemon(sleepDaemon, nil);                      // start the sleep daemon
        setdaemon(eatDaemon, nil);                       // start the hunger daemon
        gameClock.setClock('5:00 am', 5, 1887, 6, 17);        
    }
    versionDesc = { 
        "Release <<say(self.release)>> / 
        Serial number <<self.serial>>\n
        Alt Library Version <<self.altVersion>>\b";
    }
    release = 1
    serial = ''
    /*
     *  This method sets the serial number as a 6-digit string with
     *  format yymmdd based on the system time.
     */
    setSerial = {
        local s = gettime(GETTIME_DATE_AND_TIME);
        local y, m, d;
        
        y = s[1];
        m = s[2];
        d = s[3];
        
        y *= 10000;
        m *= 100;
        
        self.serial = substr(cvtstr(y+m+d), 3, 6);     
    }
    restoreIntroduction = {

            /* tell the player we're restoring a game */
            "\b[Restoring saved position...]\b";
    }
    mainRestore(fname) = {
        /* try restoring the game */
        switch(restore(fname))
        {
        case RESTORE_SUCCESS:
            /* update the status line */
            scoreStatus(global.score, global.turnsofar);

            /* tell the user we succeeded, and show the location */
            "Restored.\b";
            parserGetMe().location.lookAround(true);
        
            /* success */
            return true;

        case RESTORE_FILE_NOT_FOUND:
            "The saved position file could not be opened. ";
            return nil;

        case RESTORE_NOT_SAVE_FILE:
            "This file does not contain a saved game position. ";
            return nil;

        case RESTORE_BAD_FMT_VSN:
            "This file was saved by another version of TADS that is
            not compatible with the current version. ";
            return nil;

        case RESTORE_BAD_GAME_VSN:
            "This file was saved by a different game, or a different
            version of this game, and cannot be restored with this game. ";
            return nil;

        case RESTORE_READ_ERROR:
            "An error occurred reading the saved position file; the file
            might be corrupted.  The game might have been partially restored,
            which could make it impossible to continue playing; if the game
            does not seem to be working properly, you should quit the game
            and start over. ";
            return nil;

        case RESTORE_NO_PARAM_FILE:
            /* 
             *   ignore the error, since the caller was only asking, and
             *   return nil 
             */
            return nil;

        default:
            "Restore failed. ";
            return nil;
        }
    }
    /*
     *  deathMessage() is called when the player wins or dies.  It tells the
     *  player how well he has done (with his score), and asks if he'd
     *  like to start over (the alternative being quitting the game).
     *
     *  The method can be passed a parm. If the parm is true then the
     *  method displays "won"; if false the method displays "died"; if
     *  the parm is a single-quoted string then it is displayed.
     */
    deathMessage(...) = {
        local parm;
        
        if (argcount == 1) parm = getarg(1);
        
        if (datatype(parm) == DTY_SSTRING)
            say(parm);
        else if (parm == true)
            "\b*** You have won ***\b";
        else 
            "\b*** You have died ***\b";

        scoreRank();
        self.queryContinue;
    }
    queryContinue = {
        "\bYou may restore a saved game, start over, quit, or undo
        the current command.\n";
        while (true) {
            local resp;

            "\nPlease enter RESTORE, RESTART, QUIT, or UNDO: >";
            resp = upper(inputLine());
            if (resp == 'RESTORE') {
                resp = askfile('File to restore',
                                ASKFILE_PROMPT_OPEN, FILE_TYPE_SAVE);
                if (resp == nil)
                    "Restore failed. ";
                else if (restore(resp))
                    "Restore failed. ";
                else {
                    parserGetMe().location.lookAround(true);
                    scoreStatus(global.score, global.turnsofar);
                    abort;
                }
            } else if (resp == 'RESTART') {
                scoreStatus(0, 0);
                restart();
            } else if (resp == 'QUIT') {
                self.terminate;
                quitGame();
                abort;
            } else if (resp == 'UNDO') {
                if (undo()) {
                    "(Undoing one command)\b";
                    parserGetMe().location.lookAround(true);
                    scoreStatus(global.score, global.turnsofar);
                    abort;
                } else
                    "Sorry, no undo information is available. ";
            }
        }
    }
    /*
     *   The terminate() method is called just before the game ends.  It
     *   generally displays a good-bye message.  The default version does
     *   nothing.  Note that this function is called only when the game is
     *   about to exit, NOT after dying, before a restart, or anywhere else.
     */
    terminate = {}
;

#pragma C-

#endif /* _STORY_T_ */
