/*  Copyright (c) 1998-2000 by TenthStone (John McCall).  All Rights Reserved. */
//  12/15/99 - 233 objects/classes (with ts_std.t)

//  THIS IS A PRERELEASE VERSION OF THIS LIBRARY.  I make no
//  guarantees as per certain features working identically
//  in any final release.  Will notify upon changes.  Please
//  see revision history when updating library version.
//
//  This is a beta release.  If you have suggestions, comments,
//  flames, I'd be happy to accept them all at tenthstone@hotmail.com.
//  Espescially re attempts at standards of capitalisation, I
//  know I've missed places.
//
//  Oh, and yes I'm working on better documentation.
//         TS 8/8/99

//  BOOKMARK writeMenu -> inputdialog() option?
//     messaging -- invisible actors.

Pianosa: versionInfo
    sdesc = "Pianosa advanced adventure definitions"
    ver = "v0.6"
    verdate = "December 18th, 1999"
    bdesc = "\bWritten with the << sdesc >> by TenthStone, << ver >> (<< verdate >>). ";
;

/*  Revision history
      1.0  August 28th, 2000
           'look x' -> 'inspect x'. .locatetree (ts_sense->Pianosa).
           notified (notifiedDaemon, .notification); Me notified
           (ts_std).  daemonDaemon handling: setDaemon, remDaemon.
           ts_funcs: listWithout, sublist, sayValue, listList.
           Added 'for', 'by', 'against' preps. .predthedesc, .subjthedesc.
           menuclass now Menu (ts_std, ts_menu).  doorwayframe.
           .primaryIPos. multilocatefixed. resource(). .wasdesc.
           ts_std: .startAt->parserGetMe().  .ispasttense.  conj(),
           currentX().  conj() -> no %s%, %es%, %y%.  Reorganised
           as documentation updated.
      0.6  December 18th, 1999
           Capitalisation, alphabetization efforts begun.  General
           functions drawn out into ts_funcs.t.  Parameter to contdesc
           properties.  Sense-passing (since it's in fashion) in
           sense.t.  Position template, exec.  Rewrote sense.t.
           cont listings redone somewhat.  Example game moving along,
           which always leads to changes.  The docs are a bit behind
           the times.
      0.5  September 12th, 1999
           Getting stabler.  Ah, right.  Started documentation,
           which always leads to changes.  Have restructured a
           few of the subclasses.  Fixed status lines.  Revised
           ts_menu.t, this file to add unrestricted parameter.
           Reformed object movement: .putInto( taker ),
           .putInto( target ), added .forceInto.  Direction class,
           .uberlocate, versionInfo, aboutVerb.  gacx -> property.
           Position -> obj, not const.
      0.4  August 8th, 1999
           I think it's fairly stable.  I've been wrong before.
           Still pre-release, but I'll release it soon anyway as
           Pianosa.t.  Brought liquid handling in from test
           file (see liquid, liquidcontainer).  Added options
           menu, room-based music system, better HTML support.
      0.3  June 24th, 1999
           Debugging continues.  Implementation of easy-add
           positions today.  This file is called "tscopy.t", but
           it seems to be working.  Have pulled compiler codes
           into seperate file.  May do same with other basic
           elements:  preps, art., cW's, sW, fs.
      0.2  May 8, 1999
           Debugging begins?  Creation of test.t? tsmenu.t?
           macrolibrary?  I don't know.
      0.1  January 1999
           Creation from adv.t as "ts.t"
*//*
    Pianosa.t  - standard adventure definitions for TADS games

    modified from ADV.T v2.2.3 (c) 1988, 1994 Michael J. Roberts
    Generalizes verb handlings.

    Thanks to:
        Michael J. Roberts for TADS.
        Kevin Forchione, Jesse Welton, and Neil K. Guy for
          advice and good ideas that I've unabashedly stolen.
        Other people for pretending to pay attention.
        (insert witty "fundamental force" physics joke here)

    To do:  alphabetize
            macro library
            continue debugging

    Feel free to any inspirations you may take away from this, although
    I ask for any advice you might give me.

    This file serves functions equivalent to ADV.T, and should be
    #included instead of that file.  Including them both may be potentially
    dangerous to the epileptic.

    ts_std.t #includes this file on its own.

    Important changes of immediate concern to your game:
      - read the manual.  Hopefully I'll have written one up, so this
	should not be a problem.  There are many, many differences here.
	Among the more subtle:
      - versionVerb calls version.bdesc instead of version.sdesc.  bdesc
	should be an in-depth description of your game, including author,
	version number.  sdesc should just be the name of the game.
      - The fixes from Steven Granade et al.'s BUGS.T have been
	adapted where applicable.
    To find any other changes, search this file for "(modify)" (no quotes)
      or "(note)".
    
    TenthStone's TADS wishlist, as of September 3, 1999:
	preparseCmdActor:  second argument gives actor word list.
	objwords() for verbs.
	better pronoun handling (redirect isHim/isHer somehow?) for
	    foreign language support
	verb.disambig( list ) right before .validDo checks.
	verb.cantDisambig( list ), before calling player disambiguation.
	dynamic property creation from strings

    removed:
	darkroom (-> room)
	follower (-> Follower, movableActor)
	goToSleep (-> .sleep)
        keyedLockable (-> doorway, Lockcode)
        lockableDoorway (-> doorway, Lockcode)
        seethruItem (-> thing)

    renamed:
        basicNumObj ->                  numObj (no longer a class)
        basicStrObj ->                  strObj (no longer a class)
        beditem ->                      bednested
        buttonItem ->                   buttonthing
        chairitem ->                    chairnested
        clothingItem ->                 clothingitem
        darkTravel() ->                 stumble()
        deepverb ->                     deepVerb
        dialItem ->                     dialthing
        distantItem ->                  distantthing
        eatDaemon ->                    hungerDaemon
        fixeditem ->                    fixedthing
        floatingItem ->                 floatingobject
        fooditem ->                     foodthing
        .in (direction) ->              .enter
        incscore() ->                   addScore()
        .isEquivalent ->                .isequivalent
        .isIn ->                        .isvisiblyin
        itemcnt() ->                    invSpaces
        listcont() ->                   contListing()
        listcontcont() ->               innerContListing()
        lookXxxVerb ->                  lookxxxVerb
        keyItem ->                      keyitem
        Prep ->                         prep
        sayPrefixCount() ->             saynumber()
        scoreRank() ->                  rank()
        scoreStatus() ->                showScore()
        switchItem ->                   switchablething
        sysverb ->                      sysVerb
        theFloor ->                     roomfloor
        transparentItem ->              transparentcontainer
        turncount() ->                  nextTurn()
*/

#pragma C+

#include <ts_codes.t>
#include <ts_funcs.t>

#define __FILES_LIBRARY_NAME Pianosa
#define __FILES_LIBRARY_VERSION 0.6
#define __FILES_LIBRARY_PIANOSA true

compoundWord 'on' 'to' 'onto';
compoundWord 'in' 'to' 'into';
compoundWord 'in' 'between' 'inbetween';
compoundWord 'down' 'in' 'downin';
compoundWord 'down' 'on' 'downon';
compoundWord 'up' 'on' 'upon';
compoundWord 'out' 'of' 'outof';
compoundWord 'off' 'of' 'offof';
compoundWord 'out' 'from' 'outfrom';
compoundWord 'outfrom' 'under' 'outfromunder';
compoundWord 'outfrom' 'behind' 'outfrombehind';
compoundWord 'as' 'well'  'as_well';
compoundWord 'as_well' 'as' 'as_well_as';
compoundWord 'inventory' 'wide' 'inventorywide';
compoundWord 'inventory' 'tall' 'inventorytall';
compoundWord 'i' 'wide' 'inventorywide';
compoundWord 'i' 'tall' 'inventorytall';
compoundWord 'take' 'inventory' 'inventory';

formatstring 'you' fmtYou;
formatstring 'your' fmtYour;
formatstring 'yours' fmtYours;
formatstring 'you\'re' fmtYoure;
formatstring 'youm' fmtYoum;
formatstring 'you\'ve' fmtYouve;
formatstring 'have' fmtHave;
formatstring 'do' fmtDo;
formatstring 'are' fmtAre;
formatstring 'were' fmtWere;
formatstring 'me' fmtMe;
formatstring 'yourself' fmtYourself;    // %You% take%s% it upon %yourself%

specialWords
    'of',
    'and' = 'as_well_as',
    'then' = 'next',
    'all' = 'everything' = 'every',
    'both',
    'but' = 'except' = 'minus',
    'one' = 'thing',
    'ones' = 'things',
    'it' = 'there' = 'that' = 'this',
    'them' = 'those' = 'these',
    'him',
    'her',
    'any' = 'either'
;

//  (modify)  General function list (all available functions have been
//      placed here).
//  removal of unused checkDoor
//  reachablelist, visiblelist to class thing
addScore : function;
aloneContListing : function;    // new
checkReach : function;
conj : function;
contListing : function;
currentActor : function;  // new
currentDobj : function;   // new
currentIobj : function;   // new
currentPrep : function;   // new
currentVerb : function;   // new
daemonDaemon : function;  // new
getPastParticiple : function;   // new
getPastTense : function;  // new
hungerDaemon : function;  // modified
initLibrary : function;   // new
initMultiobject : function;     // new
innerContListing : function;
invCount : function;      // new
invSpaces : function;
isIndistinguishable : function;
nextTurn : function;
notifiedDaemon : function;    // new
parseErrorParam : function;   // new
preinit : function;       // new
preinitAdaptables : function; // new
reactorDaemon : function; // new
remDaemon : function;     // new
sayDirection : function;  // new
setDaemon : function;     // new
showScore : function;
sleepDaemon : function;   // modified
sumBulk : function;
sumWeight : function;
travelProp : function;    // new

//  These functions can be found in ts_funcs.t
execute : function;       // new
gac : function;           // new
gacal : function;         // new
gacil : function;         // new
getIndexList : function;  // new
getOutput : function;     // new
imperative : function;    // new
inputLine : function;
listListing : function;   // new
listWithout : function;   // new
pac : function;           // new
_rand : function;
redirect : function;      // new
resource : function;      // new
sayDate : function;       // new
sayNumber : function;     // modified
sayValue : function;      // new
setHer : function;        // new
setHim : function;        // new
setThem : function;       // new
sublist : function;       // new
tabs : function;          // new

conclude : function;      // These must be provided by your gamefile
die : function;           // (or ts_std.t)
init : function;
initRestart : function;
modifyParseError : function;
pardon : function;
rank : function;
stumble : function;
terminate : function;

#define FIRST_PERSON    1
#define SECOND_PERSON   2
#define THIRD_PERSON    3

#define NEARPAST_TENSE -2
#define PAST_TENSE     -1
#define PRESENT_TENSE   0

/* Functions * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// (modify) calls global.Score (note the capitalisation, suggesting a
//  message).
addScore: function( amount ) {
    global.score += amount;
    global.Score( amount );
    if (not global.hasHTML) showScore( global.score, global.thisturn );
}

// (modify) Lists describealones; returns total describealone count (spaces).
aloneContListing: function( obj, ... ) {
    local pos = In, count = 0, i, j, tot, cur, after, totcount, v;
    local lst;
    switch (argcount) {
      case 3: v = getarg( 3 );
      case 2: pos = getarg( 2 );
    }
    lst = obj.(pos.contProp);
    tot = length( lst );
    for (i = 1; i <= tot; ++i) {
      cur = lst[i];
      if (cur.describealone and not cur.ishidden) {
        totcount = 1;
        if (cur.isequivalent) {
          for (after = 0, j = 1; j <= tot; ++j) {
            if (j != i and isIndistinguishable( cur, lst[j] )) {
              if (j < i) {
                after = nil;
                j = tot;
              }
              else ++after;
            }
          }
          if (after) totcount = after;
          else continue;
        }
        if (totcount > 1) cur.bdesc( totcount );
        else cur.bdesc;
        count++;
      }
    }
    return count;
}

checkReach: function( loc, actor, v, obj ) {
    if (obj == numObj or obj == strObj) return;
    if (actor.isCarrying( obj ) == nil and not obj.isvisiblyin( actor.location )) {
        local lst = loc.reachable, i, len = length( lst );
        for (i = 1; i <= len; ++i) if (obj.isvisiblyin( lst[i] )) return;
        obj.cantReach( actor ); exit;
    }
}

// (modify)
//  conjugate a verb (string, in the infinite form, no 'to') according to
//  the given object's rules.
//  To contract 'to have' or 'to be', use '\'have' and '\'be'.
//  Included nonstandard verbs: 'can' 'cannot' 'may' 'might' 'can\'t'
//  The verb 'to lie', as in 'to lie down', must be passed in as '\'lie'.
//
//  conj() uses the functions getPastTense and getPastParticiple.  getPastTense
//  fails for two verbs: 'to be' and 'to have', because these verbs conjugate
//  differently for different persons.
//
// syntaces:
//  conj( 'be' )        conjugate 'to be' according to currentActor rules.
//  conj( 'be', Mary )  conjugate 'to be' according to Mary's rules.
//  conj( 'be', PAST_TENSE )        conjugate 'to be' according to currentActor
//                      rules, placing the verb one tense behind the norm.
//  conj( 'be', PAST_TENSE, Mary )  conjugate 'to be' according to Mary's
//                      rules, placing the verb one tense behind the norm.
//
//  The helping verbs -- can, cannot, etc. -- require a final parameter when
//  PAST_TENSE is being specified;  this is the proper verb, and allows that
//  verb to be added in if necessary.  Thus:
//  conj( 'can', PAST_TENSE, 'do' ) == ('could do' || 'could have done')
conj: function( v, ... ) {
    local l, ten = PRESENT_TENSE, obj = currentActor();
    switch (argcount) {
      case 3:
        ten = getarg( 2 );
        obj = getarg( 3 );
        break;
      case 2:
        l = getarg( 2 );
        if (datatype( l ) == TYPE_OBJECT) obj = l;
        else ten = l;
    }

    if (obj.ispasttense) {
      if (ten == PAST_TENSE) ten = NEARPAST_TENSE;
      else ten = PAST_TENSE;
    }

    if (v == '\'be') {
      if (ten == NEARPAST_TENSE) return '\'d been';
      if (obj.isplural or obj.grammarperson == SECOND_PERSON) {
        if (ten == PAST_TENSE) return ' were';
        else return '\'re';
      }
      else {
        if (ten == PAST_TENSE) return ' was';
        switch (obj.grammarperson) {
          case FIRST_PERSON: return '\'m';
          case THIRD_PERSON: return '\'s';
        }
      }
    }
    if (v == '\'have') {
      if (ten == NEARPAST_TENSE) return '\'d had';
      if (ten == PAST_TENSE) return '\'d';
      else {
        if (obj.grammarperson != THIRD_PERSON) return '\'ve';
        else return '\'s';
      }
    }

    if (ten == NEARPAST_TENSE) {
      switch (v) {
        case 'cannot': case 'can': case 'can\'t': case 'might': case 'may':
          return getPastParticiple( v ) + ' ' + getPastParticiple( getarg( argcount ) );
        default:
          return 'had ' + getPastParticiple( v );
      }
    }
    
    if (v == 'be') {
      if (ten == NEARPAST_TENSE) return 'had been';
      if (obj.isplural or obj.grammarperson == SECOND_PERSON) {
        if (ten == PAST_TENSE) return 'were';
        else return 'are';
      }
      else {
        if (ten == PAST_TENSE) return 'was';
        switch (obj.grammarperson) {
          case FIRST_PERSON: return 'am';
          case THIRD_PERSON: return 'is';
        }
      }
    }
    if (v == 'have') {
      if (ten == NEARPAST_TENSE) return 'had had';
      if (ten == PAST_TENSE) return 'had';
      else {
        if (obj.grammarperson != THIRD_PERSON) return 'have';
        else return 'has';
      }
    }
        
    if (ten == PAST_TENSE) {
      switch (v) {
        case 'cannot': case 'can': case 'can\'t': case 'might': case 'may':
          if (!obj.ispasttense) return getPastTense( v ) + ' ' + getarg( argcount );
        default:
          return getPastTense( v );
      }
    }
    else if (obj.grammarperson != THIRD_PERSON) return v;
    else if (obj.isplural) return v;
    else {
      local len = length( v );
      local last1 = substr( v, len, 1 );
      local last2 = substr( v, len - 1, 1 );
      
      if (last1 == 's') return (v + 'es');
      if (last1 == 'y') return (substr( v, 1, len - 1 ) + 'ies');
      if (find( [ 'a', 'e', 'i', 'o', 'u' ], last1 )) return (v + 'es');
      if (len >= 3) {
        if (substr( v, len - 2, 3 ) == 'tch') return (v + 'es');
      }
      return v + 's';
    }
}
        
// (modify)
//  optimized for indistinguishables
//  use of idesc
//  supports inventory wide/tall
//  Second argument of relative position (Symbol), default In.
//  optional third passed value of "level" (for inventory tall)
//  Force wide descriptions by passing true as third argument.
//  If no contents: force "nothing" by passing 0 as fourth argument.
//                  force emptysymbol by passing true as fourth argument.
// Defaults:
//  contListing( OBJECT, In, 1, nil );
contListing: function( obj, ... ) {
    local i, count, tot, list, cur, disptot, prefix_count, lev = 1, j, pos = In;
    local v = nil;
    switch( argcount ) {
        case 4: v = getarg( 4 );
        case 3: lev = getarg( 3 );
        case 2: pos = getarg( 2 );
    }
    list = obj.(pos.contProp);
    tot = length( list );
    count = 0;
    disptot = invSpaces( list );
    for (i = 1; i <= tot; ++i) {
        cur = list[i];
        if (cur.islisted) {
            prefix_count = 1;
            if (cur.isequivalent) {
                local after;
                for (after = 0, j = 1; j <= tot; ++j) {
                  if (j != i and list[j].isequivalent) {
                    if (not cur.distinguish( list[j] ) and not list[j].distinguish( cur )) {
                        if (j < i) {
                            after = nil;
                            j = tot;
                        }
                        else ++after;
                    }
                  }
                }
                if (after) prefix_count = after;
                else continue;
            }
            if (global.inventall and lev != true) {
              "\n";
              for (j = 1; j <= lev; ++j) "\t";
            }
            else {
              if (count > 0) {
                if (count + 1 < disptot) ", ";
                else if (count == 1) " and ";
                else ", and ";
              }
            }
            if (prefix_count > 1) {
                sayNumber( prefix_count ); " ";
                cur.pluralidesc;
            }
            else cur.idesc;
            count++;
        }
    }
    if (count == 0) {
      switch (v) {
        case 0: "nothing"; break;
        case true: obj.(pos.emptyProp); break;
      }
    }
}

currentActor: function() {
    return parserGetObj( PO_ACTOR );
}

currentDobj: function() {
    return parserGetObj( PO_DOBJ );
}

currentIobj: function() {
    return parserGetObj( PO_IOBJ );
}

currentPrep: function() {
    return parserGetObj( PO_PREP );
}

currentVerb: function() {
    return parserGetObj( PO_VERB );
}

daemonDaemon: function( parm ) {
    local lst = global.daemonlist, len, cnt = global.daemonlistcount;
    local i, val, n;
    for (n = 1; n <= cnt; ++n) {
      for (i = 1, len = length( lst[n] ); i <= len; ++i) {
        val = lst[n][i];
        switch (datatype( val[1] )) {
          case TYPE_FUNCTION:
            switch (length( val )) {
              case 2: (val[1])( val[2] ); break;
              case 3:
                val[3]--;
                if (val[3] == 0) {
                  lst[n] = listWithout( lst[n], i );
                  (val[1])( val[2] ); break;
                  i--;
                }
            }
            break;
          case TYPE_OBJECT:
            switch (length( val )) {
              case 3: val[1].(val[2])( val[3] ); break;
              case 4:
                val[4]--;
                if (val[4] == 0) {
                  lst[n] = listWithout( lst[n], i );
                  val[1].(val[2])( val[3] ); break;
                  i--;
                }
            }
            break;
        }
      }
    }
    global.daemonlist = lst;
}

getPastParticiple: function( v ) {
    local l;
    switch (v) {
        case 'arise': l = 'arisen'; break;      case 'awake': l = 'awoken'; break;
        case 'be': l = 'been'; break;
        case 'bear': l = 'bourne'; break;       case 'beat': l = 'beaten'; break;
        case 'become': l = true; break;         case 'befall': l = 'befallen'; break;
        case 'begin': l = 'begun'; break;       case 'behold': l = 'beheld'; break;
        case 'bend': l = 'bent'; break;         case 'beseech': l = 'besought'; break;
        case 'bet': l = true; break;            case 'bid': l = ['bidden' 'bade']; break;
        case 'bind': l = 'bound'; break;        case 'bite': l = 'bitten'; break;
        case 'bleed': l = 'bled'; break;        case 'bring': l = 'brought'; break;
        case 'build': l = 'built'; break;       case 'burn': l = ['burnt' nil]; break;
        case 'burst': l = true; break;          case 'buy': l = 'bought'; break;
        case 'can': l = 'could have';           case 'cannot': l = 'could not have'; break;
        case 'can\'t': l = 'couldn\'t have';
        case 'cast': l = true; break;
        case 'catch': l = 'caught'; break;      case 'choose': l = 'chosen'; break;
        case 'cling': l = 'clung'; break;       case 'come': l = true; break;
        case 'cost': l = true; break;           case 'creep': l = 'crept'; break;
        case 'cut': l = true; break;            case 'deal': l = 'dealt'; break;
        case 'dig': l = 'dug'; break;           case 'do': l = 'done'; break;
        case 'draw': l = 'drawn'; break;        case 'dream': l = [nil 'dreamt']; break;
        case 'drink': l = 'drunk'; break;       case 'drive': l = 'driven'; break;
        case 'dwell': l = ['dwelt',nil]; break; case 'eat': l = 'eaten'; break;
        case 'fall': l = 'fallen'; break;       case 'feed': l = 'fed'; break;
        case 'feel': l = 'felt'; break;         case 'fight': l = 'fought'; break;
        case 'find': l = 'found'; break;        case 'flee': l = 'fled'; break;
        case 'fling': l = 'flung'; break;       case 'fly': l = 'flown'; break;
        case 'forbid': l = 'forbidden'; break;  case 'forecast': l = true; break;
        case 'forego': l = 'foregone'; break;   case 'foresee': l = 'foreseen'; break;
        case 'foretell': l = 'foretold'; break; case 'forget': l = 'forgotten'; break;
        case 'forgive': l = 'forgiven'; break;  case 'forsake': l = 'forsaken'; break;
        case 'freeze': l = 'frozen'; break;     case 'get': l = 'gotten'; break;
        case 'give': l = 'given'; break;        case 'go': l = 'gone'; break;
        case 'grind': l = 'ground'; break;      case 'grow': l = 'grown'; break;
        case 'hang': l = 'hung'; break;         case 'have': l = 'had'; break;
        case 'hear': l = 'heard'; break;
        case 'hide': l = 'hidden'; break;          case 'hit': l = true; break;
        case 'hold': l = 'held'; break;         case 'hurt': l = true; break;
        case 'keep': l = 'kept'; break;         case 'kneel': l = 'knelt'; break;
        case 'know': l = 'known'; break;         case 'lay': l = 'laid'; break;
        case 'lead': l = 'led'; break;         case 'leap': l = [nil 'leapt']; break;
        case 'learn': l = [nil 'learnt']; break;case 'leave': l = 'left'; break;
        case 'lend': l = 'lent'; break;         case 'let': l = true; break;
        case '\'lie': l = 'lain'; break;           case 'light': l = [nil 'lit']; break;
        case 'lose': l = 'lost'; break;         case 'make': l = 'made'; break;
        case 'meant': l = 'meant'; break;       case 'meet': l = 'met'; break;
        case 'may': l = 'might have'; break;    case 'might': l = 'might have'; break;
        case 'mistake': l = 'mistaken'; break;   case 'pay': l = 'paid'; break;
        case 'put': l = true; break;            case 'quit': l = true; break;
        case 'read': l = true; break;           case 'rend': l = 'rent'; break;
        case 'rid': l = ['rid','ridden']; break;case 'ride': l = 'rode'; break;
        case 'ring': l = 'rung'; break;         case 'rise': l = 'risen'; break;
        case 'run': l = true; break;
        case 'say': l = 'said'; break;          case 'see': l = 'seen'; break;
        case 'seek': l = 'sought'; break;       case 'sell': l = 'sold'; break;
        case 'send': l = 'sent'; break;         case 'set': l = true; break;
        case 'shake': l = 'shook'; break;       case 'shear': l = 'shorn'; break;
        case 'shed': l = true; break;           case 'shine': l = 'shone'; break;
        case 'shoot': l = 'shot'; break;        case 'shrink': l = 'shrunk'; break;
        case 'shut': l = true; break;           case 'sing': l = 'sung'; break;
        case 'sink': l = 'sunk'; break;         case 'sit': l = 'sat'; break;
        case 'slay': l = 'slewn'; break;        case 'sleep': l = 'slept'; break;
        case 'slide': l = 'slid'; break;        case 'sling': l = 'slung'; break;
        case 'slit': l = true; break;           case 'smell': l = [nil 'smelt']; break;
        case 'speak': l = 'spoken'; break;      case 'speed': l = [nil 'sped']; break;
        case 'spend': l = 'spent'; break;       case 'spill': l = [nil 'spilt']; break;
        case 'spin': l = 'spun'; break;         case 'spit': l = 'spat'; break;
        case 'split': l = true; break;          case 'spread': l = true; break;
        case 'spring': l = 'sprung'; break;     case 'stand': l = 'stood'; break;
        case 'steal': l = 'stolen'; break;      case 'stick': l = 'stuck'; break;
        case 'sting': l = 'stung'; break;       case 'stink': l = 'stunk'; break;
        case 'stride': l = 'strode'; break;     case 'strike': l = 'struck'; break;
        case 'swear': l = 'sworn'; break;       case 'sweep': l = 'swept'; break;
        case 'swim': l = 'swum'; break;         case 'swing': l = 'swung'; break;
        case 'take': l = 'taken'; break;        case 'teach': l = 'tought'; break;
        case 'tear': l = 'torn'; break;         case 'tell': l = 'told'; break;
        case 'think': l = 'thought'; break;     case 'throw': l = 'thrown'; break;
        case 'thrust': l = true; break;         case 'tread': l = 'trod'; break;
        case 'wake': l = 'waken'; break;        case 'waylay': l = 'waylaid'; break;
        case 'wear': l = 'worn'; break;         case 'weave': l = [nil 'woven']; break;
        case 'weep': l = 'wept'; break;         case 'wind': l = 'wound'; break;
        case 'withdraw': l = 'withdrawn'; break;case 'withhold': l = 'withheld'; break;
        case 'withstand': l = 'withstood'; break;   case 'wring': l = 'wrought'; break;
        case 'write': l = 'written'; break;     default: l = nil;
    }
    if (datatype( l ) == TYPE_LIST) l = l[_rand( length( l ) - 1 )];
    if (datatype( l ) == TYPE_SINGLE) return l;
    else if (l == true) return v;
    else if (l == nil) {
        local len = length( v );
        local last1 = substr( v, len, 1 );
        local last2 = substr( v, len - 1, 1 );
        local last3 = substr( v, len - 2, 1 );
        if (last1 == 'e') return (v + 'd');
        if (last1 == 'y') return (substr( v, 1, len - 1 ) + 'ied');
        if (!find( [ 'a', 'e', 'i', 'o', 'u' ], last1 )
            && find( [ 'a', 'e', 'i', 'o', 'u' ], last2 )
            && !find( [ 'a', 'e', 'i', 'o', 'u' ], last3 ))
            return v + last1 + 'ed';
        return v + 'ed';
    }
}

getPastTense: function( v ) {
    local l;
    switch (v) {
        case 'arise': l = 'arose'; break;       case 'awake': l = 'awoke'; break;
        case 'bear': l = 'bore'; break;         case 'beat': l = true; break;
        case 'become': l = 'became'; break;     case 'befall': l = 'befell'; break;
        case 'begin': l = 'began'; break;       case 'behold': l = 'beheld'; break;
        case 'bend': l = 'bent'; break;         case 'beseech': l = 'besought'; break;
        case 'bet': l = true; break;            case 'bid': l = [true 'bade']; break;
        case 'bind': l = 'bound'; break;        case 'bite': l = 'bit'; break;
        case 'bleed': l = 'bled'; break;        case 'bring': l = 'brought'; break;
        case 'build': l = 'built'; break;       case 'burn': l = ['burnt' nil]; break;
        case 'burst': l = true; break;          case 'buy': l = 'bought'; break;
        case 'can': l = 'could'; break;         case 'cannot': l = 'could not'; break;
        case 'can\'t': l = 'couldn\'t'; break;
        case 'cast': l = true; break;
        case 'catch': l = 'caught'; break;      case 'choose': l = 'chose'; break;
        case 'cling': l = 'clung'; break;       case 'come': l = 'came'; break;
        case 'cost': l = true; break;           case 'creep': l = 'crept'; break;
        case 'cut': l = true; break;            case 'deal': l = 'dealt'; break;
        case 'dig': l = 'dug'; break;           case 'do': l = 'did'; break;
        case 'draw': l = 'drew'; break;         case 'dream': l = [nil 'dreamt']; break;
        case 'drink': l = 'drank'; break;       case 'drive': l = 'drove'; break;
        case 'dwell': l = ['dwelt',nil]; break; case 'eat': l = 'ate'; break;
        case 'fall': l = 'fell'; break;         case 'feed': l = 'fed'; break;
        case 'feel': l = 'felt'; break;         case 'fight': l = 'fought'; break;
        case 'find': l = 'found'; break;        case 'flee': l = 'fled'; break;
        case 'fling': l = 'flung'; break;       case 'fly': l = 'flew'; break;
        case 'forbid': l = 'forbade'; break;    case 'forecast': l = true; break;
        case 'forego': l = 'forewent'; break;   case 'foresee': l = 'foresaw'; break;
        case 'foretell': l = 'foretold'; break; case 'forget': l = 'forgot'; break;
        case 'forgive': l = 'forgave'; break;   case 'forsake': l = 'forsook'; break;
        case 'freeze': l = 'froze'; break;      case 'get': l = 'got'; break;
        case 'give': l = 'gave'; break;         case 'go': l = 'went'; break;
        case 'grind': l = 'ground'; break;      case 'grow': l = 'grew'; break;
        case 'hang': l = 'hung'; break;         case 'hear': l = 'heard'; break;
        case 'hide': l = 'hid'; break;          case 'hit': l = true; break;
        case 'hold': l = 'held'; break;         case 'hurt': l = true; break;
        case 'keep': l = 'kept'; break;         case 'kneel': l = 'knelt'; break;
        case 'know': l = 'knew'; break;         case 'lay': l = 'laid'; break;
        case 'lead': l = 'led'; break;         case 'leap': l = [nil 'leapt']; break;
        case 'learn': l = [nil 'learnt']; break;case 'leave': l = 'left'; break;
        case 'lend': l = 'lent'; break;         case 'let': l = true; break;
        case '\'lie': l = 'lay'; break;           case 'light': l = [nil 'lit']; break;
        case 'lose': l = 'lost'; break;         case 'make': l = 'made'; break;
        case 'meant': l = 'meant'; break;       case 'meet': l = 'met'; break;
        case 'may': l = 'might'; break;
        case 'mistake': l = 'mistook'; break;   case 'pay': l = 'paid'; break;
        case 'put': l = true; break;            case 'quit': l = true; break;
        case 'read': l = true; break;           case 'rend': l = 'rent'; break;
        case 'rid': l = true; break;            case 'ride': l = 'rode'; break;
        case 'ring': l = 'rang'; break;         case 'rise': l = 'rose'; break;
        case 'run': l = 'ran'; break;
        case 'say': l = 'said'; break;          case 'see': l = 'saw'; break;
        case 'seek': l = 'sought'; break;       case 'sell': l = 'sold'; break;
        case 'send': l = 'sent'; break;         case 'set': l = true; break;
        case 'shake': l = 'shook'; break;       case 'shear': l = [nil 'shore']; break;
        case 'shed': l = true; break;           case 'shine': l = 'shone'; break;
        case 'shoot': l = 'shot'; break;        case 'shrink': l = 'shrank'; break;
        case 'shut': l = true; break;           case 'sing': l = 'sang'; break;
        case 'sink': l = 'sank'; break;         case 'sit': l = 'sat'; break;
        case 'slay': l = 'slew'; break;         case 'sleep': l = 'slept'; break;
        case 'slide': l = 'slid'; break;        case 'sling': l = 'slung'; break;
        case 'slit': l = true; break;           case 'smell': l = [nil 'smelt']; break;
        case 'speak': l = 'spoke'; break;       case 'speed': l = [nil 'sped']; break;
        case 'spend': l = 'spent'; break;       case 'spill': l = [nil 'spilt']; break;
        case 'spin': l = 'spun'; break;         case 'spit': l = 'spat'; break;
        case 'split': l = true; break;          case 'spread': l = true; break;
        case 'spring': l = 'sprang'; break;     case 'stand': l = 'stood'; break;
        case 'steal': l = 'stole'; break;       case 'stick': l = 'stuck'; break;
        case 'sting': l = 'stung'; break;       case 'stink': l = 'stunk'; break;
        case 'stride': l = 'strode'; break;     case 'strike': l = 'struck'; break;
        case 'swear': l = 'swore'; break;       case 'sweep': l = 'swept'; break;
        case 'swim': l = 'swam'; break;         case 'swing': l = 'swung'; break;
        case 'take': l = 'took'; break;         case 'teach': l = 'tought'; break;
        case 'tear': l = 'tore'; break;         case 'tell': l = 'told'; break;
        case 'think': l = 'thought'; break;     case 'throw': l = 'threw'; break;
        case 'thrust': l = true; break;         case 'tread': l = 'trod'; break;
        case 'wake': l = 'woke'; break;         case 'waylay': l = 'waylaid'; break;
        case 'wear': l = 'wore'; break;         case 'weave': l = [nil 'wove']; break;
        case 'weep': l = 'wept'; break;         case 'wind': l = ' wound'; break;
        case 'withdraw': l = 'withdrew'; break; case 'withhold': l = 'withheld'; break;
        case 'withstand': l = 'withstood'; break;   case 'wring': l = 'wrought'; break;
        case 'write': l = 'wrote'; break;       default: l = nil;
    }
    if (datatype( l ) == TYPE_LIST) l = l[_rand( length( l ) - 1 )];
    if (datatype( l ) == TYPE_SINGLE) return l;
    else if (l == true) return v;
    else if (l == nil) {
        local len = length( v );
        local last1 = substr( v, len, 1 );
        local last2 = substr( v, len - 1, 1 );
        local last3 = substr( v, len - 2, 1 );
        if (last1 == 'e') return (v + 'd');
        if (last1 == 'y') return (substr( v, 1, len - 1 ) + 'ied');
        if (!find( [ 'a', 'e', 'i', 'o', 'u' ], last1 )
            && find( [ 'a', 'e', 'i', 'o', 'u' ], last2 )
            && !find( [ 'a', 'e', 'i', 'o', 'u' ], last3 ))
            return v + last1 + 'ed';
        return v + 'ed';
    }
}

// (modify) the first appearance of these functions in this file.  I thought
//  it appropriate; it allows me to bind the actions closer into the library.
hungerDaemon: function( parm ) {
    local a, o;
    for (o = firstobj( movableActor ); o; o = nextobj( movableActor, o )) {
      if (o.hashunger) {
        o.hungryTime++;
        o.Hungry(o.hungerTime - o.hungryTime);
      }
    }
}

// (modify) Call this routine from init, or from commonInit, or whatever.
initLibrary: function {
    local n = global.daemonlistcount;
    global.daemonlist = [];
    for (; n > 0; n--) global.daemonlist += [[]];
    setdaemon( daemonDaemon, nil );
    setDaemon( nextTurn, nil, true );
    setDaemon( reactorDaemon, nil, 1 );
    setDaemon( notifiedDaemon, nil, 2 );
    initMultiobject();
}

initMultiobject: function {
    local o = firstobj( multiobject );
    while (o) {
        if (o.ismultiobject) o.create;
        o = nextobj( multiobject, o );
    }
}

// (modify)  Likewise as with contListing.  Lists all contents of all
//  objects within an object's contents;  uses .listallcontents.
//  .listallcontcontents is normally the correct function to be called.
//  The optional fourth argument specifies whether the emptysymbol
//  messages should be displayed.
innerContListing: function( obj, ... ) {
    local list, i, lev = 2, pos = In, tot, v = nil;
    if (argcount > 3) v = getarg( 4 );
    if (argcount > 2) lev = getarg( 3 );
    if (argcount > 1) pos = getarg( 2 );
    list = obj.(pos.contProp);
    for (i = 1, tot = length( list ); i <= tot; ++i)
        list[i].listallcontents( lev, v );
}

// (modify)
//  invSpaces returns how many entries will appear in an inventory list.
//  invCount, however, merely returns however many objects there are in the
//    inventory list that should be listed.  Compare:
//      (1) invCount is marginally quicker, because it doesn't even check
//          obj.isequivalent;  the difference becomes much greater when
//          there are identical objects in the game.  If you're just
//          checking to see if there's anything at all visible inside X
//          object, use invCount. 
//      (2) invCount determines how many objects are being referred in the
//          contents list.  invSpaces determines how many inventory slots
//          said contents will occupy.  An inventory slot is a space in an
//          inventory;  e.g. 'the Martian and her three human slaves' has two
//          inventory slots, but refers to four objects.
invCount: function( list ) {
    local cnt = 0, tot = length( list ), i;
    for (i = 1; i <= tot; ++i) {
        if (list[i].islisted) cnt += list[i].objcount;
    }
    return cnt;
}

invSpaces: function( list ) {
    local cnt, tot, i, obj, j;
    tot = length( list );
    for (i = 1, cnt = 0; i <= tot; ++i) {
        obj = list[i];
        if (obj.islisted) {
            if (obj.isequivalent) {
                for (j = i + 1; j <= tot; ++j) {
                    if (isIndistinguishable( obj, list[j] )) goto skip_it;
                }
            }
            ++cnt;
            skip_it:
        }
    }
    return cnt;
}

isIndistinguishable: function( obj1, obj2 ) {
    return (firstsc( obj1 ) == firstsc( obj2 )
            and obj1.isworn == obj2.isworn
            and obj1.islamp == obj2.islamp
            and (obj1.islamp ? obj1.islit == obj2.islit : true));
}

nextTurn: function( parm ) {
    incturn();
    global.thisturn++;
    showScore( global.score, global.thisturn );
}

// (modify) 
notifiedDaemon: function( o ) {
    for (o = firstobj( notified ); o; o = nextobj( o, notified ))
        o.notification;
}

// (modify)
parseErrorParam: function( err, str, ... ) {
    local c;
    switch (argcount) {
      case 2: c = modifyParseError( err, str ); break;
      case 3: c = modifyParseError( err, str, getarg( 3 ) ); break;
      case 4: c = modifyParseError( err, str, getarg( 3 ), getarg( 4 ) ); break;
      case 5: c = modifyParseError( err, str, getarg( 3 ), getarg( 4 ), getarg( 5 ) ); break;
      case 6: c = modifyParseError( err, str, getarg( 3 ), getarg( 4 ), getarg( 5 ), getarg( 6 ) ); break;
    }
    if (c == TYPE_LIST) return c[1];
    switch (err) {
      case PRSERR_DONT_SEE_ANY: return getOutput(parserGetMe,&fmtYou)+' '+conj('do',parserGetMe)+'n\'t see any '+getarg(3)+' '+(parserGetMe.ispasttense?'around':'here')+'. ';
      case PRSERR_ONE_ACTOR: return getOutput(parserGetMe,&fmtYou)+' '+conj('can',parserGetMe)+' only speak to one person at a time. ';
      case PRSERR_DONT_SEE_REF: case PRSERR_DONT_SEE_ANY2: return getOutput(parserGetMe,&fmtYou)+' '+conj('do',parserGetMe)+'n\'t see that '+(parserGetMe.ispasttense?'around':'here')+'. ';
      case 17: return '(I can\'t find a verb in that sentence.) ';
      case 19: return '(There were words after that command I couldn\'t use.) ';
      case 24: return '(That sentence doesn\'t make any sense.) ';
      case PRSERR_BAD_AGAIN: return getOutput(parserGetMe,&fmtYou)+' '+conj('cannot',parserGetMe)+' do that again. ';
      case PRSERR_NO_MULTI: return '(That can\'t be done with multiple objects.)';
      case PRSERR_ONLY_SEE: return getOutput(parserGetMe,&fmtYou)+' only '+conj('see',parserGetMe)+' %d of those. ';
      case PRSERR_CANT_TALK: return getOutput(parserGetMe,&fmtYou)+' '+conj('can\'t',parserGetMe)+' talk to that. ';
      case PRSERR_DONT_SEE_ANY_MORE: return getOutput(parserGetMe,&fmtYou)+' '+conj('can\'t',parserGetMe)+'n\'t see that '+(parserGetMe.ispasttense?'around':'here')+' anymore. ';
      case PRSERR_DONT_SEE_THAT: return getOutput(parserGetMe,&fmtYou)+' '+conj('can\'t',parserGetMe)+'n\'t see that '+(parserGetMe.ispasttense?'around':'here')+'. ';
      default:
        if (err < 100) return '(' + str + ') ';
        else return nil;
    }
}
        
// (modify)
// From initSearch().
// specialPreinit() is a blank function which can be overridden
//  for sundry positions purposes.
// note that preinit does not check to see whether only one position
//  has been supplied for an object.  Objects cannot be in two places at
//  once!  Their .locate and .position methods will only use the first
//  of the four that is valid.
preinit: function {
    local o, pl, i, len, loc;
    preinitAdaptables();
    pl = global.positionlist;
    len = length( pl );
    specialPreinit();
    global.floatinglist = [];
    for (o = firstobj(); o; o = nextobj( o )) {
        if (o.islamp) global.lamplist += o;
        if (isclass( o, floatingobject )) global.floatinglist += o;
        else {
            for (i = 1; i <= len; ++i) {
                loc = o.(pl[i].locProp);
                if (loc) loc.forceAccept( o, pl[i] );
            }
        }
    }
}

preinitAdaptables: function {
    local lst = gac( Position ), len = length( lst ), i, o, t = 1;
    global.positionlist = [];
    for (i = 1; i <= len; ++i) {        
        o = lst[i];
        o.initposition;
        if (o.position == t) {
            global.positionlist += o;
            lst -= o;
            len--;
            i = 0;
            t++;
        }
    }
    lst = gac( Direction );
    len = length( lst );
    global.directionlist = [];
    for (i = 1; i <= len; ++i) {
        global.directionlist += lst[i];
        global.exitlist += lst[i].dirTravel;
    }
}

reactorDaemon: function( parm ) {
    global.curaloc.notifyReactors( global.curactor, global.curverb, global.curdobj,
        global.curprep, global.curiobj );
}

remDaemon: function( pnt, parm, ... ) {
    local i, j, jlst, jlen, remall = nil;
    local n = global.daemonlistcount, res = [ pnt parm ];
    local rlen, k, tst;
    switch (argcount) {
      case 4:
        res = [ pnt parm getarg( 3 ) ];
        remall = getarg( 4 );
        break;
      case 3:
        if (datatype( pnt ) == TYPE_OBJECT) res = [ pnt parm getarg( 3 ) ];
        else remall = getarg( 3 );
        break;
    }
    rlen = length( res );
    for (i = 1; i <= n; ++i) {
      jlst = global.daemonlist[i];
      jlen = length( jlst );
      for (j = 1; j <= jlen; ++j) {
        if (datatype( jlst[j][1] ) == datatype( res[1] )) {
          tst = 0;
          for (k = 1; k <= rlen; ++k)
            if (jlst[j][k] == res[k]) tst++;
          if (tst == res) {
            jlst = listWithout( jlst, j );
            global.daemonlist[i] = jlst;
            if (not remall) return;
            j--;
            jlen--;
          }
        }
      }
    }
}

sayDirection: function ( dir ) {
    return global.directionlist[find( global.exitlist, dir )].dirNames;
}

setDaemon: function( pnt, parm, ... ) {
    local n = global.daemonlistcount, place = (n / 2) + 1;
    local res = [ pnt parm ];
    switch (argcount) {
      case 4:
        res = [ pnt parm getarg( 3 ) ];
        place = getarg( 4 );
        break;
      case 3:
        if (datatype( pnt ) == TYPE_OBJECT) res = [ pnt parm getarg( 3 ) ];
        else place = getarg( 3 );
        break;
    }
    if (place == true) place = n;
    if (place < 1 or place > n)
      "ERROR: invalid 'place' argument to setDaemon. ";
    else {
      if ((datatype( pnt ) == TYPE_OBJECT and datatype( parm ) == TYPE_PROPERTY)
        or (datatype( pnt ) == TYPE_FUNCTION))
          global.daemonlist[place] += [res];
      else "ERROR: unknown daemon type passed as argument to setDaemon. ";
    }
}
     
showScore: function( points, turns ) {
    setscore( points, turns );
}

// (modify) Now present.
sleepDaemon: function( parm ) {
    local a, o;
    for (o = firstobj( movableActor ); o; o = nextobj( movableActor, o )) {
      if (o.hassleep) {
        o.sleepyTime++;
        a = o.sleepyTime;
        o.Sleepy(o.sleepTime - a);
      }
    }
}

// (modify) for contents.  Containers may determine whether their bulk
//  counts in the summation.
// .totalbulk is a method, usually returning the sum of the .bulk
//  property and the various .classbulks but which compensates for certain
//  special occaisions, such as the usual irrelevance of the bulk of a
//  worn object.
sumBulk: function( l ) {
    local tot, i, c, totbulk = 0;
    if (l == []) return 0;
    for (i = 1, tot = length( l ); i <= tot; ++i) {
        c = l[i];
        totbulk += c.totalbulk;
    }
    return totbulk;
}

// (modify) for contents.  See sumBulk above.
sumWeight: function( l ) {
    local tot, i, c, totweight = 0;
    if (l == []) return 0;
    for (i = 1, tot = length( l ); i <= tot; ++i) {
        c = l[i];
        totweight += c.totalweight;
    }
    return totweight;
}

travelProp: function ( dir ) {
    return global.directionlist[find( global.exitlist, dir )].dirGoDirProp;
}

/* Classes, Part I:  thing-derived * * * * * * * * * * * * * * * * * * * * * */
/* 'object' inheritors */

// (modify) thing
// There are now four different types of locations, extendable by Position objects:
//    Symbol    Cont. Class
//    ------    -----------
//    in        container
//    on        surface
//    under     cover
//    behind    mask
//  The Symbol is used in deriving several useful informations:
// Symbol       (e.g. "In") a preprocessor symbol used with routines such as
//              .putInto.
// .symbol      (e.g. ".in") the location property, parallel to the
//              ADV.T .location property.  These properties are compiled
//              at start into the .uberlocate property (= [ pos obj ]) and never
//              again taken note of.
// .symbolcont  (e.g. ".incont") a property of a containing object parallel
//              to ADV.T's .contents property.
// .routesymbol (e.g. ".routein") a method of an object which should
//              reroute object placement if so desired.  Returns true if
//              placement was rerouted.  Called by .putInto.
// .symbolcontvisible    (e.g. ".incontvisible") a method of an object which
//              returns whether a certain set of contents is visible/hidden.
// .symbolcontreachable  (e.g. ".incontreachable") a method of an object
//              which returns whether a certain set of contents is reachable/
//              shut off.  These last two replace the contentsVisible and
//              contentsReachable of ADV.T.
// .emptysymbol (e.g. ".emptyin") a method of an object which returns a message
//              to the effect of "This is empty".  It should not end in a period.
// .isvisiblyin returns whether an object is around another.  A second property
//  specifies what relationship must exist between the penultimate location
//  and the ultimate:  i.e. if a medallion is in a box which is on a shelf,
//  then medallion.isvisiblyin( shelf ) = true.  medallion.isvisiblyin( shelf, On ) = true.
//  medallion.isvisiblyin( shelf, Behind ) = nil.
// .isin tests, like isvisiblyin, whether an object is inside another;  however,
//  .isin does not test whether the object is actually visible to the
//  outer object.  It has the same second optional parameter as .isvisiblyin.
// The "q" property, equal to '.isq' plus the container class name; e.g.
//   .isqcontainer, .isqmask .  A 'q' position does not list its contents in
//   room descriptions.
// .maxweightsymbol (e.g. .maxweightunder): maximum amount of weight
//  sustainable by a certain type of container.  nil == limitless.  Function:
//  maxweightProp.
// .maxbulksymbol (e.g. .maxbulkon): maximum amount of bulk placeable
//  within a certain container.  Function: maxbulkProp.
// .listallcontents is now a method of each object, which calls (after
//  checking) other methods under the system .listsymbolcont.  Each of
//  these methods calls the .symbolcontdesc method, which begins the
//  inventory ('Beneath the desk one can see...').
//  listallcontents-level checking involves making certain the object is
//  not a qclass.  listsymbolcont routines check whether the contents are
//  visible before proceeding, but do not call the emptysymbol messages
//  (for when there is nothing listable in a position) unless the second
//  parameter is true.
// .listcontoninspect determines whether the object should automatically
//  list its contents upon being looked at.
// .allcont returns all members of all of an object's contents lists.
// .allheld, by default, is the same as .allcont.  It should return
//  all objects being held (or worn, etc.)
// .locate finds the location of an object.
// .position finds the relative position of an object.
// genders:
//  ishim == nil, isher == nil:     "it"
//  ishim == true, isher == nil:    "him", "it"
//  ishim == nil, isher == true:    "her", "it"
//  ishim == true, isher == true:   "him", "her", "it"
//  isthem == true:                "them", "it"
// The formatting strings (those enclosed between percents (%) e.g. %you%)
//  have been modified to work with any "thing", and adjust their values
//  automatically to the above specification.  Their respective properties
//  begin with 'fmt' and the first letter capitalised, as in 'fmtYou'.
// idesc, pluralidesc, and specialdesc:
//  .idesc is the description as it appears in an inventory, as given by
//   contListing.  contListing is used in the "inventory" command, just as in
//   all other automatic object-listings generated by this file.
//  .pluralidesc is the same, but for plural entries (used with objects which
//   are indistinguishable, typically those dynamically spawned)
//  .specialdesc is by default included in idesc displays, and is responsible
//   for the parenthetical observations such as:
//     an old, battered lantern (giving light)
//   It must supply its own space.
// .islisted is now a method.  Do not set it specifically.  Instead, use
//  ishidden (for scenery/items becoming listed as soon as they are taken),
//  and describealone (for items which should receive their own ldesc-
//  independent line in a room desc, a line which appears even when the ldesc
//  does not.  This line is "bdesc", for "brief description".  If ishidden is
//  true, describealone is ignored.
// .cdesc ("cursory description") is called whenever an object is taken.  If
//  it returns true, the take is aborted.
// .istaken now records when an item has been taken/moved sometime in the
//  game.
// .putInto is an extension of .moveInto:  it essentially places the .doTake
//  code into a different method.  Use of thing.putInto( target, position )
//  checks for bulk (failure: target.excessbulk( thing, pos )) and weight
//  (failure: target.excessweight( thing, pos )), and if succesful:
//    calls location.Drop( thing, target )
//    calls thing.Move( target )
//    calls target.Take( thing, target_position )
//    moves thing into target (with the appropriate method)
//    sets .istaken to true.
//  If any of the first three calls returns true, the process aborts.
//  The hope is to use PUT and TAKE in a more coherent design.  .putInto
//  also supports a wide range of routing options.
//  .Grab and .verGrab have not been touched, except to add a second parameter
//  (position).  An optional, third parameter specifies what level of jostle
//  should be passed:  see below.
// .checkdrop is now called with every object, not just clothingItem.
//  It should be called in routines whenever an object is to be moved from
//  one place to another.  It is NOT called by .putInto.
// .pluralizer determines what should be suffixed to make the noun (of the
//  sdesc) plural.
// .objcount determines how many gameworld objects this object refers to;
//  it tests isthem and reports 2 (simplifying the situation) or 1.
//  This property is called by invCount.
// .iart is the indefinite article, such as 'a'.  This is seperated for
//  several reasons, chief among them to ease the use of a method for
//  determining the article and to spare the gratuitous typing involved
//  in redeclaring adesc.  My personal choice for iArt when the primary
//  (sdesc) noun is plural:  'the'.  However, this is inadequate in some
//  situations ('You can see the trees here.'), while 'some' had its own
//  drawbacks ('One cannot read some trees.').  I've gone with the first
//  because it is more likely to be a better choice.
// .dart is the definite article, typically 'the'.
// .Fail is called by .putInto when the moving object .isfixed;  if it returns
//  true, the movement is aborted.
// .jostle( level ) is a mechanism for when an object is "jostled."  It
//  is called on an object on several events:  when the object is
//  specifically moved (or is contained within a like object), when the
//  object is significantly shaken (such as when the player jumps), or
//  when the object is severely shaken (such as a specific "shake" or
//  "throw").  The default response passes the jostle on to all contents,
//  so if you modify this method and wish the jostle passed, be sure to
//  include the line 'pass jostle;' at the end.
// .followlist is a list of objects which should be sent a follow message
//  when the thing is moved (with .moveInto).  The default follow message
//  checks to see:
//      1.  if the thing is currently visible to the follower
//      2.  if destination.isfollowroom
//  and if both are true, puts the follower into the destination and
//  displays the Follow message.  room sets .isfollowroom true, nestedroom
//  sets it nil, and vehicle sets is true again;  therefore, followers will
//  follow the thing into other places or into vehicles, but will not
//  jump into a bed, a chair, or anything else.
// .isfollowable is not referenced by the .followlist support mechanisms.
//  The "follow" command fails if the direct object has .isfollowable set
//  to nil.
// .isdesc is a shortcut for "the <object> is/are", which is a quite common
//  wording.
// .thatdesc supplies a "that" or "those", accordingly.
// .removePrep takes one argument, the position of some object which the thing
//  contains, and provides the appropriate "out of" preposition.
// .ultimatelocate returns the "ultimate location" of an object by testing
//  whether that object has a location, and then returning the .ultimatelocate
//  property of that object if it does.  The usefulness is for special effects
//  such as vehicles that cannot be seen out of.
// .dropall instructs the object to drop everything it's carrying.
//  If the optional first argument is true (which is the default
//  behaviour), dropall will not drop objects which are being worn.
//  The secondargument can specify a jostle level (default 1).
class thing: object
    // thing attributes
    adesc = "<< self.iart >> << self.sdesc >>"
    bdesc = {
        "There << self.fmtAre >> << self.adesc >> ";
        if (self.locate == global.curactor.locate) "here";
        else "<< self.position.showposition >> << self.locate.predthedesc >>";
        ".";
    }
    behind = nil
    behindcont = []
    behindcontdesc( c ) = ("Behind << self.predthedesc >>", true) 
    behindcontdescafter( c ) = ". "
    behindcontreachable = (self.behindcontvisible)
    behindcontvisible = true
    bulk = 1
    bulkin = {
        if (self.isflexiblecontainer) return (sumBulk( self.incont ));
        else return 0;
    }
    bulkon = 0
    bulkunder = 0
    bulkbehind = 0
    checkdrop = {}
    dart = (self.isproper ? "" : "the" )
    describealone = nil
    Dropped( a ) = ("Dropped. ")
    emptybehind = "There is nothing unusual behind << self.predthedesc >>"
    emptyin = "There is nothing inside << self.predthedesc >>. "
    emptyon = "There is nothing on top of << self.predthedesc >>. "
    emptyunder = "Nothing unexpected can be seen underneath << self.predthedesc >>"
    excessbulk( o, p ) = "\^<< o.subjthedesc >> will not fit << p.showposition >>
        << self.predthedesc >>. "
    excessweight( o ) = "\^<< self.isdesc >> not strong enough to hold
        << o.predthedesc >>. "
    Follow( obj, dest, pos ) = "\^<< self.subjthedesc >> <<conj('follow',self)
        >> << obj.predthedesc >>. "
    followlist = []
    gensdesc = "object"
    genthedesc = "the << self.gensdesc >>"
    genadesc = "an object"
    grammarperson = THIRD_PERSON
    hearNoise( type ) = {}
    iart = (self.isproper ? "" : (self.isthem ? "" : "a"))
    idesc = {
        self.adesc;
        self.specialdesc;
    }
    in = nil
    incont = []
    incontdesc( c ) = "\^<< subjthedesc >> <<conj('seem',self)>> to hold"
    incontdescafter( c ) = ". "
    incontreachable = (self.incontvisible)
    incontvisible = true
    iPos = []
    isaddressable( actor ) = {
        self.isvisible( actor );
    }
    isfollowable = true
    isdesc = "<< self.subjthedesc >> << self.fmtAre >>"
    isdroploc = nil
    isher = nil
    ishidden = nil  // (incidentally, by dropping mere letters, ishidden
                    // could mean anything from "honourable stone" to "bad
                    // electricity" in Japanese.  Something to think about)
    ishim = nil
    islisted = (not (ishidden or describealone))
    ispasttense = (parserGetMe().ispasttense)
    isplural = nil
    isproper = nil
    isqcontainer = nil
    isqcover = nil
    isqmask = nil
    isqsurface = nil
    istaken = nil
    isthem = (self.isplural)
    ldesc = "\^<< fmtYou >> <<conj('appear',self)>> to just be <<
        objcount == 1 ? 'an' : '' >> ordinary << self.sdesc
        >> resting << self.locdesc >>. "
    listcontoninspect = true
    locate = (self.uberlocate[2])
    locdesc = (self.locate ? self.locate.posdesc( self.position ) : "")
    maxbulkbehind = 10
    maxbulkin = 10
    maxbulkon = 10
    maxbulkunder = 10
    maxweightbehind = 10
    maxweightin = 10
    maxweighton = 10
    maxweightunder = 10
    Movearound = "The attempt is futile. "
    multisdesc = (self.sdesc)
    objcount = (self.isthem ? 2 : 1)
    on = nil
    oncont = []
    oncontdesc( c ) = ("On << predthedesc >> ", true)
    oncontdescafter( c ) = ". "
    oncontreachable = (self.oncontvisible)
    oncontvisible = true
    outOfPrep = "out of"
    pluraldesc = "<< self.sdesc >><< self.pluralizer >>"
    pluralidesc = {
        self.pluraldesc;
        self.specialdesc;
    }
    pluralizer = (self.isthem ? "" : "s") // how to pluralize the object ('tree' -> 'trees')
    posdesc( pos ) = "<< self.posPrep( pos ) >> << predthedesc >>"
    position = (self.uberlocate[1])
    posPrep( pos ) = "<< pos.showposition >>"
    predthedesc = (self.thedesc)
    prefixdesc( show, i, cnt, f ) = {
      if (show) self.multidesc;
    }
    primaryIPos = (datatype( iPos ) == TYPE_LIST ? iPos[1] : iPos )
    Put( a, p, o ) = "Done. "
    readdesc = "Nothing intelligible can be taken away from << predthedesc >>. "
    roomdesc = (self.ldesc)
    routebehind( o, j ) = nil
    routein( o, j ) = nil
    routeon( o, j ) = nil
    routeunder( o, j ) = nil
    SELF = { return self; }
    removePrep( p ) = (global.positionlist[p].posRemovePrep)
    specialdesc = {
        if (self.isworn) " (being worn)";
        if (self.islamp and self.islit) " (providing light)";
    }
    subjthedesc = (self.thedesc)
    statusdesc = (self.sdesc)
    statusPrep = "in"
    Taken( a ) = "Taken. "
    thatdesc = (self.isthem ? "those" : "that")
    thedesc = "<< self.dart >> << self.sdesc >>"
    thrudesc = "Nothing can be seen through << self.predthedesc >>. "
    uberlocate = [ nil nil ]
    ultimatelocate = (self.locate != nil ? self.locate.ultimatelocate : self)
    under = nil
    undercont = []
    undercontdesc( c ) = ("Underneath << predthedesc >>", true)
    undercontdescafter( c ) = ". "
    undercontreachable = (self.undercontvisible)
    undercontvisible = true
    validActor = (self.isreachable( parserGetMe() ))
    wasdesc = "<< self.subjthedesc >> << self.fmtWere >>"
    weight = 0
    weightbehind = 0
    weightin = (sumWeight( self.incont ))
    weighton = (sumWeight( self.oncont ))
    weightunder = 0
    
    // thing methods and thing actions
    actorAction( v, d, p, i ) = {
        "Nuts. ";
        // or "What exactly do you expect to result from that? ";
        exit;
    }
    addadjective( lst ) = {
        if (datatype( lst ) == TYPE_LIST) {
            local i, len = length( lst );
            for (i = 1; i <= len; ++i) addword( self, &adjective, lst[i] );
        }
        else addword( self, &adjective, lst );
    }
    addnoun( lst ) = {
        if (datatype( lst ) == TYPE_LIST) {
            local i, len = length( lst );
            for (i = 1; i <= len; ++i) addword( self, &noun, lst[i] );
        }
        else addword( self, &noun, lst );
    }
    addplural( lst ) = {
        if (datatype( lst ) == TYPE_LIST) {
            local i, len = length( lst );
            for (i = 1; i <= len; ++i) addword( self, &plural, lst[i] );
        }
        else addword( self, &noun, lst );
    }
    allcont = {
        local i, pl = global.positionlist, len = length( pl ), l = [];
        for (i = 1; i <= len; ++i) l += self.(pl[i].contProp);
        return l;
    }
    allheld = (self.allcont)
    cantreach( actor ) = {
        if (not actor.isactor) {
            "\^<< actor.subjthedesc >> do<< actor.fmtEs >> not respond.";
            return;
        }
        if (not isclass(actor, movableActor)) {
            "There's no point in talking to << actor.sdesc >>.";
            return;
        }
        if (self.locate == nil) {
            if (actor.locate.locate) actor.locate.cantreachfrom( actor, self );
            else
                "%You% cannot reach that. ";
            return;
        }
        if (not self.locate.isopenable or self.locate.isopen)
            self.locate.cantReach( actor );
        else "\^<< self.locate.subjthedesc >> must be opened first. ";
    }
    cantreachfrom( actor, obj ) = "That cannot be reached from << self.predthedesc >>. "
    circularmessage(io) = {
        local cont = io.locate, p = io.position;

        "\^<< self.subjthedesc >> cannot be put << p.showposition >>
        << io.predthedesc >>, because << io.subjthedesc >> << io.fmtAre >>
        << cont == self ? "already" : "" >> << p.showposition >>
        << cont.predthedesc >>";
        for (; cont != self; p = cont.position, cont = cont.locate) {
            ", which << cont.fmtAre >> << cont.locate == self ? "already " :
            "" >> << p.showposition >> << cont.locate.predthedesc >>";
        }
        ".";
    }
    clearloc = {
        self.uberlocate = [ nil nil ];
    }
    construct = {
        self.putInto( self.locate, self.position );
    }
    deladjective( lst ) = {
        if (datatype( lst ) == TYPE_LIST) {
            local i, len = length( lst );
            for (i = 1; i <= len; ++i) delword( self, &adjective, lst[i] );
        }
        else delword( self, &adjective, lst );
    }
    delnoun( lst ) = {
        if (datatype( lst ) == TYPE_LIST) {
            local i, len = length( lst );
            for (i = 1; i <= len; ++i) delword( self, &noun, lst[i] );
        }
        else delword( self, &noun, lst );
    }
    delplural( lst ) = {
        if (datatype( lst ) == TYPE_LIST) {
            local i, len = length( lst );
            for (i = 1; i <= len; ++i) delword( self, &plural, lst[i] );
        }
        else delword( self, &noun, lst );
    }
    destruct = {
        self.moveInto( nil );
    }
    distinguish( obj ) = {
         return not isIndistinguishable( self, obj );
    }
    dropall( ... ) = {  // bookmark allow specification of position
        local c, pos = In, keepworn = true, i, len, o, j = 1, d;
        switch( argcount ) {
            case 3: j = getarg( 3 );
            case 2: keepworn = getarg( 2 );
            case 1: pos = getarg( 1 );
        }
        c = self.(pos.contProp);
        for (i = 1, len = length( c ); i <= len; ++i) {
            o = c[i];
            if (not (o.isworn and keepworn)) o.dropFrom( self, In, j );
        }
    }
    dropFrom( obj, ... ) = {
        local pos = In, j = 0, l;
        switch (argcount) {
            case 3: j = getarg( 3 );
            case 2: pos = getarg( 2 );
        }
        l = obj.dropping( self, pos );
        self.putInto( l[1], l[2], j );
    }
    dropping( obj, pos ) = {
        if (self.locate and not self.isdroploc) return self.locate.dropping( obj, On );
        else return [ self.SELF On ];
    }
    endPutInto( obj, pos ) = {
        self.mixCont( pos );
    }
    Fail = ("\^<< self.subjthedesc >> << fmtAre >> immobile. ", true)
    follow( obj, dest, ... ) = {
        local pos = In;
        if (argcount >= 3) pos = getarg( 3 );
        if (obj.isvisible( self ) and dest.isfollowroom) {
            self.Follow( obj, dest, pos );
            self.putInto( dest, pos );
        }
    }
    forceAccept( obj, pos ) = {
        obj.uberlocate = [ pos self ];
        self.(pos.contProp) += obj;
    }
    forceInto( obj, ... ) = {
        local pos = In;
        if (argcount > 1) pos = getarg( 2 );
        if (self.locate) self.locate.forceRelease( self );
        if (obj) obj.forceAccept( self, pos );
    }
    forceRelease( obj ) = {
        self.(obj.position.contProp) -= obj;
        obj.clearloc;
    }
    gaca( cls, ... ) = {
        local lst = [], i, pl = global.positionlist, len = length( pl );
        local prop, val = true, parm;
        switch (argcount) {
          case 4: parm = getarg( 4 );
          case 3: val = getarg( 3 );
          case 2: prop = getarg( 2 );
        }
        for (i = 1; i <= len; ++i) {
            if (argcount >= 4) lst += self.(pl[i].gacProp)( cls, prop, val, parm );
            else lst += self.(pl[i].gacProp)( cls, prop, val );
        }
        return lst;
    }
    gacb( cls, ... ) = {
        local prop, val = true, parm;
        switch (argcount) {
          case 4: parm = getarg( 4 );
          case 3: val = getarg( 3 );
          case 2: prop = getarg( 2 );
        }
        if (argcount >= 4) return gacal( cls, self.behindcont, prop, val, parm );
        else return gacal( cls, self.behindcont, prop, val );
    }
    gaci( cls, ... ) = {
        local prop, val = true, parm;
        switch (argcount) {
          case 4: parm = getarg( 4 );
          case 3: val = getarg( 3 );
          case 2: prop = getarg( 2 );
        }
        if (argcount >= 4) return gacal( cls, self.incont, prop, val, parm );
        else return gacal( cls, self.incont, prop, val );
    }
    gaco( cls, ... ) = {
        local prop, val = true, parm;
        switch (argcount) {
          case 4: parm = getarg( 4 );
          case 3: val = getarg( 3 );
          case 2: prop = getarg( 2 );
        }
        if (argcount >= 4) return gacal( cls, self.oncont, prop, val, parm );
        else return gacal( cls, self.oncont, prop, val );
    }
    gacu( cls, ... ) = {
        local prop, val = true, parm;
        switch (argcount) {
          case 4: parm = getarg( 4 );
          case 3: val = getarg( 3 );
          case 2: prop = getarg( 2 );
        }
        if (argcount >= 4) return gacal( cls, self.undercont, prop, val, parm );
        else return gacal( cls, self.undercont, prop, val );
    }
    gacva( cls, ... ) = {
        local lst = [], i, pl = global.positionlist, len = length( pl );
        local prop, val = true, parm;
        switch (argcount) {
          case 4: parm = getarg( 4 );
          case 3: val = getarg( 3 );
          case 2: prop = getarg( 2 );
        }
        for (i = 1; i <= len; ++i) {
          if (self.(pl[i].visProp)) {
            if (argcount >= 4) lst += self.(pl[i].gacProp)( cls, prop, val, parm );
            else lst += self.(pl[i].gacProp)( cls, prop, val );
          }
        }
        return lst;
    }
    Grab( obj, pos ) = {}
    hasclass( cls ) = (isclass( self, cls ))
    inventory( ... ) = {
        local lev = 1, v = nil, ipl = self.iPos, ilen, ipv = true;
        local i, pl = global.positionlist, len;
        switch (argcount) {
          case 3: ipv = getarg( 3 );
          case 2: v = getarg( 2 );
          case 1: lev = getarg( 1 );
        }
        switch (datatype( ipl )) {
          case TYPE_NIL: ipl = []; break;
          case TYPE_OBJECT: ipl = [ ipl ]; break;
        }
        ilen = length( ipl );
        for (i = 1; i <= ilen; ++i) {
          self.(ipl[i].listcontProp)( lev, ipv );
          pl -= ipl;
        }
        len = length( pl );
        for (i = 1; i <= len; ++i)
          if (not self.(pl[i].qProp)) self.(pl[i].listcontProp)( lev, v );
        lev++;
        for (i = 1; i <= ilen; ++i)
             innerContListing( self, ipl[i], lev, v );
        for (i = 1; i <= len; ++i)
             if (not self.(pl[i].qProp)) innerContListing( self, pl[i], lev, v );
    }
    isheldbyactor = {
        if (isclass( NPC, self )) return true;
        if (self.locate) return self.locate.isheldbyactor;
        else return nil;
    }
    isin( obj, ... ) = {
        local myloc = self, pos = nil;
        if (argcount > 1) pos = getarg( 2 );
        while (myloc) {
            if (myloc == obj and imperative( pos != nil, obj.position == pos ))
                return true;
            myloc = myloc.locate;
        }
        return nil;
    }
    isreachable( actor ) = {
        local loc = self.locate, aloc = actor.locate;
        if (find( aloc.reachable, self )) return true;
        if (self == actor or self == aloc) return true;
        if (loc) {
          if (loc == actor or loc == aloc) return true;
          if (loc.(self.position.reachProp))
              return loc.isreachable( actor );
        }
        return nil;
    }
    isvisible( vantage ) = {
        local loc = self, t, vloc = vantage.locate;
        while (loc) {
            if (loc == vantage) return true;
            t = loc.locate;
            if (t == nil) break;
            if (t.(loc.position.visProp)) loc = t;
            else break;
        }
        if (vloc == nil) return nil;
        if (find( vloc.visiblelist, self )) return true;
        if (vloc.(vantage.position.visProp))
            return self.isvisible( vloc );
        return nil;
    }
    isvisiblyin( obj, ... ) = {
        local myloc = self, pos = nil, ult = self.ultimatelocate;
        if (argcount > 1) pos = getarg( 2 );
        while (myloc) {
            if (myloc == obj and imperative( pos != nil, obj.position == pos ))
                return true;
            if (myloc == ult) break;
            if (not myloc.locate.(myloc.position.visProp)) break;
            myloc = myloc.locate;
        }
        return nil;
    }
    jostle( lvl ) = {
        local p, pl = global.positionlist, plen = length( pl );
        local i, lst = self.incont, len = length( lst );
        for (p = 1; p <= plen; ++p) {
          lst = self.(pl[p].contProp);
          for (i = 1, len = length( lst ); i <= len; ++i) lst[i].jostle( lvl );
        }
    }
    listallalonecontents( ... ) = {
        local lev = 1, i, pl = global.positionlist, len = length( pl );
        if (argcount > 0) lev = getarg( 1 );
        for (i = 1; i <= len; ++i) {
          if (not self.(pl[i].qProp)) aloneContListing( self, pl[i], lev );
        }
    }
    listallcontcontents( ... ) = {
        local lev = 2, v = nil;
        local i, pl = global.positionlist, len = length( pl );
        if (argcount > 0) lev = getarg( 1 );
        if (argcount > 1) v = getarg( 2 );
        for (i = 1; i <= len; ++i) {
            if (not self.(pl[i].qProp)) innerContListing( self, pl[i], lev, v );
        }
    }
    listallcontents( ... ) = {
        local lev = 1, v = nil;
        local i, pl = global.positionlist, len = length( pl );
        if (argcount > 0) lev = getarg( 1 );
        if (argcount > 1) v = getarg( 2 );
        for (i = 1; i <= len; ++i) {
            if (not self.(pl[i].qProp)) self.(pl[i].listcontProp)( lev, v );
        }
        self.listallcontcontents( lev + 1, v );
    } 
    listbehindcont( ... ) = {
        local lev = 1, j, v = true, c;
        if (argcount > 1) v = getarg( 2 );
        if (argcount > 0) lev = getarg( 1 );
        self.listXcont( Behind, lev, v );
    }
    listen( sound, spec ) = {
        if (spec) "\^<< self.subjthedesc >> doesn't respond. ";
    }
    listincont( ... ) = {
        local lev = 1, j, v = true, c;
        if (argcount > 1) v = getarg( 2 );
        if (argcount > 0) lev = getarg( 1 );
        self.listXcont( In, lev, v );
    }
    listoncont( ... ) = {
        local lev = 1, j, v = true, c;
        if (argcount > 1) v = getarg( 2 );
        if (argcount > 0) lev = getarg( 1 );
        self.listXcont( On, lev, v );
    }
    listundercont( ... ) = {
        local lev = 1, j, v = true, c;
        if (argcount > 1) v = getarg( 2 );
        if (argcount > 0) lev = getarg( 1 );
        self.listXcont( Under, lev, v );
    }
    listXcont( pos, lev, v ) = {
        local j, c;
        if (not self.(pos.visProp)) return;
        c = invCount( self.(pos.contProp) );
        if (not (c == 0 and v == nil)) {
          if (global.inventall and lev != true) {
            "\n";
            for (j = 1; j < lev; ++j) "\t";
          }
          if (c > 0 or v == 0) {
            j = self.(pos.contdescProp)( c ); " ";
            if (j == true) {
              if (c > 1) "are ";
              else "is ";
            }
          }
          contListing( self, pos, lev, v );
          if (c > 0 or v == 0) self.(pos.contdescafterProp)( c );
        }
    }
    locatetree( obj ) = {
        local loc = self.locate, lst;
        if (self == obj) return self;
        if (loc == nil) return self;
        lst = loc.locatetree( obj );
        return [] + self + self.position + lst;
    }
    mixCont( pos ) = {
        local i, lst = self.(pos.contProp), len = length( lst ), newlist;
        for (i = 1; i <= len; ++i) {
            newlist = lst - lst[i];
            if (newlist) {
                if (lst[i].mixWith( newlist )) {
                    i = 0;
                    lst = self.(pos.contProp);
                    len = length( lst );
                }
            }
        }
    }
    mixWith( lst ) = nil
    moveInto( obj, ... ) = {
        local i, pos = In, len = length( self.followlist ), loc, locpos;
        if (argcount > 1) pos = getarg( 2 );
        for (loc = self.locate; loc; locpos = loc.position, loc = loc.locate)
            if (loc.Grab( self, locpos )) break;
        if (self.locate) {
            for (i = 1; i <= len; ++i)
                followlist[i].follow( self, obj, pos );
        }
        self.forceInto( obj, pos );
    }
    putInto( trgt, ... ) = {
        local totbulk, totweight, pos = In, j = global.jostlePutInto, cp;
        if (argcount > 1) pos = getarg( 2 );
        if (argcount > 2) j = getarg( 3 );
         
        if (self.routePutInto( trgt, pos, j ) == true) return true;
        if (self.isfixed) { if (self.Fail == true) return nil; }
        if (trgt.(pos.routeProp)( self, j ) == true) return true;
        cp = pos.contProp;
        if (trgt.(pos.maxweightProp)) {
          totweight = sumWeight( trgt.cp );
          if (not self.isvisiblyin( trgt ))
            totweight += self.weight + sumWeight( self.cp );
        }
        if (trgt.(pos.maxbulkProp))
          totbulk = sumBulk( trgt.cp ) + self.bulk;
        if (trgt.(pos.maxweightProp) and
          totweight > trgt.(pos.maxweightProp))
            trgt.excessweight( self, pos );
        else if (trgt.(pos.maxbulkProp) and
          totbulk > trgt.(pos.maxbulkProp))
            trgt.excessbulk( self, pos );
        else {
            if (self.locate) {
                if (self.locate.Drop( self, trgt ) == true) return nil;
            }
            if (self.Move( trgt ) == true) return nil;
            if (self.jostle( j ) == true) return nil;
            if (trgt.Take( self, pos ) == true) return nil;
            if (trgt.isheldbyactor) {
                if (self.istaken == nil and trgt.isvisiblyin( parserGetMe() )) {
                    self.istaken = true;
                    self.FirstTake( trgt, pos );
                }
                self.ishidden = nil;
            }
            self.moveInto( trgt, pos );
            trgt.endPutInto( self, pos );
            return true;
        }
        return nil;
    }
    reachlist( a ) = {
        local ret = [], i, lst, len;
        local j, pl = global.positionlist, poslen = length( pl );
        for (j = 1; j <= poslen; ++j) {
            if (self.(pl[j].reachProp)) {
                lst = self.(pl[j].contProp); ret += lst;
                for (i = 1, len = length( lst ); i <= len; ++i)
                    ret += lst[i].reachlist( a );
            }
        }
        return ret;
    }
    routePutInto( trgt, pos, j ) = nil
    sameloc( o ) = {
        local i, lst = global.positionlist, len = length( lst ), p;
        for (i = 1; i <= len; ++i) {
            p = lst[i];
            if (o.(p) != nil and o.(p) == self.(p)) return true;
        }
        return nil;
    }
    Say( a ) = "<q><< self.thedesc >>.</q>"
    sayTo( actor, sound, specificity ) = {
        self.listen( sound, specificity );
    }
    sitDown( actor ) = {
        actor.Sitdown;
    }
    speak( o ) = {
        "\^<< self.subjthedesc >> cannot say anything. ";
        return true;
    }
    speaklist( a ) = {
        self.vislist( a );
    }
    standup( actor ) = {
        actor.Standup;
    }
    totalbulk = {
        local t = self.bulk;
        local i, pl = global.positionlist, len = length( pl );
        if (self.isworn) return 0;
        for (i = 1; i <= len; ++i) t += self.(pl[i].bulkProp);
        return t;
    }
    totalweight = {
        local t = self.weight;
        local i, pl = global.positionlist, len = length( pl );
        for (i = 1; i <= len; ++i) t += self.(pl[i].weightProp);
        return t;
    }
    travelTo( room, ... ) = {
        local pos = On, v = true;
        if (argcount >= 3) v =  getarg( 3 );
        if (argcount >= 2) pos = getarg( 2 );
        if (room) {
          local loc = self.locate;
          if (room.isobstacle) {
            self.travelTo( room.destination( self ), pos, v );
          }
          else {
            if (loc) if (loc.leaveRoom( self, v ) == true) return true;;
            if (self != parserGetMe() and
              loc == parserGetMe().locate and v) self.sayLeaving;
            self.moveInto( room, pos );
            room.enterRoom( self, v );
            if (self != parserGetMe() and
              loc == parserGetMe().locate and v) self.sayArriving;
            if (not room.notfollowroom) self.followedFrom( loc );
          }
        }
    }
    verGrab( obj, pos ) = {}
    verifyremove( actor ) = {
        local loc = self.locate, pos = self.position;
        while (loc) {
            if (loc != actor) loc.verGrab( self, pos );
            else break;
            pos = loc.position;
            loc = loc.locate;
        }
    }
    vislist( a ) = {
        local ret = [], i, lst, len;
        local j, pl = global.positionlist, poslen = length( pl );
        for (j = 1; j <= poslen; ++j) {
            if (self.(pl[j].visProp)) {
                lst = self.(pl[j].contProp); ret += lst;
                for (i = 1, len = length( lst ); i <= len; ++i)
                    ret += lst[i].vislist( a );
            }
        }
        return ret;
    }

    cantReach( actor ) = (self.cantreach( actor ))
    contents = []   // set up automatically
    isHer = (self.isher)
    isHim = (self.ishim)
    isThem = (self.isthem)
    isVisible( v ) = (self.isvisible( v ))
    location = (self.locate)
    locationOK = true
/* Old .position and .locate code (which I've updated to use object positions,
       for some reason, even though I don't use it anymore):
    position = {
        local i, pl = global.positionlist, len = length( pl );
        for (i = 1; i <= len; ++i) if (self.(pl[i].locProp)) return pl[i];
        return nil;
    }
    locate = {
        local i, len = global.totalposition, l = [];
        for (i = 1; i <= len; ++i) if (self.(pl[i].locProp)) return self.(pl[i].locProp);
        return nil;
    }
  Thanks to Jesse Welton for the line of reasoning here.
*/

    // thing verbs
    verIoAskAbout( actor ) = {}
    ioAskAbout( actor, dobj ) = {
        dobj.doAskAbout( actor, self );
    }
    verDoAskAbout( actor, io ) = {
        "\^<< self.subjthedesc >> has nothing in particular to say. ";
    }
    verDoAttackWith( actor, io ) = {
        "Attacking << self.predthedesc >> does not appear productive. ";
    }
    verIoAttackWith( actor ) = {
        "\^<< self.isdesc >> not an especially effective weapon. ";
    }
    ioAttackWith( actor, dobj ) = {
        dobj.doAttackWith( actor, self );
    }
    verDoBreak( actor ) = {}
    doBreak( actor ) = {
        "There are better ways to relieve anger. ";
    }
    verDoClean( actor ) = {
        "\^<< self.subjthedesc >> <<conj('look',actor)>> a bit cleaner. ";
    }
    verDoCleanWith( actor, io ) = {}
    doCleanWith( actor, io ) = {
        "\^<< self.subjthedesc >> <<conj('look',self)>> no different. ";
    }
    verDoDrink( actor ) = {
        "\^<< self.subjthedesc >> <<conj('do',self)>> not appear appetizing. ";
    }
    verDoDrop( actor ) = {
        if (actor.isCarrying( self ) == nil) "%You% %have%n't got << self.predthedesc >>. ";
        else self.verifyremove( actor );
    }
    doDrop( actor ) = { 
        local d = actor.locate.dropping( actor, actor.position );
        self.checkdrop;
        if (self.putInto( d[1], d[2] )) self.Dropped( actor );
    }
    verDoEat( actor ) = {
        "\^<< self.subjthedesc >> does not appear appetizing. ";
    }
    verDoFollow( actor ) = {}
    doFollow( actor ) = {
        if (find( self.followlist, actor )) {
            "\^<< actor.subjthedesc >> <<conj('cease',actor)>> %your% attempts to follow 
            << self.predthedesc >>. ";
            self.followlist -= actor;
        }
        else if (self.isfollowable) {
            "\^<< actor.subjthedesc >> <<conj('keep',actor)>> careful watch over 
            << self.predthedesc >> so that %you% <<conj('may',actor)>> follow <<
            fmtYoum >> if << fmtYou >> <<conj('move',actor)>>. ";
            self.followlist += actor;
        }
        else "\^<< actor.subjthedesc >> cannot follow << self.predthedesc >>. ";
    }
    verDoGiveTo( actor, io ) = {
        if (actor.isCarrying( self ) == nil)
            "%You% <<conj('have',actor)>>n't got << self.predthedesc >>. ";
        else self.verifyremove( actor );
    }
    doGiveTo( actor, io ) = {
        self.checkdrop;
        self.putInto( io );
    }
    verDoHello( actor ) = {}
    doHello( actor ) = {
        execute( self, helloVerb );
    }
    verDoInspect( actor ) = {}
    doInspect( actor ) = {
        self.ldesc;
        if (self.listcontoninspect) self.listallcontents;
    }
    verDoLocation( a ) = {}
    doLocation( a ) = {
        "Object \(<<sdesc>>\) is ";
        if (self.locate) "\(<< self.position.showposition >> <<
            self.locate.sdesc >>\)";
        else "nowhere. ";
        abort;
    }
    verDoLookbehind( actor ) = {}
    doLookbehind( actor ) = {
        self.behinddesc;
        self.listbehindcont( 1, true );
    }
    verDoLookin( actor ) = {
        "%You% cannot see inside << predthedesc >>. ";
    }
    doLookin( actor ) = {
        self.indesc;
        self.listincont( 1, true );
    }
    verDoLookon( actor ) = {}
    doLookon( actor ) = {
        self.ondesc;
        self.listoncont( 1, true );
    }
    verDoLookthru( actor ) = {}
    doLookthru( actor ) = {
        self.thrudesc;
    }
    verDoLookunder( actor ) = {}
    doLookunder( actor ) = {
        self.underdesc;
        self.listundercont( 1, true );
    }
    verDoMove( actor ) = { self.Movearound; }
    verDoMoveE( actor ) = { self.Movearound; }
    verDoMoveN( actor ) = { self.Movearound; }
    verDoMoveS( actor ) = { self.Movearound; }
    verDoMoveW( actor ) = { self.Movearound; }
    verDoMoveNE( actor ) = { self.Movearound; }
    verDoMoveNW( actor ) = { self.Movearound; }
    verDoMoveSE( actor ) = { self.Movearound; }
    verDoMoveSW( actor ) = { self.Movearound; }
    verDoMoveTo( actor, io ) = { self.Movearound; }
    verIoMoveTo( actor ) = {
        "\^<< self.isdesc >> not a valid endpoint. ";
    }
    verDoMoveWith( actor, io ) = { self.Movearound; }
    verIoMoveWith( actor ) = {
        "\^<< self.subjthedesc >> do<< self.fmtEs >> not seem to help. ";
    }
    verDoPlugIn( actor, io ) = {
        "\^<< self.subjthedesc >> cannot be plugged into anything. ";
    }
    verIoPlugIn( actor ) = {
        "Nothing can be plugged into << self.predthedesc >>. ";
    }
    verDoPoke( actor ) = {
        "Poking << self.predthedesc >> does not appear to have any effect. ";
    }
    verDoPull( actor ) = {
        "Attemping to pull << self.predthedesc >> has no effect. ";
    }
    verDoPush( actor ) = {
        "Pressing against "; self.predthedesc; " accomplishes little of value. ";
    }
    verDoPutBehind( actor, io ) = {
        if (io == nil) return;
        if (self.locate == io and self.position == Behind)
            "\^<< subjthedesc >> << fmtAre >> already behind << io.predthedesc >>. ";
        else if (io == self)
            "\^<< self.subjthedesc >> cannot be put behind itself. ";
        else if (io.isvisiblyin( self )) self.circularmessage( io );
        else self.verifyremove( actor );
    }
    doPutBehind( actor, io ) = {
        if (self.cdesc == true) return;
        self.checkdrop;
        if (self.putInto( actor, actor.primaryIPos )) {
            if (self.putInto( io, Behind )) self.Put( actor, Behind, io );
        }
    }
    verIoPutBehind( actor ) = {
        "Nothing can be put behind << self.predthedesc >>. ";
    }
    ioPutBehind( actor, dobj ) = {
         dobj.doPutBehind( actor, self );
    }
    verDoPutIn( actor, io ) = {
        if (io == nil) return;
        if (self.locate == io and self.position == In) {
            "\^<< self.isdesc >> already in << io.predthedesc >>. ";
        }
        else if (io == self)
            "\^<< self.subjthedesc >> cannot be put into << self.fmtYourself >>. ";
        else if (io.isvisiblyin( self )) self.circularmessage( io );
        else self.verifyremove( actor );
    }
    doPutIn( actor, io ) = {
        if (self.cdesc == true) return;
        self.checkdrop;
        if (self.putInto( actor, actor.primaryIPos )) {
            if (self.putInto( io, In )) self.Put( actor, In, io );
            else self.Taken( actor );
        }
    }
    verIoPutIn( actor ) = {
        "%You% cannot put anything into << self.predthedesc >>. ";
    }
    ioPutIn( actor, dobj ) = {
         dobj.doPutIn( actor, self );
    }
    verDoPutOn( actor, io ) = {
        if (io == nil) return;
        if (self.locate == io and self.position == On)
            "\^<< subjthedesc >> << fmtAre >> already on << io.predthedesc >>. ";
        else if (io == self)
            "\^<< subjthedesc >> cannot be put on << fmtYourself >>. ";
        else if (io.isvisiblyin( self )) self.circularmessage( io );
        else self.verifyremove( actor );
    }
    doPutOn( actor, io ) = {
        if (self.cdesc == true) return;
        self.checkdrop;
        if (self.putInto( actor, actor.primaryIPos )) {
            if (self.putInto( io, On )) self.Put( actor, On, io );
        }
    }
    verIoPutOn( actor ) = {
        "There is no appropriate surface on << self.predthedesc >>. ";
    }
    ioPutOn( actor, dobj ) = {
         dobj.doPutOn( actor, self );
    }
    verDoPutUnder( actor, io ) = {
        if (io == nil) return;
        if (self.locate == io and self.position == Under)
            "\^<< subjthedesc >> << fmtAre >> already underneath << io.predthedesc >>. ";
        else if (io == self)
            "\^<< subjthedesc >> cannot be put underneath << fmtYourself >>. ";
        else if (io.isvisiblyin( self )) self.circularmessage( io );
        else self.verifyremove( actor );
    }
    doPutUnder( actor, io ) = {
        if (self.cdesc == true) return;
        self.checkdrop;
        if (self.putInto( actor, actor.primaryIPos )) {
            if (self.putInto( io, Under )) self.Put( actor, Under, io );
        }
    }
    verIoPutUnder( actor ) = {
        "There is no reason to try to put anything below << self.predthedesc >>. ";
    }
    ioPutUnder( actor, dobj ) = {
         dobj.doPutUnder( actor, self );
    }
    verDoRead( actor ) = {
        "\^<< self.adesc >> cannot be read. ";
    }
    doRead( actor ) = {
        self.readdesc;
    }
    verDoRestore( actor ) = {
        "That may not be so easy as one might think. ";
    }
    verDoSave( actor ) = {
        "That may not be so easy as one might think. ";
    }
    verDoSay( actor ) = {}
    doSay( actor ) = {
        if (actor.speak( self )) return;
        Everyone.sayTo( actor, self, nil );
    }
    verIoSayTo( actor ) = {}
    ioSayTo( actor, dobj ) = {
        if (actor.speak( dobj )) return;
        self.sayTo( actor, dobj, true );
    }
    verDoSearch( actor ) = {
        self.verDoLookin( actor );
    }
    doSearch( actor ) = {
        self.doLookin( actor );
    }
    verDoShowTo( actor, io ) = {}
    doShowTo( actor, io ) = {
        if (io != nil) "<< fmtYou >> <<conj('make',self)>> no impression. ";
    }
    verIoShowTo( actor ) = {}
    ioShowTo( actor, dobj ) = {
        "<< dobj.fmtYou >> <<conj('make',self)>> no impression. ";
    }
    verDoTake( actor ) = {
        if (actor.isHolding( self )) "%You% already %have% that. ";
        else self.verifyremove( actor );
    }
    doTake( actor ) = {
        if (actor == parserGetMe()) if (self.cdesc == true) return;
        self.checkdrop;
        if (self.putInto( actor, actor.primaryIPos )) self.Taken( actor );
    }
    verDoTakeOff( actor, io ) = {
        if (io != nil and not self.isvisiblyin( io, On )) {
            "\^<< subjthedesc >> << fmtAre >> not on << io.predthedesc >>. ";
        }
        self.verDoTake( actor );
    }
    doTakeOff( actor, io ) = {
        self.doTake( actor );
    }
    verIoTakeOff( actor ) = {}
    ioTakeOff( actor, dobj ) = {
        dobj.doTakeOff( actor, self );
    }
    verDoTakeOut( actor, io ) = {
        if (io != nil and not self.isvisiblyin( io, In )) 
            "\^<< subjthedesc >> << fmtAre >> not in << io.predthedesc >>. ";
        self.verDoTake( actor );
    }
    doTakeOut( actor, io ) = {
        self.doTake( actor );
    }
    verIoTakeOut( actor ) = {}
    ioTakeOut( actor, dobj ) = {
        dobj.doTakeOut( actor, self );
    }
    verDoTakeOutfrombehind( actor, iobj ) = {
        if (iobj != nil and not self.isvisiblyin( iobj, Behind )) {
            "\^<< subjthedesc >> << fmtAre >> not behind << iobj.predthedesc >>. ";
        }
        self.verDoTake( actor );
    }
    doTakeOutfrombehind( actor, iobj ) = {
        self.doTake( actor );
    }    
    verIoTakeOutfrombehind( actor ) = {}
    ioTakeOutfrombehind( actor, dobj ) = {
        dobj.doTakeOutfrombehind( actor, self );
    }
    verDoTakeOutfromunder( actor, iobj ) = {
        if (iobj != nil and not self.isvisiblyin( iobj, Under )) {
            "\^<< subjthedesc >> << fmtAre >> not under << iobj.predthedesc >>. ";
        }
        self.verDoTake( actor );
    }
    doTakeOutfromunder( actor, iobj ) = {
        self.doTake( actor );
    }
    verIoTakeOutfromunder( actor ) = {}
    ioTakeOutfromunder( actor, dobj ) = {
        dobj.doTakeOutfromunder( actor, self );
    }
    verDoTellAbout( actor, io ) = {
        "\^<< subjthedesc >> listens silently. ";
    }
    verIoTellAbout( actor ) = {}
    ioTellAbout( actor, dobj ) = {
        dobj.doTellAbout( actor, self );
    }
    verDoThrow( actor ) = {
        self.verDoDrop( actor );
    }
    doThrow( actor ) = {
        self.checkdrop;
        self.putInto( actor.locate, On, global.jostleThrow );
    }
    verDoThrowAt( actor, io ) = {
        if (actor.isCarrying( self ) == nil)
            "%You% %have%n't got << predthedesc >>. ";
        else self.verifyremove( actor );
    }
    doThrowAt( actor, io ) = {
        self.checkdrop;
        self.putInto( io.location, On, global.jostleThrow );
        "\^<< fmtYou >> << fmtHave >> no great effect on << io.predthedesc >>. ";
    }
    verIoThrowAt( actor ) = {
        if (actor.isCarrying( self ) != nil)
          "%You% should drop << predthedesc >> first. ";
    }
    ioThrowAt( actor, dobj ) = {
        dobj.doThrowAt( actor, self );
    }
    verDoThrowIn( actor, io ) = {
        if (actor.isCarrying( self ) == nil)
            "%You% %have%n't got << predthedesc >>. ";
        else self.verifyremove( actor );
    }
    verDoThrowTo( actor, io ) = {
        if (actor.isCarrying( self ) == nil) {
            "%You% %have%n't got << predthedesc >>. ";
        }
        else self.verifyremove( actor );
    }
    doThrowTo( actor, io ) = {
        self.doThrowAt( actor, io );
    }
    verIoThrowTo( actor ) = {
        self.verIoThrowAt( actor );
    }
    ioThrowTo( actor, dobj ) = {
        dobj.doThrowTo( actor, self );
    }
    verDoTouch( actor ) = {
        "Touching << predthedesc >> does not appear to have any effect. ";
    }
    verDoTurn( actor ) = {
        "Attempting to turn << predthedesc >> does nothing. ";
    }
    verDoTurnon( actor ) = {
        "There is no obvious way to turn << predthedesc >> on. ";
    }
    verDoTurnoff( actor ) = {
        "There is no obvious way to turn << predthedesc >> off. ";
    }
    verDoTurnTo( actor, io ) = {
        "Attempting to turn << predthedesc >> does nothing. ";
    }
    verIoTurnTo( actor ) = {
        global.Misunderstand;
    }
    verDoTurnWith( actor, io ) = {
        "Attempting to turn << predthedesc >> does nothing. ";
    }
    verDoTypeOn( actor, io ) = {
        global.Misunderstand;
    }
    verDoUnboard( actor ) = {
        if (actor.location != self)
            "%You% %are% not << self.statusPrep >> << predthedesc >>. ";
        else if (self.location == nil) {
            "%You% cannot get out of << predthedesc >>. ";
        }
    }
    doUnboard( actor ) = {
        if (self.fastenitem)
            "%You% <<conj('need',actor)>> to unfasten << self.fastenitem.predthedesc >> first. ";
        else {
            "Very well, %you% %are% no longer << self.statusPrep >>
            << self.predthedesc >>. ";
            actor.travelTo( self.locate, On, nil );
        }
    }
    verDoUnplugFrom( actor, io ) = {
        if (io != nil) "\^<< thatdesc >> << fmtAre >> not plugged into
            << io.predthedesc >>. ";        
    }
    verIoUnplugFrom( actor ) = {
        "That is plugged into << predthedesc >>. ";
    }
    verDoUnwear( actor ) = {
        "You %are%n't wearing << predthedesc >>. ";
    }
    verDoWear( actor ) = {
        "One cannot wear "; self.adesc; ". ";
    }

    fmtAre = (conj( 'be', self ))
    fmtDo = (conj( 'do', self ))
    fmtHave = (conj( 'have', self ))
    fmtMe = { self.thedesc; }
    fmtWere = (self.isthem ? "were" : "was")
    fmtYou = {
      switch (grammarperson) {
        case FIRST_PERSON: if (isplural) "we"; else "I"; break;
        case SECOND_PERSON: "you"; break;
        case THIRD_PERSON:
          if (self.isthem) "they";
          else if (self.isher) "she";
          else if (self.ishim) "he";
          else "it";
      }
    }
    fmtYoum = {
      switch (grammarperson) {
        case FIRST_PERSON: if (isplural) "us"; else "me"; break;
        case SECOND_PERSON: "you"; break;
        case THIRD_PERSON:
          if (self.isthem) "them";
          else if (self.isher) "her";
          else if (self.ishim) "him";
          else "it";
      }
    }
    fmtYour = { 
      switch (grammarperson) {
        case FIRST_PERSON: if (isplural) "our"; else "my"; break;
        case SECOND_PERSON: "your"; break;
        case THIRD_PERSON:
          if (self.isthem) "their";
          else if (self.isher) "her";
          else if (self.ishim) "his";
          else "its";
      }
    }
    fmtYoure = "<<fmtYou>><<conj('\'be',self)>>"
    fmtYours = { 
      switch (grammarperson) {
        case FIRST_PERSON: if (isplural) "ours"; else "mine"; break;
        case SECOND_PERSON: "yours"; break;
        case THIRD_PERSON:
          if (self.isthem) "theirs";
          else if (self.isher) "hers";
          else if (self.ishim) "his";
          else "its";
      }
    }
    fmtYourself = {
      switch (grammarperson) {
        case FIRST_PERSON: if (isplural) "ourselves"; else "myself"; break;
        case SECOND_PERSON: if (isplural) "yourselves"; else "yourself"; break;
        case THIRD_PERSON:
          if (self.isthem) "themselves";
          else if (self.isher) "herself";
          else if (self.ishim) "himself";
          else "itself";
      }
    }
    fmtYouve = "<<fmtYou>><<conj('\'have',self)>>"
; // thing

/* thing inheritors */
//  (modify)
// .routedial specifies which object's setting property should be
//  modified.  See switchablething for more information.
// .settings is a list specifying exactly which settings are acceptable.
// .validsetting determines whether a particular setting is valid or not;  if it is,
//  it should return the value to be assigned to "setting".  Default procedure:
//    IF settings EXISTS,
//      IF value IS IN settings,
//        RETURN THE ELEMENT OF settingsvalues AT THE SAME POINT.
//      IF NOT, AND useonlysettings IS TRUE, RETURN NIL.  OTHERWISE, PROCEED.
//    IF value IS A NUMBER,
//      IF value IS BETWEEN minsetting AND maxsetting, RETURN value.
//    OTHERWISE, RETURN NIL.
//  Example:  if .settings == [ 'black' 'grey' 'gray' 'white' ],
//    .settingsvalues == [ 1 2 2 3 ], .useonlysettings is nil, .minsetting == 1, and
//    .maxsetting == 3, then the player can turn the dial to any of the three values
//    1, 2, or 3.  The player can also type TURN DIAL TO 'BLACK', 'GREY', or 'WHITE'
//    and the dial will know to be turned to position 1, 2, or 3 respectively.
class dialthing: thing
    minsetting = 1
    maxsetting = 10
    setting = 1
    settings = []
    settingsvalues = []
    settingsonly = nil
    ldesc = {
        "\^<< subjthedesc >> can be turned to settings numbered from
        << minsetting >> to << maxsetting >>.  At the moment, << fmtYoure >>
        set to << setting >>. ";
    }
    validsetting( num ) = {
      if (self.settings) {
        local i = find( settings, num );
        if (i) return self.settingsvalues[ i ];
        else if (self.settingsonly) return nil;
      }
      else if (datatype( num ) == TYPE_NUMBER)
        if (num < minsetting or num > maxsetting) return num;
      return nil;
    }
    verDoTurn( actor ) = {}
    doTurn( actor ) = {
        askio( toPrep );
    }
    verDoTurnTo( actor, io ) = {}
    doTurnTo( actor, io ) = {
        local i = (io == strObj or io == numObj ? io.value : io);
        if (self.validsetting( i ) == nil) "No such setting is on << self.predthedesc >>. ";
        else if (self.validsetting( i ) == self.setting)
            "\^<< subjthedesc >> << fmtHave >> already been set
            to << self.setting >>. ";
        else {
            self.setting = numObj.value;
            "\^<< subjthedesc >> now <<conj('read',self)>> << setting >>. ";
        }
    }
;

class fixedthing: thing
    ishidden = true         // should already be described in room ldesc.
    describealone = true    // if it isn't, give it its own line.
    isfixed = true          // item cannot be taken
    verDoTake( actor ) = {
        if (self.isfixed) self.Fail;
        else pass verDoTake;
    }
    verDoTakeOut( actor, io ) = {
        if (self.isfixed) self.Fail;
        else pass verDoTakeOut;
    }
    verDoDrop( actor ) = {
        if (self.isfixed) self.Fail;
        else pass verDoDrop;
    }
    verDoTakeOff( actor, io ) = {
        if (self.isfixed) self.Fail;
        else pass verDoTakeOff;
    }
    verDoTakeOutfromunder( actor ) = {
        if (self.isfixed) self.Fail;
        else pass verDoTakeoutfromunder;
    }
    verDoTakeOutfrombehind( actor ) = {
        if (self.isfixed) self.Fail;
        else pass verDoTakeOutfrombehind;
    }
    verDoMove( actor ) = {
        if (self.isfixed) self.Fail;
        else pass verDoMove;
    }
    verDoThrowAt(actor, iobj) = {
        if (self.isfixed) self.Fail;
        else pass verDoThrowAt;
    }
;

/* fixedthing inheritors */
class buttonthing: fixedthing
    noun = 'button'
    plural = 'buttons'
    isactive = nil
    routebutton = (self.SELF)
    verDoPush( actor ) = {}
    doPush( actor ) = {
      local o = self;
      if (self.routebutton) o = self.routebutton;
      if (o.isactive) o.turnOff;
      else o.turnOn;
    }
    turnOn = {
        self.isactive = true;
        "%You% <<conj('turn')>> << predthedesc >> on. ";
    }
    turnOff = {
        self.isactive = nil;
        "%You% <<conj('turn')>> << predthedesc >> off. ";
    }
;

//  (modify)
// .Error is the standard "That's not important" message, pulled out for
//  convenience's sake.
class decoration: fixedthing
    ldesc = (self.Error)
    dobjGen( a, v, i, p ) = {
        if (v != inspectVerb) {
            self.Error;
            exit;
        }
    }
    Error = "\^<< subjthedesc >> has no importance to <<currentActor.fmtYoum>>."
    iobjGen( a, v, d, p ) = {
        self.Error;
        exit;
    }
;

//  (modify)
// .Error reports that this object is too far away.
class distantthing: fixedthing
    Error = "\^<< isdesc >> too far away. "
    dobjGen( a, v, i, p ) = {
        if (v != inspectVerb) {
            self.Error;
            exit;
        }
    }
    iobjGen( a, v, d, p ) = { 
        self.Error;
        exit;
    }
;

/* thing inheritors (cont.) */
// (modify) All food comments have been delegated to here.
// .Eat upon being eaten.
// .meal is number of meals this can make.
class foodthing: thing
    verDoEat( actor ) = {
        self.verifyremove( actor );
    }
    doEat( actor ) = {
        self.checkdrop;
        if (self.Eat) return;
        global.lastMealTime -= self.foodvalue;
        self.meal--;
        if (self.meal < 1) self.moveInto( nil );
    }
    meal = 1
    Eat = "At least << self.fmtYou >> << self.fmtWere >> good for a snack. "
    foodvalue = (global.hungerTime)
;

/*  item: thing
 *      Serves the purpose of being an accounted-for item, a gameworld
 *  object which can be picked up and carried about.
 *  (note)
 *      In the process of making this distinction, I decided to standardise
 *  class naming somewhat.  For those classes which have historically been
 *  named with the suffix 'item', they will now (for the most part) end
 *  in 'thing' or 'object', depending on which they inherit from.  In some
 *  circumstances, this may... take some getting used to, but I hope it
 *  will eventually serve as a convenience.  I have decided against
 *  aliasing these former classes for this file, but feel free to do so if
 *  you feel that will make your job easier.
 *      Allow me to explain my nomenclature.  In some places, this file may
 *  not seem 'consistent' in its capitalisation.  Please advise me of such
 *  places and I'll see what I can do;  if it's a major class, and it's
 *  Release 1 or later, understand that I'll probably have to leave it alone.
 *    1.  Verb actions are capitalised thusly:
 *        (for two objects)   .verXoVerbIobjprep
 *        (for one object)    .verDoVerb
 *      System-related functions fit here as well, because I can't really alias
 *      them (initRestore, etc.).  This is called "capScheme".
 *    2.  Action routines (e.g. putInto) are capitalised likewise.
 *    3.  Methods, data, and flags are all lowercase.  This is called "capscheme".
 *    4.  Message-printers can either be capscheme or Capscheme.  The latter
 *      implies that the routine can be used as verification.  The former implies
 *      that it's just a plain message.
 *    5.  Objects and class names are completely lowercase with two groups of
 *      exceptions:  Verb is capitalised, and all character objects (Me, NPC, etc.)
 *      are capitalised.
 *    6.  Wheresoever a class/object name appears in another class/object name,
 *      is is capitalised exactly the same way.  Thus fixedthing, darkVerb.
 *    7.  Helper classes are capitalised:  Lockcode.
 *
 *      The seperation of objects into "item" enables an easy way to create
 *  an "OBJECTS" command:  object-loop through item and summarise all those
 *  with .istaken.
 */
class item: thing
;

/* item inheritors */
//  (modify)
// .remove is called to take off the article.
class clothingitem: item
    checkdrop = {
        if (self.isworn) {
            "(Taking off << predthedesc >> first)\n";
            self.remove;
        }
    }
    remove = {
        self.isworn = nil;
    }
    wear = {
        self.isworn = true;
    }
    moveInto( obj, ... ) = {
        if (self.isworn) self.remove;
        pass moveInto;
    }
    verDoWear( actor ) = {
        if (actor.isCarrying( self ) == nil)
            "%You% %do% not have << predthedesc >> on %youm%. ";
        else if (self.isworn)
            "%You% %are% already wearing << predthedesc >>. ";
    }
    doWear( actor ) = {
        if (not (actor.isHolding( self ))) {
            "(taking << predthedesc >> << self.locate.removePrep( self.position ) >>
             << self.locate.predthedesc >>)\n";
             self.putInto( actor );
        }
        "%You% %are% now wearing << predthedesc >>. ";
        self.wear;
    }
    verDoUnwear( actor ) = {
        if (not (actor.isCarrying( self ) != nil and self.isworn))
            "%You% %are% not wearing << predthedesc >>. ";
    }
    doTake(actor) = {
        if (actor.isCarrying( self ) != nil and self.isworn) redirect( actor, removeVerb, self );
        else pass doTake;
    }
    doUnwear( actor ) = {
        "%You% %are% no longer wearing << predthedesc >>. ";
        self.remove;
    }
    doSynonym('Unwear') = 'Unboard'
;

class keyitem: item
    verIoUnlockWith( actor ) = {}
    ioUnlockWith( actor, dobj ) = {
        dobj.doUnlockWith( actor, self );
    }
    verIoLockWith( actor ) = {}
    ioLockWith( actor, dobj ) = {
        dobj.doLockWith( actor, self );
    }
;

/* thing inheritors (cont.) */
class lightsource: thing
    isactive = true
    islamp = true
    islit = (isactive)
    doTurnon( actor ) = {
        local waslit = actor.locate.islit;
        self.isactive = true;
        "%You% <<conj('switch',actor)>> on << predthedesc >>";
        if (actor.locate.islit and not waslit) {
            ", lighting the area.\b";
            actor.locate.enterRoom( actor, true );
        }
        else ".";
    }
;

// (modify) We do not set .isthem to get the desired effect.
class liquid: thing
    weight = 1
    iart = "some"
    isliquid = true
    Error = "\^<< self.sdesc >> cannot be put into that. "
    spill( lvl ) = {
        "\^<< subjthedesc >> <<conj('spill',self)>> out of << locate.predthedesc >>. ";
        self.moveInto( nil );
    }
    routePutInto( trgt, pos, j ) = {
        if (isclass( trgt, liquidcontainer )) {
          if (self.locate) self.locate.putInto( trgt, pos, j );
          else self.Error;
          return true;
        }
    }
    liquidtype = (self.SELF)
    mixWith( lst ) = {
        local typ = self.liquidtype, otyp, i, len = length( lst );
        for (i = 1; i <= len; i++) {
            if (lst[i].isliquid) otyp = lst[i].liquidtype;
            else otyp = lst[i];
            if (typ.mix( self, otyp, lst[i] )) return true;
        }
    }
    mix( obj, w_cls, w_obj ) = nil
;

class readable: thing
    verDoRead( a ) = {}
;

//  (modify)
// .routeswitch specifies which object's isactive property these routines
//  should modify.  Unlike the routeposition proeprties, this is not to
//  perform the actual rerouting.  If the intended object is self,
//  this property should return nil.
class switchablething: thing
    routeswitch = nil
    verDoSwitch( actor ) = {
        if (routeswitch == nil)
            if (not actor.locate.islit) self.verDarkSwitch( actor );
        else routeswitch.verDoSwitch( actor );
    }
    doSwitch( actor ) = {
        if (routeswitch == nil) {
            if (self.isactive) self.turnOff;
            else self.turnOn;
        }
        else routeswitch.doSwitch( actor );
    }
    turnOn = {
        "\^<< self.isdesc >> now on. ";
        self.isactive = true;
    }
    turnOff = {
        "\^<< self.isdesc >> now off. ";
        self.isactive = true;
    }
    verDarkSwitch( actor ) = {
        if (actor.isCarrying( self ) == nil) actor.locate.darkdesc;
    }
    verDoTurnon( actor ) = {
        if (routeswitch == nil) {
            if (not actor.locate.islit) self.verDarkSwitch( actor );
            else if (self.isactive) "\^<< subjthedesc >> << fmtHave >> already
                been turned on. ";
        }
        else routeswitch.verDoTurnon( actor );
    }
    doTurnon( actor ) = {
        if (routeswitch == nil) self.turnOn;
        else routeswitch.doTurnon( actor );
    }
    verDoTurnoff( actor ) = {
        if (routeswitch == nil) {
            if (not actor.locate.islit) self.verDarkSwitch( actor );
            else if (not self.isactive) "\^<< self.isdesc >> already off. ";
        }
        else routeswitch.verDoTurnon( actor );
    }
    doTurnoff( actor ) = {
        if (routeswitch == nil) self.turnOff;
        else routeswitch.doTurnoff( actor );
    }
;

//  (modify)
//  rooms have (by default) no limits on weight or bulk.  darkroom routines
//  have been moved into room.  islit tests whether the light source is
//  visible at all (isvisible) from the room instead of whether it is visible
//  inside the room (isvisiblyin).  leavelist functionality is intact.  
//  Room positions:  On is physically on the floor, In is anywhere else.
//  Actors stand or sit On.
// .roomdesc is the room description (by default equal to ldesc).
// .statusdesc is the room title (by default equal to sdesc).
//  The above properties are seperated from their defaults for the benefit
//  of nestedrooms, which serve both as gameworld objects and locations.
// .darkdesc is the error message printed when the player attempts some sort
//  of action in the dark.
// .darkroomdesc is the room description shown when the room is dark.
// .darkstatusdesc is the room statusdesc shown when the room is dark.
// .cantexit is the default "exit" to the room;  it calls Exitless.
// .Enter is called by enterRoom with the entering actor as its parameter.
// .floorsdesc is the sdesc of the floor.  Usually "floor" or "ground".
// .floorldesc is the description of the floor, called by the roomfloor
//  object as its ldesc.  By default, it lists room.oncont.
// .hasfloor defines whether a location has a floor or not.
// .isinside defines whether the location is inside or outside (at this
//  point, all this affects is whether the room has a floor or a ground)
// .dropping is a byproduct of the difference between dropping an object
//  somewhere and actively putting it on the ground.  It should return
//  the final location where the dropped object should fall in the following
//  format:  [ [location] [position] ].  For some reason (bug?) self cannot
//  be used in this list;  therefore, use self.SELF.
// .isdroploc should return whether an actor dropping objects here should
//  leave them in this room or in this room's location.  If this room does
//  not have a location, this property isn't even considered.
// .travel is the general exit routine;  it receives the actor and
//  the direction property as its arguments and should handle all travel
//  from there.  It is called by the direction verbs, and not by travelTo.
// .darkTravel is the general exit routine for the dark;  it is called by
//  travel.
// .notfollowroom specifies that followers should not attempt to follow
//  actors into this room.
// .issleepable should return whether a room and position can be slept in
//  by a certain actor;  if not, it should say why.
// .actorlist lists every NPC in an actor's location (and deeper) with the
//  parameter .inEveryone set to true, excluding the actor passed.
class room: thing
    ambientlist = nil
    bgambientlist = nil
    darkdesc = "It is too dark to see. "
    darkroomdesc = "It is too dark to see. "
    darkstatusdesc = "In the dark. "
    doesecho = nil
    emptyon = "There is nothing on << self.floorthedesc >> "
    Exitless = "%You% cannot go in that direction. "
    exitlist = (global.exitlist)
    flooradesc = "a << self.floorsdesc >>"
    floorldesc = (self.listoncont)
    floorsdesc = (self.isinside ? "floor" : "ground")
    floorthedesc = "the << self.floorsdesc >>"
    genadesc = "a << self.gensdesc >>"
    gensdesc = (self.isinside ? "room" : "area")
    genthedesc = (self == parserGetMe().locate ? "here" : "the << self.gensdesc >>")
    hasambient = true
    hasbgambient = true
    hasfloor = true
    hasmusic = true
    incontdesc( c ) = "%You% can see "
    iPos = [ In On ]
    isdroploc = true
    isfollowroom = true
    isinside = true
    isroom = true
    isseen = nil
    issleepable( a, pos ) = ("\<<< self.floorthedesc >> is too hard for sleeping. ", nil)
    killoldambient = true
    killoldbgambient = nil
    killoldmusic = nil
    leavelist = []
    lightson = true
    maxbulkin = nil
    maxbulkon = nil
    maxweightin = nil
    maxweighton = nil
    musiclist = nil      // can be a single stirng or a list thereof
    notfollowroom = nil
    oncontdesc( c ) = ("On << self.floorthedesc >> ", true)
    posdesc( p ) = {
        if (p == On) "on << self.floorthedesc >>";
        else pass posdesc;
    }
    reachable = []
    repeatambient = true
    repeatbgambient = true
    repeatmusic = true   // true or a number
    roomdesc = (self.ldesc)
    roomdescafter = "\n\t"  // bookmark
    scoredesc = "<< global.score >>/<< global.thisturn >>"
    sdesc = "room"
    sequenceambient = 'random'
    sequencebgambient = 'random'
    sequencemusic = 'random' // 'random', 'cycle', or 'replace'
    sitloc = nil
    statusdesc = (self.sdesc)
    statusLine = {
        if (global.hasHTML) "<banner id=StatusLine height=previous border>
          <body bgcolor=statusbg text=statustext><b>";
        self.tagdesc;
        if (global.hasHTML) "</b><tab align=right><< self.scoredesc >></banner>";
        else "\n\t";
    }
    tagdesc = (self.islit ? self.statusdesc : self.darkstatusdesc)
    visiblelist = []
    Wait( a ) = (a == parserGetMe() ? "Time passes...\n" : '')

       // room methods and actions
    actorlist( actor ) = {
        local lst, i, newlst = [], loc = actor.ultimatelocate, len;
        lst = loc.gacva( NPC );
        for (i = 1, len = length( lst ); i <= len; ++i) {
            if (lst[i] != actor) {
                if (lst[i].inEveryone) newlst += lst[i];
            }
        }
        return newlst;
    }
    addleavelist( obj ) = {
        self.leavelist = self.leavelist + obj;
    }
    cantexit = {
        if (self.islit) self.Exitless;
        else stumble();
        return nil;
    }
    darkTravel( actor, dir ) = {
        if (self.(travelProp( dir ))( actor ) != true) {
            if (proptype( self, dir ) == TYPE_LIST)
                if ((self.dir)[1].create( (self.dir)[2], self, dir )) return;
            if (self.dir == nil) self.cantexit;
            else if (not self.dir.islit) self.cantexit;
            else actor.travelTo( self.dir );
        }
    }
    dropping( obj, pos ) = {
        if (self.locate and not self.isdroploc)
            return self.locate.dropping( obj, self.position );
        else return [ self.SELF On ];
    }
    echoNoise( type ) = {
        local lst = self.exitlist, i, len = length( lst );
        self.hearNoise( type );
        for (i = 1; i <= len; ++i)
            if (lst[i]) lst[i].hearNoise( type );
        if (self.locate) self.locate.hearNoise( type );
    }
    enterRoom( actor, v ) = {
      if (actor == parserGetMe()) {
        self.Enter;
        self.initSound;
        if (v) self.lookAround( global.verbose or not self.isseen );
        if (self.islit) {
            if (not self.isseen) self.firstseen;
            self.isseen = true;
        }
      }
    }
    hearNoise( type ) = {
        local lst = self.gaca( hearer ), i, len = length( lst );
        for (i = 1; i <= len; ++i)
            if (lst[i]) lst[i].hearNoise( type );
    }
    initAmbient = {
      if (self.killoldambient) "<sound cancel=ambient>";
      if (global.hasambient and self.hasambient) {
        local lst = ambientlist, i, len;
        local optstr = 'layer=ambient sequence=' + sequenceambient + ' repeat=';
        if (repeatambient == true) optstr += 'loop'; else optstr += repeatambient;
        if (lst) {
          if (datatype( lst ) == TYPE_SINGLE) lst = [ lst ];
          len = length( lst );
          for (i = 1; i <= len; ++i) resource( lst[i], optstr );
        }
      }
    }
    initBGAmbient = {
      if (self.killoldbgambient) "<sound cancel=bgambient>";
      if (global.hasbgambient and self.hasbgambient) {
        local lst = bgambientlist, i, len;
        local optstr = 'layer=bgambient sequence=' + sequencebgambient + ' repeat=';
        if (repeatbgambient == true) optstr += 'loop'; else optstr += repeatbgambient;
        if (lst) {
          if (datatype( lst ) == TYPE_SINGLE) lst = [ lst ];
          len = length( lst );
          for (i = 1; i <= len; ++i) resource( lst[i], optstr );
        }
      }
    }
    initMusic = {
      if (self.killoldmusic) "<sound cancel=background>";
      if (global.hasmusic and self.hasmusic) {
        local lst = musiclist, i, len;        
        local optstr = 'layer=background sequence=' + sequencemusic + ' repeat=';
        if (repeatmusic == true) optstr += 'loop'; else optstr += repeatmusic;
        if (lst) {
          if (datatype( lst ) == TYPE_SINGLE) lst = [ lst ];
          len = length( lst );
          for (i = 1; i <= len; ++i) resource( lst[i], optstr );
        }
      }
    }
    initSound = {
        self.initMusic;
        self.initBGAmbient;
        self.initAmbient;
    }
    islit = {
        local rem = global.lamplist, cur, tot = length( rem ), i;
        if (self.lightson) return true;
        for (i = 1; i <= tot; ++i) {
            cur = rem[i];
            if (cur.isvisible( self ) and cur.islit) return true;
        }
        if (self.locate and self.isvisible( self.locate )) return self.locate.islit;
        return nil;
    }
    jump( a ) = {
        "%You% <<conj('leap')>> into the air, but soon <<conj('descend')>>
        to << floorthedesc >>. ";
        a.jostle( global.jostleJump );
    }
    leaveRoom( actor, v ) = {
        local thisobj, i, tot;
        tot = length( self.leavelist );
        for (i = 1; i <= tot; ++i) {
            thisobj = self.leavelist[i];
            if (thisobj.Leaving( actor ))
                self.leavelist = self.leavelist - thisobj;
        }
    }
    lookAround( verbosity ) = {
        "\n"; self.tagdesc; "\n\t";
        if (self.islit) self.nrmLookAround( verbosity );
        else self.darkroomdesc;
    }
    makeNoise( type ) = {
        local lst = self.exitlist, i, len = length( lst );
        self.hearNoise( type );
        for (i = 1; i <= len; ++i) {
            if (self.(lst[i])) {
                if (self.(lst[i]).doesecho) self.(lst[i]).echoNoise( type );
                else self.(lst[i]).hearNoise( type );
            }
        }
        if (self.locate) self.locate.makeNoise( type );
    }
    nrmLookAround( verbosity ) = {
        local cur, i, tot;
        if (verbosity) {
            "\n\t"; self.roomdesc;
            self.listallalonecontents( 1 );
        }
        self.roomdescafter;
        self.inventory( 1, nil, nil );
    }
    notifyPreactors( a, v, d, p, i ) = {
        local l = self.gacva( Preactor ), j, len = length( l );
        global.curactor = a;
        global.curaloc = a.ultimatelocate;
        global.curverb = v;
        global.curdobj = d;
        global.curprep = p;
        global.curiobj = i;   // This information is required by notifyReactors
        l = self.orderPreactorlist( l );
        for (j = 1; j <= len; ++j) l[j].preactorAction( a, v, d, p, i );
    }
    notifyReactors( a, v, d, p, i ) = {
        local l = self.gacva( Reactor ), j, len = length( l );
        l = self.orderReactorlist( l );
        for (j = 1; j <= len; ++j) l[j].reactorAction( a, v, d, p, i );
    }
    orderPreactorlist( lst ) = { return lst; }
    orderReactorlist( lst ) = { return lst; }
    roomAction( a, v, d, p, i ) = {
        if (not self.islit and not v.validInDark( a, d, p, i )) {
            self.darkdesc;
            exit;
        }
        else if (self.locate) self.locate.roomAction( a, v, d, p, i );
        else self.ultimatelocate.notifyPreactors( a, v, d, p, i );
    }
    roomCheck( v ) = {
        if (self.islit or v.isDarkVerb) return true;
        self.darkdesc;
        return nil;
    }
    sitDown( a ) = {
        if (self.sitloc) redirect( a, sitVerb, sitloc );
        else a.Sitdown;
    }
    travel( actor, dir ) = {
        if (self.islit) {
            if (self.(travelProp( dir ))( actor ) != true) {
                if (proptype( self, dir ) == TYPE_LIST)
                    if ((self.dir)[1].create( (self.dir)[2], self, dir )) return;
                if (proptype( self, dir ) == TYPE_PROPERTY) {
                    if (self.(dir) == dir) return;
                    else self.travel( actor, self.(dir) );
                }
                if (self.dir == nil) self.cantexit;
                else actor.travelTo( self.dir );
            }
        }
        else (self.darkTravel( actor, dir ));
    }
;   // room

/* room inheritors */
// (modify)  nestedrooms may now have their own lights.
class nestedroom: room
    flooradesc = (self.locate.flooradesc)
    floorldesc = (self.locate.floorldesc)
    floorsdesc = (self.locate.floorsdesc)
    floorthedesc = (self.locate.floorthedesc)
    isdroploc = nil
    isfollowroom = nil
    ishidden = true
    ldesc = ""
    outOfPrep = "out of"
    statusdesc = "<<self.locate.statusdesc>>, <<self.statusPrep>> <<self.predthedesc>>"
    statusPrep = "in"
    
    initSound = (self.locate.initSound)
    initMusic = (self.locate.initMusic)
    initAmbient = (self.locate.initAmbient)
    initBGAmbient = (self.locate.initAmbient)
    lookAround( verbosity ) = {
        self.tagdesc; "\n\t";
        if (self.islit) {
            self.locate.nrmLookAround( verbosity );
            self.nrmLookAround( verbosity );
        }
        else self.darkroomdesc;
    }
/*  roomAction( actor, v, dobj, prep, io ) = {
        if (dobj != nil and v.doIsTouched( prep ))
            checkReach( self, actor, v, dobj );
        if (io != nil and v.ioIsTouched( prep ))
            checkReach( self, actor, v, io );
        pass roomAction;
    } */
;

/* nestedroom inheritors */
// (modify)  Adapted to use contents, posture.
//  .autoExit   Automatically exits the bed|chair when the player attempts to
//              leave the room in which the bed|chair is located.
//  .removePrepPosture is a special removePrep function which provides the
//              correct preposition given the posture of an actor.
class bednested: fixedthing, nestedroom, surface
    autoExit = nil
    sdesc = "bed"
    statusPrep = "on"
    outOfPrep = "off of"
    removePrepPosture( p ) = "off of"
    notfollowroom = true
    isfixed = true
    reachable = []
    routein( o, j ) = (o.putInto( self, On, j ), true)
    travel( actor, dir ) = {
        if (dir == &out) {
            if (actor.posture != Stand) self.standup( actor );
            else actor.travelTo( self.out, On, nil );
        }
        else {
            if (self.autoExit) {
              if (self.standup( actor ) != true) {
                "\b";
                self.locate.travel( actor, dir );
              }
            }            
            else "%You% <<conj('can',actor)>>
              not go anywhere until %you% <<conj('get',actor)>> <<
              self.removePrepPosture( actor.posture ) >> << predthedesc >>. ";
        }
        return nil;
    }
    out = (self.locate)
    verDoBoard( actor ) = { self.verDoSiton( actor ); }
    doBoard( actor ) = { self.doSiton( actor ); }
    verDoSiton( actor ) = {
        if (actor.on == self and actor.posture == Sit)
            "%You% %are% already seated on << predthedesc >>. ";
    }
    leaveRoom( actor, v ) = {
        actor.posture = Stand;
        pass leaveRoom;
    }
    doSiton( actor ) = {
        "%You% <<conj('sit',actor)>> upon << predthedesc >>. ";
        actor.travelTo( self );
        actor.posture = Sit;
    }
    verDoLieon( actor ) = {
        if (actor.location == self and actor.posture == Lie) {
            "%You% %are% already lying << statusPrep >> << predthedesc >>. ";
        }
    }
    doLieon(actor) = {
        "%You% <<conj('\'lie',actor)>> down upon << predthedesc >>.";
        actor.travelTo( self );
        actor.posture = Lie;
    }
    standup( actor ) = {
        "\^<< actor.subjthedesc >> <<conj('get',actor)
        >> << self.removePrepPosture( actor.posture ) >> << predthedesc >>. ";
        actor.posture = Stand;
        self.travel( actor, &out );
    }
    floorsdesc = (thedesc)
;

roomfloor: bednested, floatingobject
    routein( o, j ) = (o.putInto( self.locate, On, j ), true)
    noun = 'floor' 'ground'
    sdesc = (self.locate.floorsdesc)
    adesc = (self.locate.floorthedesc)  // Conceptual, ergo 'the'
    ldesc = (self.locate.floorldesc)
    statusPrep = "on"
    outOfPrep = "off of"
    locate = {
        local loc = parserGetMe().locate;
        if (loc.hasfloor) return loc;
        else {
          for (; loc; loc = loc.locate)
            if (loc.hasfloor and parserGetMe().isvisible( loc )) return loc;
        }
        return nil;
    }
    position = On
    doSiton( actor ) = {
        "%You% <<conj('sit',actor)>> upon << predthedesc >>. ";
        actor.moveInto( actor.locate, On );
        actor.posture = Sit;
    }
    doLieon( actor ) = {
        self.doSiton( actor );
        actor.posture = Lie;
    }
    ioPutOn( actor, dobj ) = {
        dobj.doDrop( actor );
    }
    ioPutIn( actor, dobj ) = {
        dobj.doDrop( actor );
    }
;

class chairnested: fixedthing, nestedroom, surface
    autoExit = true
    notfollowroom = true
    isfixed = true
    isdroploc = nil
    reachable = []
    outOfPrep = "out of"
    routein( o, j ) = (o.putInto( self, On, j ), true)
    removePrepPosture( p ) = {
        switch (p) {
            case Stand: "off of"; break;
            case Sit: "out of"; break;
            case Lie: "out of"; break;
        }
    }
    travel( actor, dir ) = {
        if (dir == &out) {
            if (actor.posture != Stand) self.standup( actor );
            else actor.travelTo( self.out, On, nil );
        }
        else {
            if (self.autoExit) {
              if (self.standup( actor ) != true) {
                "\b";
                self.locate.travel( actor, dir );
              }
            }            
            else "%You% <<conj('can',actor)>> not go anywhere until %you% <<
              conj('get',actor)>> << self.removePrepPosture( actor.posture )
              >> << predthedesc >>. ";
        }
        return nil;
    }
// There's a bug in .travel() which causes TADS to crash if standup
//  doesn't return anything (i.e. implicitly returns nil).
    out = (self.locate)
    verDoBoard( actor ) = { self.verDoSiton( actor ); }
    doBoard( actor ) = { self.doSiton( actor ); }
    verDoSiton( actor ) = {
        if (actor.on == self and actor.posture == Sit)
            "%You% %are% already seated on << predthedesc >>. ";
    }
    leaveRoom( actor, v ) = {
        actor.posture = Stand;
        pass leaveRoom;
    }
    doSiton( actor ) = {
        "%You% <<conj('sit',actor)>> on << predthedesc >>. ";
        actor.travelTo( self, On, nil );
        actor.posture = Sit;
    }
    verDoLieon( actor ) = {
        "It would not be comfortable to lie down upon << self.adesc >>. ";
    }
    standup( actor ) = {
        "\^<< actor.subjthedesc >> <<conj('get',self)>> <<
        self.removePrepPosture( actor.posture ) >> << predthedesc >>. ";
        actor.posture = Stand;
        self.travel( actor, &out );
        return nil;
    }
;

//  (modify)
// .statusPrep (see nestedroom) functionality extended to here.
// .Error reports that an action cannot be performed while the actor is
//  within the boat.
// .isopen determines whether the vehicle can be seen out of or not; the modification
//  to ultimatelocate does the trick.
class vehicle: nestedroom
    reachable = ([] + self)
    isvehicle = true
    verDoEnter( actor ) = (self.verDoBoard( actor ))
    doEnter( actor ) = (self.doBoard( actor ))
    verDoBoard( actor ) = {
        if (actor.location == self)
            "%You% %are% already << statusPrep >> << predthedesc >>. ";
        else if (actor.isCarrying( self ))
            "%You% cannot enter << predthedesc >> as long as %you% <<conj('carry')>> it. ";
        else if (not self.isopen)
            "%You% cannot enter << predthedesc >> as long as << fmtYoure >> closed. ";
    }
    ultimatelocate = {
        if (not self.isopen) return self;
        else pass ultimatelocate;
    }
    doBoard( actor ) = {
        "Okay, %you% %are% now << statusPrep >> << predthedesc >>. ";
        actor.travelTo( self );
    }
    Exitless = {
        "%You're% not going anywhere until %you% <<conj('get')>> << outOfPrep >>";
          self.predthedesc; ". ";
        return nil;
    }
    out = (self.locate)
    verDoTake( actor ) = {
        if (actor.isvisiblyin( self )) self.Error;
        else pass verDoTake;
    }
    dobjGen( a, v, i, p ) = {
        if (a.isvisiblyin( self ) and v != inspectVerb and v != getOutVerb
            and v != outVerb) {
            self.Error;
            exit;
        }
    }
    iobjGen( a, v, d, p ) = {
        if (a.isvisiblyin( self ) and v != putVerb) {
            self.Error;
            exit;
        }
    }
    Error = "%You% will need to get << outOfPrep >> << predthedesc >> first. ";
;

/* Classes, Part II: container-class-derived * * * * * * * * * * * * * * * * */
/*
    The functionality of the container classes is fairly constant, except for
    one exception with the handling of container.
  
    I have considered off and on putting in a "Beside" contents area, but
    have decided against after some consideration of the work of revising
    the revision again.  It probably wouldn't be any great amount of work,
    though, so it may appear in the next version.                            */

// (modify)
// .isflexiblecontainer specifies whether this container contours its
//  shape to its contents (e.g. its bulk increases with the bulk of its
//  contents).
class container: thing
    maxbulkin = 10
    incontreachable = (self.isopen)
    incontvisible = (self.isopen ? true : (self.istransparent))
    isdroploc = (self.isopen)
    isopen = true
    iscontainer = true
    isqcontainer = nil
    isflexiblecontainer = nil
    verIoPutIn( actor ) = {}
    ioPutIn( actor, dobj ) = {
        dobj.doPutIn( actor, self );        
    }
    verDoLookin( actor ) = {}
;

//  Although this applies only to containers, if someone were
//  designing a record player with a dust cover (an openable surface)
//  the implementation would be easy enough using this code.
class openable: container
    iscloseable = true
    isopen = true
    isopenable = true
    istransparent = nil
    verGrab( obj, pos ) = {
        if (self.isopenable and not self.isopen)
            "%You% will have to open << predthedesc >> first. ";
    }
    ldesc = {
        inherited.ldesc;
        "\^<< isdesc >> << self.isopen ? 'open' : 'closed' >>. ";
    }
    verDoOpen( actor ) = {
        if (self.isopen) "\^<< isdesc >> already open. ";
        else if (not self.isopenable) "\^<< subjthedesc >> cannot be opened. ";
    }
    doOpen( actor ) = {
        self.Open( actor );
        self.open( actor );
    }
    open( a ) = {
        self.isopen = true;
    }
    Open( a ) = {
        if (invCount( incont ) and not self.istransparent) {
            "Opening << predthedesc >> reveals ";
            contListing( self, In, true, 0 ); ". ";
        }
        else "Opened. ";
    }
    verDoClose( actor ) = {
        if (not isopen) "\^<< isdesc >> already closed. ";
        else if (not self.iscloseable) "\^<< subjthedesc >> cannot be closed. ";
    }
    doClose( actor ) = {
        self.Close( actor );
        self.close( actor );
    }
    close( a ) = {
        self.isopen = nil;
    }
    Close( a ) = "Closed. "
    Take( obj, pos ) = {
        if (pos == In and not self.isopen) {
          self.Error;
          return true;
        }
    }
    Error = "\^<< self.isdesc >> closed. "
    verIoPutIn( actor ) = {
        if (not self.isopen) self.Error;
    }
    verDoLookin( actor ) = {
        if (not self.isopen) {
            if (not self.istransparent) "%You% cannot see inside << predthedesc >>. ";
            else self.Error;
        }
    }
;

//  (modify)  keyedLockable -> lockable
//  I want Lockcode to have seniority, so that doOpen and doClose
//  will work with the locking.
class lockable: openable, Lockcode
;

class qcontainer: container
    isqcontainer = true
;

class liquidcontainer: qcontainer
    isqcontainer = (self.holdsliquid)
    holdsliquid = (length( self.incont ) > 0 ? self.incont[1].isliquid : nil)
    specialdesc = {
        inherited.specialdesc;
        if (self.holdsliquid) " containing << self.liquiddesc >>";
    }
    liquidsonly = nil
    liquiddesc = "<< self.incont[1].sdesc >>"
    oneliquidonly = nil
    ioPutIn( actor, dobj ) =  {
        if (liquidsonly and not dobj.isliquid) "\^<< dobj.thatdesc >>
            cannot be put into << self.adesc >>. ";
        else if (oneliquidonly and dobj.isliquid) "There is already
            << liquiddesc >> in << predthedesc >>. ";
        else pass ioPutIn;
    }
    spillsafe = 1
    jostle( lvl ) = {
        if (self.holdsliquid and self.spillsafe != true) {
            if (lvl > spillsafe) {
                local lst = incont, i, len = length( lst );
                for (i = 1; i <= len; ++i)
                    if (lst[i].isliquid) lst[1].spill( lvl );
            }
        }
        else pass jostle;
    }
    verDoDrink( actor ) = {
        if (not self.holdsliquid) pass verDoDrink;
    }
    doDrink( actor ) = {
        redirect( actor, drinkVerb, self.incont[1] );
    }
;

//  (modify)
//      doFollow functionality -> thing.
//      follower functionality <- follower.
//      actordesc -> bdesc.
//  AskAbout calls .askobject with the appropriate object first.  If that
//  returns nil, it then descends into the slippery mess of .askword.
// .hasfollower specifies whether this object is to have an object following
//  it about so that the player may say "Follow X" even when the player has
//  gone.  By default, true;  although these objects can slow the game,
//  they are not created until actor.travelTo is called with a non-nil
//  argument.
// .isCarrying may take a list as an argument;  it returns the first element which
//  is within the movableActor, as it does with single object parameters.
// .isCarryingAll is like isCarrying, but requires that every object in the
//  list (if so passed) be within the movableActor, and returns nil/true.
// .lastMealTime, .hungerTime, .sleepyTime, and .sleepTime are now attached to certain
//  actors.  .hashunger and .hassleep set hunger and sleep methods into action,
//  respectively (if sleepDaemon and hungerDaemon are set, respectively).  Objects must
//  be of class movableActor for any of these to matter.
// .sleepDuration is how long an actor is to stay asleep (if that actor is not
//  parserGetMe()).
// .inventory acts like listallcontents, but without the qcontainer
//  check, and always requests the emptysymbol message for incont.
class movableActor: qcontainer
    actorname = ""
    actorperson = SECOND_PERSON
    bdesc = "\^<< adesc >> << self.fmtAre >> here. "
    bulk = 10
    describealone = true
    disavow = "\^<< subjthedesc >> <<conj('seem',self)>> unimpressed. "
    emptyin = "\^<< fmtYou >> << fmtAre >> carrying nothing. "
    excessbulk( o ) = "%You% %do%n't have enough space to carry << o.predthedesc >>. "
    excessweight( o ) = "%Your% hands cannot carry so much. "
    grammarperson = {
      if (parserGetMe() == self) return actorperson;
      else return THIRD_PERSON;
    }
    hashunger = nil
    hassleep = nil
    hasfollower = true
    hungryTime = (global.hungryTime)
    hungerTime = (global.hungerTime)
    incontdesc( c ) = "\^<< self.fmtYou >> << self.fmtAre >> carrying"
    inEveryone = true
    iPos = In
    isactor = true
    posdesc( p ) = {
        if (p == In) "in << self.possessive >> hands";
        else pass posdesc;
    }
    possessive = (self == parserGetMe() ? self.fmtYour : "<< thedesc >>'s")
    posture = Stand
    preferredActor = true
    sayArriving = "\n\t\^<< subjthedesc>> enters the area."
    sayLeaving = "\n\t\^<< subjthedesc >> leaves the area."
    sdesc = (actorname)
    sleepyTime = (global.sleepyTime)
    sleepTime = (global.sleepTime)
    sleepDuration = (global.sleepDuration)
    speak( o ) = {
        "Very well, ";
        o.Say( self );
    }
    weight = 10

    actorAction( v, d, p, i ) = {
        "\^<< subjthedesc >> does nothing unexpected. ";
        exit;
    }
    askobject( obj ) = nil
    askword( word, lst ) = nil
    Awaken = {
        "\b\^<< subjthedesc >> <<conj('wake',self)>>, somewhat refreshed. ";
        self.isasleep = nil;
    }
    follow( obj, dest, ... ) = {
        local pos = In;
        if (argcount >= 3) pos = getarg( 3 );
        if (obj.isvisible( self ) and dest.isfollowroom) {
            self.Follow( obj, dest, pos );
            self.travelTo( dest, pos, nil );
        }
    }
    followedFrom( room ) = {
        if (self.curFollower) {
            self.curFollower.moveInto( room );
            self.curFollower.followTo = self.locate;
        }
        else if (self.hasfollower) {
            local o = new Follower, lst, i, len;
            self.curFollower = o;
            o.myactor = self;
            lst = getwords( self, &adjective );
            for (i = 1, len = length( lst ); i <= len; ++i)
                addword( o, &adjective, lst[i] );
            lst = getwords( self, &noun );
            for (i = 1, len = length( lst ); i <= len; ++i)
                addword( o, &noun, lst[i] );
            o.moveInto( room, On );
            o.followTo = self.locate;
        }
    }
    hungerdeath = {
      if (self == parserGetMe()) {
        "\^<< fmtYou >> simply can't go on any longer without food.
        \^<< fmtYou >> perish<< fmtEs >> from lack of nutrition. ";
        self.perish;
      }
      else if (self.isvisible( parserGetMe() )) {
        "\^<< subjthedesc >> <<conj('fade',self)>> slowly away like a Jedi master, never
        to be seen again. ";
        self.perish;
      }
    }
    Hungerwarning = {
      if (self == parserGetMe())
        "\^<< fmtYoure >> feeling really hungry.  \^<< fmtYou >> should find
        some food soon or << fmtYou >>'ll pass out from lack of nutrition. ";
    }
    Hungerwatch = {
      if (self == parserGetMe())
        "\^<< fmtYoure >> feeling a bit peckish. Perhaps it would be a good
        time to find something to eat. ";      
    }
    Hungry( t ) = {
        switch (t) {
            case 30:
            case 25:
            case 20:
                "\b"; self.Hungerwatch;
                break;
            case 15:
            case 10:
            case 5:
                "\b"; self.Hungerwarning;
                break;
            case 0:
                self.hungerdeath;
        }
    }
    isCarrying( obj ) = {
        if (datatype( obj ) == TYPE_LIST) {
            local i, len = length( obj );
            for (i = 1; i <= len; ++i) if (obj.isvisiblyin( self )) return obj;
        }
        else if (obj.isvisiblyin( self )) return true;
        return nil;
    }
    isCarryingAll( obj ) = {
        if (datatype( obj ) == TYPE_LIST) {
            local i, len = length( obj );
            for (i = 1; i <= len; ++i) if (not obj.isvisiblyin( self )) return nil;
            return true;
        }
        else return obj.isvisiblyin( self );
    }
    isHolding( obj ) = (obj.locate == self)
    moveInto( o, ... ) = {
        if (o == nil and self.curFollower != nil) self.curFollower.remove;
        pass moveInto;
    }
    perish = {
        if (self == parserGetMe()) die();
        else self.forceInto( nil );
    }
    roomCheck( v ) = (self.locate.roomCheck( v ))
    Sitdown = {
        switch (posture) {
          case Sit:
                   "\^<< fmtYou >> << fmtAre >> already sitting. ";
                   break;
                 case Stand:
                   "\^<< fmtYou >> <<conj('sit',self)>> down on << self.locate.floorthedesc >>. ";
                   break;
                 case Lie:
                   "\^<< fmtYou >> <<conj('pull',self)>> << fmtYourself >> up into a
                   sitting position. ";
                   break;
        }
        self.posture = Sit;
    }
    sleep = {
        if (self == parserGetMe()) { "\b* * * * *"; self.Awaken; }
        else {
            notify (self, &Awaken, self.sleepDuration);
            self.isasleep = true;
        }
    }
    sleepeasy = {
      if (self.isvisible( parserGetMe() ))
        "\^<< fmtMe >>, exhausted, <<conj('fall',self)>> asleep in the comfort of
        << self.locate.predthedesc >>. ";
      self.sleep;
    }
    sleephard = {
      self.dropall;
      if (self.isvisible( parserGetMe() ))
        "\^<< subjthedesc >>, exhausted, <<conj('collapse',self)>> on <<
        self.locate.predthedesc >>. ";
      self.posture = Lie;
      self.sleep;
    }
    Sleepwarning = {
      if (self.isvisible( parserGetMe() ))
        "\^<< fmtMe >> <<conj('blink',self)>> the sleep from << fmtYour >> eyes. ";
    }
    Sleepwatch = {
      if (self.isvisible( parserGetMe() ))
        "\^<< fmtMe >> <<conj((self == parserGetMe() ? "feel" : "look"),self)
        >> very tired. ";
    }
    Sleepy( t ) = {
        switch (t) {
            case 30:
            case 25:
            case 20:
                "\b"; self.Sleepwatch;
                break;
            case 15:
            case 10:
            case 5:
                "\b"; self.Sleepwarning;
                break;
            case 0:
                self.sleepyTime = 0;
                if (self.locate.issleepable( self, self.position ))
                    "\b<< self.sleepeasy >>";
                else "\b<< self.sleephard >>";
        }
    }
    Standup = {
      if (self.posture == Stand)
        "\^<< fmtYou >> << fmtAre >> already upright. ";
      else {
        self.posture = Stand;
        "\^<< fmtYou >> << conj( 'stand', currentActor() ) >> up. ";
      }
    }
    verGrab( o, p ) = {
        "\^<< subjthedesc >> <<conj('refuse',self)>> to give up
        << o.predthedesc >>. ";
    }

    verDoAskAbout( actor, iobj ) = {}
    doAskAbout( actor, iobj ) = {
        local lst = objwords( 2 ), i, tot = length( lst );
      if (self.askobject( iobj )) return;
      if ((tot == 1 and (find(['it' 'them' 'him' 'her'], lst[1]) != nil)) or tot == 0) {
        "\^<< subjthedesc >> <<conj('look',self)>> confused. ";
        return;
      }
      for (i = 1; i <= tot; ++i) if (self.askword(lst[i], lst)) return;
      self.disavow;
    }
    verIoGiveTo( actor ) = {
        if (actor == self) "%You% somehow <<conj('feel',actor)>> richer having done that. ";
    }
    ioGiveTo( actor, dobj ) = {
        "\^<< subjthedesc >> <<conj('reject',actor)>> the offer. ";
    }
    verIoPutIn( actor ) = {
        self.verIoGiveTo( actor );
    }
    ioPutIn( actor, dobj ) = {
        self.ioGiveTo( actor, dobj );
    }
;

// (modify)  Addition of NPC class, which simply combines the fixedthing
//  and movableActor classes.  NPC is genderless.  For the uninitiated, NPC
//  stands for a non-player character.
// I played around with calling Actors "Troop" instead, but decided that
//  might be a bit obscure.
// The NPC sdesc is considered normal.  For Actor and Actress, by default
//  the sdesc is considered to be a proper noun, and therefore iart and
//  dart return empty.
class NPC: fixedthing, movableActor ishidden = nil;

class Actor: NPC ishim = true isproper = true;
class Actors: NPC isthem = true;
class Actress: NPC isher = true isproper = true;

// (modify)
//  TS.T uses a non-floating Me, meaning that Me appears in contents lists
//  along with everything else.  This especially eases parserSetMe() calls.
// Unlike the other two former "basic" classes, basicMe remains so that
//  multiple-Me games will have an easier time of it.
// .ispasttense doesn't really work for irregular verbs.
class basicMe: NPC
    hasfollower = (parserGetMe() == self)
    ishidden = {
        if (self == parserGetMe()) return true;
        else pass ishidden;
    }
    ispasttense = nil
    isproper = true
    ldesc = "Dashing and suave. "
    maxweightin = 10
    maxbulkin = 10
    predthedesc = {
        if (self == parserGetMe()) self.fmtYoum;
        else pass subjthedesc;
    }
    sdesc = {
      if (self != parserGetMe()) "<< actorname >>";
      else self.fmtYou;
    }
    subjthedesc = {
        if (self == parserGetMe()) self.fmtYou;
        else pass subjthedesc;
    }

    actorAction( verb, dobj, prep, iobj ) = {
        if (self != parserGetMe()) pass actorAction;
    }
    verDoFollow( actor ) = {
        if (actor == self) "If << fmtYou >> can't follow << fmtYourself >>, perhaps
          there are more important issues at hand. ";
    }
    ioGiveTo(actor, dobj) = {
        "\^<< fmtYou >> <<conj('accept',self)>> << dobj.predthedesc >> from <<
        actor.predthedesc >>.";
        dobj.moveInto( self );
    }

    becomeMe = {
        local a = parserGetMe();
        if (a) { if (a != self) a.delnoun( [ 'me' 'myself' ] ); }
        self.addnoun( [ 'me' 'myself' ] );
        parserSetMe( self );
    }

    fmtMe = {
        if (self == parserGetMe()) "me";
        else pass fmtMe;
    }
;

//  Even though Everyone specifies more than one person, it is a singular
//  noun and thus is classified as singular (and without gender).  Which
//  is wrong, because "Everyone" should be referencable with "them".
Everyone: NPC, floatingobject
    noun = 'everyone' 'one' 'person' 'people' 'anyone'
    adjective = 'every' 'any'
    locate = (parserGetMe().locate)
    sdesc = "everyone"
    thedesc =  "everyone"
    adesc = "anyone"
    Invalid = "I don't see anyone here. "
    inEveryone = nil                // just to be certain
    actorAction( v, d, p, i ) = {
        local a = a.locate.actorlist( self );
        if (length( a )) {
          if (v == helloVerb) {
            helloVerb.action( parserGetMe() );
            exit;
          }
          else if (length( a ) == 1) redirect( a[1], v, d, p, i );
          else "You ought to be more specific about whom you are
            speaking to. ";
        }
        else self.Invalid;
        exit;
    }
    verIoSayTo( actor ) = {}
    ioSayTo( actor, dobj ) = {
        actor.speak( dobj );
        self.sayTo( actor, dobj, true );
    }
    sayTo( actor, dobj, specificity ) = {
        // specificity:  said directly to this person or not.
        local a = actor.locate.actorlist( actor ), len = length( a ), i;
        if (len > 0) {
            for (i = 1; i <= len; ++i) a[i].listen( actor, dobj, nil );
        }
        else if (specificity) self.Invalid;
    }
;

//  (modify)  Don't declare an object of this class unless you understand the
//   mystical undercurrents of Pianosa;  it is handled specially by the
//   movableActor class.
class Follower: NPC
    describealone = nil
    ishidden = true
    ldesc = "\^<< subjthedesc >> <<conj('leave',self)>>. "
    myactor = nil
    remove = {
        delete self;
    }
    sdesc = (self.myactor.sdesc)

    actorAction( v, d, p, i ) = { self.ldesc; exit; }

    dobjGen(a, v, i, p) = {
        if (v != followVerb) self.ldesc;
        exit;
    }
    iobjGen(a, v, d, p) = {
        self.ldesc;
        exit;
    }
    verDoFollow( actor ) = {}
    doFollow( actor ) = {
        actor.travelTo( self.followTo );
        if (self.myactor.isvisiblyin( self.followTo )) self.myactor.doFollow( actor );
    }
    construct = {}
    destruct = {
        self.myactor.curFollower = nil;
        self.moveInto( nil );
    }
;

//  (modify)
// .istransparent defines whether the object is transparent at this time.
class transparentcontainer: container
    istransparent = true
;

class cover: thing
    maxbulkunder = 10
    iscover = true
    isqcover = nil
    verIoPutUnder( actor ) = {}
    ioPutUnder( actor, dobj ) = {
         dobj.doPutUnder( actor, self );
    }
;

class qcover: cover
    isqcover = true
;

class coverer: qcover
    Move( target ) = {
        "Moving << predthedesc >> reveals "; contListing( self, Under, 1, 0 ); ". ";
        self.dropall( Under );
    }
    verDoMove( actor ) = {}
    doMove( actor ) = {
        local lst = self.undercont;
        self.putInto( self.locate, self.position );
        if (lst == self.undercont) self.Movearound;
    }
    undercontreachable = nil
    undercontvisible = nil
;

class mask: thing
    maxbulkbehind = 10
    ismask = true
    isqmask = nil
    verIoPutBehind( actor ) = {}
    ioPutBehind( actor, dobj ) = {
         dobj.doPutBehind( actor, self );
    }
;

class qmask: mask
    isqmask = true
;

class surface: thing
    maxbulkon = 10
    isdroploc = true
    issurface = true
    isqsurface = nil
    verIoPutOn( actor ) = {}
    ioPutOn( actor, dobj ) = {
        dobj.doPutOn( actor, self );
    }
;

class qsurface: surface
    isqsurface = true
;

/* Classes, Part III: other-base-classes * * * * * * * * * * * * * * * * * * */
articles: object
    article = 'the' 'a' 'an'
;

// (modify)
// A basic concept.  Locationless, but askAbout-able.
class concept: object
    verIoAskAbout( a ) = {}
    ioAskAbout( a, d ) = {
        d.doAskAbout( a, self );
    }
;

class Direction: object
    dirTravel = nil
    dirGoDirProp = nil
    dirNames = []
;
    
class floatingobject: object;

class hearer: object;

//  (modify)  Lockcode
// Consolidates the code used for lockable doorways and containers, should
// it be needed for anything:  eases the eyes on doorway and lockable
// classes.
// .autoOpen states whether attempting to go through a closed door should
//  automatically open it.
// .autoUnlock states whether attempting to go through a closed and locked
//  door should automatically attempt to unlock it.  This will only succeed
//  if the key is known or happens not to exist.
// .mykeyKnown states whether the correct key to the object is known (if it
//  is, it will automatically be used to unlock a door if .autoUnlock is
//  true).
// .open and
// .unlock handle their appropriate process, but perform no checking.
// .islockable defines whether an item is lockable (or relockable) at all.
// .isunlockable defines whether an item is unlockable at all.
// .keyHeldBy tests whether this object's key is being held by the argument
//  object, and if so is responsible for returning the correct object.
//  Normally, it accomplishes this by checking whether 1) .mykey exists and
//  2) the object is carrying one of .mykey, but it does not matter.  A
//  master lock (openable by any key) could be created easily.  This routine
//  is not called when a specific iobj is used, so it also tests .mykeyKnown.
//  The iobj routines use .keyIsValid.
// .mykey may be a list of possible keys.  Note that I have found no good
//  way of checking whether a certain key has been tried in a certain door; 
//  therefore, as soon as one correct key is used, every key in the list
//  will work.
//      (note)
//  The reason for the above has to do with data storage.  The best ways
//  to store such information is as a property on either the key or the door.
//   The problem with storing the data on the key is that if the key unlocks
//  more than one door, once the key sucessfully unlocks one door then every
//  door it unlocks will unlock by default -- and that's not good.
//   The problem with storing the data on the door is that if the door can
//  be unlocked by more than one key, once one key successfully unlocks the
//  door then every key that unlocks it will unlock the door by default.
//  This is also not good, but it is better for three reasons.  First, since
//  the destination code is also on the door it is easier for that codeblock
//  to reference the one door than to reference every possible key.  Second,
//  even though it is more like in the real world to have multiple copies
//  of a key than to have a key unlock more than one door, most individuals
//  would only have one copy of the key but could access a great many doors.
//  Third, keys which unlock the same door tend to be similar in appearance,
//  if not by nature than by design.  Those keys which unlock a certain door
//  might have blue key-grips, and those for another might have red ones.
//  The ideal solution is some sort of data array indexable by object;  one
//  could call .mykeyKnown( bluekey ), and the array would return whether the
//  player knows that bluekey can unlock the door (it might also be advisable
//  to add a second indexing variable for actor).
//
// .open, .close, .Open, and .Close are not defined within Lockcode.
//  Here are some functional versions.
//    open( a ) = { self.isopen = true; }
//    close( a ) = { self.isopen = nil; }
//    Open( a ) = "Opened. "
//    Close( a ) = "Closed. "
class Lockcode: object
    keyHeldBy( obj ) = (self.mykey ? (self.mykeyKnown ? obj.isCarrying( self.mykey ) : nil) : true)
    keyIsValid( obj ) = (find( self.mykey, obj ))
    mykey = []
    iscloseable = true
    islockable = nil
    isopenable = true
    isunlockable = true
    unlock( a, key ) = {
        self.islocked = nil;        
    }
    Unlock( a, key ) = {
        if (key) "\^<<a.fmtYou>> <<conj('unlock',a)>> << predthedesc >> with << key.predthedesc >>. ";
        else "Unlocked. ";
    }
    lock( a, key ) = {
        self.islocked = true;
    }
    Lock( a, key ) = {
        if (key) "\^<<a.fmtYou>> <<conj('lock',a)>> << predthedesc >> with << key.predthedesc >>. ";
        else "Locked. ";
    }
    verDoOpen( actor ) = {
        if (self.isopen) "\^<< isdesc >> already open. ";
        if (not self.isopenable) "\^<< subjthedesc >> <<conj('cannot',self)>> be opened. ";
    }
    doOpen( actor ) = {
        if (self.islocked) {
          if (self.autoUnlock and self.isunlockable) {
            local o = self.keyHeldBy( actor );
            if (o) {
                "(Unlocking << predthedesc >>)\n";
                self.unlock( actor, o );
                self.Open( actor );
                self.open( actor );
            }
            else {
                if (self.mykeyKnown) "\^<<actor.fmtYou>> <<conj('do',actor)>>
                  not have the proper key. ";
                else "\^<< subjthedesc >> <<conj('require',actor)>> a key. ";
            }
            }
          else "\^<< isdesc >> locked. ";
        }
        else {
            self.Open( actor );
            self.open( actor );
        }
    }
    verDoClose( actor ) = {
        if (not self.isopen) "\^<< isdesc >> already closed. ";
        else if (not self.iscloseable) "\^<< subjthedesc >> cannot be closed. ";
    }
    doClose( actor ) = {
        self.Close( actor );
        self.close( actor );
    }
    verDoLock( actor ) = {
        if (self.islocked) "\^<< isdesc >> already locked. ";
        else if (not self.islockable) "\^<< subjthedesc >> cannot be
            locked. ";
        else if (self.isopen) "%You% must first close << predthedesc >>. ";
    }
    doLock( actor ) = {
        if (mykey != nil and not self.mykeyKnown) askio( withPrep );
        else {
            local o = self.keyHeldBy( actor );
            if (o) {
                if (self.mykey == []) o = nil;
                self.Lock( actor, o );
                self.lock( actor, o );
            }
            else {
                if (self.mykeyKnown) "%You% %do% not have the proper key. ";
                else "\^<< subjthedesc >> <<conj('require',self)>> a key. ";
            }
        }
    }
    verDoUnlock( actor ) = {
        if (not self.islocked) "\^<< isdesc >> not locked. ";
        else if (not self.isunlockable) "%You% cannot unlock << predthedesc >>. ";
    }
    doUnlock( actor ) = {
        if (mykey != nil and not self.mykeyKnown) askio( withPrep );
        else {
            local o = self.keyHeldBy( actor );
            if (o) {
                if (self.mykey == []) o = nil;
                self.Unlock( actor, o );
                self.unlock( actor, o );
            }
            else {
                if (self.mykeyKnown) "%You% %do% not have the proper key. ";
                else "\^<< subjthedesc >> <<conj('require',self)>> a key. ";
            }
        }
    }
    verDoLockWith( actor, io ) = {
        if (self.islocked) "\^<< isdesc >> already locked. ";
        else if (not self.islockable) "\^<< subjthedesc >> cannot be locked. ";
        else if (self.mykey == nil) "Nothing is needed to lock << fmtYoum >>. ";
        else if (self.isopen) "%You% must close << fmtYoum >> first. ";
    }
    doLockWith( actor, io ) = {
        if (self.keyIsValid( io )) {
            self.Lock( actor, io );
            self.mykeyKnown = true;
            self.lock( actor, io );
        }
        else "\^<< io.subjthedesc >> << io.fmtDo >> not fit the lock. ";
    }
    verDoUnlockWith( actor, io ) = {
        if (not self.islocked) "\^<< isdesc >> not locked. ";
        else if (not self.isunlockable) "%You% cannot unlock << predthedesc >>. ";
        else if (self.mykey == nil) "Nothing is needed to unlock << fmtYoum >>. ";
    }
    doUnlockWith( actor, io ) = {
        if (self.keyIsValid( io )) {
            self.Unlock( actor, io );
            self.mykeyKnown = true;
            self.unlock( actor, io );
        }
        else "\^<< io.subjthedesc >> << io.fmtDo >> not fit the lock. ";
    }
    ldesc = {
        "\^<< self.isdesc >> ";
        if (self.isopen) "open";
        else {
            "closed";
            if (self.islocked) " and locked";
        }
        ". ";
    }
;

// (modify)
// This idea was taken straight from Kevin Forchione, although the
//  implementation is so twisted from the original (found in
//  dooritem.t as multiloc) that it's completely unrecognizable.
// A multiobject is an object found in several different places to
//  begin with.  This is accomplished by dynamic object creation in
//  the function initMultiobject, called by initLibrary.
// .locatelist is a list of locations, followed (optionally) by
//  positions (which default to In).  For example:
//   locatelist = [ inntable On inncounter Behind mug1 mug2 mug3 ]
//  places the object on the inn table, behind the inn counter, and
//  in mugs 1, 2, and 3.
// .multiobjectlist is a list of the objects created by create, in order of
//  their presence in .locatelist.
class multiobject: object
    locatelist = []
    multiobjectlist = []
    ismultiobject = true
    create = {
        local i, loclist, len, obj;
        loclist = self.locatelist;
        for (i = 1, len = length( loclist ); i <= len; ++i) {
            obj = new self;
            obj.ismultiobject = nil;
            self.multiobjectlist += obj;
            obj.clearloc;
            if (loclist[i + 1].isposition) {
                obj.moveInto( loclist[i], loclist[i + 1] );
                i++;
            }
            else obj.moveInto( loclist[i], In );
        }
    }
    construct = {}
;

// (modify) An object which exists in multiple locations.
class multilocatefixed: fixedthing, multiobject
    create = {
        local i, loclist = self.locatelist, len = length( loclist );
        for (i = 1; i <= len; ++i) {
          if (i < len and loclist[i + 1].isposition) {
            loclist[i].forceAccept( self, loclist[i + 1] );
            i++;
          }
          else loclist[i].forceAccept( self, In );
        }
    }
    isreachable( v ) = {
        local i, loclist = self.locatelist, len = length( loclist );
        for (i = 1; i <= len; ++i) {
          if (i < len and loclist[i + 1].isposition) {
            if (loclist[i].isreachable( v )) return true;
            i++;
          }
          else if (loclist[i].isreachable( v )) return true;
        }
        return nil;
    }
    isvisible( v ) = {
        local i, loclist = self.locatelist, len = length( loclist );
        for (i = 1; i <= len; ++i) {
          if (i < len and loclist[i + 1].isposition) {
            if (loclist[i].isvisible( v )) return true;
            i++;
          }
          else if (loclist[i].isvisible( v )) return true;
        }
        return nil;
    }
;

class notified: object;

numObj: object
    value = 0
    sdesc = "<< value >>"
    adesc = "a number"
    thedesc = "the number << value >>"
    verDoTypeOn( actor, io ) = {}
    doTypeOn( actor, io ) = { "<q>Tap, tap....</q> "; }
    verIoTurnTo( actor ) = {}
    ioTurnTo( actor, dobj ) = { dobj.doTurnTo( actor, self ); }
    doSay( actor ) = {
        if (actor.speak( self )) return;
        Everyone.sayTo( actor, self, nil );
    }
    Say( a ) = "<q><< self.value >>.</q>"
;

class obstacle: object
    isobstacle = true
;

//  (modify)
// .destination now receives an argument of the character doing the
//  traveling.
// .doordir is a property pointing to the direction which should
//   be followed when the door is entered (e.g. &north).
// See helper class Lockcode for info on locks.
// See class matchdoorway for an easier, less general form of a door.
class doorway: Lockcode, fixedthing, obstacle
    autoOpen = true
    isdoorway = true
    isopen = true
    islocked = true
    hearNoise( type ) = {
        if (self.doordest) self.doordest.hearNoise( type );
    }
    destination( actor ) = {
        if (self.isopen) {
          self.doorwayMessage( actor );
          return self.doordest;
        }
        else if (not self.islocked) {
          if (self.autoOpen and self.isopenable) {
            "(Opening << predthedesc >>)\n";
            self.open( actor );
            self.doorwayMessage( actor );
            return self.doordest;
          }
          else {
            "%You% will need to open << predthedesc >>. ";
            setit( self );
            return nil;
          }
        }
        else {
          if (self.autoUnlock and self.isunlockable and self.isopenable) {
            local o = self.keyHeldBy( actor );
            if (o) {
                if (self.mykey == []) o = nil;
                "(Unlocking and opening << predthedesc >>)\n";
                self.unlock( actor, o );
                self.open( actor );
                self.doorwayMessage( actor );
                return self.doordest;
            }
            else {
                if (self.mykeyKnown) "%You% %do% not have the proper key. ";
                else "\^<< subjthedesc >> <<conj('require',self)>> a key. ";
            }
            }
          else "\^<< self.isdesc >> locked. ";
        }
    }
    unlock( a, key ) = {
        self.islocked = nil;
        if (self.otherside) self.otherside.islocked = nil;
    }
    lock( a, key ) = {
        self.islocked = true;
        if (self.otherside) self.otherside.islocked = true;
    }
    open( a ) = {
        self.isopen = true;
        if (self.otherside) self.otherside.isopen = true;
    }
    Open( a ) = "Opened. "
    close( a ) = {
        self.isopen = nil;
        if (self.otherside) self.otherside.isopen = nil;
    }
    Close( a ) = "Closed. "
    verDoEnter( actor ) = {
        if (self.doordir == nil) "\^<< thedesc >> cannot be entered. ";
    }
    doEnter( actor ) = {
        actor.locate.travel( actor, self.doordir );
    }
    ioThrowAt( a, d ) = {
        if (self.isopen and self.doordest) {
          "\^<< d.subjthedesc  >> flies through << self.predthedesc >>. ";
          d.dropFrom( self.doordest );
        }
        else d.doThrowAt( a, self );
    }

    doorwayMessage( actor ) = {}
;

// (modify)
//  Borrowing heavily from Kevin Forchione's doorItem.
// The use of the multiobject class here is only to cause create
//  to be called by multiobjectInit.
// If a room contains multiple links to the same room, it is
//  assumed that all of these links should be replaced by doors,
//  and all by the same single door.  BOOKMARK enable this to be
//  customized: method called with prop-pointer.
// .locatelist is a parsed list of locations in the following format:
//  [ source1 dest1,1 &dest1,2 &dest1,3 &etc. nil|true
//    &(source2 dest2,1 &dest2,2 &dest2,3 &etc. nil|true) &etc. ]
//   where source is the departure room and each dest is a
//    destination from that room.  If the terminating term in a
//    series is true, then each door is bidirectional and another
//    door will be placed in the destination room leading back to
//    to the source;  if nil, the door is unidirectional and the
//    player will simply pop into the new room.
//  Examples:
//   [ parlour formalDining greatHall true ]
//     creates four doors:  one from the parlour to the formal dining
//     room, one from the parlour to the great hall, one from the
//     formal dining room to the parlour, and one from the great hall
//     to the parlour.
//   [ masterBedroom masterBathroom upstairsHallway true bedroomTims
//    upstairsHallway true bedroomJohns upstairsHallway true
//    upstairsHallway centerAttic nil ]
//     may seem like a lot of typing, but consider that you've been
//     spared the trouble of creating 9 identical doors by that line.
//     It would be slightly easier, however, to write this as:
//   [ upstairsHallway masterBedroom bedroomTims bedroomJohns true
//    upstairsHallway centerAttic nil masterBedroom masterBathroom
//    true ]
//     The attic stairway, evidently, emerges as a hole in the attic
//     floor, and not to a proper door.  This could also be defined
//     as a bidirectional door, which would allow the player to be
//     shut in the attic if the door should be locked.
// .initdoor allows customization of doors;  for instance, one side
//  of a door can be set not .isunlockable.  The parameters are source
//  and dest in that order.
// .setupdoor sets up the door;  the third argument is the terminant
//  .locatelist element (true/nil).
class matchdoorway: doorway, multiobject
    locatelist = []
    create = {
        local o, loc = self.locatelist, loclen = length( loc );
        local lst = [], i;
        for (i = 1; i <= loclen; ++i) {
            o = loc[i];
            if (o == true or o == nil) {
                local j, lstlen = length( lst ), s;
                if (length( lst ) >= 2) {
                    s = lst[1];
                    for (j = 2; j <= lstlen; ++j) self.setupdoor( s, lst[j], o );
                }
                lst = [];
            }
            else lst += o;
        }
    }
    initdoor( src, dst ) = {}
    setupdoor( src, dst, hasdouble ) = {
        local d1, d2, lst = src.exitlist, i, len = length( lst );
        d1 = new self;
        d1.doordest = dst;
        d1.moveInto( src, In );
        d1.ismultiobject = nil;
        for (i = 1; i <= len; ++i) {
            if (src.(lst[i]) == dst) {
                src.(lst[i]) = d1;
                d1.addadjective( sayDirection( lst[i] ) );
                if (d1.doordir == nil) d1.doordir = lst[i];
            }
        }
        if (hasdouble) {
            d2 = dst; dst = src; src = d2;
            lst = src.exitlist;
            len = length( lst );
            d2 = new self;
            d2.moveInto( src, In );
            d2.doordest = dst;
            d2.ismultiobject = nil;
            d1.otherside = d2;
            d2.otherside = d1;
//          d1.reachable += d2;
//          d2.reachable += d1;
//          d1.visiblelist += d2;
//          d2.visiblelist += d1;
            for (i = 1; i <= len; ++i) {
                if (src.(lst[i]) == dst) {
                    src.(lst[i]) = d2;
                    d1.addadjective( sayDirection( lst[i] ) );
                    if (d2.doordir == nil) d2.doordir = lst[i];
                }
            }
            d2.initdoor( src, dst );
        }
        d1.initdoor( src, dst );
    }
    construct = {}
    getdoor( loc1, ... ) = {
        local loc2, lst = loc1.gaca( self ), i, len = length( lst ), ret = [];
        if (argcount >= 2) loc2 = getarg( 2 );
        if (loc2) {
          for (i = 1; i <= len; ++i)
            if (lst[i].doordest == loc2) ret += lst[i];
        }
        else {
          if (len != 1) return nil;
          return lst[1];
        }
        if (length( ret ) == 1) return ret[1];
        else return nil;
    }
;

// (modify) standard two-way door w/ object-containing frame
//  If strange things start happening, try setting .doorwayframeclass
//  manually.  Note that doorwayframe uses matchdoorway, so be sure
//  to set .locatelist = [ loc1 loc2 true ] (multiple locations will
//  work, but the contents of any frame will appear in ALL of them).
class doorwayframe: matchdoorway, openable
    doorwayframeclass = (self.ismultiobject ? self : firstsc( self ))
/*
  I'm doing strange things here, so I'll explain.  The matchdoorway class
  sets up two different objects here; this is good.  However, I also want
  to set up "In" as a valid position for the door, which should be available
  to both sides.  So, I route puts from the dynamic object to the master object,
  the doorwayframe object;  thus, the parent stores the info.  Neat.

  I also add the class 'openable' to allow the player to manually put things
  into the "In" position when the door is open.  Note that the datum of whether
  the door is open or not would NOT normally be stored on the parent itself;
  however, in this case I've hacked .open and .close to update that information
  for this object as well.

  One problem.  For .locatetree and .isin purposes, we'll have to hack .locate
  and .position.
 */
    routein( obj, j ) = (self.doorwayframeclass == self ? nil : (obj.putInto( self.doorwayframeclass, In, j ), true))
    open( a ) = {
        self.doorwayframeclass.isopen = true;
        pass open;
    }
    verIoPutIn( a ) = {
        if (not self.isopen) "\^<< isdesc >> closed. ";
    }
    locate = {
        if (self == self.doorwayframeclass) {
          local i, lst = self.locatelist, len = length( lst );
          for (i = 1; i <= len; ++i)
            if (datatype( lst[i] ) == TYPE_OBJECT)
              if (parserGetMe().isin( lst[i] )) return lst[i];
          return nil;
        }
        pass locate;
    }
    position = In
;

//  (modify)  Easily addable positions.  In and On are necessary for the survival
// of the library.  In order to add a new position
// 1.  Pick a name and find a valid "position" number for it.  This
//     number will determine the order of objects in global.positionlist.
// 2.  Make sure there are preposition objects for your new prepositions:
//     passive (is IN x), active (put INTO x), and removal (take OUT OF x).
// 3.  Define a Position object using one of the below as a model, substituting
//     appropriate method names for those given.  .posPrepobject and
//     .outofPrepobject can be objects OR lists.
// 4.  Modify thing to provide values for those properties which you have just
//       created.
//         incont = []
//         incontreachable = true
//         incontvisible = true
//         isqcontainer = nil
//         maxweightin = 10
//         maxbulkin = 10
//         routein( o, j ) = nil
//     Some have several options
//         weightin = (sumWeight( self.incont ))
//         weightunder = 0   // objects beneath, behind do not increase the weight.
//         bulkin = {
//             if (self.isflexiblecontainer) return (sumBulk( self.incont ));
//             else return 0;
//         }
//         bulkon = 0
//     Others you'll just have to make judgements on
//         incontdesc( c ) = "Inside << self.predthedesc >> can be seen"
//         emptyin = "There is nothing inside << self.predthedesc >>. "
//     Or copy in code
//         listincont( ... ) = {
//             local lev = 1, j, v = true, c;
//             if (argcount > 1) v = getarg( 2 );
//             if (argcount > 0) lev = getarg( 1 );
//             self.listXcont( In, lev, v );
//         } //  changing this ^^
//         gaci -- just change the lst declaration to fit your cont prop
//     descProp and locProp need not be defined in thing.
// 5.  Modify putVerb to add a new iobj phrasing (making sure that the position is
//         defined as a preposition), and add default responses to thing (using the
//         other positions as templates, naturally)
// 6.  Create a lookinVerb-type verb to correspond to the new positon, again adding
//         defaults to thing
// 7.  Modify takeVerb to add a new iobj phrasing for "take out from <position>",
//         with the preposition again defined.  compoundWord may be necessary.
//         Add thing responses.  This is not completely necessary.
// 8.  Create classes to correspond with the new position.  See container,
//         qcontainer for examples.
class Position: object
    isposition = true
    showactiveposition = (self.showposition)
    initposition = {
        local lst = self.posPrepobject, i, len;
        if (datatype( lst ) == TYPE_LIST)
            for (i = 1, len = length( lst ); i <= len; ++i) takeVerb.pospreplist += lst[i];
        lst = self.outofPrepobject;
        if (datatype( lst ) == TYPE_LIST)
            for (i = 1, len = length( lst ); i <= len; ++i) takeVerb.pospreplist += lst[i];
    }
;

In: Position
    position = 1
    bulkProp = &bulkin
    contProp = &incont
    contdescProp = &incontdesc
    contdescafterProp = &incontdescafter
    descProp = &indesc
    emptyProp = &emptyin
    gacProp = &gaci
    listcontProp = &listincont
    locProp = &in
    maxbulkProp = &maxbulkin
    maxweightProp = &maxweightin
    outofPrepobject = [ outPrep fromPrep outfromPrep ]
    posPrepobject = inPrep
    qProp = &isqcontainer
    reachProp = &incontreachable
    removePrep = "out of"
    routeProp = &routein
    showactiveposition = "into"
    showposition = "in"
    visProp = &incontvisible
    weightProp = &weightin
;

On: Position
    position = 2
    bulkProp = &bulkon
    contProp = &oncont
    contdescProp = &oncontdesc
    contdescafterProp = &oncontdescafter
    descProp = &ondesc
    emptyProp = &emptyon
    gacProp = &gaco
    listcontProp = &listoncont
    locProp = &on
    maxbulkProp = &maxbulkon
    maxweightProp = &maxweighton
    outofPrepobject = offPrep
    posPrepobject = onPrep
    qProp = &isqsurface
    reachProp = &oncontreachable
    removePrep = "off of"
    routeProp = &routeon
    showactiveposition = "onto"
    showposition = "on"
    visProp = &oncontvisible
    weightProp = &weighton
;

Under: Position
    position = 3
    bulkProp = &bulkunder
    contProp = &undercont
    contdescProp = &undercontdesc
    contdescafterProp = &undercontdescafter
    descProp = &underdesc
    emptyProp = &emptyunder
    gacProp = &gacu
    listcontProp = &listundercont
    locProp = &under
    maxbulkProp = &maxbulkunder
    maxweightProp = &maxweightunder
    outofPrepobject = outunderPrep
    posPrepobject = underPrep
    qProp = &isqcover
    reachProp = &undercontreachable
    removePrep = "out from under"
    routeProp = &routeunder
    showactiveposition = "under"
    showposition = "under"
    visProp = &undercontvisible
    weightProp = &weightunder
;

Behind: Position
    position = 4
    bulkProp = &bulkbehind
    contProp = &behindcont
    contdescProp = &behindcontdesc
    contdescafterProp = &behindcontdescafter
    descProp = &behinddesc
    emptyProp = &emptybehind
    gacProp = &gacb
    listcontProp = &listbehindcont
    locProp = &behind
    maxbulkProp = &maxbulkbehind
    maxweightProp = &maxweightbehind
    outofPrepobject = outbehindPrep
    posPrepobject = behindPrep
    qProp = &isqmask
    reachProp = &behindcontreachable
    removePrep = "out from behind"
    routeProp = &routebehind
    showactiveposition = "behind"
    showposition = "behind"
    visProp = &behindcontvisible
    weightProp = &weightbehind
;

// (modify)  Preactors receive notification of every command given in their
//  presence (Preactor.ultimatelocate == actor.ultimatelocate).  This wizardry
//  is executed in roomAction, which calls self.notifyPreactors with The Five
//  Arguments Wherewith All Commands May Be Described.  notifyPreactors then
//  calls the preactorAction method on every "present" Preactor.
//  Preactor inherits from object, so it has no baggage attached;  anything
/// may be a Preactor.  If you change roomAction for any reason, be sure to
//  call notifyPreactors (if the command passes roomAction, that is;  if the
//  action can't be done, no point in checking to see if any pedestrians have
//  anything to say).  preactorAction occurs before the command is executed;
//  abort, exit, and exitobj work just as well here as elsewhere.
class Preactor: object
    preactorAction( actor, verb, dobj, prep, iobj ) = {}
;

class Prep: object;

aboutPrep: Prep preposition = 'about' sdesc = "about";
againstPrep: Prep preposition = 'against' sdesc = "against";
aroundPrep: Prep preposition = 'around' sdesc = "around";
atPrep: Prep preposition = 'at' sdesc = "at";
behindPrep: Prep preposition = 'behind' sdesc = "behind";
betweenPrep: Prep preposition = 'between' 'inbetween' sdesc = "between";
byPrep: Prep preposition = 'by' sdesc = "by";
downPrep: Prep preposition = 'down' 'd' sdesc = "d";
eastPrep: Prep preposition = 'east' 'e' sdesc = "east";
forPrep: Prep preposition = 'for' sdesc = "for";
fromPrep: Prep preposition = 'from' sdesc = "from";
inPrep: Prep preposition = 'in' 'into' 'downin' sdesc = "in";
nePrep: Prep preposition = 'northeast' 'ne' sdesc = "northeast";
northPrep: Prep preposition = 'north' 'n' sdesc = "north";
nwPrep: Prep preposition = 'northwest' 'nw' sdesc = "northwest";
ofPrep: Prep preposition = 'of' sdesc = "of";
offPrep: Prep preposition = 'off' 'offof' sdesc = "off";
onPrep: Prep preposition = 'on' 'onto' 'downon' 'upon' sdesc = "on";
outPrep: Prep preposition = 'out' 'outof' sdesc = "out";
outbehindPrep: Prep preposition = 'outfrombehind' sdesc = "out from behind";
outfromPrep: Prep preposition = 'outfrom' sdesc = "out from";
outunderPrep: Prep preposition = 'outfromunder' sdesc = "out from under";
overPrep: Prep preposition = 'over' sdesc = "over";
sePrep: Prep preposition = 'southeast' 'se' sdesc = "southeast";
southPrep: Prep preposition = 'south' 's' sdesc = "south";
swPrep: Prep preposition = 'southwest' 'sw' sdesc = "southwest";
toPrep: Prep preposition = 'to' sdesc = "to";
thruPrep: Prep preposition = 'through' 'thru' sdesc = "through";
underPrep: Prep preposition = 'under' 'beneath' sdesc = "under";
upPrep: Prep preposition = 'up' 'u' sdesc = "u";
westPrep: Prep preposition = 'west' 'w' sdesc = "west";
withPrep: Prep preposition = 'with' 'using' sdesc = "with";

// (modify)  Reactors are much like Preactors, except they:
//  - are notified by notifyReactors, which is called by reactorDaemon, which
//    must be set in init
//  - are notified after the command is run
//  - are notified with the reactorAction routine.
//  Note that commands don't actually have had to have been successful for
//  Reactors to catch wind of it.  As long as the Daemons are run, the Reactors
//  will hear about what was typed in.  The only times the Daemons aren't run
//  are 1) when the command contains an error or 2) when "abort" was called.
//  They will be notified after an "exit" or "exitobj".
//  Command information for Reactors is stored in global by notifyPreactors.
//  If notifyPreactors is not called each turn, the information supplied to
//  Reactors will almost undoubtedly be wildly incorrect.
class Reactor: object
    reactorAction( actor, verb, dobj, prep, iobj ) = {}
;

strObj: object   // when a string is used in a player command,
    value = ''              //  this is set to its value
    sdesc = "<q><< value >></q>"
    adesc = "<q><< value >></q>"
    thedesc = "<q><< value >></q>"
    verDoTypeOn( actor, io ) = {}
    doTypeOn( actor, io ) = { "<q>Tap, tap....</q> "; }
    doSynonym('TypeOn') = 'EnterOn' 'EnterIn' 'EnterWith'
    verDoSave( actor ) = {}
    doSave( actor ) = {
        self.saveGame( actor );
        abort;
    }
    saveGame(actor) = {
        if (save( self.value )) {
            "Save failed. ";
            return nil;
        }
        else {
            "Saved. ";
            return true;
        }
    }
    doRestore( actor ) = {
        self.restoreGame(actor);
        abort;
    }
    verDoRestore( actor ) = {}
    restoreGame( actor ) = {
        if (restore( self.value )) {
            "Restore failed. ";
            return nil;
        }
        else {
            "Restored.\b";
            showScore( global.score, global.thisturn );
            parserGetMe().locate.lookAround( true );
            return true;
        }
    }
    verDoScript( actor ) = {}
    startScripting( actor ) = {
        logging( self.value );
        "Writing script file. ";
    }
    doScript( actor ) = {
        self.startScripting(actor);
        abort;
    }
    doSay( actor ) = {
        if (actor.speak( self )) return;
        Everyone.sayTo( actor, self, nil );
    }
    Say( a ) = "<q><< self.value >>.</q>"
    verDoBeamme( actor ) = {}
    doBeamme( a ) = {
        local str = lower( value ), len = length( str ), o;
        local objlst = [], ostr;
        for (o = firstobj( room ); o; o = nextobj( o, room )) {
          ostr = getOutput( o, &statusdesc );
          if (length( ostr ) >= len)
            if (substr( lower( ostr ), 1, len ) == str) objlst += o;
        }
        len = length( objlst );
        if (len == 0) "No rooms found. ";
        else {
          for (o = 1; o <= len; ++o)
            "\n\t<< o >>. << objlst[o].statusdesc >>";
          o = 0;
          while (o < 1 or o > len) {
            "\n#";
            o = inputLine();
            if (o == '') { "Aborted. "; abort; }
            o = cvtnum( o );
          }
          parserGetMe().travelTo( objlst[o] );
        }
        abort;
    }
;

class versionInfo: object;

// (modify)
// doIsSeen
//  Return true if the dobj must be seen for the action to continue.
//  Defaults to self.doIsTouched.
// doIsTouched
//  Return true if the dobj must be touchable for the action to continue.
//  putVerb defines both doIsTouched AND ioIsTouched to be true.  The
//  indirect object isn't really touched;  but as far as I can conceive of
//  it, it should be touchable.  Defaults to true.
// doIsSpokenTo
//  Return true if the direct object must be spoken to for the action to
//  continue.  
// ioIsSeen        \
// ioIsTouched     - > same as direct object
// ioIsSpokenTo    /
class Verb: object                // A deep-structure verb.
    curprep = nil
    sdesc = "do that to"
    doIsSeen( p ) = (self.doIsTouched)
    doIsTouched( p ) = true
    doIsSpokenTo( p ) = nil
    ioIsSeen( p ) = (self.ioIsTouched)
    ioIsTouched( p ) = true
    ioIsSpokenTo( p ) = nil
    validDo( actor, obj, seqno ) = {
        if (self.doIsTouched( curprep )) return (obj.isreachable( actor ));
        else if (self.doIsSeen( curprep )) return (obj.isvisible( actor ));
        else if (self.doIsSpokenTo( curprep )) return (obj.isaddressable( actor ));
        else return true;
    }
    validDoList(actor, prep, iobj) = {
      if (self.doIsTouched( prep ) or self.doIsSeen( prep ) or self.doIsSpokenTo( prep )) {
        local ret = global.floatinglist, loc = actor.ultimatelocate;
        self.curprep = prep;
        if (self.doIsTouched( prep )) ret += actor.reachlist( actor ) + loc.reachlist( actor );
        else if (self.doIsSeen( prep )) ret += actor.vislist( actor ) + loc.vislist( actor );
        else if (self.doIsSpokenTo( prep )) ret += actor.speaklist( actor ) + loc.speaklist( actor );
        return ret;
      }
      else return nil;
    }
    validIo( actor, obj, seqno ) = {
        if (self.ioIsTouched( curprep )) return (obj.isreachable( actor ));
        else if (self.ioIsSeen( curprep )) return (obj.isvisible( actor ));
        else if (self.ioIsSpokenTo( curprep )) return (obj.isaddressable( actor ));
        else return true;
    }
    validIoList(actor, prep, dobj) = {
      if (self.ioIsTouched( prep ) or self.ioIsSeen( prep ) or self.ioIsSpokenTo( prep )) {
        local ret = global.floatinglist, loc = actor.ultimatelocate;
        if (self.ioIsTouched( prep )) ret += actor.reachlist( actor ) + loc.reachlist( actor );
        else if (self.ioIsSeen( prep )) ret += actor.vislist( actor ) + loc.vislist( actor );
        else if (self.ioIsSpokenTo( prep )) ret += actor.speaklist( actor ) + loc.speaklist( actor );
        return ret;
      }
      else return nil;
    }
    doDefault( actor, prep, io ) = (actor.allcont + actor.locate.allcont)
    ioDefault( actor, prep ) = (actor.allcont + actor.locate.allcont)
;

//  (modify)
//  a - direct object
//  d - direct object
//  p - preposition
//  i - indirect object
//    Added for such things as helpVerb and undoVerb, which should be
//  DarkVerb's if they have no direct object.  Called by darkroom.roomAction;
//  I would have used isDarkVerb except one user of the method, roomCheck,
//  is called only with the verb object.
class darkVerb: Verb
   validInDark( a, d, p, i ) = (self.isDarkVerb)
   isDarkVerb = true
;

againVerb: darkVerb
    verb = 'again' 'g'
;

askVerb: Verb
    verb = 'ask'
    sdesc = "ask"
    prepDefault = aboutPrep
    ioAction( aboutPrep ) = 'AskAbout'
    validIo( actor, obj, seqno ) = (seqno == 1)
    validIoList(actor, prep, dobj) = (nil)
    doIsTouched( p ) = nil
    doIsSpokenTo( p ) = true
;

attachVerb: Verb
    verb = 'attach' 'connect'
    sdesc = "attach"
    prepDefault = toPrep
    ioAction( toPrep ) = 'AttachTo'
;

attackVerb: Verb
    verb = 'attack' 'kill' 'hit'
    sdesc = "attack"
    prepDefault = withPrep
    ioAction( withPrep ) = 'AttackWith'
;

boardVerb: Verb
    verb = 'get in' 'get into' 'board' 'get on'
    sdesc = "get on"
    doAction = 'Board'
;

breakVerb: Verb
    verb = 'break' 'ruin' 'destroy'
    sdesc = "break"
    doAction = 'Break'
;

centerVerb: Verb
    verb = 'center'
    sdesc = "center"
    doAction = 'Center'
;

cleanVerb: Verb
    verb = 'clean' 'clean up'
    sdesc = "clean"
    ioAction( withPrep ) = 'CleanWith'
    doAction = 'Clean'
;

climbVerb: Verb
    verb = 'climb'
    sdesc = "climb"
    doAction = 'Climb'
;

closeVerb: Verb
    verb = 'close'
    sdesc = "close"
    doAction = 'Close'
;

detachVerb: Verb
    verb = 'detach' 'disconnect'
    prepDefault = fromPrep
    ioAction( fromPrep ) = 'DetachFrom'
    doAction = 'Detach'
    sdesc = "detach"
;

digVerb: Verb
    verb = 'dig' 'dig in'
    sdesc = "dig in"
    prepDefault = withPrep
    ioAction( withPrep ) = 'DigWith'
;

drinkVerb: Verb
    verb = 'drink'
    sdesc = "drink"
    doAction = 'Drink'
;

dropVerb: Verb, darkVerb
    verb = 'drop' 'put down'
    sdesc = "drop"
    ioAction( onPrep ) = 'PutOn'
    doAction = 'Drop'
    doDefault( actor, prep, io ) = (actor.allcont)
;

eatVerb: Verb
    verb = 'eat' 'consume'
    sdesc = "eat"
    doAction = 'Eat'
;

fastenVerb: Verb
    verb = 'fasten' 'buckle' 'buckle up'
    sdesc = "fasten"
    doAction = 'Fasten'
;

flipVerb: Verb
    verb = 'flip'
    sdesc = "flip"
    doAction = 'Flip'
;

followVerb: Verb
    sdesc = "follow"
    verb = 'follow'
    doAction = 'Follow'
    doIsSeen( p ) = true
    doIsTouched( p ) = nil
;

getOutVerb: Verb
    verb = 'get out' 'get outof' 'get off' 'get offof'
    sdesc = "get out of"
    doAction = 'Unboard'
    action(actor) = { askdo; }
    doDefault( actor, prep, io ) = {
        if (actor.locate and actor.location.locate)
            return( [] + actor.location );
        else return( [] );
    }
;

giveVerb: Verb
    verb = 'give' 'offer'
    sdesc = "give"
    prepDefault = toPrep
    ioAction( toPrep ) = 'GiveTo'
    doDefault( actor, prep, io ) = (actor.contents)
    ioIsSeen( p ) = true
    ioIsTouched( p ) = nil
;

helloVerb: Verb, fixedthing, floatingobject
    islisted = nil
    noun = 'hello' 'hi'
    verb = 'hello' 'hi' 'greetings'
    sdesc = "say hello to"
    locate = (parserGetMe().locate)
    action( actor ) = {
        if (parserGetMe().speak( self )) return;
        if (actor == parserGetMe()) Everyone.sayTo( parserGetMe(), self, nil );
        else actor.sayTo( parserGetMe(), self, true );
    }
    isactor = true
    isvisible( loc ) = true
    Say( a ) = "<q>Hello.</q>"
    dobjGen( a, v, i, p ) = {
      if (v != sayVerb) {  
        "An interesting idea, albeit an absurd one. ";
        abort;
      }
    }
    doAction = 'Hello'
    iobjGen( a, v, i, p ) = {
      "An interesting idea, albeit an absurd one. ";
      abort;
    }
;

iVerb: Verb
    verb = 'inventory' 'i'
    action( actor ) = {
        actor.inventory;
    }
;

inspectVerb: Verb
    verb = 'inspect' 'examine' 'look at' 'l at' 'x' 'regard' // 'consider'
    sdesc = "inspect"
    doAction = 'Inspect'
    doIsSeen( p ) = true
    doIsTouched( p ) = nil
;

jumpVerb: Verb
    verb = 'jump' 'jump over' 'jump off' 'leap' 'leap over' 'leap off'
            'plunge' 'plunge off' 'dive' 'dive over' 'dive off'
    sdesc = "jump"
    doAction = 'Jump'
    action( actor ) = {
        actor.locate.jump( actor );
    }
;

lieVerb: Verb
    verb = 'lie on' 'lie in' 'lie downon' 'lie downin'
    sdesc = "lie on"
    doAction = 'Lieon'
;

lockVerb: Verb
    verb = 'lock'
    sdesc = "lock"
    ioAction( withPrep ) = 'LockWith'
    doAction = 'Lock'
    prepDefault = withPrep
;

lookVerb: Verb
    verb = 'look' 'l' 'look around' 'l around' 'x around' 'bearings'
    sdesc = "look"
    doAction = 'Look'
    action( actor ) = {
        actor.locate.lookAround( true );
    }
    verbAction( a, d, p, i ) = {
        if (d) {
          redirect( a, inspectVerb, d );
          abort;
        }
    }
;

lookbehindVerb: Verb
    verb = 'look behind' 'l behind' 'x behind'
    sdesc = "look behind"
    doAction = 'Lookbehind'
    doIsSeen( p ) = true
    doIsTouched( p ) = nil
;

lookinVerb: Verb
    verb = 'look in' 'l in' 'x in'
    sdesc = "look in"
    doAction = 'Lookin'
    doIsSeen( p ) = true
    doIsTouched( p ) = nil
;

lookonVerb: Verb
    verb = 'look on' 'l on' 'x on'
    sdesc = "look on"
    doAction = 'Lookon'
    doIsSeen( p ) = true
    doIsTouched( p ) = nil
;

lookthruVerb: Verb
    verb = 'look through' 'look thru' 'l through' 'l thru' 'x through' 'x thru'
    sdesc = "look through"
    doAction = 'Lookthru'
    doIsTouched( p ) = nil
    doIsSeen( p ) = true
;

lookunderVerb: Verb
    verb = 'look under' 'look beneath' 'l under' 'l beneath' 'x under' 'x beneath'
    sdesc = "look under"
    doAction = 'Lookunder'
;

moveVerb: Verb
    verb = 'move' 'displace'
    sdesc = "move"
    ioAction( withPrep ) = 'MoveWith'
    ioAction( toPrep ) = 'MoveTo'
    doAction = 'Move'
;

moveEVerb: Verb
    verb = 'move east' 'move e' 'push east' 'push e'
    sdesc = "move east"
    doAction = 'MoveE'
;

moveNVerb: Verb
    verb = 'move north' 'move n' 'push north' 'push n'
    sdesc = "move north"
    doAction = 'MoveN'
;

moveSVerb: Verb
    verb = 'move south' 'move s' 'push south' 'push s'
    sdesc = "move south"
    doAction = 'MoveS'
;

moveWVerb: Verb
    verb = 'move west' 'move w' 'push west' 'push w'
    sdesc = "move west"
    doAction = 'MoveW'
;

moveNEVerb: Verb
    verb = 'move northeast' 'move ne' 'push northeast' 'push ne'
    sdesc = "move northeast"
    doAction = 'MoveNE'
;

moveNWVerb: Verb
    verb = 'move northwest' 'move nw' 'push northwest' 'push nw'
    sdesc = "move northwest"
    doAction = 'MoveNW'
;

moveSEVerb: Verb
    verb = 'move southeast' 'move se' 'push southeast' 'push se'
    sdesc = "move southeast"
    doAction = 'MoveSE'
;

moveSWVerb: Verb
    verb = 'move southwest' 'move sw' 'push southwest' 'push sw'
    sdesc = "move southwest"
    doAction = 'MoveSW'
;

openVerb: Verb
    verb = 'open'
    sdesc = "open"
    doAction = 'Open'
;

plugVerb: Verb
    verb = 'plug'
    sdesc = "plug"
    prepDefault = inPrep
    ioAction( inPrep ) = 'PlugIn'
;

pokeVerb: Verb
    verb = 'poke' 'jab'
    sdesc = "poke"
    doAction = 'Poke'
;

pullVerb: Verb
    verb = 'pull' 'yank'
    sdesc = "pull"
    doAction = 'Pull'
;

pushVerb: Verb
    verb = 'push' 'press' 'depress'
    sdesc = "push"
    doAction = 'Push'
;

putVerb: Verb
    verb = 'put' 'place' 'position'
    sdesc = "put"
    prepDefault = inPrep
    ioAction( inPrep ) = 'PutIn'
    ioAction( onPrep ) = 'PutOn'
    ioAction( underPrep ) = 'PutUnder'
    ioAction( behindPrep ) = 'PutBehind'
    doDefault( actor, prep, io ) = (takeVerb.doDefault( actor, prep, io ) + actor.contents)
;

readVerb: Verb
    verb = 'read'
    sdesc = "read"
    doAction = 'Read'
;

removeVerb: Verb
    verb = 'take off' 'doff'
    sdesc = "take off"
    doAction = 'Unwear'
    ioAction( fromPrep ) = 'RemoveFrom'
;

sayVerb: Verb
    verb = 'say'
    sdesc = "say"
    doAction = 'Say'
    ioAction( toPrep ) = 'SayTo'
    doIsTouched( p ) = nil
    ioIsTouched( p ) = nil
    ioIsSpokenTo( p ) = true
;

screwVerb: Verb
    verb = 'screw' 'screw in'
    sdesc = "screw"
    ioAction( withPrep ) = 'ScrewWith'
    doAction = 'Screw'
;

searchVerb: Verb
    verb = 'search'
    sdesc = "search"
    doAction = 'Search'
;

showVerb: Verb
    verb = 'show'
    sdesc = "show"
    prepDefault = toPrep
    ioAction( toPrep ) = 'ShowTo'
    doDefault( actor, prep, io ) = (actor.contents)
    ioIsSeen( p ) = true
    ioIsTouched( p ) = nil
;

sitVerb: Verb
    verb = 'sit on' 'sit in' 'sit downin' 'sit downon' 'sit' 'sit down'
    sdesc = "sit on"
    doAction = 'Siton'
    action( actor ) = {
        actor.locate.sitDown( actor );
    }
;

sleepVerb: darkVerb
    action( actor ) = {
        if (actor.cantSleep)
            "%You% %are% far too worried about life to sleep. ";
        else if (global.sleepyTime + 1 < global.sleepTime)
            "%You're% not tired. ";
        else if (actor.locate.issleepable) actor.sleep;
    }
    verb = 'sleep'
;

switchVerb: Verb
    verb = 'switch'
    sdesc = "switch"
    doAction = 'Switch'
;

takeVerb: Verb
    verb = 'take' 'pick up' 'get' 'remove'
    sdesc = "take"
    ioAction( offPrep ) = 'TakeOff'
    ioAction( fromPrep ) = 'TakeOut'
    ioAction( inPrep ) = 'TakeOut'
    ioAction( onPrep ) = 'TakeOff'
    ioAction( outfromPrep ) = 'TakeOut'
    ioAction( outunderPrep ) = 'TakeOutfromunder'
    ioAction( outbehindPrep ) = 'TakeOutfrombehind'
    ioAction( underPrep ) = 'TakeOutfromunder'
    ioAction( behindPrep ) = 'TakeOutfrombehind'
    doAction = 'Take'
    pospreplist = []
    doDefault( actor, prep, io ) = {
        local ret = [], rem, cur, rem2, cur2, tot, i, tot2, j;
        if (io != nil and find( self.pospreplist, prep )) {
            rem = io.allcont;
            for (i = 1, tot = length( rem ); i <= tot; ++i) {
                cur = rem[i];
                if (not cur.isfixed and self.validDo( actor, cur, i )) ret += cur;
            }
            return ret;
        }
        rem = actor.locate.allcont;
        for (i = 1, tot = length( rem ); i <= tot; ++i) {
            cur = rem[i];
            if (cur.isfixed) {
                if (((cur.isopenable and cur.isopen) or
                  (not cur.isopenable)) and (not cur.isactor)) {
                    rem2 = cur.allcont;
                    for (j = 1, tot2 = length( rem2 ); j <= tot2; ++j) {
                        cur2 = rem2[j];
                        if (not cur2.isfixed and not cur2.notakeall) ret += cur2;
                    }
                }
            }
            else if (not cur.notakeall) ret += cur;
        }
        return ret;
    }
;

tellVerb: Verb
    verb = 'tell' 'inform'
    sdesc = "tell"
    prepDefault = aboutPrep
    ioAction( aboutPrep ) = 'TellAbout'
    validIo( actor, obj, seqno ) = (seqno == 1)
    validIoList(actor, prep, dobj) = (nil)
    ioDefault( actor, prep ) = {
        if (prep == aboutPrep) return([]);
        else pass ioDefault;
    }
    doIsSpokenTo( p ) = true
    doIsTouched( p ) = nil
;

standVerb: Verb
    verb = 'stand' 'stand up' 'get up'
    sdesc = "stand"
    action( actor ) = {
        actor.locate.standup( actor );
    }
;

standOnVerb: Verb
    verb = 'stand on'
    sdesc = "stand on"
    doAction = 'Standon'
;

throwVerb: Verb
    verb = 'throw' 'toss' 'heave'
    sdesc = "throw"
    prepDefault = atPrep
    ioAction( atPrep ) = 'ThrowAt'
    ioAction( toPrep ) = 'ThrowTo'
    ioAction( inPrep ) = 'ThrowIn'
    ioIsSeen( p ) = true
    ioIsTouched( p ) = nil
;

touchVerb: Verb
    verb = 'touch'
    sdesc = "touch"
    doAction = 'Touch'
;

turnVerb: Verb
    verb = 'turn' 'rotate' 'twist'
    sdesc = "turn"
    ioAction( toPrep ) = 'TurnTo'
    ioAction( withPrep ) = 'TurnWith'
    doAction = 'Turn'
    ioIsTouched( p ) = true
;

turnOffVerb: Verb
    verb = 'turn off' 'deactivate' 'switch off'
    sdesc = "turn off"
    doAction = 'Turnoff'
;

turnOnVerb: Verb, darkVerb
    verb = 'activate' 'turn on' 'switch on'
    sdesc = "turn on"
    doAction = 'Turnon'
;

typeVerb: Verb
    verb = 'type' 'tap out'
    sdesc = "type"
    prepDefault = onPrep
    ioAction( onPrep ) = 'TypeOn'
    doIsTouched( p ) = nil
;

unfastenVerb: Verb
    verb = 'unfasten' 'unbuckle'
    sdesc = "unfasten"
    doAction = 'Unfasten'
;

unlockVerb: Verb
    verb = 'unlock'
    sdesc = "unlock"
    ioAction( withPrep ) = 'UnlockWith'
    doAction = 'Unlock'
    prepDefault = withPrep
;

unplugVerb: Verb
    verb = 'unplug'
    sdesc = "unplug"
    ioAction( fromPrep ) = 'UnplugFrom'
    doAction = 'Unplug'
;

unscrewVerb: Verb
    verb = 'unscrew'
    sdesc = "unscrew"
    ioAction( withPrep ) = 'UnscrewWith'
    doAction = 'Unscrew'
;

waitVerb: darkVerb
    verb = 'wait' 'z'
    action( actor ) = {
        if (actor.locate) actor.locate.Wait( actor );
        else "Time passes...\n";
    }
;

wearVerb: Verb
    verb = 'wear' 'put on' 'don'
    sdesc = "wear"
    doAction = 'Wear'
;

yellVerb: Verb
    verb = 'yell' 'shout' 'scream'
    action( actor ) = {
        actor.speak( self );
        Everyone.sayTo( actor, self, nil );
    }
    Say( a ) = "%you% <<conj('scream')>> mightily."
    doAction = 'Shout'
    doIsTouched( p ) = nil
;

//  (modify)
// Help defines the help information shown for this verb
// verbtask processes the action of the verb without calling abort;
//  This function duplicates that given in adv.t by the special verb routines, but
//  consolidates nomenclature to avoid confusion.
// ldesc is the most important message printed by the verb (more specifically, the
//  most likely to be changed).  For saveVerb and restoreVerb, these must return single-
//  quoted strings.
class sysVerb: darkVerb
    isSysVerb = true
    action( actor ) = {
        self.verbtask( actor );
        abort;
    }
    value = 0
    helpsdesc = (self.sdesc)
;

class travelVerb: darkVerb, Direction
    isTravelVerb = true
    action( actor ) = {
        actor.locate.travel( actor, self.dirTravel );
    }
;

aboutVerb: sysVerb
    verb = 'about'
    sdesc = "about"
    Help = "Gives information about << version.sdesc >>"
    verbtask( a ) = {
        local o;
        version.ldesc;
    }
    value = 5
;

helpVerb: sysVerb
    verb = 'help'
    sdesc = "help"
    verbtask( actor ) = {
        self.ldesc;
    }
    ldesc = {
        local lst = gac( sysVerb ), i, len = length( lst ), v = [];
        local minv = 0, maxv = 0, val, j, jlen;
        "Basic command synopsis:";
        for (i = 1; i <= len; ++i) {
          val = lst[i].value;
          v += val;
          if (val <= minv) minv = val;
          if (val >= maxv) maxv = val;
        }        
        for (i = minv; i <= maxv; ++i) {
          val = getIndexList( v, i );
          if (val == nil) continue;
          for (j = 1, jlen = length( val ); j <= jlen; ++j)
            "\n<< lst[val[j]].helpsdesc >>: << lst[val[j]].Help >>";
        }
    }
    doAction = 'Help'
    allowInDark( d, p, i ) = (d ? nil : true)
    Help = "Help screen"
    value = 10
;

iTallVerb: sysVerb
    verb = 'inventorytall' 'tall' 'inventorylist' 'ilist' 'itall'
    sdesc = "inventory tall"
    Help = "Give inventories vertically"
    ldesc = {
        version.sdesc; " will now give inventories in vertical lists, rather
        than in paragraph form. ";
    }
    verbtask( actor ) = {
        global.inventall = true;
        self.ldesc;
    }
    value = 15
;

iWideVerb: sysVerb
    verb = 'inventorywide' 'wide' 'iwide'
    sdesc = "inventory wide"
    Help = "Give inventories in paragraphs"
    ldesc = {
        version.sdesc; " will now give inventories in paragraphs, rather
        than in vertical lists. ";
    }
    verbtask( actor ) = {
        global.inventall = nil;
        self.ldesc;
    }
    value = 20
;

optionsVerb: sysVerb
    verb = 'options'
    sdesc = "options"
    Help = "Access the game options"
    verbtask( actor ) = {
        writeMenu( optionsMenu );
    }
    value = 25
;

quitVerb: sysVerb
    verb = 'quit'
    sdesc = "quit"
    Help = "Leave the game"
    ldesc = {
        scoreVerb.verbtask( parserGetMe() );
    }
    verbtask( actor ) = {
        self.ldesc;
        writeMenu( quitMenu );
    }
    allowInDark( d, p, i ) = (d ? nil : true)
    doAction = 'Unboard' 
    doDefault( actor, prep, io ) = {
        if (actor.locate and actor.locate.locate)
            return( [] + actor.locate );
        else return [];
    }
    value = 30
;

restartVerb: sysVerb
    verb = 'restart'
    sdesc = "restart"
    Help = "Begin again"
    ldesc = "Are you sure you want to start over? (YES or NO) > "
    verbtask( actor ) = {
        writeMenu( restartMenu );
    }
    value = 35
;

restoreVerb: sysVerb
    verb = 'restore'
    sdesc = "restore"
    Help = "Restore progress from a file"
    doAction = 'Restore'
    ldesc = 'File to restore game from'
    verbtask( actor ) = {
        local savefile;        
        savefile = askfile( ldesc, ASKFILE_PROMPT_OPEN, FILE_TYPE_SAVE, ASKFILE_EXT_RESULT );
        switch( savefile[1] ) {
          case ASKFILE_SUCCESS:
            self.tryfile( savefile[2] );
            break;
          case ASKFILE_FAILURE:
            "Error: dialog not displayed.
            \nInput filename: ";
            self.tryfile( inputLine() );
            break;
          case ASKFILE_CANCEL:
            "Restore aborted. ";
        }
    }
    tryfile( fname ) = {
      if (fname == '' or fname == nil) "Restore aborted. ";
      else {
        fname = restore( fname );
        switch( fname ) {
          case RESTORE_SUCCESS:
            showScore(global.score, global.thisturn);
            "Restored.\b";
            parserGetMe().location.lookAround(true);
            break;
          case RESTORE_FILE_NOT_FOUND:
            "Restore failed:  file not found. "; break;
          case RESTORE_NOT_SAVE_FILE:
            "Restore failed:  file is not a TADS saved game. "; break;
          case RESTORE_BAD_FMT_VSN:
            "Restore failed:  file has been saved in an incompatible format. "; break;
          case RESTORE_BAD_GAME_VSN:
            "Restore failed:  file is from a different game. "; break;
          case RESTORE_READ_ERROR:
            "Restore failed:  file is damaged. "; break;
          case RESTORE_NO_PARAM_FILE:
            "TADS error:  No restore parameter provided to interpreter. "; break;
        }
      }
    }
    value = 40
;

saveVerb: sysVerb
    verb = 'save'
    sdesc = "save"
    Help = "Save progress to a file"
    doAction = 'Save'
    ldesc = 'File to save game in'
    verbtask( actor ) = {
        local savefile;
        savefile = askfile( ldesc );
        if (savefile == nil or savefile == '') {
            "Failed. ";
            return nil;
        }
        else if (save( savefile )) {
            "Saved failed. ";
            return nil;
        }
        else {
            "Saved. ";
            return true;
        }
    }
    value = 45
;

scoreVerb: sysVerb
    verb = 'score' 'status'
    sdesc = "score"
    Help = "Give the current score or a status report"
    ldesc = (rank())
    verbtask( actor ) = {
        self.ldesc;
    }
    value = 50
;

scriptVerb: sysVerb
    verb = 'script' 'log'
    sdesc = "script"
    Help = "Store text in a file"
    doAction = 'Script'
    verbtask( actor ) = {
        local scriptfile;
        scriptfile = askfile( 'File to write transcript to' );
        if (scriptfile == nil or scriptfile == '') "Failed. ";
        else {
            logging( scriptfile );
            "All text will now be saved to the script file.
            Type UNSCRIPT at any time to discontinue scripting.";
        }
    }
    value = 55
;

terseVerb: sysVerb
    verb = 'brief' 'terse'
    sdesc = "terse"
    Help = "Give complete descriptions only when first entering a room"
    ldesc = {
        version.sdesc; " will now only volunteer full descriptions of places
        when they are first entered. ";
    }
    verbtask( actor ) = {
        self.ldesc;
        global.verbose = nil;
    }
    value = 60
;

undoVerb: sysVerb
    verb = 'undo'
    sdesc = "undo"
    Help = "Take back a move"
    verbtask( actor ) = {
        if (undo() and undo()) {
            self.ldesc; "\b";
            parserGetMe().locate.lookAround( true );
            showScore( global.score, global.thisturn );
            return true;
        }
        else "No more undo information is available. ";
    }
    ldesc = "(Undoing one command)"
    action( actor ) ={
        self.verbtask( actor );
        abort;
    }
    value = 65
;

unscriptVerb: sysVerb
    verb = 'unscript' 'unlog' 'stoplog'
    sdesc = "unscript"
    Help = "End text scripting"
    ldesc = {
        "Script closed.\n";
    }
    verbtask( actor ) = {
        self.ldesc;
        logging( nil );
    }
    value = 70
;

//  (modify)
//  Set global.verboseLook to true if you want this verb to look around whenever
//  "verbose" is entered.
verboseVerb: sysVerb
    verb = 'verbose'
    sdesc = "verbose"
    Help = "Give complete descriptions whenever entering a room, whether the room has been entered before or not"
    ldesc = {
        version.sdesc; " will now provide full descriptions of places
        whenever they are entered. ";
    }
    action( actor ) = {
        self.ldesc;
        global.verbose = true;
        if (global.verboseLook) actor.locate.lookAround( true );
        else abort;
    }
    value = 75
;

//  (modify)
//  This now requests version.bdesc.  version.bdesc should abort if
//  compilation and runtime information is not wanted.
versionVerb: sysVerb
    verb = 'version'
    sdesc = "version"
    Help = "Give the current version of this work"
    ldesc = {
        "\nCompiled with TADS v"; say( __TADS_VERSION_MAJOR );
        "."; say( __TADS_VERSION_MINOR ); " on ";
        sayDate( __DATE__ );
    }
    verbtask( actor ) = {
        local o;
        version.bdesc;
        self.ldesc;
        for (o = firstobj( versionInfo ); o; o = nextobj( o, versionInfo ))
            o.bdesc;
    }
    value = 80
;

// (modify)  will not appear if game is not in debugging mode.  Of course, the gamefile
//  could always #define __DEBUG if it wanted to...
#ifdef __DEBUG

aquitVerb: sysVerb
    verb = 'aquit'
    sdesc = "aquit"
    Help = "(debug) Quit without question (execute conclude())"
    verbtask( actor ) = {
        conclude();
    }
;

beammeVerb: sysVerb
    verb = 'beamme'
    sdesc = "beamme"
    Help = "(debug) Transport verb"
    verbtask( a ) = {
        "Location name (title): ";
        strObj.value = inputLine();
        strObj.doBeamme( a );
    }
    doAction = 'Beamme'
;

debugVerb: sysVerb
    verb = 'debug'
    sdesc = "debug"
    Help = "(debug) Enter debugger"
    verbtask( actor ) = {
        if (debugTrace()) self.ldesc;
    }
    ldesc = "But surely this game is already in a perfect state... "
;

debugoff: sysVerb
    verb ='debug off'
    sdesc = "debug off"
    Help = "(debug) Turn off debugTrace"
    verbtask( actor ) = {
        "debugTrace disabled. ";
        debugTrace( 1, nil );
    }
;

debugon: sysVerb
    verb ='debug on'
    sdesc = "debug on"
    Help = "(debug) Turn on debugTrace"
    verbtask( actor ) = {
        "debugTrace enabled. ";
        debugTrace( 1, true );
    }
;

godieVerb: sysVerb
    verb = 'godie'
    sdesc = "godie"
    Help = "(debug) Execute die()"
    verbtask( actor ) = {
        die();
    }
;

locateVerb: sysVerb
    validDo( actor, obj, seqno ) = true
    validDoList(actor, prep, iobj) = (nil)
    verb = 'location'
    sdesc = "location"
    doAction = 'Location'
    Help = "(debug) Print location info for an object"
    verbtask( actor ) = {
        actor.doLocation( actor );
    }
    doIsTouched( p ) = nil
;

tstestVerb: sysVerb
    verb = 'tstest'
    sdesc = "tstest"
    Help = "(debug) Framework for test routine"
    verbtask( actor ) = {
        local o = self;
        switch( o ) {
          case self: "Self. ";
          default: "Not found. ";
        }
    }
;

#endif

// #include <ts_sense.t>
