#pragma C+

class Sense: object;

Vision: Sense
    blocksenseProp = &blockvision
    issensibleProp = &isvisible
    positionProp = &visProp
    quicksensibleProp = &visiblelist
;

Reach: Sense
    blocksenseProp = &blockreach
    issensibleProp = &isreachable
    positionProp = &reachProp
    quicksensibleProp = &reachable
;

Hearing: Sense
    blocksenseProp = &blockhearing
    issensibleProp = &isaudible
    positionProp = nil
    quicksensibleProp = &audiblelist
;

modify thing
    audiblelist = []
    reachable = []
    visiblelist = []
    //  A new version.  Let's hope it works.
    cansense( sen, obj, ... ) = {
        local lst = self.(sen.quicksensibleProp), i, len = length( lst );
        local loc, pos, c = 1;
        if (argcount >= 3) c = getarg( 3 ) + 1;
        for (i = 1; i <= len; ++i)
          if (obj.isin( lst[i] ))
            if (lst[i].cansense( sen, obj, c )) return true;
        if (obj == self) return not self.blocksense( sen, self, self, c );
        if (self.isin( obj )) {
          local loc = self.locate;
          if (loc == obj) return not loc.blocksense( sen, self.position, loc, c );
          if (loc.blocksense( sen, self.position, true, c )) return nil;
          else return loc.cansense( sen, obj, c );
        }
        if (obj.isin( self )) {
          lst = obj.locatetree( self );
          len = length( lst );
          if (self.blocksense( sen, self, lst[len - 1], c )) return nil;
          else return lst[len - 2].cansense( sen, obj, c );
        }
        lst = obj.locatetree( nil );
        loc = self.locatetree( nil );
        len = length( lst );
        for (i = 3; i <= len; i += 2) {
          pos = find( loc, lst[i] );
          if (pos != nil) {
            if (lst[i].blocksense( sen, loc[pos - 1], lst[i - 1] , c + ((pos - 1) / 2))) return nil;
            if (self.cansense( sen, lst[i], c ) == nil) return nil;
            return lst[i].cansense( sen, obj, c + ((pos - 1) / 2));
          }
        }
        return nil;
    }            
/*  cansense( obj, sen ) = {
        local loc, pos, i, lst, len;
        if (obj == self) return not self.blocksense( sen, self, self );
        loc = self;
        pos = self;
        while (loc) {
          if (loc == obj) return not loc.blocksense( sen, pos, loc );
          if (obj.isin( loc )) {
            lst = obj.locatetree( loc );
            len = length( lst );
            if (loc.blocksense( sen, loc, lst[len - 1] )) goto SENSELIST;
            for (i = len - 2; i >= 3; i -= 2)
              if (lst[i].blocksense( sen, true, lst[i - 1] )) goto SENSELIST;
            return true;
          }
          pos = loc.position;
          loc = loc.locate;
        }
        SENSELIST:
        lst = self.(sen.quicksensibleProp);
        for (i = 1, len = length( lst ); i <= len; ++i)
          if (lst[i].cansense( obj, sen )) return true;
        return nil;
    } */
    blocksense( sen, from, to, cnt ) = (self.(sen.blocksenseProp)( from, to, cnt ))
    blockhearing( from, to, cnt ) = {
        return self.blockvision( from, to, cnt );
    }
    blockreach( from, to, cnt ) = {
// case values must be constant;  that self is allowed in compilation
// is a bug.
        if (to == self) return nil;
        switch (to) {
          case true: return true;
          default: return not self.(to.reachProp);
        }
    }
    blockvision( from, to, cnt ) = {
        if (to == self) return nil;
        switch (to) {
          case true: return nil;
          default: return not self.(to.visProp);
        }
    }
    isaddressable( obj ) = (self.cansense( Hearing, obj ))
    isreachable( obj ) = (obj.cansense( Reach, self ))
    isvisible( obj ) = (obj.cansense( Vision, self ))
;

// bookmark
class partialroomparent: room
    contentsReachable = true
;

class partialroom: nestedroom
    statusdesc = (self.sdesc)
    blockreach( from, to, cnt ) = {
        if (to == self) return nil;
        switch (to) {
          case true: return nil;
          default: return not self.(to.reachProp);
        }
    }
    incontvisible = true
    incontreachable = (parserGetMe().isin( self ))
    isqcontainer = (parserGetMe().isin( self ))
    oncontreachable = (parserGetMe().isin( self ))
    oncontvisible = nil
;
