/*
 * Sample game to test actor stuff. It includes all the actor classes from
 * Chapter 9 of the WorldClass Author's Manual. Currently, it instantiates a
 * Controllable actor, but the actor definition can be changed to try out the
 * other actor classes.
 *
 * This module has been built to work with WorldClass
 * Copyright (C) 1994 by Paul Gilbert
 */
#include <world.t>

Me: Player
   location = room1
;

room1: Room
  sdesc = "room 1"
  ldesc = "You are in a very boring room. There is a passage to the east and
     south, and an imaginary passage to the west."
  noun = 'room 1'

  goEast  = room2
  goSouth = room4
  verGoWest(actor) =
     { "%You% can't go that way, since %you% <<actor.isnt>> imaginary."; }
;

room2: Room
  sdesc = "room 2"
  ldesc = "You are in a second boring room. Exits are to the south and west."
  noun = 'room 2'

  goSouth = room3
  goWest = room1
;

room3: Room
  sdesc = "room 3"
  ldesc = "This is yet another boring room, with exits to the north & west."
  noun = 'room 3'

  goWest = room4
  goNorth = room2
;

room4: Room
  sdesc = "room 4"
  ldesc = "This is... you guessed it, another boring room, with exits to the
     east and north."
  noun = 'room 4'

  goEast  = room3
  goNorth = room1
;

/*
 * Actor Classes. Here we define the actor classes, and any modifications to
 * existing classes which will be required.
 */

modify global
   nondeterministic = true
   dirstringlist =      ['north' 'northeast' 'east' 'southeast'
	 'northwest' 'west' 'southwest' 'south']
   olddirlist = [&north, &ne, &east, &se, &nw, &w, &sw, &s]
   verdirlist = [&verGoNorth, &verGoNortheast, &verGoEast, &verGoSoutheast,
	 &verGoNorthwest, &verGoWest, &verGoSouthwest, &verGoSouth]
   dirlist =    [&goNorth, &goNortheast, &goEast, &goSoutheast,
	 &goNorthwest, &goWest, &goSouthwest, &goSouth]
;

class Mover: Actor
	diroklist = []

movevalid(direction) =
	{
   local dir := find( global.dirstringlist, direction );
	local dest;

	// Check to see if the given direction is in the dirok list.
	// If it is, then return true immediately.
	if ( find(self.diroklist, direction) )
		return true;

	// Check to see if a verGo<dir> method exists, and if so call it
	// to see if it outputs anything. If it does, the test fails
	if (defined(self.location, global.verdirlist[dir]))
		{
		Outhide(true);
		self.location.(global.verdirlist[dir])(self);
		if (Outhide(nil))
			return nil;
		}

	// Check to see if a go<dir> is defined, then get the destination,
	// remembering that it can be both a method or set to an object.
	// Then check to see if destination is not nil, and if so output true.
	if (defined(self.location, global.dirlist[dir]))
		{
		if (proptype(self.location, global.dirlist[dir])=6)
			dest := self.location.(global.dirlist[dir])(self);
		else
			dest := self.location.(global.dirlist[dir]);
		if ( dest ) return true; else return nil;
		}
	else
		{
		if (defined(self.location, global.olddirlist[dir]))
			return true;
		else
			return nil;     
		}
	}

getdestination( direction ) =
	{
	local dir := find( global.dirstringlist, direction );

	// Check to see if a verGo<dir> method exists, and if so call it
	// to see if it outputs anything. If it does, the test fails
	if (defined(self.location, global.verdirlist[dir]))
		{
		Outhide(true);
		self.location.(global.verdirlist[dir])(self);
		if (Outhide(nil))
			return nil;
		}

	// Check to see if a go<dir> is defined, then get the destination,
	// remembering that it can be both a method or set to an object.
	// Then check to see if destination is not nil, and if so output true.
	if (defined(self.location, global.dirlist[dir]))
		{
		if (proptype(self.location, global.dirlist[dir])=6)
			return self.location.(global.dirlist[dir])(self);
		else
			return self.location.(global.dirlist[dir]);
		}
	else
		{
		if (defined(self.location, global.olddirlist[dir]))
			return self.location.(global.olddirlist[dir]);
		else
			return nil;     
		}
	}
;

class Wanderer: Mover
	roomprop = nil
	pauseturns = 3

	leavemessage(dir) =
		{ "\n\^<<self.subjthedesc>> ";
			if (self.isplural) "leave"; else "leaves";
			" to the <<dir>>."; }
	entermessage(dir) =
		{ "\n\^<<self.subjthedesc>> ";
			if (self.isplural) "enter"; else "enters";
			" from the <<dir>>."; }
	attemptedleave(dir) =
		{ "\n\^<,self.subjthedesc>> starts going to the <<dir>>. "; }

	pausectr = 0
	moveDaemon =
		{
		local tries;

		pausectr += global.turnspertick;
		if (pausectr > pauseturns)
			{
			for (tries:=1; tries<50; tries++)
				{
				local dir := global.dirstringlist[rnd(8)];
				local seen;
				local dest;

				if ( self.movevalid(dir) )
					{
					dest := self.getdestination(dir);
					seen := Me.cansee( self.location, self.locationtype, true );
					if ( dest = nil )
						{
						if ( seen )
							{
							self.attemptedleave(dir);
							self.location.(global.verdirlist[dir])(self);
							}
						exit;
						}
					else
						{
						if ( not self.roomprop or ( self.roomprop and dest.(self.roomprop) ) )
							{
							if ( seen )
							  self.leavemessage(dir);
							Outhide(true);        
							self.travelto( dest );
							Outhide(nil);
							if ( Me.cansee( self.location, self.locationtype, true ) )
							  self.entermessage(global.dirstringlist[9 - find(global.dirstringlist, dir)]);
							pausectr := 0;
							exit;
								
							}
						}
					}
				}
			}
		}
;

class Trackactor: Mover
	track = []
	pauseturns = 3

	pausectr = 0
	trackctr = 1

	leavemessage(dir) =
		{ "\n\^<<self.subjthedesc>> ";
			if (self.isplural) "leave"; else "leaves";
			" to the <<dir>>.\n"; }
	entermessage(dir) =
		{ "\n\^<<self.subjthedesc>> ";
			if (self.isplural) "enter"; else "enters";
			" from the <<dir>>.\n"; }
	attemptedleave(dir) =
		{ "\n\^<,self.subjthedesc>> starts to the <<dir>>. "; }

	moveDaemon =
		{
		pausectr += global.turnspertick;
		if (pausectr > pauseturns)
			{
			if ( length(self.track) = 0 )
				{
				pausectr := 0;
				return;
				}
			else
				{
				local dir := self.track[trackctr];
				local seen;
				local dest;

				if ( self.movevalid(dir) )
					{
					dest := self.getdestination(dir);
					seen := Me.cansee( self.location, self.locationtype, true );
					if (dest = nil )
						{
						if ( seen )
							{
							self.attemptedleave(dir);
							self.location.(global.verdirlist[dir])(self);
							}
						return;
						}
					else
						{
						if ( not self.roomprop or ( self.roomprop and dest.(self.roomprop) ) )
							{
							if ( seen )
								self.leavemessage(dir);
							Outhide(true);
							self.travelto( dest );
							Outhide(nil);
							if ( Me.cansee( self.location, self.locationtype, true ) )
								self.entermessage(global.dirstringlist[9 - find(global.dirstringlist, dir)]);
							pausectr := 0;
							trackctr += 1;
							if ( trackctr > length(track) ) trackctr := 1;
							return;
							}
						}
					}
				}
			}
		}
;

class Controllable: Mover
	leavemessage(dir) =
		{ "\b\^<<self.subjthedesc>> ";
			if (self.isplural) "leave"; else "leaves";
			" to the <<dir>>.\n"; }
	entermessage(dir) =
		{ "\b\^<<self.subjthedesc>> ";
			if (self.isplural) "enter"; else "enters";
			" from the <<dir>>.\n"; }
	attemptedleave(dir) =
		{ "\b\^<,self.subjthedesc>> starts to the <<dir>>. "; }

	actorAction(v, d, p, i) =
	{
	if (isclass(v, Travelverb))
		{
		local dir := global.dirstringlist[ find( global.dirlist, v.doprop ) ];
		local dest;
		local seen;

		if ( self.movevalid(dir) )
			{
			dest := self.getdestination(dir);
			seen := Me.cansee( self.location, self.locationtype, true );
			if (dest = nil )
				{
				if ( seen )
					{
					self.attemptedleave(dir);
					self.location.(global.verdirlist[dir])(self);
					}
				exit;
				}
			else
				{
				if ( not self.roomprop or ( self.roomprop and dest.(self.roomprop) ) )
					{
					if ( seen )
					   self.leavemessage(dir);
					else
					   "Done.";
					Outhide(true);
					self.travelto( dest );
					Outhide(nil);
					if ( Me.cansee( self.location, self.locationtype, true ) )
						self.entermessage(global.dirstringlist[9 - find(global.dirstringlist, dir)]);
					}
				exit;
				}
			}
		}
	else if (v <> helloVerb)
		{
		self.aamessage(v, d, p ,i);
		exit;
		}
	}
;

/*
 * Here we activate any moveDaemons
 */
replace userinit: function
{
	if (global.restarting = nil) {
		"\b\b\b\b\b\b\b\b";
		intro();
	}
	global.lastactor := Me;
	Me.location.enter(Me);
	notify(monk, &moveDaemon, 0);
}

/*
 * Here's where we try out the classes
 */
monk: Male, Controllable
  track = ['east' 'south' 'west' 'north']
  sdesc = "monk"
	location = room1
	noun = 'monk'
	actordesc = {
		"There is an ancient monk here.";
	}
;
