//
//  XTBaseTextHandler_private.h
//  XTads
//
//  Created by Rune Berg on 11/08/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTBaseTextHandler.h"


#define NO_CHILD_INDEX  (-1)


@interface XTBaseTextHandler ()

@property NSString *debugName;

@property (weak) XTBaseTextHandler *parentHandler;
@property NSMutableArray *childHandlers; // of XTBannerHandler

@property (weak) XTBannerTextHandler *siblingForWhere; // "other"

@property NSMutableArray *layoutViews;

@property XTPrefs *prefs;

@property NSMutableArray *formattingQueue;

// pagination state
@property NSAttributedString *attributedStringThatBrokePaginationLimit;
@property CGFloat maxTextViewHeightBeforePagination;
@property CGFloat visibleHeightBeforeLayoutOfViews;
@property CGFloat totalHeightBeforeLayoutOfViews;

@property NSRect visibleRectAtStartOfWindowResize;

@property BOOL nonstopModeState;


- (void)setBannerIndex:(NSUInteger) bannerIndex;

- (NSAttributedString *)appendAttributedStringToTextStorage:(NSAttributedString *)attrString;

- (void)addChildHandler:(XTBannerTextHandler *)childHandler;

- (NSInteger)indexOfChild:(XTBannerTextHandler*)childHandler;

- (void)tearDownLayoutViews;

- (void)teardownReceptionOfAppLevelNotifications;

- (NSView *)internalRebuildViewHierarchy;

- (void)clearPaginationState;

- (BOOL)shouldAutoScrollToBottom;

- (void)recalcDynamicTabStops:(BOOL)changedMainOutputAreaSize;

- (BOOL)processFormattingQueue;

- (void)restoreStringThatBrokePaginationLimit;

- (BOOL)checkIfHasReachedPaginationLimit:(NSAttributedString *)lastAttrStringAppended;

@end
