//
//  XTFormattedOutputElement.m
//  TadsTerp
//
//  Created by Rune Berg on 10/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTFormattedOutputElement.h"
#import "XTAllocDeallocCounter.h"


@implementation XTFormattedOutputElement

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

+ (instancetype) regularOutputElement:(NSMutableAttributedString *)attributedString
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementRegularOutput;
	elt.attributedString = attributedString;
	return elt;
}

+ (instancetype)tabElement:(XTHtmlTag *)htmlTag attributedString:(NSMutableAttributedString *)attributedString
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementTab;
	elt.attributedString = attributedString;
	elt.htmlTag = htmlTag;
	return elt;
}

+ (instancetype)gameTitleElement:(NSMutableAttributedString *)attributedString
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementGameTitle;
	elt.attributedString = attributedString;
	return elt;
}

+ (instancetype)bannerStartElement:(XTHtmlTag *)htmlTag;
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementBannerStart;
	elt.htmlTag = htmlTag;
	return elt;
}

+ (instancetype)bannerEndElement
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementBannerEnd;
	return elt;
}

+ (instancetype)bannerClearElement
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementBannerClear;
	return elt;
}

+ (instancetype)statusLineModeStart
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementStatusLineModeStart;
	return elt;
}

+ (instancetype)statusLineModeEnd
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementStatusLineModeEnd;
	return elt;
}

+ (instancetype)statusLineModeSuppress
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementStatusLineModeSuppress;
	return elt;
}

+ (instancetype)clearWhitespaceBeforeOrAfterBlockLevelTagOutputElement
{
	XTFormattedOutputElement *elt = [XTFormattedOutputElement new];
	elt.elementType = XTFormattedOutputElementClearWhitespaceBeforeOrAfterBlockLevelTag;
	return elt;
}

- (BOOL)isRegularOutputElement
{
	return (self.elementType == XTFormattedOutputElementRegularOutput);
}

- (BOOL)isRegularOutputElementWithString:(NSString *)str
{
	return [self isRegularOutputElement] && [str isEqualToString:self.attributedString.string];
}

- (BOOL)isTabElement
{
	return (self.elementType == XTFormattedOutputElementTab);
}

- (BOOL)isGameTitleElement
{
	return (self.elementType == XTFormattedOutputElementGameTitle);
}

- (BOOL)isBannerStartElement
{
	return (self.elementType == XTFormattedOutputElementBannerStart);
}

- (BOOL)isBannerEndElement
{
	return (self.elementType == XTFormattedOutputElementBannerEnd);
}

- (BOOL)isBannerClearElement
{
	return (self.elementType == XTFormattedOutputElementBannerClear);
}

- (BOOL)isStatusLineModeStart
{
	return (self.elementType == XTFormattedOutputElementStatusLineModeStart);
}

- (BOOL)isStatusLineModeEnd
{
	return (self.elementType == XTFormattedOutputElementStatusLineModeEnd);
}

- (BOOL)isStatusLineModeSuppress
{
	return (self.elementType == XTFormattedOutputElementStatusLineModeSuppress);
}

- (BOOL)isClearWhitespaceBeforeOrAfterBlockLevelTagOutputElement
{
	return (self.elementType == XTFormattedOutputElementClearWhitespaceBeforeOrAfterBlockLevelTag);
}

- (NSString *)elementTypeAsString
{
	NSString *res;
	switch (self.elementType) {
		case XTFormattedOutputElementRegularOutput:
			res = @"RegularOutput";
			break;
		case XTFormattedOutputElementTab:
			res = @"Tab";
			break;
		case XTFormattedOutputElementGameTitle:
			res = @"GameTitle";
			break;
		case XTFormattedOutputElementBannerStart:
			res = @"BannerStart";
			break;
		case XTFormattedOutputElementBannerEnd:
			res = @"BannerEnd";
			break;
		case XTFormattedOutputElementBannerClear:
			res = @"BannerClear";
			break;
		case XTFormattedOutputElementStatusLineModeStart:
			res = @"StatusLineModeStart";
			break;
		case XTFormattedOutputElementStatusLineModeEnd:
			res = @"StatusLineModeEnd";
			break;
		case XTFormattedOutputElementStatusLineModeSuppress:
			res = @"StatusLineModeSuppress";
			break;
		case XTFormattedOutputElementClearWhitespaceBeforeOrAfterBlockLevelTag:
			res = @"ClearWhitespaceBeforeOrAfterBlockLevelTag";
			break;
		default:
			res = [NSString stringWithFormat:@"unknown: %ld", self.elementType];
			break;
	}
	return res;
}

@end
