//
//  XTHtmlTagBr.m
//  TadsTerp
//
//  Created by Rune Berg on 31/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagBr.h"
#import "XTBaseTextHandler.h"
#import "XTOutputFormatterProtocol.h"
#import "XTAllocDeallocCounter.h"


@implementation XTHtmlTagBr

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

+ (NSString *)name
{
	return @"br";
}

+ (BOOL)standalone
{
	return YES;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagBr:self];
	[textHandler receiveFormattedElements:formattedElements];
}

@end
