//
//  XTTadsGameInfo.m
//  TadsTerp
//
//  Created by Rune Berg on 04/06/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTTadsGameInfo.h"
#include "gameinfo.h"  // T3 C++
#import "XTAllocDeallocCounter.h"


@implementation XTTadsGameInfo

OVERRIDE_ALLOC_FOR_COUNTER

OVERRIDE_DEALLOC_FOR_COUNTER

+ (XTTadsGameInfo *)gameInfoFromFile:(NSString *)gameFilename
{
	const char* fn = [gameFilename cStringUsingEncoding:NSUTF8StringEncoding];
	XTTadsGameInfo *gameInfo = nil;
	CTadsGameInfo info;

	if (info.read_from_file(fn)) {
		gameInfo = [XTTadsGameInfo new];
		const char* name = info.get_val("name");
		if (name != NULL) {
			gameInfo.gameTitle = [NSString stringWithUTF8String:name];
		}
	}

	return gameInfo;
}

@end
