//
//  XTTextStorageBatcher.h
//  XTads
//
//  Created by Rune Berg on 17/05/2019.
//  Copyright © 2019 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTHtmlTagTab.h"


//NS_ASSUME_NONNULL_BEGIN

@interface XTTextStorageBatcher : NSObject

- (BOOL)append:(NSAttributedString *)attrString;

- (BOOL)appendArray:(NSArray<NSAttributedString *>*)attrStringArray;

- (void)insert:(NSAttributedString *)attrString atIndex:(NSUInteger)idx;

- (NSAttributedString *)getBatchedString;

- (NSUInteger)getBatchedSubStringCount;

- (NSAttributedString *)getBatchedSubStringAtIndex:(NSUInteger)index;

- (NSArray<NSMutableAttributedString *> *)getBatchedSubStringsToIndex:(NSUInteger)index;

- (void)pruneToIndex:(NSUInteger)index;

- (NSArray<NSMutableAttributedString *>*)flush;

- (BOOL)hasContents;

- (void)removeTrailingWhitespace;

- (void)reset;

- (NSUInteger)lengthOfRemainingBatchedText;

- (void)addTabToLastBatchedSubstring:(XTHtmlTagTab *)tabTag;

@end

//NS_ASSUME_NONNULL_END
