//
//  XTHtmlQuotedSpace.m
//  XTads
//
//  Created by Rune Berg on 07/03/15.
//  Copyright (c) 2015 Rune Berg. All rights reserved.
//

#import "XTHtmlTagQuotedSpace.h"
#import "XTAllocDeallocCounter.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagQuotedSpace

static const unichar quotedSpace = 0x15;
static NSString *string;

+ (void)initialize
{
	string = [NSString stringWithFormat:@"%C", quotedSpace];
}

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (NSString *)asString
{
	return string;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagQuotedSpace:self];
	[textHandler receiveFormattedElements:formattedElements];
}

@end
