//
//  XTBanner.h
//  XTads
//
//  Created by Rune Berg on 14/12/15.
//  Copyright © 2015 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTBaseTextHandler.h"
#import "XTGameWindowController.h"
#import "XTBannerContainerView.h"
#import "XTMainTextView.h"
#import "XTOutputTextParserProtocol.h"


@interface XTBannerTextHandler : XTBaseTextHandler <NSTextViewDelegate>

@property (weak) XTMainTextHandler *mainTextHandler;

@property NSUInteger where; // "where"
@property NSUInteger type; // "wintype"
@property NSUInteger alignment; // "align"
@property NSUInteger size; //"siz"
@property NSUInteger sizeUnits; // "sizunits"
@property NSUInteger style; // "style"
@property BOOL isSizedToContent;
@property CGFloat sizeOfContents;

// for T2 banner tag "previous" attr:
@property BOOL isBeingCreated;
@property NSNumber *initialSize;
@property NSUInteger initialSizeUnits;
@property BOOL wasInitiallySizedToContents;
@property BOOL wasInitiallySizedToPrevious;
@property CGFloat initialSizeOfContents;
@property BOOL hadUnspecifiedSizeLastTime;
@property BOOL hadPreviousSizeLastTime;

@property NSString *tagId; // for T2 <banner id="...">

@property BOOL isForTradStatusLine;
@property BOOL tagBannerNeedsSizeToContent;

+ (void)resetStaticState;

+ (instancetype)handlerWithParent:(XTBannerTextHandler *)parent
							where:(NSInteger)where
							other:(XTBannerTextHandler *)other
						  wintype:(NSInteger)wintype
							align:(NSInteger)align
							 size:(NSInteger)size
						sizeUnits:(NSInteger)sizeUnits
							style:(NSUInteger)style;

- (void)setIsForT3:(BOOL)isForT3;

- (void)setIsForTagBanner:(BOOL)isForTagBanner;

- (void)createTextViewForBanner;

- (CGFloat)calcViewSizeForConstraint;

- (void)captureInitialSizeWhenViewSize:(CGFloat)viewSize;

- (void)resetForTradStatusLine;

- (void)display:(NSString *)string;

- (void)mainThread_clear;

- (void)synchClear;

- (void)executeClear;

- (void)displayTradStatusLineScoreString:(NSString *)string;

- (void)setSize:(NSUInteger)size
	  sizeUnits:(NSUInteger)sizeUnits
	 isAdvisory:(BOOL)isAdvisory;

- (BOOL)isTagBannerThatShouldResizeToContents;

- (void)mainThread_sizeToContents;

- (void)mainThread_getUsableSizes:(NSMutableArray *)results;

- (void)gotoRow:(NSUInteger)row column:(NSUInteger)column;

- (void)mainThread_setForegroundColorForGrid:(NSNumber *)foregroundColorObj;

- (void)mainThread_setBackgroundColorForGrid:(NSNumber *)backgroundColorObj;

- (void)mainThread_setScreenColorForGrid:(NSNumber *)screenColorObj;

- (XTHtmlTag *)processTagTreeFromMainOutput:(XTHtmlTag *)currentTag
									 parser:(id<XTOutputTextParserProtocol>)parser;

- (void)flushTradStatusLineScoreString;

- (BOOL)isGridMode;

@end
