//
//  XTHtmlTagFontContainerTag.m
//  XTads
//
//  Created by Rune Berg on 02/06/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTFormattingSpecificationForHtmlTag.h"
#import "XTFormattingSpecification.h"
#import "XTTextAlignMode.h"
#import "XTLogger.h"
#import "XTHtmlTagSecondOutermost.h"
#import "XTAllocDeallocCounter.h"


@interface XTFormattingSpecificationForHtmlTag ()

@end


@implementation XTFormattingSpecificationForHtmlTag

static XTLogger* logger;

@synthesize oldFormattingSpecForHtmlTag = _oldFormattingSpecForHtmlTag;
@synthesize formattingSpec = _formattingSpec;
@synthesize tagContainer = _tagContainer;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTFormattingSpecificationForHtmlTag class]];
}

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (instancetype)init
{
	self = [super init];
	if (self) {
		_formattingSpec = [XTFormattingSpecification specificationWithDefaults];
	}
	return self;
}

- (void)formattingEntry:(NSObject<XTOutputFormatterProtocol> *)formatter
		   tagContainer:(XTHtmlTagContainer *)tagContainer
{
	//XT_DEF_SELNAME;
	
	_tagContainer = tagContainer;

	//XT_WARN_3(@"self.oldFormattingSpec = formatter.formattingSpec (%@) - align %@ -> %@",
	//		  self.tag.name, self.oldFormattingSpec.textAlignModeAsString, formatter.formattingSpecification.textAlignModeAsString);
	_oldFormattingSpecForHtmlTag = formatter.formattingSpecForHtmlTag;

	_formattingSpec = [tagContainer makeFormattingSpecificationFrom:self.oldFormattingSpecForHtmlTag.formattingSpec];
	//XT_WARN_3(@"formatter.formattingSpec = newFormattingSpec (%@) - align %@ -> %@",
	//		  self.tag.name, formatter.formattingSpec.textAlignModeAsString, newFormattingSpec.textAlignModeAsString);
	formatter.formattingSpecForHtmlTag = self;

	//pre tag should be set in formatter
}

- (void)formattingExit:(NSObject<XTOutputFormatterProtocol> *)formatter
{
	if (self.oldFormattingSpecForHtmlTag != nil) {
		//XT_DEF_SELNAME;
		//XT_WARN_3(@"formatter.formattingSpec = self.oldFormattingSpec (%@) - align %@ -> %@",
		//		  self.tag.name, formatter.formattingSpec.textAlignModeAsString, self.oldFormattingSpec.textAlignModeAsString);
		formatter.formattingSpecForHtmlTag = self.oldFormattingSpecForHtmlTag;
	} else {
		XT_DEF_SELNAME;
		XT_WARN_1(@"oldFormattingSpecForHtmlTag == nil (unbalanced %@ tags?)", self.tagContainer.name)
	}
}

@end
