//
//  XTHtmlWhitespace.m
//  TadsTerp
//
//  Created by Rune Berg on 06/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagWhitespace.h"
#import "XTAllocDeallocCounter.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagWhitespace

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (instancetype)initWithText:(NSString *)text
{
	self = [super init];
	if (self) {
		_text = text;
	}
	return self;
}

+ (id)tagWithText:(NSString *)text
{
	XTHtmlTagWhitespace *tag = [[XTHtmlTagWhitespace alloc] initWithText:text];
	return tag;
}

+ (NSString *)name
{
	return @"xtads-whitespace";
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagWhitespace:self];
	[textHandler receiveFormattedElements:formattedElements];
}

@end
