//
//  XTTableColumnWidthTracker.h
//  XTads
//
//  Created by Rune Berg on 07/09/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTextTableBlock.h"


@interface XTTableColumnWidthTracker : NSObject

+ (id)tracker;

- (NSNumber *)registerNewTable;

- (void)noteMaxContentRectWidthForTable:(NSNumber *)tableId
						 textTableBlock:(XTTextTableBlock *)textTableBlock
								  width:(CGFloat)width;

- (void)noteMinContentRectWidthForTable:(NSNumber *)tableId
						 textTableBlock:(XTTextTableBlock *)textTableBlock
								  width:(CGFloat)width;

- (void)noteTotalBoundsWidthForTable:(NSNumber *)tableId
					  textTableBlock:(XTTextTableBlock *)textTableBlock
							   width:(CGFloat)width;

- (void)noteBoundsRectWidthForTable:(NSNumber *)tableId
					 textTableBlock:(XTTextTableBlock *)textTableBlock
							  width:(CGFloat)width;

- (CGFloat)contentRectWidthForTable:(NSNumber *)tableId
					 textTableBlock:(XTTextTableBlock *)textTableBlock
						usableWidth:(CGFloat)usableWidth;

- (CGFloat)contentRectXForTable:(NSNumber *)tableId
				 textTableBlock:(XTTextTableBlock *)textTableBlock
						originX:(CGFloat)originX
					usableWidth:(CGFloat)usableWidth;

- (CGFloat)totalTableWidth:(NSNumber *)tableId;

- (void)clearAll;

@end
