//
//  XTOutputTextParser.h
//  TadsTerp
//
//  Created by Rune Berg on 08/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//
//  --------------------------------------------------
//  Converts chunks of text into a list of:
//		* html tag objects
//		* entity-expanded regular text
//		* whitespace tokens
//  --------------------------------------------------
//

#import <Foundation/Foundation.h>
#import "XTOutputTextParserBase.h"
#import "XTOutputTextParserProtocol.h"
#import "XTHtmlTagContainer.h"


@interface XTOutputTextParserHtml : XTOutputTextParserBase <XTOutputTextParserProtocol>

typedef NS_ENUM(NSInteger, XTOutputTextParserHtmlState) {
	XT_HTML_INITIAL,
	XT_HTML_IN_WHITESPACE,
	XT_HTML_IN_TEXT,
	XT_HTML_AFTER_TAG_START,
	XT_HTML_AFTER_PSEUDOTAG_START,
	XT_HTML_IN_TAG_NAME,
	XT_HTML_AFTER_TAG_NAME,
	XT_HTML_AT_CLOSING_SLASH,
	XT_HTML_IN_ATTRIBUTE_NAME,
	XT_HTML_STARTING_ATTRIBUTE_VALUE,
	XT_HTML_IN_QUOTED_ATTRIBUTE_VALUE,
	XT_HTML_IN_UNQUOTED_ATTRIBUTE_VALUE,
	XT_HTML_IN_MISFORMED_TAG,
	XT_HTML_IN_COMMENT_OPENING_AFTER_EXCL_MARK,
	XT_HTML_IN_COMMENT_OPENING_AFTER_DASH_1,
	XT_HTML_IN_COMMENT_CONTENT,
	XT_HTML_IN_COMMENT_CLOSING_AFTER_DASH_1,
	XT_HTML_IN_COMMENT_CLOSING_AFTER_DASH_2
};

@property XTOutputTextParserHtmlState state;

- (void)resetForGameHasEndedMsg;

@end
