/*
 * Decompiled with CFR 0.152.
 */
package maze;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Random;
import maze.MazeCell;
import maze.MazeIndex;
import maze.mazeTextFrame;

public class mazeGenerator {
    private int mazeHeight;
    private int mazeWidth;
    private int totalCells;
    MazeCell[][] aMaze;
    Random randomGenerator;

    public mazeGenerator(int height, int width) {
        int w = 0;
        this.randomGenerator = new Random();
        this.mazeHeight = height;
        this.mazeWidth = width;
        this.totalCells = this.mazeHeight * this.mazeWidth;
        this.aMaze = new MazeCell[this.mazeHeight][this.mazeWidth];
        for (int h = 0; h < this.mazeHeight; h = (int)((short)(h + 1))) {
            while (w < this.mazeWidth) {
                this.aMaze[h][w] = new MazeCell();
                w = (short)(w + 1);
            }
            w = 0;
        }
    }

    public void buildMaze() {
        ArrayDeque<MazeIndex> MazeIndexStack = new ArrayDeque<MazeIndex>();
        int visitedCells = 1;
        MazeIndex[] neighborsArray = new MazeIndex[4];
        for (int i = 0; i <= 3; ++i) {
            neighborsArray[i] = new MazeIndex(0, 0);
        }
        MazeIndex currentCell = new MazeIndex(0, 0);
        currentCell.setHeight(this.randomGenerator.nextInt(this.mazeHeight));
        currentCell.setWidth(this.randomGenerator.nextInt(this.mazeWidth));
        while (visitedCells < this.totalCells) {
            int neighborsWith4Walls = 0;
            if (currentCell.getWidth() > 0 && this.aMaze[currentCell.getHeight()][currentCell.getWidth() - 1].hasAllSet()) {
                neighborsArray[neighborsWith4Walls].Height = currentCell.getHeight();
                neighborsArray[neighborsWith4Walls].Width = currentCell.getWidth() - 1;
                ++neighborsWith4Walls;
            }
            if (currentCell.getHeight() < this.mazeHeight - 1 && this.aMaze[currentCell.getHeight() + 1][currentCell.getWidth()].hasAllSet()) {
                neighborsArray[neighborsWith4Walls].Height = currentCell.getHeight() + 1;
                neighborsArray[neighborsWith4Walls].Width = currentCell.getWidth();
                ++neighborsWith4Walls;
            }
            if (currentCell.getWidth() < this.mazeWidth - 1 && this.aMaze[currentCell.getHeight()][currentCell.getWidth() + 1].hasAllSet()) {
                neighborsArray[neighborsWith4Walls].Height = currentCell.getHeight();
                neighborsArray[neighborsWith4Walls].Width = currentCell.getWidth() + 1;
                ++neighborsWith4Walls;
            }
            if (currentCell.getHeight() > 0 && this.aMaze[currentCell.getHeight() - 1][currentCell.getWidth()].hasAllSet()) {
                neighborsArray[neighborsWith4Walls].Height = currentCell.getHeight() - 1;
                neighborsArray[neighborsWith4Walls].Width = currentCell.getWidth();
                ++neighborsWith4Walls;
            }
            if (neighborsWith4Walls > 0) {
                int aRandomNumber = 0;
                if (neighborsWith4Walls > 1) {
                    aRandomNumber = this.randomGenerator.nextInt(neighborsWith4Walls);
                }
                if (currentCell.getHeight() == neighborsArray[aRandomNumber].Height) {
                    if (currentCell.getWidth() > neighborsArray[aRandomNumber].Width) {
                        this.aMaze[currentCell.getHeight()][currentCell.getWidth()].destroyWestWall();
                        this.aMaze[neighborsArray[aRandomNumber].Height][neighborsArray[aRandomNumber].Width].destroyEastWall();
                    } else {
                        this.aMaze[currentCell.getHeight()][currentCell.getWidth()].destroyEastWall();
                        this.aMaze[neighborsArray[aRandomNumber].Height][neighborsArray[aRandomNumber].Width].destroyWestWall();
                    }
                } else if (currentCell.getHeight() < neighborsArray[aRandomNumber].Height) {
                    this.aMaze[currentCell.getHeight()][currentCell.getWidth()].destroySouthWall();
                    this.aMaze[neighborsArray[aRandomNumber].Height][neighborsArray[aRandomNumber].Width].destroyNorthWall();
                } else {
                    this.aMaze[currentCell.getHeight()][currentCell.getWidth()].destroyNorthWall();
                    this.aMaze[neighborsArray[aRandomNumber].Height][neighborsArray[aRandomNumber].Width].destroySouthWall();
                }
                MazeIndexStack.offerFirst(new MazeIndex(currentCell.getHeight(), currentCell.getWidth()));
                currentCell.setHeight(neighborsArray[aRandomNumber].Height);
                currentCell.setWidth(neighborsArray[aRandomNumber].Width);
                ++visitedCells;
                continue;
            }
            MazeIndex tempMazeIndex = (MazeIndex)MazeIndexStack.pollFirst();
            currentCell.setHeight(tempMazeIndex.getHeight());
            currentCell.setWidth(tempMazeIndex.getWidth());
        }
    }

    public void displayMaze(mazeTextFrame mazeTF) {
        int i;
        int w = 0;
        for (int h = 0; h < this.mazeHeight; h = (int)((short)(h + 1))) {
            mazeTF.mazeWriteToTextArea("  ");
            while (w < this.mazeWidth) {
                if (this.aMaze[h][w].hasNorthSet()) {
                    mazeTF.mazeWriteToTextArea("====");
                } else {
                    mazeTF.mazeWriteToTextArea("== =");
                }
                w = (short)(w + 1);
            }
            mazeTF.mazeWriteToTextArea("=");
            mazeTF.mazeWriteToTextArea("\n");
            for (i = 2; i <= 4; ++i) {
                mazeTF.mazeWriteToTextArea("  ");
                for (w = 0; w < this.mazeWidth; w = (int)((short)(w + 1))) {
                    if (i == 3) {
                        if (this.aMaze[h][w].hasWestSet()) {
                            mazeTF.mazeWriteToTextArea("\u00a6");
                        } else {
                            mazeTF.mazeWriteToTextArea(" ");
                        }
                    } else {
                        mazeTF.mazeWriteToTextArea("\u00a6");
                    }
                    mazeTF.mazeWriteToTextArea("   ");
                }
                mazeTF.mazeWriteToTextArea("\u00a6");
                mazeTF.mazeWriteToTextArea("\n");
            }
            w = 0;
        }
        mazeTF.mazeWriteToTextArea("  ");
        for (i = 1; i <= this.mazeWidth; ++i) {
            mazeTF.mazeWriteToTextArea("====");
        }
        mazeTF.mazeWriteToTextArea("=\n");
    }

    public void outputMaze(String mazeFilename) {
        try {
            BufferedWriter mazeDefinitionFile = new BufferedWriter(new FileWriter(mazeFilename));
            mazeDefinitionFile.write("mazeGrid = new Vector(100,[");
            int w = 0;
            for (int h = 0; h < this.mazeHeight; h = (int)((short)(h + 1))) {
                mazeDefinitionFile.write("[");
                while (w < this.mazeWidth) {
                    mazeDefinitionFile.write(this.aMaze[h][w].getCellInfo() + (w != this.mazeWidth - 1 ? "," : ""));
                    w = (short)(w + 1);
                }
                mazeDefinitionFile.write("]");
                if (h != this.mazeHeight - 1) {
                    mazeDefinitionFile.write(",");
                    mazeDefinitionFile.newLine();
                }
                w = 0;
            }
            mazeDefinitionFile.write("])");
            mazeDefinitionFile.newLine();
            mazeDefinitionFile.close();
        }
        catch (IOException e) {
            System.err.format("outputMaze error: %s%n", e);
        }
    }
}

