#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of PROTEUS, the TADS 3 Utility Classes Package
 *
 *  String.t
 *
 *  Provides useful String class methods for diagnostic verbs.
 */

#include "proteus.h"

modify String
{
    /*
     *  Returns the symbol table key for this string.
     */
    getSymbol()
    {
        return gSymbols.getSymbol(self);
    }

    /*
     *  Returns the predicate associated with the tag, which this
     *  string represents.
     */
    getPredicate()
    {
        return gSymbols.getSymbol('predicate(' + self + ')');
    }

    /*
     *  Returns the verb phrase associated with the predicate that
     *  is associated with the tag that this string represents.
     */
    getVerbPhrase()
    {
        local pred;

        pred = getPredicate();

        if (pred == nil)
            return nil;
        else
            return pred.verbPhrase;
    }

    /*
     *  Returns a single-quoted string href that is built from the 
     *  command (predicate) that is associated with the tag that 
     *  this string represents.
     */
    getCmdHref([strings])
    {
        local pred;

        pred = getPredicate();

        if (pred == nil)
            return nil;

        return pred.getHref(strings...);
    }
}