#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  
 *	 SimClone.t
 *
 *  Provides a mechanism for making copies of 
 * "simulation" objects.
 */

/* include the TADS and T3 system headers */
#include <tads.h>
#include <t3.h>

/* 
   *  The root Object class makes a simple copy (i.e., with references 
   *  duplicated) of all of the object's fields.
   *
   *  Override this method in each subclass so that it makes copies of 
   *  referenced objects where appropriate.
   */
modify TadsObject
{
	/* creates and returns a shallow copy of this object */
	simClone()
	{
        return createClone();
    }
}

/*
  *   For Thing class the containment relationship established through
  *   location and contents attributes is a special-case. We don't want
  *   the copy of an object to point to the original's contents, so we 
  *   make copies of the contents, and resolve their location so that they
  *   point to the copy of the original.
  */
modify Thing
{
    simClone()
    {
        local cl = inherited();

        /* clone the containment children */
        cl.contents = [];
        foreach (local o in contents)
            cl.contents += o.simClone();

        /* 
          *   fix up the copied containment children to point 
          *   to the copied containment parent. 
          */
        foreach (local o in cl.contents)
            o.location = cl;

        return cl;
    }
}