#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlSign.t
 */

#include "html.h"

/*--------------------------------------------------------------------*/
/*
 *  A base class for HTML Signs
 */
class HtmlSign: HtmlTable, Readable
{
    bgColor             = '\"#AAAAAA\"'
    border              = 1
    cellPadding         = 15
    color               = 'yellow'
    size                = '+3'

    initHtmlAttributes  = nil
    initText            = ''

    htmlTableGen        = nil

    desc()
    {
        if (!htmlTableGen)
            construct(initHtmlAttributes, initText...);

        generate();
    }

    construct(attr, [text])
    {
        local f, d, r;

        inherited HtmlTag.construct(attr);

        f = new HtmlTextFont(attr, text...);
        f.setColor(color);
        f.setSize(size);
        f.setBold(true);

        d = new HtmlTableData(attr, f);
        d.setBgColor(bgColor);

        r = new HtmlTableRow(attr, d);
        r.setBgColor(bgColor);
        
        inherited(attr, r);

        setBorder(true);
        setCellPadding(20);

        htmlTableGen = true;
    }
}