#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlTableCaption.t
 */

#include "html.h"

/*--------------------------------------------------------------------*/
/*
 *  A base class for HTML Table Captions
 */
class HtmlTableCaption: HtmlTag
{
    tagRoot     = '<caption'
    beginTag    = ''
    endTag      = '</caption>'

    stringSep   = '<br>'

    fontList    = []

    getAlign()
    {
        return getHtmlAttributes.getAlign();
    }

    setAlign(val)
    {
        getHtmlAttributes.setAlign(val);
    }

    getVAlign()
    {
        return getHtmlAttributes.getVAlign();
    }

    setVAlign(val)
    {
        getHtmlAttributes.setVAlign(val);
    }

    generate()
    {
        beginTag = generateTag();

        say(beginTag);

        for (local i = 1; i <= fontList.length(); ++i)
        {
            fontList[i].generate();

            if (i < fontList.length())
                say(stringSep);
        }

        say(endTag);
    }

    generateTag()
    {
        local str = '';

        str += tagRoot;
        str += getAlign();
        str += getVAlign();
        str += '>';

        return str;
    }

    construct(attr, [fontList])
    {
        inherited(attr);

        foreach(local font in fontList)
        {
            try
            {
                if (dataType(font) == TypeObject && font.ofKind(HtmlTextFont))
                    fontList += font;
            }
            catch(RuntimeError e) {}
        }
    }
}