#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlTableRow.t
 */

#include "html.h"

/*--------------------------------------------------------------------*/
/*
 *  A base class for HTML Table Rows
 */
class HtmlTableRow: HtmlTag
{
    tagRoot     = '<tr'
    beginTag    = ''
    endTag      = '</tr>'

    tableDataList = []

    getAlign()
    {
        return getHtmlAttributes.getAlign();
    }

    setAlign(val)
    {
        getHtmlAttributes.setAlign(val);
    }

    getVAlign()
    {
        return getHtmlAttributes.getVAlign();
    }

    setVAlign(val)
    {
        getHtmlAttributes.setVAlign(val);
    }

    getBgColor()
    {
        return getHtmlAttributes.getBgColor();
    }

    setBgColor(val)
    {
        getHtmlAttributes.setBgColor(val);
    }

    generate()
    {
        beginTag = generateTag();

        say(beginTag);

        foreach (local td in tableDataList)
            td.generate();

        say(endTag);
    }

    generateTag()
    {
        local str = '';

        str += tagRoot;

        str += getAlign();
        str += getVAlign();
        str += getBgColor();

        str += '>';

        return str;
    }

    construct(attr, [tdList])
    {
        inherited(attr);

        foreach (local td in tdList)
        {
            try
            {
                if (dataType(td) == TypeObject && td.ofKind(HtmlTableData))
                    tableDataList += td;
            }
            catch(RuntimeError e) {}
        }
    }
}