#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of PROTEUS, the TADS 3 Utility Classes Package
 *
 *  Morphic.t
 *
 *  Implements a basic delegation pattern.
 */

/* include the proteus lookup table header */
#include "proteus.h"
#include "adv3.h"

/*
 *  Define the propNotDefined property and export it so that the VM can
 *  call this property when a call is made to an undefined property.
 */
property propNotDefined;
export propNotDefined;

/*
 *  The Morphic class is an object that takes on the characteristics
 *  of its handler class. Since the handler class can be dynamically
 *  changed at runtime, the morphic class can alter its properties 
 *  (both state and behavior) dynamically.
 *  
 */
class Morphic: PreinitObject
{
    /* a Morphic is a Thing by default */
    defaultHandler = Thing

    setHandler(obj)
    {
        if (obj.ofKindOrUU(Object))
            defaultHandler = obj.createInstance();
    }

    getHandler()
    {
        return defaultHandler;
    }

    propNotDefined(prop, [args])
    {
        return delegated (getHandler()).(prop)(args...);
    }
    
    /* override intrinsic methods with delegate counterparts */
    getSuperclassList()
    {
        local ret = inherited();

        ret += getHandler();

        return ret;
    }
    getPropParams(prop)
    {
        local ret = inherited(prop);

        if (ret != nil)
            return ret;

        return delegated (getHandler())(prop);
    }
    ofKind(cls)
    {
        local ret = inherited(cls);

        if (ret != nil)
            return ret;

        return delegated (getHandler())(cls);
    }
    propDefined(prop, [args])
    {
        local ret = inherited(prop, args...);

        if (ret != nil)
            return ret;

        return delegated (getHandler())(prop, args...);
    }
    propInherited(prop, targetObj, definingObj, [args])
    {
        local ret = inherited(prop, targetObj, definingObj, args...);

        if (ret != nil)
            return ret;

        return delegated (getHandler())(prop, targetObj, definingObj, args...);
    }
    propType(prop)
    {
        local ret = inherited(prop);

        if (ret != nil)
            return ret;

        return delegated (getHandler())(prop);
    }
    execute()
    {
        /* set the default handler to an instance of itself */
        setHandler(defaultHandler);

        /* initialize the object's vocabulary and containment */
        initializeVocab();
        initializeThing();
    }
}