#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of PROTEUS, the TADS 3 Utility Classes Package
 *
 *  Visitor.t
 *
 *  Implements a basic visitor pattern.
 */

/* include the proteus lookup table header */
#include "proteus.h"

/*
 *  Visitor Interface. This interface defines the required 
 *  properties of a Visitor.
 */
class VisitorIF: Interface
{
    visitVisitable(visitable) {}
}

/*
 *  Visitor class. This class provides a base 
 *  for Visitor objects, and defines a visitVisitable() 
 *  method.
 */
class Visitor: object
{
    implements(VisitorIF)

    visitVisitable(visitable) {}
}

/*
 *  Visitable Interface. This interface defines the required 
 *  properties of a Visitable.
 */
class VisitableIF: Interface
{
    accept(visitor) {}
}

/*
 *  Visitable mix-in. This class provides a mechanism
 *  for the Visitor pattern. This mix-in should go last in 
 *  the object superclass definition.
 */
class Visitable: object
{
    implements(VisitableIF)

    accept(visitor) 
    {
        local prop;

        prop = getVisitProp(visitor);

        return visitor.(prop)(self);
    }

    /*
     *  Method determines which property to call on the visitor.
     */
    getVisitProp(visitor)
    {
        local str, prop, clsList;

        clsList = getInherSuperclassList() - Visitable;

        foreach (local cls in clsList)
        {
            str     = 'visit' + gSymbols.getSString(cls);
            prop    = gSymbols.getSymbol(str);

            if (prop && visitor.propDefined(prop))
                return prop;
        }
        return visitVisitable;
    }
}