#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  Structure disp.t
 *
 *  Provides a mechanism for displaying the structure of an object. 
 */

#include "proteus.h"
 
modify Object
{
    /*
     *  Display the structure of this object.
     */
    displayStructure([cond])
    {
        local strucList, clsList, cls, propList;
        
        "\b<<isClass() ? "Class" : "Object">>
            \t<<getObjTagAndSym()>>";
        
        clsList = getSuperclassList();

        if (clsList.length() > 0)
            "\textends\t";

        for (local i = 1; i <= clsList.length(); ++i)
        {
            "<<String.toSString(clsList[i], MapObjReference, MapObjRefAHref)>>";

            if (i < clsList.length())
                ", ";
        }

        "\n{";

        "\n\tDynamOrAnon:&ensp<<isDynamOrAnon() ? "true" : "nil">>";

        "&emspUnnamedInternal:&ensp<<isUnnamedInternal() ? "true" : "nil">>";

        "&emspTransient:&ensp<<isTransient() ? "true" : "nil">>";

        /* Lists */
        "\b\tLists:&emsp<<aHref(
            'ZlistParentObj'.getCmdHref(getMetaCmdReference()), 
            'Parents')>>";
        
        "&emsp<<aHref(
            'ZlistChildObj'.getCmdHref(getMetaCmdReference()), 
            'Children')>>";

        "&emsp<<aHref(
            'ZlistFirstNamedAncestorObj'.getCmdHref(getMetaCmdReference()), 
            'First Named Ancestors')>>";

        "&emsp<<aHref(
            'ZlistFirstNamedDescendantObj'.getCmdHref(getMetaCmdReference()), 
            'First Named Descendants')>>";

        /* Trees */
        "\b\tTrees:&emsp<<aHref(
            'ZtreeAncestorObj'.getCmdHref(getMetaCmdReference()),
            'Ancestors')>>";

        "&emsp<<aHref(
            'ZtreeDescendantObj'.getCmdHref(getMetaCmdReference()),
            'Descendants')>>";

        "&emsp<<aHref(
            'ZtreeModObj'.getCmdHref(getMetaCmdReference()), 
            'Modifications')>>";

        "&emsp<<aHref(
            'ZtreeContObj'.getCmdHref(getMetaCmdReference()), 
            'Containment')>>";

        local cmd, cmdStack = new StackTraceInfo();

        cmd = cmdStack.actionClassList.car();

        "\b\tProperties:";
        if (cmd != ZshowDirObjAction)
        {
            "&emsp<<aHref(
                'ZshowDirObj'.getCmdHref(getMetaCmdReference()), 
                'Direct')>>";
        }
        if (cmd != ZshowDefObjAction)
        {
           "&emsp<<aHref(
                'ZshowDefObj'.getCmdHref(getMetaCmdReference()), 
                'Defined')>>";
        }
        if (cmd != ZshowActObjAction)
        {
            "&emsp<<aHref(
                'ZshowActObj'.getCmdHref(getMetaCmdReference()), 
                'Action')>>";
        }
        if (cmd != ZshowStateObjAction)
        {
            "&emsp<<aHref(
                'ZshowStateObj'.getCmdHref(getMetaCmdReference()), 
                'State')>>";
        }
        if (cmd != ZshowNonStaticObjAction)
        {
            "&emsp<<aHref(
                'ZshowNonStaticObj'.getCmdHref(getMetaCmdReference()), 
                'Non-static')>>";
        }
        if (cmd != ZshowDeltaObjAction)
        {
            "&emsp<<aHref(
                'ZshowDeltaObj'.getCmdHref(getMetaCmdReference()), 
                'State Delta')>>";
        }

        "\n";

        strucList = getInherStrucList(cond...);
        
        for (local i = 1; i <= strucList.length(); ++i)
        {
             cls         = strucList[i][1];
                        
            "\b<<i > 1 ? "\b" : "">>\tproperties 
                <<cmd == ZshowNonStaticObjAction ? "non-statically" : 
                "statically">>
                defined by 
                <<cls.isClass() ? "class" : "object">> 
                <<String.toSString(cls, MapObjReference, MapObjRefAHref)>>\n";
            
            propList    = strucList[i][2];
            
            foreach (local prop in propList)
            {
                displayPropType(prop, 2);
            }
        }
        
        "}\n";
    }
    
    /*
     *  Display the structure of this object.
     */
    displayStateDelta(obj, sup, [bypass])
    {
        local prop, delta;
        
        delta = getStateDelta(obj, bypass...);
        
        if (delta.length() == 0)
        {
            if (sup == true)
                return;
            else
            {
                "<p><b>========== START TADS 3 DIAGNOSTIC ==========</b><p>";
                "\bState Delta: <<getObjTagAndSym()>>, <<obj.getObjTagAndSym()>>\n";
                "\n\tNO STATE CHANGES.\b";
                "<p><b>========== END TADS 3 DIAGNOSTIC ============</b><p>";
            }
        }
        else
        {
            "<p><b>========== START TADS 3 DIAGNOSTIC ==========</b><p>";
            "\bState Delta: <<getObjTagAndSym()>>, <<obj.getObjTagAndSym()>>\n";

            for (local i = 1; i <= delta.length(); ++i)
            {
                prop         = delta[i][1];
            
                "\n\t<<getObjTagAndSym()>>.";
                displayPropType(prop,0);
                "\n\t<<obj.getObjTagAndSym()>>.";
                obj.displayPropType(prop,0);
                "\b";
           }
            "<p><b>========== END TADS 3 DIAGNOSTIC ============</b><p>";
        }
    }

    displayPropType(prop, lvl)
    {
        local val, propName, href, txt;
        
        for (local i = 1; i <= lvl; ++i)
            "\t";
            
        propName = String.toSString(prop).substr(2);
        "<<aHref(
            'ZtreeDefinerObj'.getCmdHref(propName), propName)>>";
    
        switch(propDesc(prop, PropDescType))
        {
            case TypeNil:
                val = self.(prop);
                " :&enspTypeNil = <<String.toSString(val)>>";
                break;

            case TypeTrue:
                val = self.(prop);
                " :&enspTypeTrue = <<String.toSString(val)>>";
                break;

            case TypeObject:
                val = self.(prop);
                href = 'ZshowPropObj'.getCmdHref(getMetaCmdReference(), 
                    gSymbols.getSString(prop));
                txt = val.getObjTagAndSym();
                " :&enspTypeObject = <<aHref(href, txt)>>";

#ifdef _BIGNUM_H_

                else if (val.ofKindOrUU(BigNumber)
                     "&ensp<<String.toSString(val, MapObjValue, MapObjRefAHref)>>";

#endif

                break;

            case TypeProp:
                val = self.(prop);
                " :&enspTypeProp = <<String.toSString(val)>>";
                break;

            case TypeInt:
                val = self.(prop);
                " :&enspTypeInt = <<String.toSString(val)>>";
                break;

            case TypeSString:
                val = self.(prop);
                " :&enspTypeSString = <<String.toSString(val, 
                    MapObjValue, MapObjRefAHref, HtmlifyTranslateWhitespace)>>";
                break;

            case TypeFuncPtr:
                val = self.(prop);
                 " :&enspTypeFuncPtr = <<String.toSString(val)>>";
                break;

            case TypeEnum:
                val = self.(prop);
                 " :&enspTypeEnum = <<String.toSString(val)>>";
                break;
            
            case TypeDString:
                " :&enspTypeDString = \"<<self.(prop)>>\"";
                break;
            
            case TypeList:
                val = self.(prop);
                " :&enspTypeList = <<String.toSString(val, 
                    MapObjValue, MapObjRefAHref)>>";
                break;
        
            case TypeCode:
                "(";
                displayPropParams(prop);
                ") :&enspTypeCode";
                break;
            
            case TypeNativeCode:
                "(";
                displayPropParams(prop);
                ") :&enspTypeNativeCode";
                break;

            case TypePropNonStatic:
                " :&enspTypePropNonStatic";
                break;
            
            default:
                " :&enspNULL = <<String.toSString(val)>>";
        }
        
        "\n";
    }

    displayPropParams(prop)
    {
        local propParams;

        propParams = getPropParams(prop);

        for (local i = 1; i <= propParams.length(); ++i)
        {
            "<<String.toSString(propParams[i])>>";
            if (i < propParams.length())
                ", ";
        }
    }
}