#include <tads.h>

/*
 * An XTads test game.
 * Focus is on sizing vert. grid banner to content.
 */
main(args)
{
	local b0 = nil;

    "A banner test game for XTads.\b\b";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignRight,
                       50, BannerSizePercent,
                       0);
	 bannerSetScreenColor(b1, ColorWhite);
    "b1 (child of b0) is a vertical grid banner right of b0, sized to 50% of its parent. ";
    "\bPress a key to continue...\n";
    inputKey();

    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content - i.e. be invisible\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, '1');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, ' 12');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, '\n123');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();
    
    bannerSay(b1, ' 12');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();

	 bannerClear(b1);
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content - i.e. be invisible\n";
    "\bPress a key to continue...\n";
    inputKey();    

    bannerSay(b1, '1');
    bannerSizeToContents(b1);
    "\bb1 should now be sized to horiz content\n";
    "\bPress a key to continue...\n";
    inputKey();    

    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(win)
{
    local info = bannerGetInfo(win);

    "align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>";
}
