/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.MainWin;
import WizSolitaire.TableCell;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class GameTable
extends JComponent {
    public static final int XOFFSET = 6;
    public static final int YOFFSET = 5;
    public static final int DEF_WIDTH = 680;
    public static final int DEF_HEIGHT = 480;
    private Color e = Color.GRAY;
    private String f;
    private Image g;
    private Image h;
    private Graphics i;
    private Deck j;
    private Vector k = new Vector();
    private Object l;
    private Vector m = new Vector();
    private CardGame n;
    private int o = 176;
    private int p = 260;
    private int q;
    private int r;
    private int s = 680;
    private int t = 480;
    private CardWrapper u;
    private boolean v;
    private boolean w = false;
    private MainWin x;

    public GameTable(MainWin mainWin, Deck deck) {
        this.x = mainWin;
        this.j = deck;
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(this.s, this.t));
        GameTable gameTable = this;
        gameTable.setSize(gameTable.getPreferredSize());
        this.enableEvents(48L);
        this.Clear();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                if (mouseEvent.getClickCount() == 2) {
                    this.u(mouseEvent);
                    return;
                }
                this.s(mouseEvent);
                return;
            }
            case 502: {
                this.v(mouseEvent);
                return;
            }
            case 501: {
                this.w(mouseEvent);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.x(mouseEvent);
    }

    public void SetGame(CardGame cardGame) {
        this.n = cardGame;
    }

    public void Clear() {
        this.k.clear();
        this.m.clear();
        this.v = true;
        System.gc();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        this.h();
        if (this.i != null) {
            int n2;
            for (n2 = 0; n2 < this.GetCellCount(); ++n2) {
                this.GetCell(n2).PaintTo(this.i, false);
            }
            for (n2 = 0; n2 < this.GetCellCount(); ++n2) {
                this.GetCell(n2).PaintTo(this.i, true);
            }
            graphics.drawImage(this.h, 0, 0, this);
        }
    }

    private void h() {
        if (this.g != null) {
            int n2 = this.getSize().height;
            int n3 = this.getSize().width;
            int n4 = this.g.getWidth(this);
            int n5 = this.g.getHeight(this);
            for (int i2 = 0; i2 < n2; i2 += n4) {
                for (int i3 = 0; i3 < n3; i3 += n5) {
                    this.i.drawImage(this.g, i3, i2, this);
                }
            }
            return;
        }
        this.i.setColor(this.e);
        this.i.fillRect(0, 0, this.s, this.t);
    }

    public void SetBackgroundImg(String string) {
        this.g = null;
        try {
            if (string != null) {
                this.g = ImageIO.read(new FileInputStream(string));
                this.f = string;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void SetBackground(Color color) {
        this.e = color;
        this.repaint(20L);
    }

    public void AddCell(TableCell tableCell) {
        tableCell.SetCardSize(this.o, this.p);
        this.m.add(tableCell);
    }

    public TableCell GetCell(int n2) {
        return (TableCell)this.m.get(n2);
    }

    public int GetCellCount() {
        return this.m.size();
    }

    public CardWrapper WrapCard(Card card) {
        CardWrapper cardWrapper = new CardWrapper(this.l);
        cardWrapper.SetSize(this.o, this.p);
        this.k.add(cardWrapper);
        cardWrapper.SetBack(this.j.GetBack());
        cardWrapper.SetCard(card);
        return cardWrapper;
    }

    public void ResizeCards(int n2, int n3) {
        int n4;
        this.o = n2;
        this.p = n3;
        for (n4 = 0; n4 < this.k.size(); ++n4) {
            CardWrapper cardWrapper = (CardWrapper)this.k.get(n4);
            cardWrapper.SetBack(this.j.GetBack());
            cardWrapper.SetSize(n2, n3);
        }
        for (n4 = 0; n4 < this.GetCellCount(); ++n4) {
            this.GetCell(n4).SetCardSize(n2, n3);
        }
        if (this.n != null) {
            this.n.ResizeDeck(n2, n3);
        }
        this.invalidate();
    }

    public void Resize(int n2, int n3) {
        this.h = this.createImage(n2, n3);
        this.i = this.h.getGraphics();
        this.setMinimumSize(new Dimension(this.s, this.t));
        this.setMaximumSize(new Dimension(this.s, this.t));
        this.setPreferredSize(new Dimension(this.s, this.t));
        GameTable gameTable = this;
        gameTable.setSize(gameTable.getPreferredSize());
        this.s = n2;
        this.t = n3;
        ((Window)this.getTopLevelAncestor()).pack();
        this.repaint();
    }

    private void q(CardWrapper cardWrapper, int[] nArray) {
        for (int i2 = this.GetCellCount() - 1; i2 >= 0; --i2) {
            int n2 = this.GetCell(i2).CardIndex(cardWrapper);
            if (n2 < 0) continue;
            nArray[1] = n2;
            nArray[0] = i2;
            return;
        }
    }

    public CardWrapper WrapperAtPos(Point point) {
        for (int i2 = this.GetCellCount() - 1; i2 >= 0; --i2) {
            TableCell tableCell = this.GetCell(i2);
            int n2 = tableCell.GetCardsCount();
            if (tableCell.GetType() == 0) continue;
            while (--n2 >= 0) {
                CardWrapper cardWrapper = tableCell.GetWrapper(n2);
                Rectangle rectangle = cardWrapper.getBounds();
                if (point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height) continue;
                return cardWrapper;
            }
        }
        return null;
    }

    private void s(MouseEvent mouseEvent) {
        Point point;
        if (!this.w && this.WrapperAtPos(point = mouseEvent.getPoint()) == null) {
            for (int i2 = this.GetCellCount() - 1; i2 >= 0; --i2) {
                if (!this.GetCell(i2).PointIn(point)) continue;
                this.n.CardClick(null, i2, -1);
                break;
            }
            this.repaint();
        }
    }

    private void t(MouseEvent mouseEvent) {
        int[] nArray = new int[2];
        this.q((CardWrapper)mouseEvent.getComponent(), nArray);
        this.n.CardClick((CardWrapper)mouseEvent.getComponent(), nArray[0], nArray[1]);
    }

    private void u(MouseEvent mouseEvent) {
        CardWrapper cardWrapper = this.WrapperAtPos(mouseEvent.getPoint());
        if (cardWrapper != null) {
            int[] nArray = new int[2];
            this.q(cardWrapper, nArray);
            this.n.CardDblClick(cardWrapper, nArray[0], nArray[1]);
        }
    }

    private void v(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        CardWrapper cardWrapper = this.WrapperAtPos(point);
        if (cardWrapper != null && cardWrapper == this.u && !this.u.IsMoving()) {
            this.t(new MouseEvent(this.u, 0, 0L, 0, point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        } else {
            this.n.CardMouseUp(point.x, point.y);
        }
        this.u = null;
        this.w = false;
        this.repaint();
    }

    private void w(MouseEvent mouseEvent) {
        CardWrapper cardWrapper = this.WrapperAtPos(mouseEvent.getPoint());
        if (cardWrapper != null) {
            Point point = mouseEvent.getPoint();
            int[] nArray = new int[2];
            this.w = true;
            this.q = point.x;
            this.r = point.y;
            this.q(cardWrapper, nArray);
            this.u = cardWrapper;
            this.n.CardMouseDown(cardWrapper, nArray[0], nArray[1], point.x, point.y);
            this.n.CountAsPlayed();
        }
    }

    private void x(MouseEvent mouseEvent) {
        if (this.w) {
            int n2 = this.GetCellCount();
            Point point = mouseEvent.getPoint();
            int n3 = point.x - this.q;
            int n4 = point.y - this.r;
            while (--n2 >= 0) {
                TableCell tableCell = this.GetCell(n2);
                int n5 = tableCell.GetCardsCount();
                while (--n5 >= 0) {
                    CardWrapper cardWrapper = tableCell.GetWrapper(n5);
                    if (!cardWrapper.IsMoving()) continue;
                    Point point2 = cardWrapper.getLocation();
                    cardWrapper.setLocation(point2.x + n3, point2.y + n4);
                }
            }
            this.q = point.x;
            this.r = point.y;
            this.repaint(20L);
        }
    }

    public void StatusMsg(String string) {
        this.x.StatusMsg(string);
    }

    public void StartPlayTimer() {
        this.x.StartPlayTimer();
    }

    public void GameOver(boolean bl) {
        this.x.StopPlayTimer();
        if (this.v) {
            String string;
            String string2;
            if (bl) {
                string2 = "Congratulations";
                string = "Congratulations! You made it!";
            } else {
                string2 = "Game over";
                string = "Out of luck today, eh?";
            }
            string = string + "\n\nWould you like to play again?";
            string2 = string2 + " - Wiz Solitaire";
            switch (JOptionPane.showConfirmDialog(this, string, string2, 0)) {
                case 0: {
                    this.n.Start();
                    return;
                }
                case 1: {
                    this.v = false;
                }
            }
        }
    }

    public MainWin GetWin() {
        return this.x;
    }
}

