/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.Games.DiplomatLevelWin;
import WizSolitaire.Settings;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Vector;

public class Diplomat
extends CardGame {
    public static final int DIPLOMAT_NORMAL;
    public static final int DIPLOMAT_HARD = 1;
    private int c;
    private int d = 0;

    public Diplomat(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Diplomat", deck, gameTable, n2, n3);
    }

    public void LoadSettings(Settings settings, String string) {
        super.LoadSettings(settings, string);
        this.d = settings.getInt(string + ".Level", this.d);
    }

    public void SaveSettings(Settings settings, String string) {
        super.SaveSettings(settings, string);
        settings.setInt(string + ".Level", this.d);
    }

    public void Start() {
        DiplomatLevelWin diplomatLevelWin = new DiplomatLevelWin((Frame)this.Table.getTopLevelAncestor(), true);
        diplomatLevelWin.SetLevel(this.d);
        diplomatLevelWin.setVisible(true);
        this.d = diplomatLevelWin.GetLevel();
        super.Start();
    }

    protected void SetupCells() {
        for (int i2 = 0; i2 < 18; ++i2) {
            this.Table.AddCell(new TableCell());
        }
    }

    protected void Layout() {
        this.Table.Resize(12 + (6 + this.CardWidth) * 9, this.CardHeight * 5);
        float f2 = (float)((double)this.CardWidth / 88.0);
        int n2 = (int)(14.0f * f2);
        this.Table.GetCell(0).SetPos(6, 5);
        this.Table.GetCell(1).SetPos(6, 5 + this.CardHeight + 4);
        for (int i2 = 0; i2 < 8; ++i2) {
            this.Table.GetCell(i2 + 2).SetPos(6 + (i2 + 1) * (6 + this.CardWidth), 5);
            TableCell tableCell = this.Table.GetCell(i2 + 10);
            tableCell.SetPos(6 + (i2 + 1) * (6 + this.CardWidth), 5 + this.CardHeight + 4);
            tableCell.SetCardSpacing(0, n2);
        }
    }

    protected void PlaceCards() {
        TableCell tableCell;
        int n2 = 104;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 10; i3 < 18; ++i3) {
                Card card = this.MyDeck.Pick();
                tableCell = this.Table.GetCell(i3);
                CardWrapper cardWrapper = this.Table.WrapCard(card);
                tableCell.AddCard(cardWrapper);
                cardWrapper.SetFrontUp(true);
                --n2;
            }
        }
        tableCell = this.Table.GetCell(0);
        while (n2-- > 0) {
            Card card = this.MyDeck.Pick();
            CardWrapper cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(false);
        }
        this.c = 0;
    }

    private boolean h(Card card, int n2) {
        Card card2 = this.Table.GetCell(n2).GetCard(-1);
        int n3 = card.GetValue();
        boolean bl = false;
        if (n2 >= 10) {
            bl = card2 == null && (this.d == 0 || n3 == 13) || card2 != null && n3 + 1 == card2.GetValue();
        } else if (n2 >= 2) {
            bl = card2 == null && n3 == 1 || card2 != null && n3 - 1 == card2.GetValue() && card.GetSuit() == card2.GetSuit();
        }
        return bl;
    }

    public void CardClick(CardWrapper cardWrapper, int n2, int n3) {
        if (n2 == 0) {
            CardWrapper cardWrapper2 = this.Table.GetCell(0).PopCard();
            UndoStep undoStep = this.NewMove();
            if (cardWrapper2 != null) {
                undoStep.AddMove(cardWrapper2);
                cardWrapper2.SetFrontUp(true);
                this.Table.GetCell(1).AddCard(cardWrapper2);
            }
            this.AddUndo(undoStep);
        }
    }

    public void CardMouseDown(CardWrapper cardWrapper, int n2, int n3, int n4, int n5) {
        TableCell tableCell;
        if ((n2 >= 10 || n2 == 1) && cardWrapper == (tableCell = this.Table.GetCell(n2)).GetWrapper(-1)) {
            cardWrapper.SetMoving(true);
        }
    }

    public void CardMouseUp(int n2, int n3) {
        Vector vector = new Vector();
        this.GetMovingCards(vector);
        if (vector.size() > 0) {
            Rectangle rectangle = new Rectangle();
            TableCell tableCell = null;
            int n4 = 0;
            int n5 = 0;
            this.GetCardsRect(vector, rectangle);
            CardWrapper cardWrapper = (CardWrapper)vector.get(0);
            for (int i2 = 2; i2 < 18; ++i2) {
                int n6;
                TableCell tableCell2 = this.Table.GetCell(i2);
                if (tableCell2 == cardWrapper.GetCell() || (n6 = tableCell2.CoverArea(rectangle)) <= n4) continue;
                tableCell = tableCell2;
                n4 = n6;
                n5 = i2;
            }
            if (n4 > 25 && this.h(cardWrapper.GetCard(), n5)) {
                UndoStep undoStep = this.NewMove();
                cardWrapper = (CardWrapper)vector.get(0);
                undoStep.AddMove(cardWrapper);
                tableCell.AddCard(cardWrapper);
                this.AddUndo(undoStep);
                if (n5 >= 2 && n5 <= 9) {
                    ++this.c;
                }
            }
        }
        super.CardMouseUp(n2, n3);
        if (this.c >= 104) {
            this.GameOver(true);
        }
    }

    public void Undo() {
        super.Undo();
        this.c = 0;
        for (int i2 = 2; i2 <= 9; ++i2) {
            this.c += this.Table.GetCell(i2).GetCardsCount();
        }
    }
}

