/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class PicturesList
extends JPanel {
    public static final int LISTwidth = 220;
    public static final int LISTheight = 620;
    public static final int VISROWS = 4;
    public static final int LEFT = -1;
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    int pos;
    int list_id;
    DefaultListModel list_model;
    JList list;

    PicturesList(int n, ActionListener actionListener) {
        super(new BorderLayout());
        this.pos = n;
        this.list_id = n;
        this.list_model = new DefaultListModel();
        this.list = new JList(this.list_model);
        this.list.setVisibleRowCount(4);
        this.list.setCellRenderer(new VignetteRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(220, 620));
        this.add(jScrollPane);
        JPanel jPanel = new JPanel();
        switch (n) {
            case -1: {
                JButton jButton = new JButton("Open");
                jButton.setActionCommand("Open L");
                jButton.addActionListener(actionListener);
                jPanel.add(jButton);
                jButton = new JButton(">>>");
                jButton.addActionListener(actionListener);
                jPanel.add(jButton);
                break;
            }
            case 1: {
                JButton jButton = new JButton("<<<");
                jButton.addActionListener(actionListener);
                jPanel.add(jButton);
                jButton = new JButton("Open");
                jButton.setActionCommand("Open R");
                jButton.addActionListener(actionListener);
                jPanel.add(jButton);
                break;
            }
            default: {
                JButton jButton = new JButton("<<< + >>>");
                jButton.addActionListener(actionListener);
                jPanel.add(jButton);
            }
        }
        this.add((Component)jPanel, "North");
        this.list.addMouseListener(new rightClickListener());
    }

    public boolean isVisible(PicturesListElement picturesListElement) {
        if (picturesListElement.actual_list != this.list) {
            return false;
        }
        int n = this.list_model.indexOf(picturesListElement);
        return n >= this.list.getFirstVisibleIndex() && n <= this.list.getLastVisibleIndex();
    }

    void setElements(String string, String[] stringArray) {
        this.list_model.clear();
        this.list_id += this.pos;
        for (int i = 0; i < stringArray.length; ++i) {
            this.list_model.addElement(new PicturesListElement(string, stringArray[i], this.list_id, this.list));
        }
        this.list.setSelectedIndex(-1);
        this.list.ensureIndexIsVisible(0);
    }

    void addElements(Object[] objectArray) {
        if (this.pos == 0) {
            int n = this.list.getSelectedIndex();
            if (n == -1) {
                n = this.list_model.getSize();
            }
            for (int i = objectArray.length - 1; i >= 0; --i) {
                ((PicturesListElement)objectArray[i]).actual_list = this.list;
                this.list_model.add(n, objectArray[i]);
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                PicturesListElement picturesListElement = (PicturesListElement)objectArray[i];
                if (picturesListElement.list_id != this.list_id) continue;
                for (n = 0; n < this.list_model.getSize(); ++n) {
                    if (picturesListElement.file.compareTo(((PicturesListElement)this.list_model.elementAt((int)n)).file) >= 0) continue;
                    picturesListElement.actual_list = this.list;
                    this.list_model.add(n, picturesListElement);
                    break;
                }
                if (n != this.list_model.getSize()) continue;
                picturesListElement.actual_list = this.list;
                this.list_model.addElement(picturesListElement);
            }
            this.list.setSelectedIndex(-1);
        }
    }

    Object[] transfer() {
        Object[] objectArray = this.list.getSelectedValues();
        int[] nArray = this.list.getSelectedIndices();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            this.list_model.removeElementAt(nArray[i] - n++);
        }
        this.list.setSelectedIndex(-1);
        return objectArray;
    }

    public boolean isEmpty() {
        return this.list_model.isEmpty();
    }

    public Enumeration elements() {
        return this.list_model.elements();
    }

    public int length() {
        return this.list_model.size();
    }

    class rightClickListener
    extends MouseAdapter {
        static final int ICONSIDE = 18;

        rightClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                for (int i = PicturesList.this.list.getFirstVisibleIndex(); i <= PicturesList.this.list.getLastVisibleIndex(); ++i) {
                    Rectangle rectangle = PicturesList.this.list.getCellBounds(i, i);
                    if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                    Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width - 18, rectangle.y + rectangle.height - 18, 18, 18);
                    PicturesListElement picturesListElement = (PicturesListElement)PicturesList.this.list_model.get(i);
                    if (rectangle2.contains(mouseEvent.getX(), mouseEvent.getY())) {
                        if (!picturesListElement.hasSound()) break;
                        try {
                            Applet.newAudioClip(picturesListElement.sound().toURI().toURL()).play();
                        }
                        catch (MalformedURLException malformedURLException) {}
                        break;
                    }
                    BufferedImage bufferedImage = ImagePool.find(picturesListElement);
                    if (bufferedImage == null) break;
                    new ZoomWindow(bufferedImage, picturesListElement.file);
                    break;
                }
            }
        }
    }
}

