/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.PacksPanelAutomationHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.n3.nanoxml.XMLElement;

public class PacksPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private JLabel spaceLabel;
    private JTextArea descriptionArea;
    private JScrollPane tableScroller;
    protected int bytes = 0;
    private JTable packsTable;
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "packsLang.xml";
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public PacksPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        Object object;
        try {
            object = "packsLang.xml_" + installData.localeISO3;
            this.langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream((String)object));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setLayout(new BoxLayout(this, 1));
        object = new JLabel(installerFrame.langpack.getString("PacksPanel.info"), installerFrame.icons.getImageIcon("preferences"), 11);
        this.add((Component)object);
        this.add(Box.createRigidArea(new Dimension(0, 3)));
        JLabel jLabel = new JLabel(installerFrame.langpack.getString("PacksPanel.tip"), installerFrame.icons.getImageIcon("tip"), 11);
        this.add(jLabel);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.packsTable = new JTable();
        this.packsTable.setIntercellSpacing(new Dimension(0, 0));
        this.packsTable.setBackground(Color.white);
        this.packsTable.setSelectionMode(0);
        this.packsTable.getSelectionModel().addListSelectionListener(this);
        this.packsTable.setShowGrid(false);
        this.tableScroller = new JScrollPane(this.packsTable);
        this.tableScroller.setAlignmentX(0.0f);
        this.tableScroller.getViewport().setBackground(Color.white);
        this.tableScroller.setPreferredSize(new Dimension(300, installData.guiPrefs.height / 3 + 30));
        this.add(this.tableScroller);
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setMargin(new Insets(2, 2, 2, 2));
        this.descriptionArea.setAlignmentX(0.0f);
        this.descriptionArea.setCaretPosition(0);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setOpaque(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setBorder(BorderFactory.createTitledBorder(installerFrame.langpack.getString("PacksPanel.description")));
        this.add(this.descriptionArea);
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel(installerFrame.langpack.getString("PacksPanel.space")));
        jPanel.add(Box.createHorizontalGlue());
        this.spaceLabel = new JLabel("");
        jPanel.add(this.spaceLabel);
        this.add(jPanel);
    }

    public void panelActivate() {
        try {
            this.packsTable.setModel(new PacksModel(this.idata.availablePacks, this.idata.selectedPacks));
            CheckBoxEditorRenderer checkBoxEditorRenderer = new CheckBoxEditorRenderer(false);
            this.packsTable.getColumnModel().getColumn(0).setCellRenderer(checkBoxEditorRenderer);
            CheckBoxEditorRenderer checkBoxEditorRenderer2 = new CheckBoxEditorRenderer(true);
            this.packsTable.getColumnModel().getColumn(0).setCellEditor(checkBoxEditorRenderer2);
            this.packsTable.getColumnModel().getColumn(0).setMaxWidth(40);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                public void setBorder(Border border) {
                }
            };
            this.packsTable.getColumnModel().getColumn(1).setCellRenderer(defaultTableCellRenderer);
            DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer(){

                public void setBorder(Border border) {
                }
            };
            defaultTableCellRenderer2.setHorizontalAlignment(4);
            this.packsTable.getColumnModel().getColumn(2).setCellRenderer(defaultTableCellRenderer2);
            this.packsTable.getColumnModel().getColumn(2).setMaxWidth(100);
            this.tableScroller.remove(this.packsTable.getTableHeader());
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            Iterator iterator = this.idata.availablePacks.iterator();
            this.bytes = 0;
            while (iterator.hasNext()) {
                Pack pack = (Pack)iterator.next();
                if (pack.required) {
                    this.bytes = (int)((long)this.bytes + pack.nbytes);
                    continue;
                }
                if (!this.idata.selectedPacks.contains(pack)) continue;
                this.bytes = (int)((long)this.bytes + pack.nbytes);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showSpaceRequired();
    }

    protected void showSpaceRequired() {
        this.spaceLabel.setText(Pack.toByteUnitsString(this.bytes));
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public boolean isValidated() {
        return true;
    }

    public void makeXMLData(XMLElement xMLElement) {
        new PacksPanelAutomationHelper().makeXMLData(this.idata, xMLElement);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.packsTable.getSelectedRow();
        if (n >= 0) {
            Pack pack = (Pack)this.idata.availablePacks.get(n);
            String string = "";
            if (pack.id != null && !pack.id.equals("")) {
                string = this.langpack.getString(pack.id + ".description");
            }
            if (string.equals("")) {
                string = pack.description;
            }
            this.descriptionArea.setText(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CheckBoxEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private JCheckBox display = new JCheckBox();

        public CheckBoxEditorRenderer(boolean bl) {
            this.display.setHorizontalAlignment(0);
            if (bl) {
                this.display.addActionListener(this);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.display.setForeground(jTable.getSelectionForeground());
                this.display.setBackground(jTable.getSelectionBackground());
            } else {
                this.display.setForeground(jTable.getForeground());
                this.display.setBackground(jTable.getBackground());
            }
            int n3 = (Integer)object;
            this.display.setSelected(object != null && Math.abs(n3) == 1);
            this.display.setEnabled(n3 >= 0);
            return this.display;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }

        public Object getCellEditorValue() {
            return new Integer(this.display.isSelected() ? 1 : 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }
    }

    private class PacksModel
    extends AbstractTableModel {
        private List packs;
        private List packsToInstall;

        public PacksModel(List list, List list2) {
            this.packs = list;
            this.packsToInstall = list2;
        }

        public int getRowCount() {
            return this.packs.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = PacksPanel.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = PacksPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            Pack pack = (Pack)this.packs.get(n);
            if (pack.required) {
                return false;
            }
            return n2 == 0;
        }

        public Object getValueAt(int n, int n2) {
            Pack pack = (Pack)this.packs.get(n);
            switch (n2) {
                case 0: {
                    int n3 = 0;
                    n3 = pack.required ? -1 : (this.packsToInstall.contains(pack) ? 1 : 0);
                    return new Integer(n3);
                }
                case 1: {
                    if (pack.id == null || pack.id.equals("")) {
                        return pack.name;
                    }
                    return PacksPanel.this.langpack.getString(pack.id);
                }
                case 2: {
                    return Pack.toByteUnitsString((int)pack.nbytes);
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && object instanceof Integer) {
                Pack pack = (Pack)this.packs.get(n);
                if ((Integer)object == 1) {
                    this.packsToInstall.add(pack);
                    PacksPanel.this.bytes = (int)((long)PacksPanel.this.bytes + pack.nbytes);
                } else {
                    this.packsToInstall.remove(pack);
                    PacksPanel.this.bytes = (int)((long)PacksPanel.this.bytes - pack.nbytes);
                }
                PacksPanel.this.showSpaceRequired();
            }
        }
    }
}

