/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.util;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static byte[] hexNumberTable = new byte[255];
    private static byte[] lookUpHexAlphabet = new byte[16];

    static boolean isHex(byte by) {
        return hexNumberTable[by] != -1;
    }

    static boolean isArrayByteHex(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!HexBin.isHex(byArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isHex(String string) {
        if (string == null) {
            return false;
        }
        return HexBin.isArrayByteHex(string.getBytes());
    }

    public static byte[] encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = n * 2;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n) {
            byArray2[n3 * 2] = lookUpHexAlphabet[byArray[n3] >> 4];
            byArray2[n3 * 2 + 1] = lookUpHexAlphabet[byArray[n3] & 0xF];
            ++n3;
        }
        return byArray2;
    }

    public static byte[] decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return null;
        }
        int n2 = n / 2;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = (byte)(hexNumberTable[byArray[n3 * 2]] << 4 | hexNumberTable[byArray[n3 * 2 + 1]]);
            ++n3;
        }
        return byArray2;
    }

    public static int getDecodedDataLength(byte[] byArray) {
        if (!HexBin.isArrayByteHex(byArray)) {
            return -1;
        }
        return byArray.length / 2;
    }

    static {
        int n = 0;
        while (n < 255) {
            HexBin.hexNumberTable[n] = -1;
            ++n;
        }
        int n2 = 57;
        while (n2 >= 48) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 48);
            --n2;
        }
        int n3 = 70;
        while (n3 >= 65) {
            HexBin.hexNumberTable[n3] = (byte)(n3 - 65 + 10);
            --n3;
        }
        int n4 = 102;
        while (n4 >= 97) {
            HexBin.hexNumberTable[n4] = (byte)(n4 - 97 + 10);
            --n4;
        }
        int n5 = 0;
        while (n5 < 10) {
            HexBin.lookUpHexAlphabet[n5] = (byte)(48 + n5);
            ++n5;
        }
        int n6 = 10;
        while (n6 <= 15) {
            HexBin.lookUpHexAlphabet[n6] = (byte)(65 + n6 - 10);
            ++n6;
        }
    }
}

