/*
 * Decompiled with CFR 0.152.
 */
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Setup;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Uninstall;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;

public class MainClass {
    private static final Class installClass = new MainClass().getClass();
    public static final boolean DEBUG = false;
    private static File uninstDir_;
    private static File jarFile_;
    private static String DEST_PATH;
    private static String LICENSE_KEY_SUPPORT_NAME;

    public static void main(String[] args) {
        block9: {
            if (!MainClass.testJavaVersion()) {
                MainClass.exitOnError();
            }
            try {
                if (args.length == 0) {
                    String s1 = installClass.getName() + ".class";
                    String s3 = ClassLoader.getSystemResource(s1).getPath();
                    s3 = URLDecoder.decode(s3);
                    String s4 = "!/" + s1;
                    String s5 = "file:";
                    if (s3 != null && s3.indexOf(s4) > 0 && s3.indexOf(s5) >= 0) {
                        s3 = s3.substring(s3.indexOf(s5) + s5.length(), s3.indexOf(s4));
                        jarFile_ = new File(s3);
                    } else {
                        System.err.println("\nuse jar to start installation");
                        MainClass.exitOnError();
                    }
                    MainClass.setup();
                    break block9;
                }
                if (!"uninstall".equals(args[0])) {
                    System.err.println(" no such option supported");
                    MainClass.exitOnError();
                    break block9;
                }
                if (args[1] != null) {
                    uninstDir_ = new File(args[1]);
                    if (!uninstDir_.exists()) {
                        System.err.println(uninstDir_ + " does not exist");
                        MainClass.exitOnError();
                    }
                    MainClass.uninstall();
                    break block9;
                }
                System.err.println("\nMissing uninstall dir");
                MainClass.exitOnError();
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    static void exitOnError() {
        System.out.println("Press \"enter\" to exit");
        try {
            System.in.read();
        }
        catch (IOException ioexception) {
            // empty catch block
        }
        System.exit(1);
    }

    static boolean testJavaVersion() {
        boolean flag = true;
        String s = System.getProperty("java.version");
        if (s.compareTo("1.2") < 0) {
            System.out.println("\nJava VM not suitable: version " + s);
            System.out.println("Minimum required: version 1.2\n");
            flag = false;
        }
        return flag;
    }

    static void setup() throws IOException {
        MainClass.printDebug("\nExtracting classloader...");
        MainClass.printDebug("  OK");
        MainClass.printDebug("\nLauching setup...");
        MainClass.launchSetup(jarFile_);
    }

    private static void deleteAll(File file) {
        if (file.isDirectory()) {
            File[] afile = file.listFiles();
            int i = 0;
            while (i < afile.length) {
                MainClass.deleteAll(afile[i]);
                ++i;
            }
        }
        if (file.delete()) {
            MainClass.printDebug("\n" + file + " deleted");
        }
    }

    static void uninstall() throws IOException {
        MainClass.printDebug("\nExtracting classloader...");
        MainClass.printDebug("  OK");
        File file1 = new File(uninstDir_.getAbsolutePath() + File.separator + "install.jar");
        if (!file1.exists() || !file1.canRead()) {
            System.out.println(file1 + " can not be read!");
            MainClass.exitOnError();
        }
        MainClass.printDebug("\nLauching uninstall...");
        MainClass.launchUninstall(file1);
    }

    static void launchSetup(File file) throws IOException {
        try {
            Setup setup = new Setup(DEST_PATH, LICENSE_KEY_SUPPORT_NAME, file, installClass.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void launchUninstall(File file) throws IOException {
        try {
            Uninstall uninstall = new Uninstall(uninstDir_.getAbsolutePath());
        }
        catch (Exception exception) {
            MainClass.printDebug(exception.toString());
        }
    }

    private static void printDebug(String s) {
    }

    static Class getClass(String s) throws ClassNotFoundException {
        return Class.forName(s);
    }

    static {
        DEST_PATH = "[HOME]DaffodilDB" + Globals.APP_VERSION.replace('.', '_') + "";
        LICENSE_KEY_SUPPORT_NAME = "com.daffodilwoods.daffodilinstaller.daffodildb2_0.DefaultLicenseKeySupport";
    }
}

