/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;

public class JVMUtility {
    public static String[] getJavaPaths() {
        if (Globals.IS_WIN) {
            return JVMUtility.getJavaPathsFromJREandJDKRegistry();
        }
        return JVMUtility.getJavaPathsForOtherOS();
    }

    private static String[] getJavaPathsForOtherOS() {
        ArrayList list = new ArrayList();
        String javaHome = System.getProperty("java.home");
        javaHome = javaHome + File.separator + "bin" + File.separator + "java";
        JVMUtility.addInToList(javaHome, list);
        return list.size() == 0 ? null : list.toArray(new String[0]);
    }

    private static String[] getJavaPathsFromJREandJDKRegistry() {
        ArrayList list = new ArrayList();
        String key = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
        JVMUtility.getJavaPathsFromRegistry(key, list);
        key = "SOFTWARE\\JavaSoft\\Java Development Kit";
        JVMUtility.getJavaPathsFromRegistry(key, list);
        String s = JVMUtility.getJavaExeHandlerInWindow();
        JVMUtility.addInToList(s, list);
        String javaHome = System.getProperty("java.home");
        javaHome = javaHome + File.separator + "bin" + File.separator + "java.exe";
        JVMUtility.addInToList(javaHome, list);
        return list.size() == 0 ? null : list.toArray(new String[0]);
    }

    private static void getJavaPathsFromRegistry(String key, ArrayList list) {
        try {
            RegistryKey jdkKey = Registry.HKEY_LOCAL_MACHINE.openSubKey(key, 1);
            Enumeration enu = jdkKey.keyElements();
            while (enu.hasMoreElements()) {
                Object obj = enu.nextElement();
                String subkey = (String)obj;
                String str = JVMUtility.getJavaPath(key + "\\" + subkey);
                str = str + "\\bin\\java.exe";
                JVMUtility.addInToList(str, list);
            }
            jdkKey.closeKey();
        }
        catch (RegistryException ex) {}
    }

    private static String getJavaPath(String parentKey) {
        try {
            RegistryKey javaKey = Registry.HKEY_LOCAL_MACHINE.openSubKey(parentKey, 1);
            RegistryValue value = javaKey.getValue("JavaHome");
            byte[] bytedata = value.getByteData();
            String str = new String(bytedata);
            javaKey.closeKey();
            return str;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String getJavaExeHandlerInWindow() {
        try {
            String key = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\java.exe";
            RegistryKey javaKey = Registry.HKEY_LOCAL_MACHINE.openSubKey(key, 1);
            String value = javaKey.getDefaultValue();
            javaKey.closeKey();
            return value;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void addInToList(String javaExe, ArrayList list) {
        File file;
        if (javaExe != null && !list.contains(javaExe) && (file = new File(javaExe)).exists()) {
            list.add(javaExe);
        }
    }
}

