/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.InstallStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LogInfo;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ScriptInfo;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.SetupFileFilter;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ShortcutsUtility;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Step;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.StepFactory;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.WindowsShortcut;
import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

public class Utility {
    static void updateWindowsRegistry(File sharedDir, boolean upgrade, String lastVer, StepFactory ui_, String installClassName_) throws IOException {
        File destPath = new File(sharedDir.getAbsolutePath() + File.separator + Globals.APP_NAME + "_" + Globals.APP_VERSION);
        try {
            RegistryKey newKey = Registry.HKEY_LOCAL_MACHINE.createSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + Globals.APP_NAME + " " + Globals.APP_VERSION, "", 2);
            RegStringValue displayName = new RegStringValue(newKey, "DisplayName");
            displayName.setData(Globals.APP_NAME + " " + Globals.APP_VERSION);
            newKey.setValue(displayName);
            RegStringValue displayIcon = new RegStringValue(newKey, "DisplayIcon");
            displayIcon.setData(Globals.DEST_PATH + "\\icons\\Uninstall.ico");
            newKey.setValue(displayIcon);
            RegStringValue uninstallString = new RegStringValue(newKey, "UninstallString");
            String scriptStr = "";
            scriptStr = scriptStr + "\"" + Globals.JAVAW_EXE + "\"" + " -cp \"" + destPath.getAbsolutePath() + File.separator + "install.jar" + "\" ";
            scriptStr = scriptStr + installClassName_ + " uninstall \"" + destPath.getAbsolutePath() + "\"";
            Globals.printDebug("writing unistall command in registry :: " + scriptStr);
            uninstallString.setData(scriptStr);
            newKey.setValue(uninstallString);
            newKey.closeKey();
        }
        catch (Exception e) {
            throw new IOException("" + e);
        }
    }

    static void extractUninstallFiles(File _destPath, boolean upgrade, String lastVer, boolean[] dirty_, File fileWithArchive_) throws IOException {
        File destPath = new File(_destPath, Globals.APP_NAME + "_" + Globals.APP_VERSION);
        if (upgrade) {
            File lastVerPath = new File(_destPath, Globals.APP_NAME + "_" + lastVer);
            if (!destPath.exists() && !lastVerPath.renameTo(destPath)) {
                throw new IOException(Globals.i18n("Setup_CouldNotRenameDir") + " " + lastVerPath);
            }
        } else if (!destPath.exists() && !destPath.mkdirs()) {
            throw new IOException(Globals.i18n("Setup_NotCreateDirectory") + " " + destPath);
        }
        dirty_[0] = true;
        File[] ls = destPath.listFiles(new SetupFileFilter(".daf", 2, 2));
        int i = 0;
        while (i < ls.length) {
            ls[i].delete();
            ++i;
        }
        Object out = null;
        FileInputStream in = null;
        byte[] buf = new byte[]{};
        int read = 0;
        in = new FileInputStream(fileWithArchive_);
        JarInputStream jar = new JarInputStream(in);
        JarOutputStream outJar = new JarOutputStream(new FileOutputStream(destPath.getAbsolutePath() + File.separator + "install.jar"));
        ZipEntry entry = jar.getNextEntry();
        while (entry != null) {
            String entryName = entry.getName();
            if (!entryName.endsWith(".zip")) {
                buf = new byte[2048];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((read = jar.read(buf)) != -1) {
                    bos.write(buf, 0, read);
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(bos.toByteArray());
                bos.close();
                ZipEntry outEntry = new ZipEntry(entryName);
                CRC32 crc = new CRC32();
                outEntry.setCrc(crc.getValue());
                outEntry.setSize(bos.toByteArray().length);
                outJar.putNextEntry(outEntry);
                buf = new byte[512];
                read = bais.read(buf, 0, buf.length);
                while (read > 0) {
                    crc.update(buf, 0, read);
                    outJar.write(buf, 0, read);
                    read = bais.read(buf, 0, buf.length);
                }
                bais.close();
                outEntry.setCrc(crc.getValue());
                outJar.closeEntry();
            }
            jar.closeEntry();
            entry = jar.getNextEntry();
        }
        jar.close();
        outJar.close();
        in.close();
    }

    public static String expandDirectory(String dir, boolean block) throws IOException {
        String res = null;
        if (!dir.startsWith("[")) {
            res = dir;
        } else {
            int index = dir.indexOf(93);
            String prefix = dir.substring(1, index).trim();
            if ("HOME".equals(prefix)) {
                res = System.getProperty("user.home");
                if (Globals.IS_WIN && Globals.IS_ROOT && res != null && res.length() > 3 && res.charAt(1) == ':') {
                    res = res.substring(0, 3);
                }
            } else if ("C:".equals(prefix)) {
                if (Globals.IS_WIN) {
                    res = "C:\\";
                } else if (Globals.IS_UNIX) {
                    res = "/";
                } else if (Globals.IS_MAC) {
                    res = ":";
                }
            } else if ("PROGRAM".equals(prefix)) {
                if (!Globals.IS_ROOT) {
                    res = System.getProperty("user.home");
                } else if (Globals.IS_WIN) {
                    try {
                        RegistryKey programDirKey = Registry.HKEY_LOCAL_MACHINE.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
                        res = programDirKey.getStringValue("ProgramFilesDir");
                        programDirKey.closeKey();
                    }
                    catch (Exception re) {
                        if (block) {
                            throw new IOException(re.getMessage());
                        }
                        res = null;
                    }
                    if (res == null) {
                        Globals.printDebug("Could not find program dir in registry:");
                        Globals.printDebug("using 'C:\\Program Files'");
                        res = "C:\\Program Files";
                    }
                } else if (Globals.IS_UNIX) {
                    res = "/usr/local";
                }
            } else if (prefix.length() == 2 && prefix.endsWith(":")) {
                if (Globals.IS_WIN) {
                    res = prefix.substring(0, 2) + File.separator;
                } else if (Globals.IS_UNIX) {
                    res = "/";
                }
            }
            String suffix = "";
            if (dir.length() > index + 1 && (suffix = suffix + dir.substring(index + 1).trim()).startsWith("/")) {
                suffix = suffix.substring(1);
            }
            if (res == null) {
                if (block) {
                    throw new IOException(Globals.i18n("Setup_InvalidDir") + dir);
                }
                res = System.getProperty("user.dir");
            }
            res = res + File.separator + suffix;
        }
        return res;
    }

    public static Object[] generateLaunchScripts(LogInfo logInfo, StepFactory ui_, Step step_) throws IOException {
        InstallStep step = (InstallStep)step_;
        ScriptInfo[] scripts = Globals.getScriptInfos();
        if (scripts == null) {
            step.status(Globals.i18n("Setup_NoLaunchScript"));
            Globals.printDebug("No launch script");
            return null;
        }
        if (!Globals.IS_WIN && !Globals.IS_UNIX) {
            ui_.showError(new Exception(Globals.i18n("Setup_SorryScriptsNotSupported")));
            return null;
        }
        String NL = System.getProperty("line.separator");
        ArrayList<String[]> scriptaral = new ArrayList<String[]>();
        int i = 0;
        while (i < scripts.length) {
            String[] scriptinfo;
            if (scripts[i].isJava_) {
                if (!(!Globals.isServerSelected && (scripts[i].scriptName_.endsWith("StartServer") || scripts[i].scriptName_.endsWith("StopServer")) || !Globals.isEmbeddedSelected && (scripts[i].scriptName_.endsWith("BrowserEmbedded") || scripts[i].scriptName_.endsWith("ShellEmbedded")) || !Globals.isClientSelected && (scripts[i].scriptName_.endsWith("BrowserServer") || scripts[i].scriptName_.endsWith("ShellServer")))) {
                    String sname;
                    scriptinfo = new String[6];
                    String script = "";
                    if (Globals.IS_WIN) {
                        script = script + "REM Launch script" + NL;
                        script = script + NL;
                    } else {
                        script = script + "#!/bin/sh" + NL;
                        script = script + "### Launch Script for " + Globals.APP_NAME + NL;
                        script = script + NL;
                    }
                    if (!Globals.IS_WIN) {
                        script = script + "APP_HOME=`dirname $0`" + NL;
                    }
                    String tkClass = scripts[i].mainClassName_;
                    StringTokenizer temp = new StringTokenizer(scripts[i].classPath_, ",");
                    String[] tkClassPath = new String[temp.countTokens()];
                    int n = 0;
                    while (temp.hasMoreTokens()) {
                        String tt = Utility.convertPath(temp.nextToken());
                        tkClassPath[n++] = tt;
                    }
                    String tkJavaMode = scripts[i].javaMode_;
                    temp = new StringTokenizer(scripts[i].javaArguments_, ",");
                    String[] tkJavaArgs = new String[temp.countTokens()];
                    n = 0;
                    while (temp.hasMoreTokens()) {
                        tkJavaArgs[n++] = Utility.convertPath(temp.nextToken());
                    }
                    temp = new StringTokenizer(scripts[i].classArguments_, ",");
                    String[] tkClassArgs = new String[temp.countTokens()];
                    n = 0;
                    while (temp.hasMoreTokens()) {
                        tkClassArgs[n++] = Utility.convertPath(temp.nextToken());
                    }
                    if ("console".equals(tkJavaMode)) {
                        script = script + "\"" + Globals.JAVA_EXE + "\"";
                        scriptinfo[1] = Globals.JAVA_EXE;
                    } else {
                        script = script + "\"" + Globals.JAVAW_EXE + "\"";
                        scriptinfo[1] = Globals.JAVAW_EXE;
                    }
                    scriptinfo[2] = "";
                    n = 0;
                    while (n < tkJavaArgs.length) {
                        script = script + " " + tkJavaArgs[n];
                        scriptinfo[2] = scriptinfo[2] + " " + tkJavaArgs[n];
                        ++n;
                    }
                    if (tkClassPath.length > 0) {
                        script = script + " -cp \"";
                        scriptinfo[3] = " -cp \"";
                    }
                    n = 0;
                    while (n < tkClassPath.length) {
                        String cp = "";
                        if (n > 0) {
                            cp = cp + File.pathSeparator;
                        }
                        if (!Globals.IS_WIN && !tkClassPath[n].startsWith("/")) {
                            cp = cp + "$APP_HOME/";
                        }
                        cp = cp + tkClassPath[n];
                        cp = cp.replace('/', File.separatorChar);
                        script = script + cp;
                        scriptinfo[3] = scriptinfo[3] + cp;
                        ++n;
                    }
                    if (tkClassPath.length > 0) {
                        script = script + "\"";
                        scriptinfo[3] = scriptinfo[3] + "\"";
                    }
                    script = script + " " + tkClass;
                    scriptinfo[4] = " " + tkClass;
                    scriptinfo[5] = "";
                    n = 0;
                    while (n < tkClassArgs.length) {
                        script = script + " \"" + tkClassArgs[n] + "\"";
                        scriptinfo[5] = scriptinfo[5] + " \"" + tkClassArgs[n] + "\"";
                        ++n;
                    }
                    script = Globals.IS_WIN ? script + " %1 %2 %3 %4 %5 %6 %7 %8 %9" : script + " $*";
                    scriptinfo[0] = sname = scripts[i].scriptName_;
                    sname = Utility.computeLocalPath(sname);
                    sname = Globals.IS_WIN ? sname + ".bat" : sname + ".sh";
                    File sfile = new File(sname);
                    step.details(sfile.getAbsolutePath());
                    if (!logInfo.oldlog.contains(sfile.getAbsolutePath())) {
                        logInfo.log.println(sfile.getAbsolutePath());
                    }
                    PrintWriter scriptFile = new PrintWriter(new FileWriter(sfile));
                    scriptFile.println(script);
                    scriptFile.close();
                    scriptaral.add(scriptinfo);
                }
            } else {
                scriptinfo = new String[]{scripts[i].scriptName_, Utility.convertPath(scripts[i].mainClassName_), "", "", "", ""};
                if (Globals.isDocumentaionSelected || !scripts[i].scriptName_.startsWith("Documentation")) {
                    scriptaral.add(scriptinfo);
                }
            }
            ++i;
        }
        return scriptaral.toArray();
    }

    static String computeLocalPath(String entry) throws IOException {
        String res = Utility.expandDirectory(entry, false);
        if (res == null) {
            throw new IOException(Globals.i18n("Setup_InvalidPath") + entry);
        }
        if (!(res.startsWith("/") || res.startsWith("C:\\") || res.startsWith(":"))) {
            res = Globals.DEST_PATH + "/" + res;
        }
        return res.replace('/', File.separatorChar);
    }

    static void generateUninstallScripts(File destPath, LogInfo logInfo, String installClassName_, StepFactory ui_, Step step_) throws IOException {
        InstallStep step = (InstallStep)step_;
        if (!Globals.IS_WIN && !Globals.IS_UNIX) {
            ui_.showError(new Exception(Globals.i18n("Setup_NotGenerateScript")));
            return;
        }
        if (!(destPath = new File(destPath, Globals.APP_NAME + "_" + Globals.APP_VERSION)).exists() && !destPath.mkdirs()) {
            ui_.showError(new Exception(Globals.i18n("Setup_NotCreateDirectory") + " " + destPath));
            return;
        }
        File[] ls = new File(Globals.DEST_PATH).listFiles(new SetupFileFilter("uninstall_" + Globals.APP_NAME + "_", 1, 1));
        int i = 0;
        while (i < ls.length) {
            ls[i].delete();
            ++i;
        }
        String sname = "uninstall_" + Globals.APP_NAME + "_" + Globals.APP_VERSION;
        sname = Utility.computeLocalPath(sname);
        sname = Globals.IS_WIN ? sname + ".bat" : sname + ".sh";
        step.details(sname);
        File sfile = new File(sname);
        PrintWriter script = new PrintWriter(new FileWriter(sfile));
        logInfo.log.println(sfile.getAbsolutePath());
        if (Globals.IS_WIN) {
            script.println("REM Uninstall script for " + Globals.APP_NAME + "_" + Globals.APP_VERSION);
            script.println();
        } else {
            script.println("#!/bin/sh");
            script.println("### Uninstall script for " + Globals.APP_NAME + "_" + Globals.APP_VERSION);
            script.println();
            script.println("stty -icanon");
        }
        String scriptStr = "";
        String javaArguments = " -cp \"" + destPath.getAbsolutePath() + File.separator + "install.jar" + "\" ";
        javaArguments = javaArguments + installClassName_ + " uninstall \"" + destPath.getAbsolutePath() + "\"";
        scriptStr = scriptStr + "\"" + Globals.JAVAW_EXE + "\"" + javaArguments;
        script.println(scriptStr);
        if (Globals.IS_WIN) {
            Utility.uninstallShortcut(javaArguments);
        }
        if (Globals.IS_UNIX) {
            script.println("stty icanon");
        }
        script.close();
    }

    private static void uninstallShortcut(String scriptStr) {
        try {
            String desktopPath = Globals.DEST_PATH;
            String startMenuPath = Globals.DEST_PATH;
            try {
                RegistryKey dirKey = Registry.HKEY_CURRENT_USER.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
                desktopPath = dirKey.getStringValue("Desktop");
                startMenuPath = dirKey.getStringValue("Programs");
                byte[] b = dirKey.getValue("Programs").getByteData();
                startMenuPath = new String(b, "Cp1252");
                Globals.printDebug("\nStartMenu path in registry: '" + startMenuPath + "'");
                if (startMenuPath != null && startMenuPath.indexOf("D?marrer") > -1) {
                    int deb = startMenuPath.indexOf("D?marrer");
                    int last = deb + 8;
                    startMenuPath = startMenuPath.substring(0, deb) + "D\u00e9marrer" + startMenuPath.substring(last);
                }
            }
            catch (Exception e) {
                Globals.printDebug("\nDesktop or Programs Folder not found :\n" + e.getMessage());
            }
            if (desktopPath == null || !new File(desktopPath).exists()) {
                desktopPath = Globals.DEST_PATH;
            }
            if (startMenuPath == null || !new File(startMenuPath).exists()) {
                startMenuPath = Globals.DEST_PATH;
            }
            Globals.printDebug("\nDesktop path : '" + desktopPath + "'");
            Globals.printDebug("\nStart menu path : '" + startMenuPath + "'");
            String linkpath = "";
            if (!"applications".equals("Daffodil".toLowerCase()) && !"utilities".equals("Daffodil".toLowerCase())) {
                linkpath = linkpath + "\\Daffodil";
            }
            linkpath = linkpath + "\\" + Globals.APP_NAME + " " + Globals.APP_VERSION;
            Globals.printDebug(" Link path ::: " + linkpath);
            String linkname = linkpath + "\\Uninstall " + Globals.APP_NAME + " " + Globals.APP_VERSION + ".lnk";
            String iconfile = ShortcutsUtility.getWindowsIconFile("Uninstall");
            System.out.println("Scriptstr :: " + scriptStr);
            new WindowsShortcut(startMenuPath + linkname, Globals.JAVAW_EXE, scriptStr, Globals.DEST_PATH, iconfile);
        }
        catch (Exception e) {}
    }

    public static String convertPath(String str) {
        String keyword_dest_path = "[DEST_PATH]";
        String returnStr = str;
        int index = str.indexOf(keyword_dest_path);
        if (index != -1) {
            String prefix = str.substring(0, index);
            String suffix = str.substring(index + keyword_dest_path.length());
            returnStr = prefix + Globals.DEST_PATH + suffix;
        }
        return returnStr;
    }
}

