/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class WindowsShortcut {
    private byte[] answer = new byte[1024];
    private int offset = 1024;
    private byte[] buf = new byte[8];
    private ByteArrayOutputStream bytestream = new ByteArrayOutputStream(125);

    public WindowsShortcut(String fulllinkpath, String fulltargetpath, String arguments, String workingdirectory, String iconfile) throws IOException {
        this.buildLink(fulltargetpath, arguments, workingdirectory, fulllinkpath, iconfile);
        File linkfile = new File(fulllinkpath);
        this.mkpath(linkfile);
        this.writeFile(linkfile);
    }

    private final void buildLink(String fulltargetpath, String arguments, String workingdirectory, String fulllinkpath, String iconfile) throws IOException {
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        if (iconfile != null) {
            int iconfilelen = this.write(iconfile);
            this.writeBackward(iconfilelen, 2);
        }
        if (arguments != null) {
            int argumentslength = this.write(arguments);
            this.writeBackward(argumentslength, 2);
        }
        if (workingdirectory != null) {
            int tplength = this.write(workingdirectory);
            this.writeBackward(tplength, 2);
        }
        File destf = new File(fulltargetpath);
        File linkf = new File(fulllinkpath);
        String rp = this.getRelativePath(linkf.getParent(), destf.getParent());
        Globals.printDebug("rp = " + rp);
        if (rp != null) {
            rp = rp.length() > 0 ? rp + File.separator + destf.getName() : destf.getName();
            Globals.printDebug("rp = " + rp);
            int rplen = this.write(rp);
            this.writeBackward(rplen, 2);
        }
        int postfileoff = this.offset;
        this.buf[0] = 0;
        this.write(this.buf, 0, 1);
        int finalpathoff = this.offset;
        this.buf[0] = 0;
        this.write(this.buf, 0, 1);
        this.write(fulltargetpath);
        int localpathoff = this.offset;
        this.buf[0] = 0;
        this.write(this.buf, 0, 1);
        this.buf[0] = 16;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        this.buf[0] = 3;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        int voltablen = localpathoff - this.offset + 4;
        this.writeBackward(voltablen, 4);
        int fileinfooff = this.offset - 28;
        int tmp = finalpathoff - fileinfooff;
        this.writeBackward(tmp, 4);
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        tmp = localpathoff - fileinfooff;
        this.writeBackward(tmp, 4);
        this.buf[0] = 28;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        this.buf[0] = 1;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        this.buf[0] = 28;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        tmp = postfileoff - fileinfooff;
        this.writeBackward(tmp, 4);
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.buf[4] = 0;
        this.buf[5] = 0;
        this.buf[6] = 0;
        this.buf[7] = 0;
        this.write(this.buf, 0, 8);
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        this.buf[0] = 1;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        int filelen = (int)destf.length();
        this.writeBackward(filelen, 4);
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.buf[4] = 0;
        this.buf[5] = 0;
        this.buf[6] = 0;
        this.buf[7] = 0;
        this.write(this.buf, 0, 8);
        this.write(this.buf, 0, 8);
        this.write(this.buf, 0, 8);
        this.buf[0] = 32;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        int flags = 2;
        if (rp != null) {
            flags += 8;
        }
        if (workingdirectory != null) {
            flags += 16;
        }
        if (arguments != null) {
            flags += 32;
        }
        if (iconfile != null) {
            flags += 64;
        }
        this.writeBackward(flags, 4);
        this.buf[0] = -64;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.buf[4] = 0;
        this.buf[5] = 0;
        this.buf[6] = 0;
        this.buf[7] = 70;
        this.write(this.buf, 0, 8);
        this.buf[0] = 1;
        this.buf[1] = 20;
        this.buf[2] = 2;
        this.buf[3] = 0;
        this.buf[4] = 0;
        this.buf[5] = 0;
        this.buf[6] = 0;
        this.buf[7] = 0;
        this.write(this.buf, 0, 8);
        this.buf[0] = 76;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.write(this.buf, 0, 4);
        this.bytestream.close();
    }

    private final int write(byte[] source, int srcoffset, int length) {
        int newoffset = this.offset - length;
        if (newoffset < 0) {
            length += newoffset;
            srcoffset -= newoffset;
            newoffset = 0;
        }
        int atbuff = newoffset;
        int atsrc = srcoffset;
        int i = 0;
        while (i < length) {
            this.answer[atbuff] = source[atsrc];
            ++atbuff;
            ++atsrc;
            ++i;
        }
        this.offset = newoffset;
        return length;
    }

    private final int write(String text) throws IOException {
        OutputStreamWriter writeout = new OutputStreamWriter(this.bytestream);
        writeout.write(text, 0, text.length());
        writeout.close();
        byte[] bytes = this.bytestream.toByteArray();
        this.bytestream.reset();
        return this.write(bytes, 0, bytes.length);
    }

    private final int write(byte abyte) {
        int rc = 0;
        if (this.offset > 0) {
            --this.offset;
            this.answer[this.offset] = abyte;
            rc = 1;
        }
        return rc;
    }

    private final int writeForward(int value, int length) {
        int i = 0;
        int rc = 0;
        while (i < length && i < 4) {
            byte abyte = (byte)value;
            rc += this.write(abyte);
            value >>>= 8;
            ++i;
        }
        return rc;
    }

    private final int writeBackward(int value, int count) {
        boolean rc = false;
        byte[] tmp = new byte[count];
        int i = 0;
        while (i < count && i < 4) {
            tmp[i] = (byte)value;
            value >>>= 8;
            ++i;
        }
        return this.write(tmp, 0, i);
    }

    private final String getRelativePath(String from, String to) {
        char achar;
        int flen = from.length();
        int tlen = to.length();
        char sep = File.separatorChar;
        int prevsep = -1;
        int sepcount = 0;
        StringBuffer fromb = new StringBuffer(from);
        StringBuffer tob = new StringBuffer(to);
        int i = flen - 1;
        if (fromb.charAt(i) != sep) {
            fromb.append(sep);
            ++flen;
        }
        if (tob.charAt(i = tlen - 1) != sep) {
            tob.append(sep);
            ++tlen;
        }
        i = 0;
        boolean ok = true;
        while (ok && i < flen && i < tlen) {
            achar = Character.toLowerCase(fromb.charAt(i));
            if (achar == Character.toLowerCase(tob.charAt(i))) {
                if (achar == sep) {
                    prevsep = i;
                    ++sepcount;
                }
            } else {
                ok = false;
            }
            ++i;
        }
        if (sepcount == 0) {
            return null;
        }
        if (i == flen && i == tlen) {
            return "";
        }
        fromb.delete(0, ++prevsep);
        tob.delete(0, prevsep);
        int state = 0;
        i = 0;
        while (i < fromb.length()) {
            achar = fromb.charAt(i);
            if (achar == sep) {
                state = 0;
                ++i;
                continue;
            }
            if (state < 2) {
                fromb.setCharAt(i, '.');
                ++state;
                ++i;
                continue;
            }
            fromb.deleteCharAt(i);
        }
        i = fromb.length() - 1;
        if (i > 0 && fromb.charAt(i) != sep) {
            fromb.append(sep);
        }
        fromb.append(tob.toString());
        flen = fromb.length();
        i = flen - 1;
        if (fromb.charAt(i) == sep) {
            fromb.delete(i, flen);
        }
        return fromb.toString();
    }

    private final void mkpath(File file) throws IOException {
        ArrayList<File> need = new ArrayList<File>();
        File check = file.getParentFile();
        int max = 0;
        while (!check.exists()) {
            ++max;
            need.add(check);
            check = check.getParentFile();
        }
        int i = 0;
        while (i < max) {
            check = (File)need.get(i);
            check.mkdirs();
            need.set(i, null);
            ++i;
        }
        check = null;
        Object var2_2 = null;
    }

    private final void writeFile(File dest) throws IOException {
        int len = this.answer.length - this.offset;
        FileOutputStream ds = new FileOutputStream(dest);
        ds.write(this.answer, this.offset, len);
        ds.close();
    }
}

