/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtilities {
    public static String[] splitString(String splitStr, String delim) {
        StringTokenizer toker = new StringTokenizer(splitStr, delim);
        int count = toker.countTokens();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            try {
                result[i] = toker.nextToken();
            }
            catch (NoSuchElementException ex) {
                result = null;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String[] argumentSubstitution(String[] args, Hashtable vars) {
        StringBuffer argBuf = new StringBuffer();
        String[] result = new String[args.length];
        int aIdx = 0;
        while (aIdx < args.length) {
            String argStr = args[aIdx];
            int index = argStr.indexOf(36);
            result[aIdx] = index < 0 ? argStr : StringUtilities.stringSubstitution(argStr, vars);
            ++aIdx;
        }
        return result;
    }

    public static String stringSubstitution(String argStr, Hashtable vars) {
        StringBuffer argBuf = new StringBuffer();
        int cIdx = 0;
        block3: while (cIdx < argStr.length()) {
            char ch = argStr.charAt(cIdx);
            switch (ch) {
                case '$': {
                    String value;
                    StringBuffer nameBuf = new StringBuffer();
                    ++cIdx;
                    while (cIdx < argStr.length()) {
                        ch = argStr.charAt(cIdx);
                        if (ch != '_' && !Character.isLetterOrDigit(ch)) break;
                        nameBuf.append(ch);
                        ++cIdx;
                    }
                    if (nameBuf.length() <= 0 || (value = (String)vars.get(nameBuf.toString())) == null) continue block3;
                    argBuf.append(value);
                    break;
                }
                default: {
                    argBuf.append(ch);
                    ++cIdx;
                }
            }
        }
        return argBuf.toString();
    }

    public static String[] parseArgumentString(String argStr) {
        String[] result = null;
        Vector vector = StringUtilities.parseArgumentVector(argStr);
        if (vector != null && vector.size() > 0) {
            result = new String[vector.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = (String)vector.elementAt(i);
                ++i;
            }
        }
        return result;
    }

    public static Vector parseArgumentVector(String argStr) {
        Vector<String> result = new Vector<String>();
        StringBuffer argBuf = new StringBuffer();
        boolean backSlash = false;
        boolean matchSglQuote = false;
        boolean matchDblQuote = false;
        int cIdx = 0;
        while (cIdx < argStr.length()) {
            char ch = argStr.charAt(cIdx);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (backSlash) {
                        argBuf.append(ch);
                        backSlash = false;
                        break;
                    }
                    if (matchSglQuote || matchDblQuote) {
                        argBuf.append(ch);
                        break;
                    }
                    if (argBuf.length() <= 0) break;
                    result.addElement(argBuf.toString());
                    argBuf.setLength(0);
                    break;
                }
                case '\\': {
                    if (backSlash) {
                        argBuf.append("\\");
                    }
                    backSlash = !backSlash;
                    break;
                }
                case '\'': {
                    if (backSlash) {
                        argBuf.append("'");
                        backSlash = false;
                        break;
                    }
                    if (matchSglQuote) {
                        result.addElement(argBuf.toString());
                        argBuf.setLength(0);
                        matchSglQuote = false;
                        break;
                    }
                    if (matchDblQuote) break;
                    matchSglQuote = true;
                    break;
                }
                case '\"': {
                    if (backSlash) {
                        argBuf.append("\"");
                        backSlash = false;
                        break;
                    }
                    if (matchDblQuote) {
                        result.addElement(argBuf.toString());
                        argBuf.setLength(0);
                        matchDblQuote = false;
                        break;
                    }
                    if (matchSglQuote) break;
                    matchDblQuote = true;
                    break;
                }
                default: {
                    if (backSlash) {
                        switch (ch) {
                            case 'b': {
                                argBuf.append('\b');
                                break;
                            }
                            case 'f': {
                                argBuf.append('\f');
                                break;
                            }
                            case 'n': {
                                argBuf.append('\n');
                                break;
                            }
                            case 'r': {
                                argBuf.append('\r');
                                break;
                            }
                            case 't': {
                                argBuf.append('\t');
                                break;
                            }
                            default: {
                                char ch2 = argStr.charAt(cIdx + 1);
                                char ch3 = argStr.charAt(cIdx + 2);
                                if (ch >= '0' && ch <= '7' && ch2 >= '0' && ch2 <= '7' && ch3 >= '0' && ch3 <= '7') {
                                    int octal = (ch - 48) * 64 + (ch2 - 48) * 8 + (ch3 - 48);
                                    argBuf.append((char)octal);
                                    cIdx += 2;
                                    break;
                                }
                                if (ch == '0') {
                                    argBuf.append('\u0000');
                                    break;
                                }
                                argBuf.append(ch);
                                break;
                            }
                        }
                    } else {
                        argBuf.append(ch);
                    }
                    backSlash = false;
                }
            }
            ++cIdx;
        }
        if (argBuf.length() > 0) {
            result.addElement(argBuf.toString());
        }
        return result;
    }
}

